/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef F2T_BRUTUS_DEFINES_H
#define F2T_BRUTUS_DEFINES_H


/****************************************************/
/*        Misc property tags and constants          */
/*                                                  */
/*  Only included here so that we can make use of   */
/*  their symbolic names.                           */
/*                                                  */
/****************************************************/

// http://msdn2.microsoft.com/en-us/library/bb820947.aspx
#define MAPI_BG_SESSION (0x00200000)

// Causes MAPI to store profiles in temporary .mmp files on disk, instead of in the registry
// http://support.microsoft.com/kb/891425
#define MAPI_TEMPORARY_PROFILES (0x00000004)

// see: http://support.microsoft.com/?kbid=834496
#define MDB_ONLINE (0x00000100)

// http://support.microsoft.com/kb/822977/
#define MAPI_FORCE_ACCESS (0x00080000)

// http://blogs.msdn.com/stephen_griffin/archive/2007/03/19/mapi-and-exchange-2007.aspx
#define CONNECT_IGNORE_NO_PF (0x00008000)

#define PR_IPM_OUTLOOK_OUTBOX       (PT_BINARY    | (0x35E2 << 16)) // on private message store
#define PR_IPM_OUTLOOK_WASTEBASKET  (PT_BINARY    | (0x35E3 << 16)) // on private message store
#define PR_IPM_OUTLOOK_SENTMAIL     (PT_BINARY    | (0x35E4 << 16)) // on private message store
#define PR_IPM_OUTLOOK_VIEWS        (PT_BINARY    | (0x35E5 << 16)) // on private message store
#define PR_IPM_OUTLOOK_COMMON_VIEWS (PT_BINARY    | (0x35E6 << 16)) // on private message store
#define PR_IPM_OUTLOOK_FINDER       (PT_BINARY    | (0x35E7 << 16)) // on private message store
#define PR_IPM_OUTLOOK_CALENDAR     (PT_BINARY    | (0x36D0 << 16)) // on root folder in private message store
#define PR_IPM_OUTLOOK_CONTACTS     (PT_BINARY    | (0x36D1 << 16)) // on root folder in private message store
#define PR_IPM_OUTLOOK_JOURNAL      (PT_BINARY    | (0x36D2 << 16)) // on root folder in private message store
#define PR_IPM_OUTLOOK_NOTES        (PT_BINARY    | (0x36D3 << 16)) // on root folder in private message store
#define PR_IPM_OUTLOOK_TASKS        (PT_BINARY    | (0x36D4 << 16)) // on root folder in private message store
#define PR_IPM_OUTLOOK_REMINDERS    (PT_BINARY    | (0x36D5 << 16)) // on root folder in private message store
#define PR_IPM_OUTLOOK_DRAFTS       (PT_BINARY    | (0x36D7 << 16)) // on root folder in private message store
#define PR_ADDITIONAL_REN_ENTRYIDS  (PT_MV_BINARY | (0x36D8 << 16)) // http://blogs.msdn.com/stephen_griffin/archive/2007/03/06/outlook-2007-rtm-docs-properties.aspx
#define PR_FREEBUSY_ENTRYIDS        (PT_MV_BINARY | (0x36E4 << 16)) // on root folder in private message store


#endif // F2T_BRUTUS_DEFINES_H
