/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef _CONV_UTILS_H_
#define _CONV_UTILS_H_

#include "return_codesC.h"
#include "utils/macros.h"
#include "typesS_impl.h"

#include <tao/PortableServer/PortableServer.h>

#include <tnef.h>
#include "edkmdb.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>

#include "Brutus_Loader_Impl_Export.h"

// Valid values: http://msdn.microsoft.com/en-us/library/ms776446(VS.85).aspx
extern "C" unsigned long local_code_page;

extern Brutus_Loader_Impl_Export const char *hresult_to_str(const HRESULT HValue);

/*
 * Big ugly hack to easily implement content scrambling
 * in multiprocess mode
 */
extern Brutus_Loader_Impl_Export bool scramble_content;

extern Brutus_Loader_Impl_Export bool sPropProblem_mapi_to_brutus(::SPropProblem *Mapi_Problem,
								  ::BRUTUS::SPropProblem& Brutus_Problem,
								  bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool sPropProblem_array_mapi_to_brutus(::SPropProblemArray *Mapi_Problems,
									::BRUTUS::SPropProblemArray& Brutus_Problems,
									bool DeAlloc = false);

extern Brutus_Loader_Impl_Export ULONG proptype_brutus_to_mapi(const ::BRUTUS::PT_TYPE Brutus_Type);

extern Brutus_Loader_Impl_Export bool proptag_brutus_to_mapi(const ::CORBA::ULong Brutus_Tag,
							     ULONG& Mapi_Tag);

extern Brutus_Loader_Impl_Export bool proptag_mapi_to_brutus(const ULONG Mapi_Tag,
							     ::BRUTUS::BDEFINE_out Brutus_Tag);

extern Brutus_Loader_Impl_Export bool proptag_array_brutus_to_mapi(const ::BRUTUS::SPropTagArray *Brutus_Tags,
								   void *Parent,
								   ::SPropTagArray*& Mapi_Tags);

extern Brutus_Loader_Impl_Export bool proptag_array_mapi_to_brutus(::SPropTagArray *Mapi_Tags,
								   ::BRUTUS::SPropTagArray & Brutus_Tags,
								   bool DeAlloc);

extern Brutus_Loader_Impl_Export bool proptag_array_mapi_to_brutus(::SPropTagArray *Mapi_Tags,
								   ::BRUTUS::SPropTagArray_out Brutus_Tags,
								   bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool srow_brutus_to_mapi(const ::BRUTUS::SRow *Brutus_Row,
							  ::SRow*& Mapi_Row);

extern Brutus_Loader_Impl_Export bool srow_brutus_to_mapi_internal_alloc(const ::BRUTUS::SRow *Brutus_Row,
									 ::SRow* const Mapi_Row);

extern Brutus_Loader_Impl_Export bool srow_mapi_to_brutus(::SRow *Mapi_Row,
							  ::BRUTUS::SRow& Brutus_Row,
							  LPMAPISESSION Mapi_Session,
							  bool DeAlloc = false,
							  PortableServer::POA_ptr Poa = PortableServer::POA::_nil());

extern Brutus_Loader_Impl_Export bool srow_set_brutus_to_mapi(const ::BRUTUS::SRowSet *Brutus_RowSet,
							      ::SRowSet*& Mapi_RowSet);

extern Brutus_Loader_Impl_Export bool srow_set_brutus_to_mapi_internal_alloc(const ::BRUTUS::SRowSet *Brutus_RowSet,
									     ::SRowSet* const Mapi_RowSet);

extern Brutus_Loader_Impl_Export bool srow_set_mapi_to_brutus(::SRowSet *Mapi_RowSet,
							      ::BRUTUS::SRowSet& Brutus_RowSet,
							      LPMAPISESSION Mapi_Session,
							      bool DeAlloc = false,
							      PortableServer::POA_ptr Poa = PortableServer::POA::_nil());

extern Brutus_Loader_Impl_Export bool order_brutus_to_mapi(const ::BRUTUS::BDEFINE Brutus_Order,
							   ULONG& Mapi_Order);

extern Brutus_Loader_Impl_Export bool order_mapi_to_brutus(const ULONG Mapi_Order,
							   ::BRUTUS::BDEFINE& Brutus_Order);

extern Brutus_Loader_Impl_Export bool sort_order_brutus_to_mapi(const ::BRUTUS::SSortOrder *Brutus_Order,
								void *Parent,
								::SSortOrder*& Mapi_Order);

extern Brutus_Loader_Impl_Export bool sort_order_brutus_to_mapi_internal_alloc(const ::BRUTUS::SSortOrder *Brutus_Order,
									       ::SSortOrder* const Mapi_Order);

extern Brutus_Loader_Impl_Export bool sort_order_mapi_to_brutus(::SSortOrder *Mapi_Order,
								::BRUTUS::SSortOrder& Brutus_Order,
								bool DeAlloc = false);


extern Brutus_Loader_Impl_Export bool sort_order_set_brutus_to_mapi(const ::BRUTUS::SSortOrderSet *Brutus_OrderSet,
								    void *Parent,
								    ::SSortOrderSet*& Mapi_OrderSet);

extern Brutus_Loader_Impl_Export bool sort_order_set_brutus_to_mapi_internal_alloc(const ::BRUTUS::SSortOrderSet *Brutus_OrderSet,
										   void *Parent,
										   ::SSortOrderSet* const Mapi_OrderSet);

extern Brutus_Loader_Impl_Export bool sort_order_set_mapi_to_brutus(::SSortOrderSet *Mapi_OrderSet,
								    ::BRUTUS::SSortOrderSet& Brutus_OrderSet,
								    bool DeAlloc = false);


extern Brutus_Loader_Impl_Export bool notify_mapi_to_brutus(const ULONG cNotif,
							    const ::NOTIFICATION *lpNotifications,
							    ::BRUTUS::seq_NOTIFICATION_out Brutus_Notification,
							    LPMAPISESSION Mapi_Session,
							    PortableServer::POA_ptr Poa);

extern Brutus_Loader_Impl_Export bool mapierror_mapi_to_brutus(::MAPIERROR *Mapi_Error,
							       ::BRUTUS::MAPIERROR & Brutus_Error,
							       bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool mapierror_brutus_to_mapi(const ::BRUTUS::MAPIERROR *Brutus_Error,
							       void *Parent,
							       ::MAPIERROR*& Mapi_Error);

extern Brutus_Loader_Impl_Export bool mapiuid_mapi_to_brutus(::MAPIUID *Mapi_Uid,
							     ::BRUTUS::MAPIUID_out Brutus_Uid,
							     bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool mapiuid_brutus_to_mapi_no_alloc(const char *Brutus_Uid,
								      ::MAPIUID& Mapi_Uid);

extern Brutus_Loader_Impl_Export bool mapiuid_brutus_to_mapi(const char *Brutus_Uid,
							     void *Parent,
							     ::MAPIUID*& Mapi_Uid);

extern Brutus_Loader_Impl_Export bool mapiuid_array_brutus_to_mapi(const ::BRUTUS::seq_MAPIUID *Brutus_Uids,
								   void *Parent,
								   ::MAPIUID*& Mapi_Uids);

extern Brutus_Loader_Impl_Export bool guid_mapi_to_brutus(::GUID *Mapi_Guid,
							  ::BRUTUS::GUID_out Brutus_Guid,
							  bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool guid_brutus_to_mapi_no_alloc(const char *Brutus_Guid,
								   ::GUID * const Mapi_Guid,
								   bool Input_Verified = false);

extern Brutus_Loader_Impl_Export bool guid_brutus_to_mapi(const char *Brutus_Guid,
							  void *Parent,
							  ::GUID*& Mapi_Guid);

extern Brutus_Loader_Impl_Export bool guid_array_brutus_to_mapi(const ::BRUTUS::seq_GUID *Brutus_Guids,
								void *Parent,
								::GUID*& Mapi_Guids);

extern Brutus_Loader_Impl_Export bool guid_brutus_to_lpbyte_no_alloc(const char *Brutus_Guid,
								     LPBYTE Mapi_LPBYTE,
								     bool Input_Verified = false);

extern Brutus_Loader_Impl_Export bool guid_brutus_to_lpbyte(const char *Brutus_Guid,
							    void *Parent,
							    LPBYTE & Mapi_LPBYTE);

extern Brutus_Loader_Impl_Export bool entryid_mapi_to_brutus(const ULONG cbEntryId,
							     ::ENTRYID *Mapi_EntryId,
							     ::BRUTUS::ENTRYID_out Brutus_EntryId,
							     bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool entryid_mapi_to_brutus(const ULONG cbEntryId,
							     ::ENTRYID *Mapi_EntryId,
							     ::BRUTUS::ENTRYID & Brutus_EntryId,
							     bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool entryid_brutus_to_mapi(const ::BRUTUS::ENTRYID *Brutus_EntryId,
							     void *Parent,
							     ULONG& Mapi_EntryIdSize,
							     ::ENTRYID*& Mapi_EntryId);

extern Brutus_Loader_Impl_Export bool entrylist_brutus_to_mapi_internal_alloc(const ::BRUTUS::seq_ENTRYID *Brutus_ENTRYLIST,
									      void *Parent,
									      ::ENTRYLIST *Mapi_ENTRYLIST);

extern Brutus_Loader_Impl_Export bool entrylist_brutus_to_mapi(const ::BRUTUS::seq_ENTRYID *Brutus_ENTRYLIST,
							       void *Parent,
							       ::ENTRYLIST*& Mapi_ENTRYLIST);

extern Brutus_Loader_Impl_Export bool table_event_mapi_to_brutus(const ULONG Mapi_TableEvent,
								 ::BRUTUS::BDEFINE& Brutus_TableEvent);

extern Brutus_Loader_Impl_Export bool object_type_mapi_to_brutus(const unsigned long Mapi_Obj_Type,
								 ::BRUTUS::BDEFINE& Brutus_Obj_Type);

extern Brutus_Loader_Impl_Export bool object_type_brutus_to_mapi(const ::BRUTUS::BDEFINE Brutus_ObjType,
								 unsigned long & Mapi_Obj_Type);

extern Brutus_Loader_Impl_Export bool msg_flags_mapi_to_brutus(const ULONG Mapi_MsgFlags,
							       ::CORBA::ULong& Brutus_MsgFlags);

extern Brutus_Loader_Impl_Export bool bresult_to_hresult(const ::BRUTUS::BRESULT BValue,
							 HRESULT& HValue);

extern Brutus_Loader_Impl_Export bool hresult_to_bresult(const HRESULT HValue,
							 ::BRUTUS::BRESULT& BValue);

extern Brutus_Loader_Impl_Export bool currency_mapi_to_brutus(::CURRENCY *Mapi_Curr,
							      ::BRUTUS::CURRENCY& Brutus_Curr,
							      bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool currency_brutus_to_mapi(const ::BRUTUS::CURRENCY *Brutus_Curr,
							      void *Parent,
							      ::CURRENCY*& Mapi_Curr);

extern Brutus_Loader_Impl_Export bool currency_brutus_to_mapi_no_alloc(const ::BRUTUS::CURRENCY *Brutus_Curr,
								       ::CURRENCY& Mapi_Curr);

extern Brutus_Loader_Impl_Export bool large_int_mapi_to_brutus(::LARGE_INTEGER *Mapi_LI,
							       ::BRUTUS::LARGE_INTEGER& Brutus_LI,
							       bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool large_int_brutus_to_mapi(const ::BRUTUS::LARGE_INTEGER *Brutus_LI,
							       void *Parent,
							       ::LARGE_INTEGER*& Mapi_LI);

extern Brutus_Loader_Impl_Export bool large_int_brutus_to_mapi_no_alloc(const ::BRUTUS::LARGE_INTEGER *Brutus_LI,
									::LARGE_INTEGER& Mapi_LI);

extern Brutus_Loader_Impl_Export bool filetime_mapi_to_brutus(::FILETIME *Mapi_FT,
							      ::BRUTUS::FILETIME& Brutus_FT,
							      bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool filetime_brutus_to_mapi(const ::BRUTUS::FILETIME *Brutus_FT,
							      void *Parent,
							      ::FILETIME*& Mapi_FT);

extern Brutus_Loader_Impl_Export bool filetime_brutus_to_mapi_no_alloc(const ::BRUTUS::FILETIME *Brutus_FT,
								       ::FILETIME& Mapi_FT);

extern Brutus_Loader_Impl_Export bool sbinary_mapi_to_brutus(::SBinary *Mapi_Bin,
							     ::BRUTUS::SBinary& Brutus_Bin,
							     bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool sbinary_brutus_to_mapi(const ::BRUTUS::SBinary *Brutus_Bin,
							     void *Parent,
							     ::SBinary*& Mapi_Bin);

extern Brutus_Loader_Impl_Export bool sbinary_brutus_to_mapi_internal_alloc(const ::BRUTUS::SBinary *Brutus_Bin,
									    void *Parent,
									    ::SBinary* const Mapi_Bin);

extern Brutus_Loader_Impl_Export bool sbinary_array_mapi_to_brutus(::SBinaryArray *Mapi_BinArray,
								   ::BRUTUS::SBinaryArray& Brutus_BinArray,
								   bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool sbinary_array_brutus_to_mapi(const ::BRUTUS::SBinaryArray *Brutus_BinArray,
								   void *Parent,
								   ::SBinaryArray*& Mapi_BinArray);

extern Brutus_Loader_Impl_Export bool sbinary_array_brutus_to_mapi_internal_alloc(const ::BRUTUS::SBinaryArray *Brutus_BinArray,
										  void *Parent,
										  ::SBinaryArray* const Mapi_BinArray);

extern Brutus_Loader_Impl_Export bool spropvalue_mapi_to_brutus(::SPropValue *Mapi_SPropValue,
								::BRUTUS::SPropValue& Brutus_SPropValue,
								LPMAPISESSION Mapi_Session,
								bool DeAlloc = false,
								PortableServer::POA_ptr Poa = PortableServer::POA::_nil());

extern Brutus_Loader_Impl_Export bool spropvalue_array_mapi_to_brutus(const ULONG cValues,
								      ::SPropValue *Mapi_SPropValues,
								      ::BRUTUS::seq_SPropValue& Brutus_SPropValues,
								      LPMAPISESSION Mapi_Session,
								      bool DeAlloc = false,
								      PortableServer::POA_ptr Poa = PortableServer::POA::_nil());

extern Brutus_Loader_Impl_Export bool spropvalue_brutus_to_mapi(const ::BRUTUS::SPropValue *Brutus_SPropValue,
								void *Parent,
								::SPropValue*& Mapi_SPropValue);

extern Brutus_Loader_Impl_Export bool spropvalue_brutus_to_mapi_internal_alloc(const ::BRUTUS::SPropValue *Brutus_SPropValue,
									       void *Parent,
									       ::SPropValue* const Mapi_SPropValue);

extern Brutus_Loader_Impl_Export bool spropvalue_array_brutus_to_mapi(const ::BRUTUS::seq_SPropValue *Brutus_SPropValues,
								      void *Parent,
								      ULONG& cValues,
								      ::SPropValue*& Mapi_SPropValues);

extern Brutus_Loader_Impl_Export bool fuzzyLevel_brutus_to_mapi(const ::BRUTUS::FUZZY_TYPE Brutus_Fuzzy,
								ULONG& Mapi_Fuzzy);

extern Brutus_Loader_Impl_Export bool fuzzyLevel_mapi_to_brutus(const ULONG Mapi_Fuzzy,
								::BRUTUS::FUZZY_TYPE & Brutus_Fuzzy);

extern Brutus_Loader_Impl_Export bool relop_brutus_to_mapi(const ::BRUTUS::RELOP_TYPE Brutus_Relop,
							   ULONG& Mapi_Relop);

extern Brutus_Loader_Impl_Export bool relop_mapi_to_brutus(const ULONG Mapi_Relop,
							   ::BRUTUS::RELOP_TYPE & Brutus_Relop);

extern Brutus_Loader_Impl_Export bool bmr_brutus_to_mapi(const ::BRUTUS::BMR_TYPE Brutus_Bmr,
							 ULONG& Mapi_Bmr);

extern Brutus_Loader_Impl_Export bool bmr_mapi_to_brutus(const ULONG Mapi_Bmr,
							 ::BRUTUS::BMR_TYPE & Brutus_Bmr);

extern Brutus_Loader_Impl_Export bool sub_object_brutus_to_mapi(const ::BRUTUS::BDEFINE Brutus_Sub,
								ULONG& Mapi_Sub);

extern Brutus_Loader_Impl_Export bool sub_object_mapi_to_brutus(const ULONG Mapi_Sub,
								::BRUTUS::BDEFINE & Brutus_Sub);

extern Brutus_Loader_Impl_Export bool nameid_mapi_to_brutus(::MAPINAMEID *Mapi_Name,
							    ::BRUTUS::MAPINAMEID& Brutus_Name,
							    bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool nameid_brutus_to_mapi(const ::BRUTUS::MAPINAMEID *Brutus_Name,
							    void *Parent,
							    ::MAPINAMEID*& Mapi_Name);

extern Brutus_Loader_Impl_Export bool nameid_brutus_to_mapi_internal_alloc(const ::BRUTUS::MAPINAMEID *Brutus_Name,
									   void *Parent,
									   MAPINAMEID* const Mapi_Name);

extern Brutus_Loader_Impl_Export bool nameid_array_mapi_to_brutus(const ULONG cValues,
								  ::MAPINAMEID **Mapi_Name,
								  ::BRUTUS::seq_MAPINAMEID& Brutus_Name,
								  bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool nameid_array_brutus_to_mapi(const ::BRUTUS::seq_MAPINAMEID *Brutus_Names,
								  void *Parent,
								  ::LPMAPINAMEID*& Mapi_Names);

extern Brutus_Loader_Impl_Export bool adr_brutus_to_mapi(const ::BRUTUS::ADRENTRY *Brutus_Adr,
							 ::ADRENTRY*& Mapi_Adr);

extern Brutus_Loader_Impl_Export bool adr_brutus_to_mapi_internal_alloc(const ::BRUTUS::ADRENTRY *Brutus_Adr,
									::ADRENTRY* const Mapi_Adr);

extern Brutus_Loader_Impl_Export bool adr_mapi_to_brutus(::ADRENTRY *Mapi_Adr,
							 ::BRUTUS::ADRENTRY& Brutus_Adr,
							 LPMAPISESSION Mapi_Session,
							 bool DeAlloc = false,
							 PortableServer::POA_ptr Poa = PortableServer::POA::_nil());

extern Brutus_Loader_Impl_Export bool adr_list_brutus_to_mapi(const ::BRUTUS::ADRLIST *Brutus_AdrList,
							      ::ADRLIST*& Mapi_AdrList);

extern Brutus_Loader_Impl_Export bool adr_list_brutus_to_mapi_internal_alloc(const ::BRUTUS::ADRLIST *Brutus_AdrList,
									     ::ADRLIST* const Mapi_AdrList);

extern Brutus_Loader_Impl_Export bool adr_list_mapi_to_brutus(::ADRLIST *Mapi_AdrList,
							      ::BRUTUS::ADRLIST& Brutus_AdrList,
							      LPMAPISESSION Mapi_Session,
							      bool DeAlloc = false,
							      PortableServer::POA_ptr Poa = PortableServer::POA::_nil());

extern Brutus_Loader_Impl_Export bool srestriction_mapi_to_container(::SRestriction *Mapi_Res,
								     LPMAPISESSION MAPISession,
								     ::BRUTUS::SRestrictionContainer_out Brutus_Res,
								     PortableServer::POA_ptr Poa);

extern Brutus_Loader_Impl_Export bool srestriction_mapi_to_brutus(::SRestriction *Mapi_Res,
								  LPMAPISESSION MAPISession,
								  ::BRUTUS::SRestriction_out Brutus_Res,
								  PortableServer::POA_ptr Poa);

extern Brutus_Loader_Impl_Export bool ANDrestriction_brutus_to_mapi_internal_alloc(const ::BRUTUS::SAndRestriction_ptr Brutus_Res,
										   void *Parent,
										   ::SAndRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool ORrestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SOrRestriction_ptr Brutus_Res,
										  void *Parent,
										  ::SOrRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool NOTrestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SNotRestriction_ptr Brutus_Res,
										   void *Parent,
										   ::SNotRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool CONTENTrestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SContentRestriction_ptr Brutus_Res,
										       void *Parent,
										       ::SContentRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool PROPERTYrestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SPropertyRestriction_ptr Brutus_Res,
											void *Parent,
											::SPropertyRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool COMPAREPROPSrestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SComparePropsRestriction_ptr Brutus_Res,
											    void *Parent,
											    ::SComparePropsRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool BITMASKrestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SBitMaskRestriction_ptr Brutus_Res,
										       void *Parent,
										       ::SBitMaskRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool SIZErestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SSizeRestriction_ptr Brutus_Res,
										    void *Parent,
										    ::SSizeRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool EXISTrestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SExistRestriction_ptr Brutus_Res,
										     void *Parent,
										     ::SExistRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool SUBrestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SSubRestriction_ptr Brutus_Res,
										   void *Parent,
										   ::SSubRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool COMMENTrestriction_brutus_to_mapi_internal_alloc(::BRUTUS::SCommentRestriction_ptr Brutus_Res,
										       void *Parent,
										       ::SCommentRestriction* const Mapi_Res);

extern Brutus_Loader_Impl_Export bool srestriction_brutus_to_mapi_internal_alloc(const ::BRUTUS::SRestriction& Brutus_Res,
										 void *Parent,
										 ::SRestriction* const Mapi_Res);


extern Brutus_Loader_Impl_Export bool srestriction_brutus_to_mapi(const ::BRUTUS::SRestriction& Brutus_Res,
								  void *Parent,
								  ::SRestriction*& Mapi_Res);

extern Brutus_Loader_Impl_Export bool brutus_entry_id_is_nil(const ::BRUTUS::ENTRYID* const b_eid);

extern Brutus_Loader_Impl_Export bool seq_ulong_brutus_to_mapi(const ::BRUTUS::seq_ulong & Brutus_seq_ulong,
							       void *Parent,
							       ULONG *& seq_mapi_ulong);

extern Brutus_Loader_Impl_Export bool seq_ulong_mapi_to_brutus(const ULONG len,
							       ULONG *& seq_mapi_ulong,
							       ::BRUTUS::seq_ulong_out Brutus_seq_ulong,
							       bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool seq_octet_brutus_to_mapi(const ::BRUTUS::seq_octet & Brutus_seq_octet,
							       void *Parent,
							       void *& mapi_void);

extern Brutus_Loader_Impl_Export bool seq_octet_mapi_to_brutus(const ULONG len,
							       ::BYTE *Mapi_seq_octet,
							       ::BRUTUS::seq_octet_out Brutus_seq_octet,
							       bool Dealloc = false);

extern Brutus_Loader_Impl_Export bool sTnefProblem_mapi_to_brutus(::STnefProblem *Mapi_Problem,
								  ::BRUTUS::STnefProblem_out Brutus_Problem,
								  bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool sTnefProblem_array_mapi_to_brutus(::STnefProblemArray *Mapi_Problems,
									::BRUTUS::STnefProblemArray_out Brutus_Problems,
									bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool statstg_mapi_to_brutus(::STATSTG *Stats,
							     ::STATFLAG Flag,
							     ::BRUTUS::STATSTG_out Brutus_StatStg);

extern Brutus_Loader_Impl_Export bool statstg_brutus_to_mapi(const ::BRUTUS::STATSTG & Brutus_Stats,
							     ::BRUTUS::STATFLAG Flag,
							     ::STATSTG *Mapi_StatStg);

extern Brutus_Loader_Impl_Export bool readstate_mapi_to_brutus(::READSTATE *Mapi_ReadState,
							       ::BRUTUS::READSTATE & Brutus_ReadState,
							       bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool readstate_brutus_to_mapi(const ::BRUTUS::READSTATE *Brutus_ReadState,
							       void *Parent,
							       ::READSTATE *& Mapi_ReadState);

extern Brutus_Loader_Impl_Export bool readstate_brutus_to_mapi_internal_alloc(const ::BRUTUS::READSTATE *Brutus_ReadState,
									      void *Parent,
									      ::READSTATE * const Mapi_ReadState);

extern Brutus_Loader_Impl_Export bool readstate_array_mapi_to_brutus(ULONG Count,
								     ::READSTATE *Mapi_ReadState,
								     ::BRUTUS::seq_READSTATE_out Brutus_ReadState,
								     bool DeAlloc = false);

extern Brutus_Loader_Impl_Export bool readstate_array_brutus_to_mapi(const ::BRUTUS::seq_READSTATE *Brutus_ReadStates,
								     void *Parent,
								     ::READSTATE *& Mapi_ReadStates);

extern Brutus_Loader_Impl_Export bool rowentry_brutus_to_mapi(const ::BRUTUS::ROWENTRY *Brutus_Rowentry,
							      void *Parent,
							      ::ROWENTRY *& Mapi_Rowentry);

extern Brutus_Loader_Impl_Export bool rowentry_brutus_to_mapi_internal_alloc(const ::BRUTUS::ROWENTRY *Brutus_Rowentry,
									     void *Parent,
									     ::ROWENTRY * const Mapi_Rowentry);

extern Brutus_Loader_Impl_Export bool rowentry_array_brutus_to_mapi(const ::BRUTUS::seq_ROWENTRY *Brutus_RowList,
								    void *Parent,
								    ::ROWLIST *& Mapi_RowList);

extern Brutus_Loader_Impl_Export bool action_mapi_to_brutus(::ACTION * Mapi_Action,
							    ::BRUTUS::ACTION_out Brutus_Action,
							    LPMAPISESSION Mapi_Session,
							    PortableServer::POA_ptr Poa,
							    bool DeAlloc = false);

extern Brutus_Loader_Impl_Export LPWSTR ascii_to_unicode(void *Parent,
							 const char *str);

extern Brutus_Loader_Impl_Export LPWSTR utf8_to_unicode(void *Parent,
							const char *str);

extern Brutus_Loader_Impl_Export char *unicode_to_utf8(LPCWSTR wstr);

extern Brutus_Loader_Impl_Export char *utf8_to_codepage(void *Parent,
							const char *str,
							const unsigned long codepage);

extern Brutus_Loader_Impl_Export char *codepage_to_utf8(void *Parent,
							const char *str,
							const unsigned long codepage);

extern Brutus_Loader_Impl_Export bool large_int_mapi_to_brutus_server_version(::LARGE_INTEGER *Mapi_LI,
									      ::BRUTUS::SERVER_VERSION_out Version);

#endif //  _CONV_UTILS_H_
