/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef _IEIHC_UTILS_H_
#define _IEIHC_UTILS_H_

#include "IExchangeImportHierarchyChangesC.h"
#include "edkguid.h"

#include <tao/PortableServer/PortableServer.h>

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>
#include "edkmdb.h"

class CExchangeImportHierarchyChanges : public virtual IExchangeImportHierarchyChanges {
public:
	CExchangeImportHierarchyChanges(BRUTUS::IExchangeImportHierarchyChanges_ptr BrutusIEIHC,
					LPMAPISESSION MAPISession,
					PortableServer::POA_ptr Poa)
		:
		ref_count_(0),
		stream_(NULL),
		mapi_session_(MAPISession),
		poa_(PortableServer::POA::_duplicate(Poa)),
		brutus_obj_(BRUTUS::IExchangeImportHierarchyChanges::_duplicate(BrutusIEIHC))
		{
			mapi_session_->AddRef();
			InitializeCriticalSection(&critical_section_);
			AddRef();
		};

	STDMETHODIMP QueryInterface(REFIID riid,
				    LPVOID *ppvObj)
		{
			HRESULT hr = E_NOINTERFACE;
			*ppvObj = 0;

			if ((IID_IUnknown == riid) || (IID_IExchangeImportHierarchyChanges == riid)) {
				*ppvObj = (IExchangeImportHierarchyChanges*)this;
				AddRef();
				hr = S_OK;
			}

			return hr;
		};


	STDMETHODIMP_(ULONG) AddRef()
		{
			EnterCriticalSection(&critical_section_);
			ULONG count = ++ref_count_;
			LeaveCriticalSection(&critical_section_);

			return count;
		};


	STDMETHODIMP_(ULONG) Release()
		{
			EnterCriticalSection(&critical_section_);
			ULONG count = --ref_count_;
			LeaveCriticalSection(&critical_section_);
			if (!count)
				delete this;

			return count;
		};

	virtual HRESULT STDMETHODCALLTYPE GetLastError(HRESULT hResult,
						       ULONG ulFlags,
						       LPMAPIERROR FAR * lppMAPIError);

	virtual HRESULT STDMETHODCALLTYPE Config(LPSTREAM lpStream,
						 ULONG ulFlags);

	virtual HRESULT STDMETHODCALLTYPE UpdateState(LPSTREAM lpStream);

	virtual HRESULT STDMETHODCALLTYPE ImportFolderChange(ULONG cValue,
							     LPSPropValue lpPropArray);

	virtual HRESULT STDMETHODCALLTYPE ImportFolderDeletion(ULONG ulFlags,
							       LPENTRYLIST lpSourceEntryList);


private:
	~CExchangeImportHierarchyChanges()
		{
			if (stream_)
				stream_->Release();

			if (mapi_session_)
				mapi_session_->Release();

			DeleteCriticalSection(&critical_section_);
			brutus_obj_->Destroy(0);
		};

	LONG ref_count_;
	LPSTREAM stream_;
	LPMAPISESSION mapi_session_;
	PortableServer::POA_var poa_;
	CRITICAL_SECTION critical_section_;
	BRUTUS::IExchangeImportHierarchyChanges_var brutus_obj_;
};

#endif //  _IEIHC_UTILS_H_
