/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "progress_utils.h"
#include "conv_utils.h"
#include "utils/macros.h"

HRESULT CMAPIProgress::Progress(ULONG ulValue,
				ULONG ulCount,
				ULONG ulTotal)
{
	if (CORBA::is_nil(brutus_progress_))
		return S_OK;

	BRUTUS::BRESULT br;
	try {
		br = brutus_progress_->Progress((CORBA::ULong)ulValue,
						(CORBA::ULong)ulCount,
						(CORBA::ULong)ulTotal);
	}
	catch (...) {
		BRUTUS_LOG_BUG("Exception caught from client in BRUTUS::IMAPIProgress::Progress()");
		return E_FAIL;
	}

	HRESULT hr;
	if (!bresult_to_hresult(br, hr)) {
		hr = E_FAIL;
		BRUTUS_LOG_BUG("Could not convert BRESULT into HRESULT");
	}

	return hr;
}


HRESULT CMAPIProgress::GetFlags(ULONG FAR *lpulFlags)
{
	if (CORBA::is_nil(brutus_progress_)) {
		*lpulFlags = flags_;
		return S_OK;
	}

	CORBA::ULong flags;
	BRUTUS::BRESULT br;
	try {
		br = brutus_progress_->GetFlags(flags);
	}
	catch (...) {
		BRUTUS_LOG_BUG("Exception caught from BRUTUS::IMAPIProgress::GetFlags()");
		return E_FAIL;
	}
	*lpulFlags = flags;

	HRESULT hr;
	if (!bresult_to_hresult(br, hr)) {
		hr = E_FAIL;
		BRUTUS_LOG_BUG("Could not convert BRESULT into HRESULT");
	}

	return hr;
}


HRESULT CMAPIProgress::GetMax(ULONG FAR *lpulMax)
{
	if (CORBA::is_nil(brutus_progress_)) {
		*lpulMax = max_;
		return S_OK;
	}

	CORBA::ULong max;
	BRUTUS::BRESULT br;
	try {
		br = brutus_progress_->GetMax(max);
	}
	catch (...) {
		BRUTUS_LOG_BUG("Exception caught from BRUTUS::IMAPIProgress::GetMax()");
		return E_FAIL;
	}
	*lpulMax = max;

	HRESULT hr;
	if (!bresult_to_hresult(br, hr)) {
		hr = E_FAIL;
		BRUTUS_LOG_BUG("Could not convert BRESULT into HRESULT");
	}

	return hr;
}


HRESULT CMAPIProgress::GetMin(ULONG FAR *lpulMin)
{
	if (CORBA::is_nil(brutus_progress_)) {
		*lpulMin = min_;
		return S_OK;
	}

	CORBA::ULong min;
	BRUTUS::BRESULT br;
	try {
		br = brutus_progress_->GetMin(min);
	}
	catch (...) {
		BRUTUS_LOG_BUG("Exception caught from BRUTUS::IMAPIProgress::GetMin()");
		return E_FAIL;
	}
	*lpulMin = min;

	HRESULT hr;
	if (!bresult_to_hresult(br, hr)) {
		hr = E_FAIL;
		BRUTUS_LOG_BUG("Could not convert BRESULT into HRESULT");
	}

	return hr;
}


HRESULT CMAPIProgress::SetLimits(LPULONG lpulMin,
				 LPULONG lpulMax,
				 LPULONG lpulFlags)
{
	if (CORBA::is_nil(brutus_progress_)) {
		min_ = *lpulMin;
		max_ = *lpulMax;
		flags_ = *lpulFlags;
		return S_OK;
	}

	BRUTUS::BRESULT br;
	try {
		br = brutus_progress_->SetLimits((CORBA::ULong)*lpulMin,
						 (CORBA::ULong)*lpulMax,
						 (CORBA::ULong)*lpulFlags);
	}
	catch (...) {
		BRUTUS_LOG_BUG("Exception caught from BRUTUS::IMAPIProgress::SetLimits()");
		return E_FAIL;
	}

	HRESULT hr;
	if (!bresult_to_hresult(br, hr)) {
		hr = E_FAIL;
		BRUTUS_LOG_BUG("Could not convert BRESULT into HRESULT");
	}

	return hr;
}
