/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef _RECUR_UTILS_H_
#define _RECUR_UTILS_H_

#include "typesC.h"
#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>

class invalid_index {
public:
	invalid_index(void)
		{ };

	~invalid_index(void)
		{ };
};

class invalid_operation {
public:
	invalid_operation(void)
		{ };

	~invalid_operation(void)
		{ };
};


class ByteArray;
class RecurBase;

class MAPIRecurrence {
public:
	MAPIRecurrence(void);

	~MAPIRecurrence(void);

	template<class T> T get_as(const size_t idx);

	void reset(void);

	// reads an SBinary into the private state
	bool read(const SBinary *RecurrenceState);

	// write all infomation from the private state into an SBinary
	bool write(void *Parent,
		   SBinary * const bin);

	::CORBA::ULong get_occurrence_count(void);

	::CORBA::ULong get_exception_count(void);

	::CORBA::ULong get_modification_count(void);

	::BRUTUS::RecurrenceType get_type(void);

	::BRUTUS::RecurrenceTerminationType get_termination_type(void);

	::BRUTUS::DayOfWeek get_first_day_of_week(void);

	void get_pattern(::BRUTUS::RecurrencePattern_out pattern);

	void get_exception_set(const bool is_event,
			       const ::BRUTUS::OccurrenceTimeType time_format,
			       FILETIME * const start,
			       ::BRUTUS::seq_RecurrenceExceptionData_out data_set);

	// construct an internal recurrence state from a pattern
	bool set_pattern(::CORBA::Boolean is_event,
			 const ::BRUTUS::FILETIME & start,
			 const ::BRUTUS::OccurrenceTime & end,
			 ::CORBA::ULong duration,
			 ::BRUTUS::DayOfWeek first_day_of_week,
			 ::BRUTUS::RecurrenceTerminationType how_to_end,
			 const ::BRUTUS::RecurrencePattern & pattern);

	// will modify one, and only one, occurrence in the series
	bool set_exception(const ::BRUTUS::RecurrenceExceptionData & exception_data);

	// as set_exception() but will ignore the exception if its
	// OccurrenceTime is equal to 'not_this'
	bool set_exception_cond(const ::BRUTUS::RecurrenceExceptionData & exception_data,
				const ::BRUTUS::OccurrenceTime & not_this);

private:
	RecurBase *mapi_pattern_; // the logic to perform operations on the binary representation
	ByteArray *data_; // internal recurrence state in a binary representation
	::BRUTUS::RecurrenceType type_;
	size_t spec_size_;
};

#endif  /* _RECUR_UTILS_H_ */
