/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef _TEMPLATES_I_
#define _TEMPLATES_I_

#include <windows.h>

template<typename Servant, typename Brutus_Object, typename IMAPI_Pointer>
static inline typename Brutus_Object::_ptr_type create_object(IMAPI_Pointer MAPI_Interface,
							      PortableServer::POA_ptr Poa,
							      LPMAPISESSION Mapi_Session)
{
	if (!MAPI_Interface)
		return Brutus_Object::_nil();

	Servant *servant = NULL;
	try {
		servant = new Servant(MAPI_Interface, Mapi_Session, Poa);
	}
	catch (std::bad_alloc&) {
		BRUTUS_LOG_ERR("No memory");
		MAPI_Interface->Release();

		throw CORBA::NO_MEMORY();
	}
	catch (...) {
		BRUTUS_LOG_BUG("Exception caught");
		return Brutus_Object::_nil();
	}

	try {
		PortableServer::ServantBase_var owner_transfer(servant);

		PortableServer::ObjectId_var oid;
		oid = Poa->activate_object(servant);
		CORBA::Object_var obj = Poa->id_to_reference(oid);
		typename Brutus_Object::_var_type narrowed_obj = Brutus_Object::_narrow(obj);

		return narrowed_obj._retn();
	}
	catch (...) {
		BRUTUS_LOG_BUG("Exception caught");
		return Brutus_Object::_nil();
	}
}

//
// MAPI_Type is a simple non-interface MAPI type, typically an instantiated
// restriction variable, *never* a MAPI interface.
//
template<typename Servant, typename Brutus_Object, typename MAPI_Pointer>
static inline typename Brutus_Object::_ptr_type create_type_container(MAPI_Pointer MAPI_Type,
								      LPMAPISESSION MAPISession,
								      PortableServer::POA_ptr Poa)
{
	if (!MAPI_Type)
		return Brutus_Object::_nil();

	Servant *servant = NULL;
	try {
		servant = new Servant(MAPI_Type, MAPISession, Poa);
	}
	catch (std::bad_alloc&) {
		BRUTUS_LOG_ERR("No memory");
		throw CORBA::NO_MEMORY();
	}

	try {
		PortableServer::ServantBase_var owner_transfer(servant);

		PortableServer::ObjectId_var oid;
		oid = Poa->activate_object(servant);
		CORBA::Object_var obj = Poa->id_to_reference(oid);
		typename Brutus_Object::_var_type narrowed_obj = Brutus_Object::_narrow(obj);

		return narrowed_obj._retn();
	}
	catch (...) {
		BRUTUS_LOG_BUG("Exception caught");
		return Brutus_Object::_nil();
	}
}

//
// MAPI_Type is an interface MAPI type such as IMsgStore.
// This function will check the validity of the provided
// interface pointer.
//
template<typename MAPI_Interface>
static inline bool valid_mapi_interface_pointer(MAPI_Interface *lpInterface)
{
	if (NULL == lpInterface)
		return false;

	if (IsBadReadPtr(lpInterface, sizeof(MAPI_Interface)))
		return false;

	if (IsBadWritePtr(lpInterface, sizeof(MAPI_Interface)))
		return false;

	return true;
}

template<typename T>
static inline typename T::_ptr_type resolve_init(CORBA::ORB_ptr Orb,
						 const char *Name)
{
	std::string ref(Name);

	CORBA::Object_var obj = CORBA::Object::_nil();
	try {
		obj = Orb->resolve_initial_references(Name);
	}
	catch (const CORBA::ORB::InvalidName &e) {
		e._tao_print_exception("Invalid initial reference");
		throw 0;
	}
	catch (const CORBA::Exception &e) {
		e._tao_print_exception("Could not resolve initial reference");
		throw 0;
	}
	catch (...) {
		throw 0;
	}
	if (CORBA::is_nil(obj.in()))
		throw 0;

	typename T::_var_type retval = T::_nil();
	try {
		retval = T::_narrow(obj.in());
	}
	catch (const CORBA::Exception &e) {
		e._tao_print_exception("Could not narrow reference");
		throw 0;
	}
	catch (...) {
		throw 0;
	}
	if (CORBA::is_nil(retval.in())) {
		throw 0;
	}

	return retval._retn();
}


#endif // _TEMPLATES_I_
