/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef F2T_TYPESS_IMPL_H
#define F2T_TYPESS_IMPL_H

#include "typesS.h"
#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_IUnknown_i : public virtual POA_BRUTUS::IUnknown,
						    public virtual ::PortableServer::RefCountServantBase

{
public:

	BRUTUS_IUnknown_i(LPUNKNOWN Unknown,
			  LPMAPISESSION MAPISession,
			  ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:
	// Skeleton constructor
	BRUTUS_IUnknown_i(void)
	{ };

	virtual ~BRUTUS_IUnknown_i(void)
	{
		try {
			unknown_->Release();
			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	LPUNKNOWN unknown_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	ACE_RW_Mutex mutex_;
};


class Brutus_Loader_Impl_Export BRUTUS_SRestrictionContainer_i : public virtual POA_BRUTUS::SRestrictionContainer,
								 public virtual ::PortableServer::RefCountServantBase

{
public:
	BRUTUS_SRestrictionContainer_i(::SRestriction *Res,
				       LPMAPISESSION MAPISession,
				       ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::SRestriction * content(void);

	virtual void Destroy(void);

private:
	BRUTUS_SRestrictionContainer_i(void)
	{ };

	virtual ~BRUTUS_SRestrictionContainer_i(void)
	{
		MAPIFreeBuffer((void*)res_);
		try {

			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	::SRestriction *res_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SAndRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SAndRestriction_i : public virtual POA_BRUTUS::SAndRestriction,
							   public virtual ::PortableServer::RefCountServantBase

{
public:
	BRUTUS_SAndRestriction_i(::SAndRestriction *Res,
				 LPMAPISESSION MAPISession,
				 ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::seq_SRestriction * lpRes(void);

private:
	BRUTUS_SAndRestriction_i (void)
	{ };

	virtual ~BRUTUS_SAndRestriction_i (void)
	{
		try {

			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	::SAndRestriction *res_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;
};

//Class BRUTUS_SOrRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SOrRestriction_i : public virtual POA_BRUTUS::SOrRestriction,
							  public virtual ::PortableServer::RefCountServantBase

{
public:
	BRUTUS_SOrRestriction_i(::SOrRestriction *Res,
				LPMAPISESSION MAPISession,
				::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::seq_SRestriction * lpRes(void);

private:
	BRUTUS_SOrRestriction_i (void)
	{ };

	virtual ~BRUTUS_SOrRestriction_i (void)
	{
		try {

			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	::SOrRestriction *res_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SNotRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SNotRestriction_i : public virtual POA_BRUTUS::SNotRestriction,
							   public virtual ::PortableServer::RefCountServantBase

{
public:
	BRUTUS_SNotRestriction_i(::SNotRestriction *Res,
				 LPMAPISESSION MAPISession,
				 ::PortableServer::POA_ptr Poa);

	virtual ::CORBA::ULong ulReserved(void);

	virtual void ulReserved(::CORBA::ULong ulReserved);

	virtual ::BRUTUS::SRestriction * lpRes(void);


private:
	BRUTUS_SNotRestriction_i (void)
	{ };

	virtual ~BRUTUS_SNotRestriction_i (void)
	{
		try {

			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	::SNotRestriction *res_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SContentRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SContentRestriction_i : public virtual POA_BRUTUS::SContentRestriction,
							       public virtual ::PortableServer::RefCountServantBase

{
public:
	BRUTUS_SContentRestriction_i(::SContentRestriction *Res,
				     LPMAPISESSION MAPISession,
				     ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::FUZZY_TYPE ulFuzzyLevel(void);

	virtual ::CORBA::ULong ulPropTag(void);

	virtual ::BRUTUS::SPropValue * lpProp(void);

private:
	BRUTUS_SContentRestriction_i (void)
	{ };

	virtual ~BRUTUS_SContentRestriction_i (void)
	{
		try {

			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	::SContentRestriction *res_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SPropertyRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SPropertyRestriction_i : public virtual POA_BRUTUS::SPropertyRestriction,
								public virtual ::PortableServer::RefCountServantBase

{
public:
	BRUTUS_SPropertyRestriction_i(::SPropertyRestriction *Res,
				      LPMAPISESSION MAPISession,
				      ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::RELOP_TYPE relop(void);

	virtual ::CORBA::ULong ulPropTag(void);

	virtual ::BRUTUS::SPropValue * lpProp(void);

private:
	BRUTUS_SPropertyRestriction_i (void)
	{ };

	virtual ~BRUTUS_SPropertyRestriction_i (void)
	{
		try {

			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	::SPropertyRestriction *res_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SComparePropsRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SComparePropsRestriction_i : public virtual POA_BRUTUS::SComparePropsRestriction,
								    public virtual ::PortableServer::RefCountServantBase

{
public:
	BRUTUS_SComparePropsRestriction_i(::SComparePropsRestriction *Res,
					  LPMAPISESSION MAPISession,
					  ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::RELOP_TYPE relop(void);

	virtual ::CORBA::ULong ulPropTag1(void);

	virtual ::CORBA::ULong ulPropTag2(void);

private:
	BRUTUS_SComparePropsRestriction_i (void)
	{ };

	virtual ~BRUTUS_SComparePropsRestriction_i (void)
	{ };

	::SComparePropsRestriction *res_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SBitMaskRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SBitMaskRestriction_i : public virtual POA_BRUTUS::SBitMaskRestriction,
							       public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_SBitMaskRestriction_i(::SBitMaskRestriction *Res,
				     LPMAPISESSION MAPISession,
				     ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BMR_TYPE relBMR(void);

	virtual ::CORBA::ULong ulPropTag(void);

	virtual ::CORBA::ULong ulMask(void);

private:
	BRUTUS_SBitMaskRestriction_i (void)
	{ };

	virtual ~BRUTUS_SBitMaskRestriction_i (void)
	{ };

	::SBitMaskRestriction *res_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SSizeRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SSizeRestriction_i : public virtual POA_BRUTUS::SSizeRestriction,
							    public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_SSizeRestriction_i(::SSizeRestriction *Res,
				  LPMAPISESSION MAPISession,
				  ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::RELOP_TYPE relop(void);

	virtual ::CORBA::ULong ulPropTag(void);

	virtual ::CORBA::ULong cb(void);

private:
	BRUTUS_SSizeRestriction_i (void)
	{ };

	virtual ~BRUTUS_SSizeRestriction_i (void)
	{ };

	::SSizeRestriction *res_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SExistRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SExistRestriction_i : public virtual POA_BRUTUS::SExistRestriction,
							     public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_SExistRestriction_i(::SExistRestriction *Res,
				   LPMAPISESSION MAPISession,
				   ::PortableServer::POA_ptr Poa);

	virtual ::CORBA::ULong ulReserved1(void);

	virtual void ulReserved1(::CORBA::ULong ulReserved1);

	virtual ::CORBA::ULong ulPropTag(void);

	virtual ::CORBA::ULong ulReserved2(void);

	virtual void ulReserved2(::CORBA::ULong ulReserved2);

private:
	BRUTUS_SExistRestriction_i (void)
	{ };

	virtual ~BRUTUS_SExistRestriction_i (void)
	{ };

	::SExistRestriction *res_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SSubRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SSubRestriction_i : public virtual POA_BRUTUS::SSubRestriction,
							   public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_SSubRestriction_i(::SSubRestriction *Res,
				 LPMAPISESSION MAPISession,
				 ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BDEFINE ulSubObject(void);

	virtual ::BRUTUS::SRestriction * lpRes(void);

private:
	BRUTUS_SSubRestriction_i (void)
	{ };

	virtual ~BRUTUS_SSubRestriction_i (void)
	{
		try {

			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	::SSubRestriction *res_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;
};


//Class BRUTUS_SCommentRestriction_i
class Brutus_Loader_Impl_Export BRUTUS_SCommentRestriction_i : public virtual POA_BRUTUS::SCommentRestriction,
							       public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_SCommentRestriction_i(::SCommentRestriction *Res,
				     LPMAPISESSION MAPISession,
				     ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::SRestriction * lpRes(void);

	virtual ::BRUTUS::seq_SPropValue * lpProp(void);

private:
	//Constructor
	BRUTUS_SCommentRestriction_i (void)
	{ };

	//Destructor
	virtual ~BRUTUS_SCommentRestriction_i (void)
	{
		try {

			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	::SCommentRestriction *res_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;
};

#endif // F2T_TYPESS_IMPL_H
