/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef F2T_BRUTUSLOGONS_IMPL_H
#define F2T_BRUTUSLOGONS_IMPL_H

#include "idl/BrutusLogOnS.h"
#include "idl/IMAPISessionC.h"
#include "idl/BrutusCheckC.h"
#include "utils/macros.h"
#include "utils/poa_utils.h"
#include "utils/logging.h"
#include "winsec.h"

#include <windows.h>
#include <winuser.h>

class BRUTUS_BrutusLogOn_i : public virtual POA_BRUTUS::BrutusLogOn,
			     public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_BrutusLogOn_i(const char * const basedir,
			     ::PortableServer::POA_ptr Poa,
			     ::CORBA::ORB_ptr ORB = ::CORBA::ORB::_nil());

	virtual void GetVersion(::BRUTUS::BrutusLogOn::BrutusVersion_out version);

	virtual ::BRUTUS::BRESULT Logon(::BRUTUS::BrutusCheck_ptr Lifeline,
					const char *MAPIProfileName,
					const char *MAPIProfilePassword,
					const char *WindowsUserName,
					const char *WindowsDomainName,
					const char *WindowsUserPassword,
					const char *MailboxName,
					const char *ServerName,
					::BRUTUS::BDEFINE LogonFlags,
					::BRUTUS::BDEFINE ProfileFlags,
					::BRUTUS::SERVER_TYPE ServerType,
					::CORBA::ULong_out InstanceID,
					::BRUTUS::IMAPISession_out Session);

private:
	BRUTUS_BrutusLogOn_i(void)
		{ };

	virtual ~BRUTUS_BrutusLogOn_i(void)
		{
			if (basedir_)
				free(basedir_);
		};

	::BRUTUS::BRESULT create_session(const char *life_line_ior,
					 const char *MAPIProfileName,
					 const char *MAPIProfilePassword,
					 const char *WindowsUserName,
					 const char *WindowsDomainName,
					 const char *WindowsPassword,
					 const char *MailboxName,
					 const char *ServerName,
					 ::BRUTUS::BDEFINE LogonFlags,
					 ::BRUTUS::BDEFINE ProfileFlags,
					 ::BRUTUS::SERVER_TYPE ServerType,
					 ::CORBA::ULong_out InstanceID,
					 ::BRUTUS::IMAPISession_out Session);

	::PortableServer::POA_var poa_;
	::CORBA::ORB_var internal_orb_;
	ACE_RW_Mutex create_proxy_mutex_;
	ACE_RW_Mutex sec_mutex_;

	char *basedir_;
};


#endif /* F2T_BRUTUSLOGONS_IMPL_H  */
