/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Definition of Brutus Server service. An instance of this class
 * initializes the  ORB, gets the root POA, POA Manager Factory,
 * IOR Table, and finally runs the ORB.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef F2T_SERVER_H
#define F2T_SERVER_H

#include "utils/config.h"
#include "BrutusLogOnS_impl.h"
#include "idl/ReferenceMapperC.h"

#include <string>
#include <ace/Task.h>
#include <tao/ORB.h>
#include <tao/PortableServer/POAC.h>
#include <tao/IORTable/IORTable.h>
#include <tao/PortableServer/POAManagerFactoryC.h>

namespace BRUTUS
{
        /*
         * The BrutusServer class contains all the base elements 
         * used to support the application. It is based on ACE_Task_Base
         * so that it may be easily threaded.
         */

        class BrutusServer : public ACE_Task_Base {
        public:
                class InitError{};

		BrutusServer(const bool debug,
			     int argc,
			     ACE_TCHAR *argv[]);

                virtual ~BrutusServer(void);

                // override the local pid/log files if the commandline 
                // indicates use of alternate paths.
                void local_pid_file (const std::string &lpf);
                void local_ior_file (const std::string &lif);

                // load configuration based on supplied config file
                virtual void configure(BRUTUS::Config & config);

                // ACE Task base generic initializer - args[0] is config file name
                virtual int open(void *args = 0);

                // ACE Task base executable method.
                virtual int svc(void);

                void shutdown(void);

        private:
                bool setup_shutdown_handler(void);

                static BrutusServer* this_;

                friend int signal_handler(int signum);

                CORBA::ORB_var orb_;
                PortableServer::POA_var root_poa_;
                PortableServer::POA_var factory_poa_;
                PortableServer::POAManagerFactory_var pmf_;
                PortableServer::POAManager_var root_poa_manager_;
                PortableServer::POAManager_var factory_poa_manager_;
                IORTable::Table_var ior_table_;
                PortableServer::POA_var admin_poa_;

		::BRUTUS::BrutusLogOn_var brutus_logon_;
		::Lorica::ReferenceMapper_var reference_mapper_;
		::CORBA::Object_var logon_mapped_;
		::CORBA::Object_var logon_mapped_secure_;

                std::string pid_file_;
                std::string ior_file_;
                std::string local_pid_file_;
                std::string local_ior_file_;

                bool must_shutdown_;
                bool debug_;

		int argc_;
		ACE_TCHAR **argv_;
        };

        int signal_handler(int signum);

}  /* namespace BRUTUS */

#endif // F2T_SERVER_H
