/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef F2T_WINSEC_H
#define F2T_WINSEC_H

#include <windows.h>

extern bool create_domain_sid(PSID Sid, PSID &DomainSid);

extern bool ObtainUserSid(HANDLE hToken, // Handle to a user token.
			  PSID *psid);   // ptr to the buffer of the user sid

extern bool AddTheAceWindowStation(HWINSTA hwinsta, // handle to a windowstation
				   PSID psid);      // logon sid of the process

extern bool AddTheAceDesktop(HDESK hdesk, // handle to a desktop
			     PSID  psid); // logon sid of the process

// Inspects the object and returns true if the 
// ACE is present in the objects DACL false otherwise
extern bool user_object_has_ace(HANDLE object,
				const ACCESS_ALLOWED_ACE * const ace);

// Will add appropiate ACEs to the windows statyion and desktop
// to grant domain users appropiate rights to have impersonated 
// processes spawned on their behalf.
extern bool adjust_dacls(PSID domain_sid);

#endif //  F2T_WINSEC_H
