/*
 *    Brutus header file for a configuration file class.
 *    Copyright (C) 2004-2008 OMC Denmark ApS.
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef F2T_CONFIG_H
#define F2T_CONFIG_H

#include <stdlib.h>
#include <string.h>
#include <new>

#include "Brutus_Utils_Export.h"

namespace BRUTUS {
        class Brutus_Utils_Export Config {
        public:
                Config(const char *stack_token)
                        {
                                _fbuf = NULL;
                                _items = NULL;
                                _fsize = 0;
                                _stack = _strdup(stack_token);
                                if (!_stack)
                                        throw std::bad_alloc();
                        };

                Config(void)
                        {
                                _fbuf = NULL;
                                _items = NULL;
                                _fsize = 0;
                                _stack = NULL;
                        };

                ~Config()
                        {
                                if (_fbuf)
                                        free(_fbuf);

                                if (_items)
                                        free(_items);

                                if (_stack)
                                        free(_stack);
                        };

                // Loads the configuration file
                int load(const char *file);

                // Will cyclically get all the item pairs, starting
                // at the first, returning false when there are no more.
                //
                // *MUST* be called before get_value().
                //
                bool get_token_value_pair(const char *token,
                                          const char *value);

                // Will return the textual value of the token
                char *get_value(const char *token);

        private:
                int _lnum;
                char *_fbuf;
                size_t _fsize;
                char *_stack;

                struct item {
                        char *token;
                        char *value;
                };
                struct item *_items;

                // whitespace?
                bool wspace(char c)
                        {
                                switch (c) {
                                case ' ' :
                                case '\t' :
                                case '\r' :
                                        return true;
                                default:
                                        return false;
                                }
                        };

                int itemize(void);
                int point_to_value(char **str, char **val);
                int get_next_line(char **str);
                int read_conf(const char *file_name, size_t *size, void **buf);
        };

};

#endif // F2T_CONFIG_H

/*
 * Local variables:
 * mode: C++
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 */
