/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef F2T_LOGGING_H
#define F2T_LOGGING_H

#include <ace/Singleton.h>
#include <fstream>
#include <iostream>

#include "Brutus_Utils_Export.h"

class Brutus_Utils_Export LogManager
{
public:
	LogManager();
	~LogManager();

	void redirectToSyslog(const ACE_TCHAR *prog_name = ACE_TEXT(""));

	void redirectToOStream(ACE_OSTREAM_TYPE *output);

	void redirectToFile(const char *filename);

	void redirectToStderr(void);

private:
	void writeHeader(void);

	std::ofstream *log_stream_;
	ACE_OSTREAM_TYPE *output_stream_;
};

typedef ACE_Singleton<LogManager, ACE_Null_Mutex> LogManagerSingleton;
#define LOG_MANAGER LogManagerSingleton::instance()

#endif // F2T_LOGGING_H
