/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef F2T_MACROS_H
#define F2T_MACROS_H

#include "logging.h"
#include "idl/definesC.h"

#include <mapidefs.h>
#include "idl/edkmdb.h"
#include "idl/edkcode.h"
#include <mapicode.h>

extern "C" unsigned int brutus_debug_level;



/***************************************************/

/*
 * Enable MAPI property content scrambling - big
 * performance hit
 */
#if defined(DO_CONTENT_SCRAMBLING)
#undef DO_CONTENT_SCRAMBLING
#endif
#define DO_CONTENT_SCRAMBLING


/***************************************************/

/*
 * (de-)activates the LOG macros
 */

// Active when brutus_debug_level >= 1
#if defined(DO_BRUTUS_LOG_BUG)
#undef DO_BRUTUS_LOG_BUG
#endif
#define DO_BRUTUS_LOG_BUG
#if defined(BRUTUS_LOG_BUG_TRIGGER)
#undef BRUTUS_LOG_BUG_TRIGGER
#endif
#define BRUTUS_LOG_BUG_TRIGGER (1)

// Active when brutus_debug_level >= 1
#if defined(DO_BRUTUS_LOG_CRITICAL)
#undef DO_BRUTUS_LOG_CRITICAL
#endif
#define DO_BRUTUS_LOG_CRITICAL
#if defined(BRUTUS_LOG_CRITICAL_TRIGGER)
#undef BRUTUS_LOG_CRITICAL_TRIGGER
#endif
#define BRUTUS_LOG_CRITICAL_TRIGGER (1)

// Active when brutus_debug_level >= 2
#if defined(DO_BRUTUS_LOG_ERR)
#undef DO_BRUTUS_LOG_ERR
#endif
#define DO_BRUTUS_LOG_ERR
#if defined(BRUTUS_LOG_ERR_TRIGGER)
#undef BRUTUS_LOG_ERR_TRIGGER
#endif
#define BRUTUS_LOG_ERR_TRIGGER (2)

// Active when brutus_debug_level >= 5
#if defined(DO_BRUTUS_LOG_INF)
#undef DO_BRUTUS_LOG_INF
#endif
#define DO_BRUTUS_LOG_INF
#if defined(BRUTUS_LOG_INF_TRIGGER)
#undef BRUTUS_LOG_INF_TRIGGER
#endif
#define BRUTUS_LOG_INF_TRIGGER (5)

// Active when brutus_debug_level >= 4
#if defined(DO_BRUTUS_LOG_PRIVATE)
#undef DO_BRUTUS_LOG_PRIVATE
#endif
#define DO_BRUTUS_LOG_PRIVATE
#if defined(BRUTUS_LOG_PRIVATE_TRIGGER)
#undef BRUTUS_LOG_PRIVATE_TRIGGER
#endif
#define BRUTUS_LOG_PRIVATE_TRIGGER (4)

// Active when brutus_debug_level >= 3
#if defined(DO_BRUTUS_LOG_EXIT)
#undef DO_BRUTUS_LOG_EXIT
#endif
#define DO_BRUTUS_LOG_EXIT
#if defined(BRUTUS_LOG_EXIT_TRIGGER)
#undef BRUTUS_LOG_EXIT_TRIGGER
#endif
#define BRUTUS_LOG_EXIT_TRIGGER (3)

// Active when brutus_debug_level >= 3
#if defined(DO_BRUTUS_LOG_GETLASTERROR)
#undef DO_BRUTUS_LOG_GETLASTERROR
#endif
#define DO_BRUTUS_LOG_GETLASTERROR
#if defined(BRUTUS_LOG_GETLASTERROR_TRIGGER)
#undef BRUTUS_LOG_GETLASTERROR_TRIGGER
#endif
#define BRUTUS_LOG_GETLASTERROR_TRIGGER (3)

// Active when brutus_debug_level >= 3
#if defined(DO_BRUTUS_LOG_HR)
#undef DO_BRUTUS_LOG_HR
#endif
#define DO_BRUTUS_LOG_HR
#if defined(BRUTUS_LOG_HR_TRIGGER)
#undef BRUTUS_LOG_HR_TRIGGER
#endif
#define BRUTUS_LOG_HR_TRIGGER (3)

/*
 * Do we do any logging at all ?
 */
#if defined(DO_BRUTUS_LOG)
#undef DO_BRUTUS_LOG
#endif

#if defined(DO_BRUTUS_LOG_BUG)
#define DO_BRUTUS_LOG
#elif defined(DO_BRUTUS_LOG_CRITICAL)
#define DO_BRUTUS_LOG
#elif defined(DO_BRUTUS_LOG_ERR)
#define DO_BRUTUS_LOG
#elif defined(DO_BRUTUS_LOG_INF)
#define DO_BRUTUS_LOG
#elif defined(DO_BRUTUS_LOG_PRIVATE)
#define DO_BRUTUS_LOG
#elif defined(DO_BRUTUS_LOG_EXIT)
#define DO_BRUTUS_LOG
#elif defined(DO_BRUTUS_LOG_GETLASTERROR)
#define DO_BRUTUS_LOG
#elif defined(DO_BRUTUS_LOG_HR)
#define DO_BRUTUS_LOG
#else
#undef DO_BRUTUS_LOG
#endif


/***************************************************/

/*
 * Will generate a header entry in the log.
 */

#if defined(BRUTUS_LOG_REF)
#undef BRUTUS_LOG_REF
#endif

#if defined(DO_BRUTUS_LOG)
#define BRUTUS_LOG_REF while (0) { }	
#endif /* DO_BRUTUS_LOG_BUG */


/***************************************************/

/*
 * Must be used when encountering a clear bug in
 * client or server code i.e. at the developer level.
 * Examples are when an application are using an
 * unknown constant, illegal function parameters or
 * when an unknown (e.g unmapped) value is returned
 * from MAPI.
 */

#if defined(BRUTUS_LOG_BUG)
#undef BRUTUS_LOG_BUG
#endif

#if defined(DO_BRUTUS_LOG_BUG)
#define BRUTUS_LOG_BUG(macro_msg_) do { \
                ACE_DEBUG((LM_WARNING, ACE_TEXT("<%T > %N:%l - %s\n"), macro_msg_)); \
	} while(0)

#else
#define BRUTUS_LOG_BUG(macro_msg_) do { } while (0)
#endif /* DO_BRUTUS_LOG_BUG */


/***************************************************/

/*
 * Must be used when encountering an exception, or a
 * similar condition, in server code. Used for
 * unrecoverable errors.
 */

#if defined(BRUTUS_LOG_CRITICAL)
#undef BRUTUS_LOG_CRITICAL
#endif

#if defined(DO_BRUTUS_LOG_CRITICAL)
#define BRUTUS_LOG_CRITICAL(macro_msg_) do { \
                ACE_DEBUG((LM_CRITICAL, ACE_TEXT("<%T > %N:%l - %s\n"), macro_msg_)); \
	} while(0)

#else
#define BRUTUS_LOG_CRITICAL(macro_msg_) do { } while (0)
#endif /* DO_BRUTUS_LOG_CRITICAL */


/***************************************************/

/*
 * Must be used when encountering an error, such as
 * memory allocation failures or similar conditions,
 * in server or client code. Bugs in the low-level MAPI
 * libraries are reported with this macro as well.
 * Mostly used for recoverable errors.
 */

#if defined(BRUTUS_LOG_ERR)
#undef BRUTUS_LOG_ERR
#endif

#if defined(DO_BRUTUS_LOG_ERR)
#define BRUTUS_LOG_ERR(macro_msg_) do { \
                ACE_DEBUG((LM_NOTICE, ACE_TEXT("<%T > %N:%l - %s\n"), macro_msg_)); \
	} while(0)

#else
#define BRUTUS_LOG_ERR(macro_msg_) do { } while (0)
#endif /* DO_BRUTUS_LOG_ERR */

/***************************************************/

/*
 * Must be used to notify entrance and exit for all
 * functions in server code. Is intended to be used
 * to log all non-critical information as well.
 */

#if defined(BRUTUS_LOG_INF)
#undef BRUTUS_LOG_INF
#endif

#if defined(DO_BRUTUS_LOG_INF)
#define BRUTUS_LOG_INF(macro_msg_) do { \
                ACE_DEBUG((LM_DEBUG, ACE_TEXT("<%T > %N:%l - %s\n"), macro_msg_)); \
	} while(0)
#else
#define BRUTUS_LOG_INF(macro_msg_) do { } while (0)
#endif /* DO_BRUTUS_LOG_INF */

/***************************************************/

/*
 * Must only be used to log privacy related activity
 * of users, such as logon/logoff.
 */

#if defined(BRUTUS_LOG_PRIVATE)
#undef BRUTUS_LOG_PRIVATE
#endif

#if defined(DO_BRUTUS_LOG_PRIVATE)
#define BRUTUS_LOG_PRIVATE(macro_msg_) do { \
                ACE_DEBUG((LM_INFO, ACE_TEXT("<%T > %N:%l - %s\n"), macro_msg_)); \
	} while(0)
#else
#define BRUTUS_LOG_PRIVATE(macro_msg_) do { } while (0)
#endif /* DO_BRUTUS_LOG_PRIVATE */

/***************************************************/

/*
 * Macros to wrap "goto exit;" calls into usefull debugging output
 */
#if defined(BRUTUS_EXIT)
#undef BRUTUS_EXIT
#endif

#if defined(DO_BRUTUS_LOG_EXIT)
#define BRUTUS_EXIT do { \
		char msg_[64] = { '\0' };                                                   \
		sprintf_s(msg_, sizeof(msg_), "%#.8lx (\"%s\")", hr, hresult_to_str(hr));   \
		ACE_DEBUG((LM_INFO, ACE_TEXT("<%T > %N:%l - EXIT, HRESULT = %s\n"), msg_)); \
		goto exit; \
	} while(0)
#else
#define BRUTUS_EXIT do { goto exit; } while (0)
#endif /* DO_BRUTUS_LOG_EXIT */

/***************************************************/

/*
 * Macros to wrap GetLastError() into usefull debugging output
 */
#if defined(DO_BRUTUS_LOG_GETLASTERROR)
#define BRUTUS_LOG_GETLASTERROR(macro_msg_) do { \
		DWORD err_ = GetLastError();				                                                          \
		LPVOID msg_buf_ = NULL;				                                                                  \
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,                                        \
			      NULL,					                                                          \
			      err_,					                                                          \
			      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),                                                          \
			      (LPTSTR) &msg_buf_,			                                                          \
			      0,					                                                          \
			      NULL );					                                                          \
		((char*)msg_buf_)[strlen((char*)msg_buf_) - 2] = '\0';                                                            \
		char msg_[512] = { '\0' };                                                                                        \
		sprintf_s(msg_, sizeof(msg_), "%s, GetLastError() returned: %#.8lx (\"%s\")", macro_msg_, err_, (char*)msg_buf_); \
		ACE_DEBUG((LM_ERROR, ACE_TEXT("<%T > %N:%l - %s\n"), msg_));                                                      \
		LocalFree(msg_buf_);					                                                          \
	} while(0)
#else
#define BRUTUS_LOG_GETLASTERROR do { } while (0)
#endif /* DO_BRUTUS_LOG_GETLASTERROR */

/***************************************************/

/*
 * Macros to print the current value of hr
 */
#if defined(BRUTUS_LOG_HR)
#undef BRUTUS_LOG_HR
#endif

#if defined(DO_BRUTUS_LOG_HR)
#define BRUTUS_LOG_HR do { \
		char msg_[64] = { '\0' };                                                 \
		sprintf_s(msg_, sizeof(msg_), "%#.8lx (\"%s\")", hr, hresult_to_str(hr)); \
		ACE_DEBUG((LM_INFO, ACE_TEXT("<%T > %N:%l - HRESULT = %s\n"), msg_));     \
	} while (0)
#else
#define BRUTUS_LOG_HR do { } while (0)
#endif /* DO_BRUTUS_LOG_HR */

/***************************************************/


/*
 * Only here because I do this a lot, so a macro would
 * ease readability.
 *
 * Typesafe/64 bits clean.
 */

#if defined(FLAGS_OFF)
#undef FLAGS_OFF
#endif
#define FLAGS_OFF(type, value, flags) do {		\
		type all_bytes_ff = (type)0;		\
		all_bytes_ff = ~all_bytes_ff;		\
		(type)value &= all_bytes_ff^flags;	\
	} while (0)

/***************************************************/

/*
 * Only defined due to performance reasons..
 * GUID_A and GUID_B must be of type "GUID*"
 */


/*
 * The macro is comparing these structure members:
 *
 * Line 1 - data1
 * Line 2 - data 2 and 3
 * Line 3 - first half of data 4
 * Line 4 - second half of data 4
 */

#if defined(MAPI_GUIDS_EQUAL)
#undef MAPI_GUIDS_EQUAL
#endif
#define MAPI_GUIDS_EQUAL(GUID_A, GUID_B)				    \
	((((unsigned long*) GUID_A)[0] == ((unsigned long*) GUID_B)[0])	    \
	 && (((unsigned long*) GUID_A)[1] == ((unsigned long*) GUID_B)[1])  \
	 && (((unsigned long*) GUID_A)[2] == ((unsigned long*) GUID_B)[2])  \
	 && (((unsigned long*) GUID_A)[3] == ((unsigned long*) GUID_B)[3]))


/***************************************************/

#endif // F2T_MACROS_H
