#!/bin/sh

if [ $# -eq 0 ]; then
    version=""
else
    version="-$1"
fi

BDIR_ROOT=$HOME/tmp

rm -rf $BDIR_ROOT/brutus
mkdir -p $BDIR_ROOT/brutus

cd $HOME/work/src/42tools/ && svn export brutus-server $BDIR_ROOT/brutus/brutus-server
cd $BDIR_ROOT/brutus/brutus-server && rm -f *.wsi && rm -f edkinc/edkmdb.h 

cd $BDIR_ROOT/brutus && tar cf "brutus-server$version.tar" brutus-server/ 
cd $BDIR_ROOT/brutus && bzip2 -f "brutus-server$version.tar"

scp -i $HOME/.ssh/no_passphrase_id_rsa $BDIR_ROOT/brutus/brutus-server$version.tar.bz2 colding@42tools.com:
scp -i $HOME/.ssh/no_passphrase_id_rsa "$HOME/Public/brutus-install.exe" colding@42tools.com:

echo ""
echo "URLs are :"
echo ""
echo "           <http://www.42tools.com/sites/default/files/downloads/brutus-server$version.tar.bz2>"
echo "           <http://www.42tools.com/sites/default/files/downloads/brutus-install.exe>"
echo ""
