/*
 * Brutus source file for implementing a value to string helper class.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#include "bresult.h"


CBresult::CBresult()
{
	// Brutus-only return codes
	br_arr[::BRUTUS::BRUTUS_INTERNAL_ERROR] = "BRUTUS_INTERNAL_ERROR";
	br_arr[::BRUTUS::BRUTUS_UNKNOWN_ERROR] = "BRUTUS_UNKNOWN_ERROR";
	br_arr[::BRUTUS::BRUTUS_NO_MAPI_SESSION] = "BRUTUS_NO_MAPI_SESSION";
	br_arr[::BRUTUS::BRUTUS_EXCEPTION_FROM_CLIENT] = "BRUTUS_EXCEPTION_FROM_CLIENT";
	br_arr[::BRUTUS::BRUTUS_LIFELINE_TIMEOUT] = "BRUTUS_LIFELINE_TIMEOUT";

	// Generic return codes
	br_arr[::BRUTUS::BRUTUS_S_OK] = "BRUTUS_S_OK";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_CALL_FAILED] = "BRUTUS_MAPI_E_CALL_FAILED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY] = "BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER] = "BRUTUS_MAPI_E_INVALID_PARAMETER";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_INTERFACE_NOT_SUPPORTED] = "BRUTUS_MAPI_E_INTERFACE_NOT_SUPPORTED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NO_ACCESS] = "BRUTUS_MAPI_E_NO_ACCESS";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT] = "BRUTUS_MAPI_E_NO_SUPPORT";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_BAD_CHARWIDTH] = "BRUTUS_MAPI_E_BAD_CHARWIDTH";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_STRING_TOO_LONG] = "BRUTUS_MAPI_E_STRING_TOO_LONG";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_UNKNOWN_FLAGS] = "BRUTUS_MAPI_E_UNKNOWN_FLAGS";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_INVALID_ENTRYID] = "BRUTUS_MAPI_E_INVALID_ENTRYID";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_INVALID_OBJECT] = "BRUTUS_MAPI_E_INVALID_OBJECT";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_OBJECT_CHANGED] = "BRUTUS_MAPI_E_OBJECT_CHANGED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_OBJECT_DELETED] = "BRUTUS_MAPI_E_OBJECT_DELETED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_BUSY] = "BRUTUS_MAPI_E_BUSY";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NOT_ENOUGH_DISK] = "BRUTUS_MAPI_E_NOT_ENOUGH_DISK";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NOT_ENOUGH_RESOURCES] = "BRUTUS_MAPI_E_NOT_ENOUGH_RESOURCES";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NOT_FOUND] = "BRUTUS_MAPI_E_NOT_FOUND";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_VERSION] = "BRUTUS_MAPI_E_VERSION";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_LOGON_FAILED] = "BRUTUS_MAPI_E_LOGON_FAILED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_SESSION_LIMIT] = "BRUTUS_MAPI_E_SESSION_LIMIT";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_USER_CANCEL] = "BRUTUS_MAPI_E_USER_CANCEL";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_UNABLE_TO_ABORT] = "BRUTUS_MAPI_E_UNABLE_TO_ABORT";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NETWORK_ERROR] = "BRUTUS_MAPI_E_NETWORK_ERROR";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_DISK_ERROR] = "BRUTUS_MAPI_E_DISK_ERROR";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_TOO_COMPLEX] = "BRUTUS_MAPI_E_TOO_COMPLEX";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_BAD_COLUMN] = "BRUTUS_MAPI_E_BAD_COLUMN";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_EXTENDED_ERROR] = "BRUTUS_MAPI_E_EXTENDED_ERROR";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_COMPUTED] = "BRUTUS_MAPI_E_COMPUTED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_CORRUPT_DATA] = "BRUTUS_MAPI_E_CORRUPT_DATA";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_UNCONFIGURED] = "BRUTUS_MAPI_E_UNCONFIGURED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_FAILONEPROVIDER] = "BRUTUS_MAPI_E_FAILONEPROVIDER";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_UNKNOWN_CPID] = "BRUTUS_MAPI_E_UNKNOWN_CPID";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_UNKNOWN_LCID] = "BRUTUS_MAPI_E_UNKNOWN_LCID";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_PASSWORD_CHANGE_REQUIRED] = "BRUTUS_MAPI_E_PASSWORD_CHANGE_REQUIRED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_PASSWORD_EXPIRED] = "BRUTUS_MAPI_E_PASSWORD_EXPIRED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_INVALID_WORKSTATION_ACCOUNT] = "BRUTUS_MAPI_E_INVALID_WORKSTATION_ACCOUNT";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_INVALID_ACCESS_TIME] = "BRUTUS_MAPI_E_INVALID_ACCESS_TIME";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_ACCOUNT_DISABLED] = "BRUTUS_MAPI_E_ACCOUNT_DISABLED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_END_OF_SESSION] = "BRUTUS_MAPI_E_END_OF_SESSION";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_UNKNOWN_ENTRYID] = "BRUTUS_MAPI_E_UNKNOWN_ENTRYID";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_MISSING_REQUIRED_COLUMN] = "BRUTUS_MAPI_E_MISSING_REQUIRED_COLUMN";
	br_arr[::BRUTUS::BRUTUS_MAPI_W_NO_SERVICE] = "BRUTUS_MAPI_W_NO_SERVICE";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_BAD_VALUE] = "BRUTUS_MAPI_E_BAD_VALUE";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_INVALID_TYPE] = "BRUTUS_MAPI_E_INVALID_TYPE";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_TYPE_NO_SUPPORT] = "BRUTUS_MAPI_E_TYPE_NO_SUPPORT";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_UNEXPECTED_TYPE] = "BRUTUS_MAPI_E_UNEXPECTED_TYPE";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_TOO_BIG] = "BRUTUS_MAPI_E_TOO_BIG";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_DECLINE_COPY] = "BRUTUS_MAPI_E_DECLINE_COPY";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_UNEXPECTED_ID] = "BRUTUS_MAPI_E_UNEXPECTED_ID";
	br_arr[::BRUTUS::BRUTUS_MAPI_W_ERRORS_RETURNED] = "BRUTUS_MAPI_W_ERRORS_RETURNED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_UNABLE_TO_COMPLETE] = "BRUTUS_MAPI_E_UNABLE_TO_COMPLETE";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_TIMEOUT] = "BRUTUS_MAPI_E_TIMEOUT";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_TABLE_EMPTY] = "BRUTUS_MAPI_E_TABLE_EMPTY";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_TABLE_TOO_BIG] = "BRUTUS_MAPI_E_TABLE_TOO_BIG";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_INVALID_BOOKMARK] = "BRUTUS_MAPI_E_INVALID_BOOKMARK";
	br_arr[::BRUTUS::BRUTUS_MAPI_W_POSITION_CHANGED] = "BRUTUS_MAPI_W_POSITION_CHANGED";
	br_arr[::BRUTUS::BRUTUS_MAPI_W_APPROX_COUNT] = "BRUTUS_MAPI_W_APPROX_COUNT";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_WAIT] = "BRUTUS_MAPI_E_WAIT";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_CANCEL] = "BRUTUS_MAPI_E_CANCEL";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NOT_ME] = "BRUTUS_MAPI_E_NOT_ME";
	br_arr[::BRUTUS::BRUTUS_MAPI_W_CANCEL_MESSAGE] = "BRUTUS_MAPI_W_CANCEL_MESSAGE";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_CORRUPT_STORE] = "BRUTUS_MAPI_E_CORRUPT_STORE";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NOT_IN_QUEUE] = "BRUTUS_MAPI_E_NOT_IN_QUEUE";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NO_SUPPRESS] = "BRUTUS_MAPI_E_NO_SUPPRESS";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_COLLISION] = "BRUTUS_MAPI_E_COLLISION";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NOT_INITIALIZED] = "BRUTUS_MAPI_E_NOT_INITIALIZED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NON_STANDARD] = "BRUTUS_MAPI_E_NON_STANDARD";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_NO_RECIPIENTS] = "BRUTUS_MAPI_E_NO_RECIPIENTS";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_SUBMITTED] = "BRUTUS_MAPI_E_SUBMITTED";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_HAS_FOLDERS] = "BRUTUS_MAPI_E_HAS_FOLDERS";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_HAS_MESSAGES] = "BRUTUS_MAPI_E_HAS_MESSAGES";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_FOLDER_CYCLE] = "BRUTUS_MAPI_E_FOLDER_CYCLE";
	br_arr[::BRUTUS::BRUTUS_MAPI_W_PARTIAL_COMPLETION] = "BRUTUS_MAPI_W_PARTIAL_COMPLETION";
	br_arr[::BRUTUS::BRUTUS_MAPI_E_AMBIGUOUS_RECIP] = "BRUTUS_MAPI_E_AMBIGUOUS_RECIP";
	br_arr[::BRUTUS::BRUTUS_OLEOBJ_S_CANNOT_DOVERB_NOW] = "BRUTUS_OLEOBJ_S_CANNOT_DOVERB_NOW";
	br_arr[::BRUTUS::BRUTUS_STG_E_INVALIDFUNCTION] = "BRUTUS_STG_E_INVALIDFUNCTION";
	br_arr[::BRUTUS::BRUTUS_STG_E_FILENOTFOUND] = "BRUTUS_STG_E_FILENOTFOUND";
	br_arr[::BRUTUS::BRUTUS_STG_E_PATHNOTFOUND] = "BRUTUS_STG_E_PATHNOTFOUND";
	br_arr[::BRUTUS::BRUTUS_STG_E_TOOMANYOPENFILES] = "BRUTUS_STG_E_TOOMANYOPENFILES";
	br_arr[::BRUTUS::BRUTUS_STG_E_ACCESSDENIED] = "BRUTUS_STG_E_ACCESSDENIED";
	br_arr[::BRUTUS::BRUTUS_STG_E_INVALIDHANDLE] = "BRUTUS_STG_E_INVALIDHANDLE";
	br_arr[::BRUTUS::BRUTUS_STG_E_INSUFFICIENTMEMORY] = "BRUTUS_STG_E_INSUFFICIENTMEMORY";
	br_arr[::BRUTUS::BRUTUS_STG_E_INVALIDPOINTER] = "BRUTUS_STG_E_INVALIDPOINTER";
	br_arr[::BRUTUS::BRUTUS_STG_E_NOMOREFILES] = "BRUTUS_STG_E_NOMOREFILES";
	br_arr[::BRUTUS::BRUTUS_STG_E_DISKISWRITEPROTECTED] = "BRUTUS_STG_E_DISKISWRITEPROTECTED";
	br_arr[::BRUTUS::BRUTUS_STG_E_SEEKERROR] = "BRUTUS_STG_E_SEEKERROR";
	br_arr[::BRUTUS::BRUTUS_STG_E_WRITEFAULT] = "BRUTUS_STG_E_WRITEFAULT";
	br_arr[::BRUTUS::BRUTUS_STG_E_READFAULT] = "BRUTUS_STG_E_READFAULT";
	br_arr[::BRUTUS::BRUTUS_STG_E_SHAREVIOLATION] = "BRUTUS_STG_E_SHAREVIOLATION";
	br_arr[::BRUTUS::BRUTUS_STG_E_LOCKVIOLATION] = "BRUTUS_STG_E_LOCKVIOLATION";
	br_arr[::BRUTUS::BRUTUS_STG_E_FILEALREADYEXISTS] = "BRUTUS_STG_E_FILEALREADYEXISTS";
	br_arr[::BRUTUS::BRUTUS_STG_E_INVALIDPARAMETER] = "BRUTUS_STG_E_INVALIDPARAMETER";
	br_arr[::BRUTUS::BRUTUS_STG_E_MEDIUMFULL] = "BRUTUS_STG_E_MEDIUMFULL";
	br_arr[::BRUTUS::BRUTUS_STG_E_PROPSETMISMATCHED] = "BRUTUS_STG_E_PROPSETMISMATCHED";
	br_arr[::BRUTUS::BRUTUS_STG_E_ABNORMALAPIEXIT] = "BRUTUS_STG_E_ABNORMALAPIEXIT";
	br_arr[::BRUTUS::BRUTUS_STG_E_INVALIDHEADER] = "BRUTUS_STG_E_INVALIDHEADER";
	br_arr[::BRUTUS::BRUTUS_STG_E_INVALIDNAME] = "BRUTUS_STG_E_INVALIDNAME";
	br_arr[::BRUTUS::BRUTUS_STG_E_UNKNOWN] = "BRUTUS_STG_E_UNKNOWN";
	br_arr[::BRUTUS::BRUTUS_STG_E_UNIMPLEMENTEDFUNCTION] = "BRUTUS_STG_E_UNIMPLEMENTEDFUNCTION";
	br_arr[::BRUTUS::BRUTUS_STG_E_INVALIDFLAG] = "BRUTUS_STG_E_INVALIDFLAG";
	br_arr[::BRUTUS::BRUTUS_STG_E_INUSE] = "BRUTUS_STG_E_INUSE";
	br_arr[::BRUTUS::BRUTUS_STG_E_NOTCURRENT] = "BRUTUS_STG_E_NOTCURRENT";
	br_arr[::BRUTUS::BRUTUS_STG_E_REVERTED] = "BRUTUS_STG_E_REVERTED";
	br_arr[::BRUTUS::BRUTUS_STG_E_CANTSAVE] = "BRUTUS_STG_E_CANTSAVE";
	br_arr[::BRUTUS::BRUTUS_STG_E_OLDFORMAT] = "BRUTUS_STG_E_OLDFORMAT";
	br_arr[::BRUTUS::BRUTUS_STG_E_OLDDLL] = "BRUTUS_STG_E_OLDDLL";
	br_arr[::BRUTUS::BRUTUS_STG_E_SHAREREQUIRED] = "BRUTUS_STG_E_SHAREREQUIRED";
	br_arr[::BRUTUS::BRUTUS_STG_E_NOTFILEBASEDSTORAGE] = "BRUTUS_STG_E_NOTFILEBASEDSTORAGE";
	br_arr[::BRUTUS::BRUTUS_STG_E_EXTANTMARSHALLINGS] = "BRUTUS_STG_E_EXTANTMARSHALLINGS";
	br_arr[::BRUTUS::BRUTUS_STG_E_DOCFILECORRUPT] = "BRUTUS_STG_E_DOCFILECORRUPT";
	br_arr[::BRUTUS::BRUTUS_STG_E_BADBASEADDRESS] = "BRUTUS_STG_E_BADBASEADDRESS";
	br_arr[::BRUTUS::BRUTUS_STG_E_INCOMPLETE] = "BRUTUS_STG_E_INCOMPLETE";
	br_arr[::BRUTUS::BRUTUS_STG_E_TERMINATED] = "BRUTUS_STG_E_TERMINATED";
	br_arr[::BRUTUS::BRUTUS_STG_S_CONVERTED] = "BRUTUS_STG_S_CONVERTED";
	br_arr[::BRUTUS::BRUTUS_STG_S_BLOCK] = "BRUTUS_STG_S_BLOCK";
	br_arr[::BRUTUS::BRUTUS_STG_S_RETRYNOW] = "BRUTUS_STG_S_RETRYNOW";
	br_arr[::BRUTUS::BRUTUS_STG_S_MONITORING] = "BRUTUS_STG_S_MONITORING";
	br_arr[::BRUTUS::BRUTUS_STG_S_MULTIPLEOPENS] = "BRUTUS_STG_S_MULTIPLEOPENS";
	br_arr[::BRUTUS::BRUTUS_STG_S_CONSOLIDATIONFAILED] = "BRUTUS_STG_S_CONSOLIDATIONFAILED";
	br_arr[::BRUTUS::BRUTUS_STG_S_CANNOTCONSOLIDATE] = "BRUTUS_STG_S_CANNOTCONSOLIDATE";
	br_arr[::BRUTUS::BRUTUS_E_PENDING] = "BRUTUS_E_PENDING";
	br_arr[::BRUTUS::BRUTUS_SYNC_E_OBJECT_DELETED] = "BRUTUS_SYNC_E_OBJECT_DELETED";
	br_arr[::BRUTUS::BRUTUS_SYNC_E_IGNORE] = "BRUTUS_SYNC_E_IGNORE";
	br_arr[::BRUTUS::BRUTUS_SYNC_E_CONFLICT] = "BRUTUS_SYNC_E_CONFLICT";
	br_arr[::BRUTUS::BRUTUS_SYNC_E_NO_PARENT] = "BRUTUS_SYNC_E_NO_PARENT";
	br_arr[::BRUTUS::BRUTUS_SYNC_E_INCEST] = "BRUTUS_SYNC_E_INCEST";
	br_arr[::BRUTUS::BRUTUS_SYNC_E_UNSYNCHRONIZED] = "BRUTUS_SYNC_E_UNSYNCHRONIZED";
	br_arr[::BRUTUS::BRUTUS_SYNC_W_PROGRESS] = "BRUTUS_SYNC_W_PROGRESS";
	br_arr[::BRUTUS::BRUTUS_SYNC_W_CLIENT_CHANGE_NEWER] = "BRUTUS_SYNC_W_CLIENT_CHANGE_NEWER";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_FAIL] = "BRUTUS_EC_EDK_E_FAIL";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_OUTOFMEMORY] = "BRUTUS_EC_EDK_E_OUTOFMEMORY";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_INVALIDARG] = "BRUTUS_EC_EDK_E_INVALIDARG";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_NOTIMPL] = "BRUTUS_EC_EDK_E_NOTIMPL";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_NOINTERFACE] = "BRUTUS_EC_EDK_E_NOINTERFACE";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_ACCESSDENIED] = "BRUTUS_EC_EDK_E_ACCESSDENIED";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_UNKNOWN] = "BRUTUS_EC_EDK_E_UNKNOWN";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_NOT_FOUND] = "BRUTUS_EC_EDK_E_NOT_FOUND";
	br_arr[::BRUTUS::BRUTUS_EDK_E_NOT_FOUND] = "BRUTUS_EDK_E_NOT_FOUND";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_SHUTDOWN_SERVICE] = "BRUTUS_EC_EDK_E_SHUTDOWN_SERVICE";
	br_arr[::BRUTUS::BRUTUS_EDK_E_SHUTDOWN_SERVICE] = "BRUTUS_EDK_E_SHUTDOWN_SERVICE";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_ALREADY_EXISTS] = "BRUTUS_EC_EDK_E_ALREADY_EXISTS";
	br_arr[::BRUTUS::BRUTUS_EDK_E_ALREADY_EXISTS] = "BRUTUS_EDK_E_ALREADY_EXISTS";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_END_OF_FILE] = "BRUTUS_EC_EDK_E_END_OF_FILE";
	br_arr[::BRUTUS::BRUTUS_EDK_E_END_OF_FILE] = "BRUTUS_EDK_E_END_OF_FILE";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_AMBIGUOUS] = "BRUTUS_EC_EDK_E_AMBIGUOUS";
	br_arr[::BRUTUS::BRUTUS_EDK_E_AMBIGUOUS] = "BRUTUS_EDK_E_AMBIGUOUS";
	br_arr[::BRUTUS::BRUTUS_EC_EDK_E_PARSE] = "BRUTUS_EC_EDK_E_PARSE";
	br_arr[::BRUTUS::BRUTUS_EDK_E_PARSE] = "BRUTUS_EDK_E_PARSE";
}

const char *CBresult::bresult_to_str(::BRUTUS::BRESULT code)
{
	return br_arr[code];
}
