/*
 * Brutus header file for Brutus test/sample utility functions.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _BRUTUS_UTILS_H_
#define _BRUTUS_UTILS_H_

#include <idl_output/typesC.h>
#include <idl_output/return_codesC.h>
#include <idl_output/IMAPISessionC.h>
#include <idl_output/IMAPIFolderC.h>
#include <idl_output/IMsgStoreC.h>
#include <tao/PortableServer/PortableServer.h>
#include <tao/ORB.h>

extern PortableServer::POA_ptr get_root_poa(CORBA::ORB_ptr ORB);

extern PortableServer::POA_ptr create_poa(const char *Name,
					  PortableServer::POAManager_ptr PoaManager,
					  PortableServer::POA_ptr ParentPOA);

/*
 * Converts a binary BLOB to a ::BRUTUS::ENTRYID
 */
extern void sbinary_to_entryid(::BRUTUS::SBinary & Bin,
			       ::BRUTUS::ENTRYID & Eid);

/*
 * Will write a stringified version of the value to stdout
 */
extern void print_spropvalue(::BRUTUS::SPropValue & PropValue);


/*
 * This is the Brutus equivalent of HrQueryAllRows()
 */
extern ::BRUTUS::BRESULT BrQueryAllRows(::BRUTUS::IMAPITable_ptr ptable, 
					::BRUTUS::SPropTagArray_var & ptags, 
					::BRUTUS::SRestrictionContainer_ptr pres,
					::BRUTUS::SSortOrderSet_var & psort, 
					CORBA::Long crowsMax, 
					::BRUTUS::SRowSet_out pprows);

/*
 * This is the Brutus equivalent of HrGetOneProp()
 */
extern ::BRUTUS::BRESULT BrGetOneProp(::BRUTUS::IMAPIProp_ptr MapiProp, 
				      ::BRUTUS::BDEFINE PropTag, 
				      ::BRUTUS::SPropValue_out PropValue);

/*
 * MsgStore is a reference to the default message store 
 * upon return or NIL
 */
extern ::BRUTUS::BRESULT get_default_message_store(::BRUTUS::IMAPISession_ptr Session,
						   PortableServer::POA_ptr ParentPoa,
						   ::BRUTUS::IMsgStore_out MsgStore);

/*
 * RootFolder is a reference to the root folder in MsgStore 
 * upon return or NIL
 */
extern ::BRUTUS::BRESULT get_root_folder(::BRUTUS::IMsgStore_ptr MsgStore,
					 ::BRUTUS::IMAPIFolder_out RootFolder);

/*
 * MsgStore is normally the default message store for the profile.
 * Folder is a reference to the requested Outlook specific folder
 * upon return or NIL. Currently predefined tags are:
 *
 *   ::BRUTUS::BRUTUS_PR_OUTLOOK_CALENDAR
 *   ::BRUTUS::BRUTUS_PR_OUTLOOK_CONTACTS
 *   ::BRUTUS::BRUTUS_PR_OUTLOOK_JOURNAL
 *   ::BRUTUS::BRUTUS_PR_OUTLOOK_NOTES
 *   ::BRUTUS::BRUTUS_PR_OUTLOOK_TASKS
 *   ::BRUTUS::BRUTUS_PR_OUTLOOK_REMINDERS
 *   ::BRUTUS::BRUTUS_PR_OUTLOOK_DRAFTS
 *
 * These tags are at the least valid for the default message store.
 */
extern ::BRUTUS::BRESULT get_outlook_folder(::BRUTUS::IMsgStore_ptr MsgStore,
					    ::BRUTUS::BDEFINE PropTag,
					    ::BRUTUS::IMAPIFolder_out Folder);

/*
 * Will list the value of the ListBy property tag for all objects
 * that are returned when GetContentsTable() are invoked on Folder.
 */
extern ::BRUTUS::BRESULT list_folder(::BRUTUS::IMAPIFolder_ptr Folder,
				     ::BRUTUS::BDEFINE ListBy);

/*
 * Will list the value of all properties for the object on stdout
 */
extern ::BRUTUS::BRESULT print_properties(::BRUTUS::IMAPIProp_ptr PropObject);


#endif // _BRUTUS_UTILS_H_

/*
 * Local variables:
 * mode: C++
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 */
