/*
 * Brutus header file for a configuration file class.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _CONFIG_H_
#define _CONFIG_H_

#include <stdlib.h>
#include <string.h>

class Config {
public:
        Config(const char *stack_token)
		{ 
			_fbuf = NULL;
			_items = NULL;
			_fsize = 0;
			_stack = strdup(stack_token);
		};

        Config(void)
		{ 
			_fbuf = NULL;
			_items = NULL;
			_fsize = 0;
			_stack = NULL;
		};

        ~Config()
		{
			free(_fbuf);
			free(_items);
			free(_stack);
		};

	int load(const char *file);
	char *get_value(const char *token);

private:
	int _lnum;
	char *_fbuf;
	size_t _fsize;
	char *_stack;

	struct item {
		char *token;
		char *value;
	};
	struct item *_items;

	// whitespace?
	bool wspace(char c)
		{
			switch (c) {
			case ' ' :
			case '\t' :
			case '\r' :
				return true;
			default:
				return false;
			}
		};

	int itemize(void);
	int point_to_value(char **str, char **val);
	int get_next_line(char **str);
	int read_conf(const char *file_name, size_t *size, void **buf);
};

#endif // _CONFIG_H_

/*
 * Local variables:
 * mode: C++
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 */
