/*
 * Brutus source file for implementing a property tag to string helper class.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#include "proptag.h"


CPropTag::CPropTag()
{
	// Property types
	ptype_arr[::BRUTUS::BRUTUS_PT_UNSPECIFIED] = "BRUTUS_PT_UNSPECIFIED";
	ptype_arr[::BRUTUS::BRUTUS_PT_NULL] = "BRUTUS_PT_NULL";
	ptype_arr[::BRUTUS::BRUTUS_PT_SHORT] = "BRUTUS_PT_SHORT";
	ptype_arr[::BRUTUS::BRUTUS_PT_USHORT] = "BRUTUS_PT_USHORT";
	ptype_arr[::BRUTUS::BRUTUS_PT_LONG] = "BRUTUS_PT_LONG";
	ptype_arr[::BRUTUS::BRUTUS_PT_ULONG] = "BRUTUS_PT_ULONG";
	ptype_arr[::BRUTUS::BRUTUS_PT_FLOAT] = "BRUTUS_PT_FLOAT";
	ptype_arr[::BRUTUS::BRUTUS_PT_DOUBLE] = "BRUTUS_PT_DOUBLE";
	ptype_arr[::BRUTUS::BRUTUS_PT_BOOLEAN] = "BRUTUS_PT_BOOLEAN";
	ptype_arr[::BRUTUS::BRUTUS_PT_CURRENCY] = "BRUTUS_PT_CURRENCY";
	ptype_arr[::BRUTUS::BRUTUS_PT_APPTIME] = "BRUTUS_PT_APPTIME";
	ptype_arr[::BRUTUS::BRUTUS_PT_SYSTIME] = "BRUTUS_PT_SYSTIME";
	ptype_arr[::BRUTUS::BRUTUS_PT_STRING8] = "BRUTUS_PT_STRING8";
	ptype_arr[::BRUTUS::BRUTUS_PT_BINARY] = "BRUTUS_PT_BINARY";
	ptype_arr[::BRUTUS::BRUTUS_PT_UNICODE] = "BRUTUS_PT_UNICODE";
	ptype_arr[::BRUTUS::BRUTUS_PT_CLSID] = "BRUTUS_PT_CLSID";
	ptype_arr[::BRUTUS::BRUTUS_PT_LONGLONG] = "BRUTUS_PT_LONGLONG";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_SHORT] = "BRUTUS_PT_MV_SHORT";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_LONG] = "BRUTUS_PT_MV_LONG";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_FLOAT] = "BRUTUS_PT_MV_FLOAT";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_DOUBLE] = "BRUTUS_PT_MV_DOUBLE";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_CURRENCY] = "BRUTUS_PT_MV_CURRENCY";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_APPTIME] = "BRUTUS_PT_MV_APPTIME";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_SYSTIME] = "BRUTUS_PT_MV_SYSTIME";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_BINARY] = "BRUTUS_PT_MV_BINARY";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_STRING8] = "BRUTUS_PT_MV_STRING8";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_UNICODE] = "BRUTUS_PT_MV_UNICODE";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_CLSID] = "BRUTUS_PT_MV_CLSID";
	ptype_arr[::BRUTUS::BRUTUS_PT_MV_LONGLONG] = "BRUTUS_PT_MV_LONGLONG";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_SHORT] = "BRUTUS_PT_MVI_SHORT";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_LONG] = "BRUTUS_PT_MVI_LONG";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_FLOAT] = "BRUTUS_PT_MVI_FLOAT";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_DOUBLE] = "BRUTUS_PT_MVI_DOUBLE";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_CURRENCY] = "BRUTUS_PT_MVI_CURRENCY";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_APPTIME] = "BRUTUS_PT_MVI_APPTIME";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_SYSTIME] = "BRUTUS_PT_MVI_SYSTIME";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_BINARY] = "BRUTUS_PT_MVI_BINARY";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_STRING8] = "BRUTUS_PT_MVI_STRING8";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_UNICODE] = "BRUTUS_PT_MVI_UNICODE";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_CLSID] = "BRUTUS_PT_MVI_CLSID";
	ptype_arr[::BRUTUS::BRUTUS_PT_MVI_LONGLONG] = "BRUTUS_PT_MVI_LONGLONG";
	ptype_arr[::BRUTUS::BRUTUS_PT_ERROR] = "BRUTUS_PT_ERROR";
	ptype_arr[::BRUTUS::BRUTUS_PT_OBJECT] = "BRUTUS_PT_OBJECT";

	// Property tags
	ptag_arr[::BRUTUS::BRUTUS_PR_ACKNOWLEDGEMENT_MODE] = "BRUTUS_PR_ACKNOWLEDGEMENT_MODE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ALTERNATE_RECIPIENT_ALLOWED] = "BRUTUS_PR_ALTERNATE_RECIPIENT_ALLOWED";
	ptag_arr[::BRUTUS::BRUTUS_PR_AUTHORIZING_USERS] = "BRUTUS_PR_AUTHORIZING_USERS";
	ptag_arr[::BRUTUS::BRUTUS_PR_AUTO_FORWARD_COMMENT] = "BRUTUS_PR_AUTO_FORWARD_COMMENT";
	ptag_arr[::BRUTUS::BRUTUS_PR_AUTO_FORWARD_COMMENT_W] = "BRUTUS_PR_AUTO_FORWARD_COMMENT_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_AUTO_FORWARD_COMMENT_A] = "BRUTUS_PR_AUTO_FORWARD_COMMENT_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_AUTO_FORWARDED] = "BRUTUS_PR_AUTO_FORWARDED";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID] = "BRUTUS_PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_CORRELATOR] = "BRUTUS_PR_CONTENT_CORRELATOR";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_IDENTIFIER] = "BRUTUS_PR_CONTENT_IDENTIFIER";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_IDENTIFIER_W] = "BRUTUS_PR_CONTENT_IDENTIFIER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_IDENTIFIER_A] = "BRUTUS_PR_CONTENT_IDENTIFIER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_LENGTH] = "BRUTUS_PR_CONTENT_LENGTH";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_RETURN_REQUESTED] = "BRUTUS_PR_CONTENT_RETURN_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONVERSATION_KEY] = "BRUTUS_PR_CONVERSATION_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONVERSION_EITS] = "BRUTUS_PR_CONVERSION_EITS";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONVERSION_WITH_LOSS_PROHIBITED] = "BRUTUS_PR_CONVERSION_WITH_LOSS_PROHIBITED";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONVERTED_EITS] = "BRUTUS_PR_CONVERTED_EITS";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEFERRED_DELIVERY_TIME] = "BRUTUS_PR_DEFERRED_DELIVERY_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELIVER_TIME] = "BRUTUS_PR_DELIVER_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISCARD_REASON] = "BRUTUS_PR_DISCARD_REASON";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISCLOSURE_OF_RECIPIENTS] = "BRUTUS_PR_DISCLOSURE_OF_RECIPIENTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_DL_EXPANSION_HISTORY] = "BRUTUS_PR_DL_EXPANSION_HISTORY";
	ptag_arr[::BRUTUS::BRUTUS_PR_DL_EXPANSION_PROHIBITED] = "BRUTUS_PR_DL_EXPANSION_PROHIBITED";
	ptag_arr[::BRUTUS::BRUTUS_PR_EXPIRY_TIME] = "BRUTUS_PR_EXPIRY_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_IMPLICIT_CONVERSION_PROHIBITED] = "BRUTUS_PR_IMPLICIT_CONVERSION_PROHIBITED";
	ptag_arr[::BRUTUS::BRUTUS_PR_IMPORTANCE] = "BRUTUS_PR_IMPORTANCE";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_ID] = "BRUTUS_PR_IPM_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_LATEST_DELIVERY_TIME] = "BRUTUS_PR_LATEST_DELIVERY_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_CLASS] = "BRUTUS_PR_MESSAGE_CLASS";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_CLASS_W] = "BRUTUS_PR_MESSAGE_CLASS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_CLASS_A] = "BRUTUS_PR_MESSAGE_CLASS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_DELIVERY_ID] = "BRUTUS_PR_MESSAGE_DELIVERY_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_SECURITY_LABEL] = "BRUTUS_PR_MESSAGE_SECURITY_LABEL";
	ptag_arr[::BRUTUS::BRUTUS_PR_OBSOLETED_IPMS] = "BRUTUS_PR_OBSOLETED_IPMS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINALLY_INTENDED_RECIPIENT_NAME] = "BRUTUS_PR_ORIGINALLY_INTENDED_RECIPIENT_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_EITS] = "BRUTUS_PR_ORIGINAL_EITS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_CERTIFICATE] = "BRUTUS_PR_ORIGINATOR_CERTIFICATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED] = "BRUTUS_PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_RETURN_ADDRESS] = "BRUTUS_PR_ORIGINATOR_RETURN_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_PARENT_KEY] = "BRUTUS_PR_PARENT_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_PRIORITY] = "BRUTUS_PR_PRIORITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGIN_CHECK] = "BRUTUS_PR_ORIGIN_CHECK";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROOF_OF_SUBMISSION_REQUESTED] = "BRUTUS_PR_PROOF_OF_SUBMISSION_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_READ_RECEIPT_REQUESTED] = "BRUTUS_PR_READ_RECEIPT_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIPT_TIME] = "BRUTUS_PR_RECEIPT_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_REASSIGNMENT_PROHIBITED] = "BRUTUS_PR_RECIPIENT_REASSIGNMENT_PROHIBITED";
	ptag_arr[::BRUTUS::BRUTUS_PR_REDIRECTION_HISTORY] = "BRUTUS_PR_REDIRECTION_HISTORY";
	ptag_arr[::BRUTUS::BRUTUS_PR_RELATED_IPMS] = "BRUTUS_PR_RELATED_IPMS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENSITIVITY] = "BRUTUS_PR_ORIGINAL_SENSITIVITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_LANGUAGES] = "BRUTUS_PR_LANGUAGES";
	ptag_arr[::BRUTUS::BRUTUS_PR_LANGUAGES_W] = "BRUTUS_PR_LANGUAGES_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_LANGUAGES_A] = "BRUTUS_PR_LANGUAGES_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLY_TIME] = "BRUTUS_PR_REPLY_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_TAG] = "BRUTUS_PR_REPORT_TAG";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_TIME] = "BRUTUS_PR_REPORT_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_RETURNED_IPM] = "BRUTUS_PR_RETURNED_IPM";
	ptag_arr[::BRUTUS::BRUTUS_PR_SECURITY] = "BRUTUS_PR_SECURITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_INCOMPLETE_COPY] = "BRUTUS_PR_INCOMPLETE_COPY";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENSITIVITY] = "BRUTUS_PR_SENSITIVITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBJECT] = "BRUTUS_PR_SUBJECT";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBJECT_W] = "BRUTUS_PR_SUBJECT_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBJECT_A] = "BRUTUS_PR_SUBJECT_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBJECT_IPM] = "BRUTUS_PR_SUBJECT_IPM";
	ptag_arr[::BRUTUS::BRUTUS_PR_CLIENT_SUBMIT_TIME] = "BRUTUS_PR_CLIENT_SUBMIT_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_NAME] = "BRUTUS_PR_REPORT_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_NAME_W] = "BRUTUS_PR_REPORT_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_NAME_A] = "BRUTUS_PR_REPORT_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_SEARCH_KEY] = "BRUTUS_PR_SENT_REPRESENTING_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_X400_CONTENT_TYPE] = "BRUTUS_PR_X400_CONTENT_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBJECT_PREFIX] = "BRUTUS_PR_SUBJECT_PREFIX";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBJECT_PREFIX_W] = "BRUTUS_PR_SUBJECT_PREFIX_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBJECT_PREFIX_A] = "BRUTUS_PR_SUBJECT_PREFIX_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_NON_RECEIPT_REASON] = "BRUTUS_PR_NON_RECEIPT_REASON";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_ENTRYID] = "BRUTUS_PR_RECEIVED_BY_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_NAME] = "BRUTUS_PR_RECEIVED_BY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_NAME_W] = "BRUTUS_PR_RECEIVED_BY_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_NAME_A] = "BRUTUS_PR_RECEIVED_BY_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_ENTRYID] = "BRUTUS_PR_SENT_REPRESENTING_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_NAME] = "BRUTUS_PR_SENT_REPRESENTING_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_NAME_W] = "BRUTUS_PR_SENT_REPRESENTING_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_NAME_A] = "BRUTUS_PR_SENT_REPRESENTING_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_ENTRYID] = "BRUTUS_PR_RCVD_REPRESENTING_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_NAME] = "BRUTUS_PR_RCVD_REPRESENTING_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_NAME_W] = "BRUTUS_PR_RCVD_REPRESENTING_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_NAME_A] = "BRUTUS_PR_RCVD_REPRESENTING_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_ENTRYID] = "BRUTUS_PR_REPORT_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_READ_RECEIPT_ENTRYID] = "BRUTUS_PR_READ_RECEIPT_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_SUBMISSION_ID] = "BRUTUS_PR_MESSAGE_SUBMISSION_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROVIDER_SUBMIT_TIME] = "BRUTUS_PR_PROVIDER_SUBMIT_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SUBJECT] = "BRUTUS_PR_ORIGINAL_SUBJECT";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SUBJECT_W] = "BRUTUS_PR_ORIGINAL_SUBJECT_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SUBJECT_A] = "BRUTUS_PR_ORIGINAL_SUBJECT_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISC_VAL] = "BRUTUS_PR_DISC_VAL";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIG_MESSAGE_CLASS] = "BRUTUS_PR_ORIG_MESSAGE_CLASS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIG_MESSAGE_CLASS_W] = "BRUTUS_PR_ORIG_MESSAGE_CLASS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIG_MESSAGE_CLASS_A] = "BRUTUS_PR_ORIG_MESSAGE_CLASS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_ENTRYID] = "BRUTUS_PR_ORIGINAL_AUTHOR_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_NAME] = "BRUTUS_PR_ORIGINAL_AUTHOR_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_NAME_W] = "BRUTUS_PR_ORIGINAL_AUTHOR_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_NAME_A] = "BRUTUS_PR_ORIGINAL_AUTHOR_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SUBMIT_TIME] = "BRUTUS_PR_ORIGINAL_SUBMIT_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLY_RECIPIENT_ENTRIES] = "BRUTUS_PR_REPLY_RECIPIENT_ENTRIES";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLY_RECIPIENT_NAMES] = "BRUTUS_PR_REPLY_RECIPIENT_NAMES";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLY_RECIPIENT_NAMES_W] = "BRUTUS_PR_REPLY_RECIPIENT_NAMES_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLY_RECIPIENT_NAMES_A] = "BRUTUS_PR_REPLY_RECIPIENT_NAMES_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_SEARCH_KEY] = "BRUTUS_PR_RECEIVED_BY_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_SEARCH_KEY] = "BRUTUS_PR_RCVD_REPRESENTING_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_READ_RECEIPT_SEARCH_KEY] = "BRUTUS_PR_READ_RECEIPT_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_SEARCH_KEY] = "BRUTUS_PR_REPORT_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DELIVERY_TIME] = "BRUTUS_PR_ORIGINAL_DELIVERY_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_SEARCH_KEY] = "BRUTUS_PR_ORIGINAL_AUTHOR_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_TO_ME] = "BRUTUS_PR_MESSAGE_TO_ME";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_CC_ME] = "BRUTUS_PR_MESSAGE_CC_ME";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_RECIP_ME] = "BRUTUS_PR_MESSAGE_RECIP_ME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_NAME] = "BRUTUS_PR_ORIGINAL_SENDER_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_NAME_W] = "BRUTUS_PR_ORIGINAL_SENDER_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_NAME_A] = "BRUTUS_PR_ORIGINAL_SENDER_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_ENTRYID] = "BRUTUS_PR_ORIGINAL_SENDER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_SEARCH_KEY] = "BRUTUS_PR_ORIGINAL_SENDER_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME_W] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME_A] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ENTRYID] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_START_DATE] = "BRUTUS_PR_START_DATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_END_DATE] = "BRUTUS_PR_END_DATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_OWNER_APPT_ID] = "BRUTUS_PR_OWNER_APPT_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESPONSE_REQUESTED] = "BRUTUS_PR_RESPONSE_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE] = "BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE_W] = "BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE_A] = "BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS] = "BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS_W] = "BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS_A] = "BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE] = "BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE_W] = "BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE_A] = "BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS] = "BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS_W] = "BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A] = "BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_W] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_W] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A] = "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONVERSATION_TOPIC] = "BRUTUS_PR_CONVERSATION_TOPIC";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONVERSATION_TOPIC_W] = "BRUTUS_PR_CONVERSATION_TOPIC_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONVERSATION_TOPIC_A] = "BRUTUS_PR_CONVERSATION_TOPIC_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONVERSATION_INDEX] = "BRUTUS_PR_CONVERSATION_INDEX";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_BCC] = "BRUTUS_PR_ORIGINAL_DISPLAY_BCC";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_BCC_W] = "BRUTUS_PR_ORIGINAL_DISPLAY_BCC_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_BCC_A] = "BRUTUS_PR_ORIGINAL_DISPLAY_BCC_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_CC] = "BRUTUS_PR_ORIGINAL_DISPLAY_CC";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_CC_W] = "BRUTUS_PR_ORIGINAL_DISPLAY_CC_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_CC_A] = "BRUTUS_PR_ORIGINAL_DISPLAY_CC_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_TO] = "BRUTUS_PR_ORIGINAL_DISPLAY_TO";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_TO_W] = "BRUTUS_PR_ORIGINAL_DISPLAY_TO_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_TO_A] = "BRUTUS_PR_ORIGINAL_DISPLAY_TO_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_ADDRTYPE] = "BRUTUS_PR_RECEIVED_BY_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_ADDRTYPE_W] = "BRUTUS_PR_RECEIVED_BY_ADDRTYPE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_ADDRTYPE_A] = "BRUTUS_PR_RECEIVED_BY_ADDRTYPE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS] = "BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS_W] = "BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS_A] = "BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE] = "BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE_W] = "BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE_A] = "BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS] = "BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS_W] = "BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A] = "BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE] = "BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE_W] = "BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE_A] = "BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS] = "BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_W] = "BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A] = "BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE] = "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_W] = "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A] = "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS] = "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_W] = "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A] = "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS] = "BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS_W] = "BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS_A] = "BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELEGATION] = "BRUTUS_PR_DELEGATION";
	ptag_arr[::BRUTUS::BRUTUS_PR_TNEF_CORRELATION_KEY] = "BRUTUS_PR_TNEF_CORRELATION_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_BODY] = "BRUTUS_PR_BODY";
	ptag_arr[::BRUTUS::BRUTUS_PR_BODY_W] = "BRUTUS_PR_BODY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_BODY_A] = "BRUTUS_PR_BODY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_TEXT] = "BRUTUS_PR_REPORT_TEXT";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_TEXT_W] = "BRUTUS_PR_REPORT_TEXT_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_TEXT_A] = "BRUTUS_PR_REPORT_TEXT_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY] = "BRUTUS_PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORTING_DL_NAME] = "BRUTUS_PR_REPORTING_DL_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORTING_MTA_CERTIFICATE] = "BRUTUS_PR_REPORTING_MTA_CERTIFICATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_RTF_SYNC_BODY_CRC] = "BRUTUS_PR_RTF_SYNC_BODY_CRC";
	ptag_arr[::BRUTUS::BRUTUS_PR_RTF_SYNC_BODY_COUNT] = "BRUTUS_PR_RTF_SYNC_BODY_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_RTF_SYNC_BODY_TAG] = "BRUTUS_PR_RTF_SYNC_BODY_TAG";
	ptag_arr[::BRUTUS::BRUTUS_PR_RTF_SYNC_BODY_TAG_W] = "BRUTUS_PR_RTF_SYNC_BODY_TAG_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RTF_SYNC_BODY_TAG_A] = "BRUTUS_PR_RTF_SYNC_BODY_TAG_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RTF_COMPRESSED] = "BRUTUS_PR_RTF_COMPRESSED";
	ptag_arr[::BRUTUS::BRUTUS_PR_RTF_SYNC_PREFIX_COUNT] = "BRUTUS_PR_RTF_SYNC_PREFIX_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_RTF_SYNC_TRAILING_COUNT] = "BRUTUS_PR_RTF_SYNC_TRAILING_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ENTRYID] = "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_INTEGRITY_CHECK] = "BRUTUS_PR_CONTENT_INTEGRITY_CHECK";
	ptag_arr[::BRUTUS::BRUTUS_PR_EXPLICIT_CONVERSION] = "BRUTUS_PR_EXPLICIT_CONVERSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_RETURN_REQUESTED] = "BRUTUS_PR_IPM_RETURN_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_TOKEN] = "BRUTUS_PR_MESSAGE_TOKEN";
	ptag_arr[::BRUTUS::BRUTUS_PR_NDR_REASON_CODE] = "BRUTUS_PR_NDR_REASON_CODE";
	ptag_arr[::BRUTUS::BRUTUS_PR_NDR_DIAG_CODE] = "BRUTUS_PR_NDR_DIAG_CODE";
	ptag_arr[::BRUTUS::BRUTUS_PR_NON_RECEIPT_NOTIFICATION_REQUESTED] = "BRUTUS_PR_NON_RECEIPT_NOTIFICATION_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELIVERY_POINT] = "BRUTUS_PR_DELIVERY_POINT";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED] = "BRUTUS_PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT] = "BRUTUS_PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT";
	ptag_arr[::BRUTUS::BRUTUS_PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY] = "BRUTUS_PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY";
	ptag_arr[::BRUTUS::BRUTUS_PR_PHYSICAL_DELIVERY_MODE] = "BRUTUS_PR_PHYSICAL_DELIVERY_MODE";
	ptag_arr[::BRUTUS::BRUTUS_PR_PHYSICAL_DELIVERY_REPORT_REQUEST] = "BRUTUS_PR_PHYSICAL_DELIVERY_REPORT_REQUEST";
	ptag_arr[::BRUTUS::BRUTUS_PR_PHYSICAL_FORWARDING_ADDRESS] = "BRUTUS_PR_PHYSICAL_FORWARDING_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED] = "BRUTUS_PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_PHYSICAL_FORWARDING_PROHIBITED] = "BRUTUS_PR_PHYSICAL_FORWARDING_PROHIBITED";
	ptag_arr[::BRUTUS::BRUTUS_PR_PHYSICAL_RENDITION_ATTRIBUTES] = "BRUTUS_PR_PHYSICAL_RENDITION_ATTRIBUTES";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROOF_OF_DELIVERY] = "BRUTUS_PR_PROOF_OF_DELIVERY";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROOF_OF_DELIVERY_REQUESTED] = "BRUTUS_PR_PROOF_OF_DELIVERY_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_CERTIFICATE] = "BRUTUS_PR_RECIPIENT_CERTIFICATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE] = "BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE_W] = "BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE_A] = "BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_TYPE] = "BRUTUS_PR_RECIPIENT_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_REGISTERED_MAIL_TYPE] = "BRUTUS_PR_REGISTERED_MAIL_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLY_REQUESTED] = "BRUTUS_PR_REPLY_REQUESTED";
	ptag_arr[::BRUTUS::BRUTUS_PR_REQUESTED_DELIVERY_METHOD] = "BRUTUS_PR_REQUESTED_DELIVERY_METHOD";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_ENTRYID] = "BRUTUS_PR_SENDER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_NAME] = "BRUTUS_PR_SENDER_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_NAME_W] = "BRUTUS_PR_SENDER_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_NAME_A] = "BRUTUS_PR_SENDER_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUPPLEMENTARY_INFO] = "BRUTUS_PR_SUPPLEMENTARY_INFO";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUPPLEMENTARY_INFO_W] = "BRUTUS_PR_SUPPLEMENTARY_INFO_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUPPLEMENTARY_INFO_A] = "BRUTUS_PR_SUPPLEMENTARY_INFO_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_TYPE_OF_MTS_USER] = "BRUTUS_PR_TYPE_OF_MTS_USER";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_SEARCH_KEY] = "BRUTUS_PR_SENDER_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_ADDRTYPE] = "BRUTUS_PR_SENDER_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_ADDRTYPE_W] = "BRUTUS_PR_SENDER_ADDRTYPE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_ADDRTYPE_A] = "BRUTUS_PR_SENDER_ADDRTYPE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_EMAIL_ADDRESS] = "BRUTUS_PR_SENDER_EMAIL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_EMAIL_ADDRESS_W] = "BRUTUS_PR_SENDER_EMAIL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENDER_EMAIL_ADDRESS_A] = "BRUTUS_PR_SENDER_EMAIL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CURRENT_VERSION] = "BRUTUS_PR_CURRENT_VERSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELETE_AFTER_SUBMIT] = "BRUTUS_PR_DELETE_AFTER_SUBMIT";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_BCC] = "BRUTUS_PR_DISPLAY_BCC";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_BCC_W] = "BRUTUS_PR_DISPLAY_BCC_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_BCC_A] = "BRUTUS_PR_DISPLAY_BCC_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_CC] = "BRUTUS_PR_DISPLAY_CC";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_CC_W] = "BRUTUS_PR_DISPLAY_CC_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_CC_A] = "BRUTUS_PR_DISPLAY_CC_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_TO] = "BRUTUS_PR_DISPLAY_TO";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_TO_W] = "BRUTUS_PR_DISPLAY_TO_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_TO_A] = "BRUTUS_PR_DISPLAY_TO_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_PARENT_DISPLAY] = "BRUTUS_PR_PARENT_DISPLAY";
	ptag_arr[::BRUTUS::BRUTUS_PR_PARENT_DISPLAY_W] = "BRUTUS_PR_PARENT_DISPLAY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_PARENT_DISPLAY_A] = "BRUTUS_PR_PARENT_DISPLAY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_DELIVERY_TIME] = "BRUTUS_PR_MESSAGE_DELIVERY_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_FLAGS] = "BRUTUS_PR_MESSAGE_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_SIZE] = "BRUTUS_PR_MESSAGE_SIZE";
	ptag_arr[::BRUTUS::BRUTUS_PR_PARENT_ENTRYID] = "BRUTUS_PR_PARENT_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_SENTMAIL_ENTRYID] = "BRUTUS_PR_SENTMAIL_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_CORRELATE] = "BRUTUS_PR_CORRELATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_CORRELATE_MTSID] = "BRUTUS_PR_CORRELATE_MTSID";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISCRETE_VALUES] = "BRUTUS_PR_DISCRETE_VALUES";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESPONSIBILITY] = "BRUTUS_PR_RESPONSIBILITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_SPOOLER_STATUS] = "BRUTUS_PR_SPOOLER_STATUS";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSPORT_STATUS] = "BRUTUS_PR_TRANSPORT_STATUS";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_RECIPIENTS] = "BRUTUS_PR_MESSAGE_RECIPIENTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_ATTACHMENTS] = "BRUTUS_PR_MESSAGE_ATTACHMENTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBMIT_FLAGS] = "BRUTUS_PR_SUBMIT_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_STATUS] = "BRUTUS_PR_RECIPIENT_STATUS";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSPORT_KEY] = "BRUTUS_PR_TRANSPORT_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_MSG_STATUS] = "BRUTUS_PR_MSG_STATUS";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_DOWNLOAD_TIME] = "BRUTUS_PR_MESSAGE_DOWNLOAD_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_CREATION_VERSION] = "BRUTUS_PR_CREATION_VERSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_MODIFY_VERSION] = "BRUTUS_PR_MODIFY_VERSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_HASATTACH] = "BRUTUS_PR_HASATTACH";
	ptag_arr[::BRUTUS::BRUTUS_PR_BODY_CRC] = "BRUTUS_PR_BODY_CRC";
	ptag_arr[::BRUTUS::BRUTUS_PR_NORMALIZED_SUBJECT] = "BRUTUS_PR_NORMALIZED_SUBJECT";
	ptag_arr[::BRUTUS::BRUTUS_PR_NORMALIZED_SUBJECT_W] = "BRUTUS_PR_NORMALIZED_SUBJECT_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_NORMALIZED_SUBJECT_A] = "BRUTUS_PR_NORMALIZED_SUBJECT_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RTF_IN_SYNC] = "BRUTUS_PR_RTF_IN_SYNC";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_SIZE] = "BRUTUS_PR_ATTACH_SIZE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_NUM] = "BRUTUS_PR_ATTACH_NUM";
	ptag_arr[::BRUTUS::BRUTUS_PR_PREPROCESS] = "BRUTUS_PR_PREPROCESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATING_MTA_CERTIFICATE] = "BRUTUS_PR_ORIGINATING_MTA_CERTIFICATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROOF_OF_SUBMISSION] = "BRUTUS_PR_PROOF_OF_SUBMISSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_ENTRYID] = "BRUTUS_PR_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_OBJECT_TYPE] = "BRUTUS_PR_OBJECT_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ICON] = "BRUTUS_PR_ICON";
	ptag_arr[::BRUTUS::BRUTUS_PR_MINI_ICON] = "BRUTUS_PR_MINI_ICON";
	ptag_arr[::BRUTUS::BRUTUS_PR_STORE_ENTRYID] = "BRUTUS_PR_STORE_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_STORE_RECORD_KEY] = "BRUTUS_PR_STORE_RECORD_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECORD_KEY] = "BRUTUS_PR_RECORD_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_MAPPING_SIGNATURE] = "BRUTUS_PR_MAPPING_SIGNATURE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ACCESS_LEVEL] = "BRUTUS_PR_ACCESS_LEVEL";
	ptag_arr[::BRUTUS::BRUTUS_PR_INSTANCE_KEY] = "BRUTUS_PR_INSTANCE_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_ROW_TYPE] = "BRUTUS_PR_ROW_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ACCESS] = "BRUTUS_PR_ACCESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ROWID] = "BRUTUS_PR_ROWID";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_NAME] = "BRUTUS_PR_DISPLAY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_NAME_W] = "BRUTUS_PR_DISPLAY_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_NAME_A] = "BRUTUS_PR_DISPLAY_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ADDRTYPE] = "BRUTUS_PR_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ADDRTYPE_W] = "BRUTUS_PR_ADDRTYPE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ADDRTYPE_A] = "BRUTUS_PR_ADDRTYPE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_EMAIL_ADDRESS] = "BRUTUS_PR_EMAIL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_EMAIL_ADDRESS_W] = "BRUTUS_PR_EMAIL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_EMAIL_ADDRESS_A] = "BRUTUS_PR_EMAIL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMMENT] = "BRUTUS_PR_COMMENT";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMMENT_W] = "BRUTUS_PR_COMMENT_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMMENT_A] = "BRUTUS_PR_COMMENT_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEPTH] = "BRUTUS_PR_DEPTH";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROVIDER_DISPLAY] = "BRUTUS_PR_PROVIDER_DISPLAY";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROVIDER_DISPLAY_W] = "BRUTUS_PR_PROVIDER_DISPLAY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROVIDER_DISPLAY_A] = "BRUTUS_PR_PROVIDER_DISPLAY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CREATION_TIME] = "BRUTUS_PR_CREATION_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_LAST_MODIFICATION_TIME] = "BRUTUS_PR_LAST_MODIFICATION_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESOURCE_FLAGS] = "BRUTUS_PR_RESOURCE_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROVIDER_DLL_NAME] = "BRUTUS_PR_PROVIDER_DLL_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROVIDER_DLL_NAME_W] = "BRUTUS_PR_PROVIDER_DLL_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROVIDER_DLL_NAME_A] = "BRUTUS_PR_PROVIDER_DLL_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SEARCH_KEY] = "BRUTUS_PR_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROVIDER_UID] = "BRUTUS_PR_PROVIDER_UID";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROVIDER_ORDINAL] = "BRUTUS_PR_PROVIDER_ORDINAL";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_VERSION] = "BRUTUS_PR_FORM_VERSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_VERSION_W] = "BRUTUS_PR_FORM_VERSION_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_VERSION_A] = "BRUTUS_PR_FORM_VERSION_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CLSID] = "BRUTUS_PR_FORM_CLSID";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CONTACT_NAME] = "BRUTUS_PR_FORM_CONTACT_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CONTACT_NAME_W] = "BRUTUS_PR_FORM_CONTACT_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CONTACT_NAME_A] = "BRUTUS_PR_FORM_CONTACT_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CATEGORY] = "BRUTUS_PR_FORM_CATEGORY";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CATEGORY_W] = "BRUTUS_PR_FORM_CATEGORY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CATEGORY_A] = "BRUTUS_PR_FORM_CATEGORY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CATEGORY_SUB] = "BRUTUS_PR_FORM_CATEGORY_SUB";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CATEGORY_SUB_W] = "BRUTUS_PR_FORM_CATEGORY_SUB_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_CATEGORY_SUB_A] = "BRUTUS_PR_FORM_CATEGORY_SUB_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_HOST_MAP] = "BRUTUS_PR_FORM_HOST_MAP";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_HIDDEN] = "BRUTUS_PR_FORM_HIDDEN";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_DESIGNER_NAME] = "BRUTUS_PR_FORM_DESIGNER_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_DESIGNER_NAME_W] = "BRUTUS_PR_FORM_DESIGNER_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_DESIGNER_NAME_A] = "BRUTUS_PR_FORM_DESIGNER_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_DESIGNER_GUID] = "BRUTUS_PR_FORM_DESIGNER_GUID";
	ptag_arr[::BRUTUS::BRUTUS_PR_FORM_MESSAGE_BEHAVIOR] = "BRUTUS_PR_FORM_MESSAGE_BEHAVIOR";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEFAULT_STORE] = "BRUTUS_PR_DEFAULT_STORE";
	ptag_arr[::BRUTUS::BRUTUS_PR_STORE_SUPPORT_MASK] = "BRUTUS_PR_STORE_SUPPORT_MASK";
	ptag_arr[::BRUTUS::BRUTUS_PR_STORE_STATE] = "BRUTUS_PR_STORE_STATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_SUBTREE_SEARCH_KEY] = "BRUTUS_PR_IPM_SUBTREE_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_OUTBOX_SEARCH_KEY] = "BRUTUS_PR_IPM_OUTBOX_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_WASTEBASKET_SEARCH_KEY] = "BRUTUS_PR_IPM_WASTEBASKET_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_SENTMAIL_SEARCH_KEY] = "BRUTUS_PR_IPM_SENTMAIL_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_MDB_PROVIDER] = "BRUTUS_PR_MDB_PROVIDER";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECEIVE_FOLDER_SETTINGS] = "BRUTUS_PR_RECEIVE_FOLDER_SETTINGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_VALID_FOLDER_MASK] = "BRUTUS_PR_VALID_FOLDER_MASK";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_SUBTREE_ENTRYID] = "BRUTUS_PR_IPM_SUBTREE_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_OUTBOX_ENTRYID] = "BRUTUS_PR_IPM_OUTBOX_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_WASTEBASKET_ENTRYID] = "BRUTUS_PR_IPM_WASTEBASKET_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_SENTMAIL_ENTRYID] = "BRUTUS_PR_IPM_SENTMAIL_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_VIEWS_ENTRYID] = "BRUTUS_PR_VIEWS_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMMON_VIEWS_ENTRYID] = "BRUTUS_PR_COMMON_VIEWS_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_FINDER_ENTRYID] = "BRUTUS_PR_FINDER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTAINER_FLAGS] = "BRUTUS_PR_CONTAINER_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_FOLDER_TYPE] = "BRUTUS_PR_FOLDER_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_COUNT] = "BRUTUS_PR_CONTENT_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_UNREAD] = "BRUTUS_PR_CONTENT_UNREAD";
	ptag_arr[::BRUTUS::BRUTUS_PR_CREATE_TEMPLATES] = "BRUTUS_PR_CREATE_TEMPLATES";
	ptag_arr[::BRUTUS::BRUTUS_PR_DETAILS_TABLE] = "BRUTUS_PR_DETAILS_TABLE";
	ptag_arr[::BRUTUS::BRUTUS_PR_SEARCH] = "BRUTUS_PR_SEARCH";
	ptag_arr[::BRUTUS::BRUTUS_PR_SELECTABLE] = "BRUTUS_PR_SELECTABLE";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBFOLDERS] = "BRUTUS_PR_SUBFOLDERS";
	ptag_arr[::BRUTUS::BRUTUS_PR_STATUS] = "BRUTUS_PR_STATUS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ANR] = "BRUTUS_PR_ANR";
	ptag_arr[::BRUTUS::BRUTUS_PR_ANR_W] = "BRUTUS_PR_ANR_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ANR_A] = "BRUTUS_PR_ANR_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENTS_SORT_ORDER] = "BRUTUS_PR_CONTENTS_SORT_ORDER";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTAINER_HIERARCHY] = "BRUTUS_PR_CONTAINER_HIERARCHY";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTAINER_CONTENTS] = "BRUTUS_PR_CONTAINER_CONTENTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_FOLDER_ASSOCIATED_CONTENTS] = "BRUTUS_PR_FOLDER_ASSOCIATED_CONTENTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEF_CREATE_DL] = "BRUTUS_PR_DEF_CREATE_DL";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEF_CREATE_MAILUSER] = "BRUTUS_PR_DEF_CREATE_MAILUSER";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTAINER_CLASS] = "BRUTUS_PR_CONTAINER_CLASS";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTAINER_CLASS_W] = "BRUTUS_PR_CONTAINER_CLASS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTAINER_CLASS_A] = "BRUTUS_PR_CONTAINER_CLASS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTAINER_MODIFY_VERSION] = "BRUTUS_PR_CONTAINER_MODIFY_VERSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_AB_PROVIDER_ID] = "BRUTUS_PR_AB_PROVIDER_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEFAULT_VIEW_ENTRYID] = "BRUTUS_PR_DEFAULT_VIEW_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSOC_CONTENT_COUNT] = "BRUTUS_PR_ASSOC_CONTENT_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_OUTLOOK_CALENDAR] = "BRUTUS_PR_OUTLOOK_CALENDAR";
	ptag_arr[::BRUTUS::BRUTUS_PR_OUTLOOK_CONTACTS] = "BRUTUS_PR_OUTLOOK_CONTACTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_OUTLOOK_JOURNAL] = "BRUTUS_PR_OUTLOOK_JOURNAL";
	ptag_arr[::BRUTUS::BRUTUS_PR_OUTLOOK_NOTES] = "BRUTUS_PR_OUTLOOK_NOTES";
	ptag_arr[::BRUTUS::BRUTUS_PR_OUTLOOK_TASKS] = "BRUTUS_PR_OUTLOOK_TASKS";
	ptag_arr[::BRUTUS::BRUTUS_PR_OUTLOOK_ONLINE_REMINDERS] = "BRUTUS_PR_OUTLOOK_ONLINE_REMINDERS";
	ptag_arr[::BRUTUS::BRUTUS_PR_OUTLOOK_OFFLINE_REMINDERS] = "BRUTUS_PR_OUTLOOK_OFFLINE_REMINDERS";
	ptag_arr[::BRUTUS::BRUTUS_PR_OUTLOOK_DRAFTS] = "BRUTUS_PR_OUTLOOK_DRAFTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACHMENT_X400_PARAMETERS] = "BRUTUS_PR_ATTACHMENT_X400_PARAMETERS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_DATA_OBJ] = "BRUTUS_PR_ATTACH_DATA_OBJ";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_DATA_BIN] = "BRUTUS_PR_ATTACH_DATA_BIN";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_ENCODING] = "BRUTUS_PR_ATTACH_ENCODING";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_EXTENSION] = "BRUTUS_PR_ATTACH_EXTENSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_EXTENSION_W] = "BRUTUS_PR_ATTACH_EXTENSION_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_EXTENSION_A] = "BRUTUS_PR_ATTACH_EXTENSION_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_FILENAME] = "BRUTUS_PR_ATTACH_FILENAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_FILENAME_W] = "BRUTUS_PR_ATTACH_FILENAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_FILENAME_A] = "BRUTUS_PR_ATTACH_FILENAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_METHOD] = "BRUTUS_PR_ATTACH_METHOD";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_LONG_FILENAME] = "BRUTUS_PR_ATTACH_LONG_FILENAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_LONG_FILENAME_W] = "BRUTUS_PR_ATTACH_LONG_FILENAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_LONG_FILENAME_A] = "BRUTUS_PR_ATTACH_LONG_FILENAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_PATHNAME] = "BRUTUS_PR_ATTACH_PATHNAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_PATHNAME_W] = "BRUTUS_PR_ATTACH_PATHNAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_PATHNAME_A] = "BRUTUS_PR_ATTACH_PATHNAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_RENDERING] = "BRUTUS_PR_ATTACH_RENDERING";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_TAG] = "BRUTUS_PR_ATTACH_TAG";
	ptag_arr[::BRUTUS::BRUTUS_PR_RENDERING_POSITION] = "BRUTUS_PR_RENDERING_POSITION";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_TRANSPORT_NAME] = "BRUTUS_PR_ATTACH_TRANSPORT_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_TRANSPORT_NAME_W] = "BRUTUS_PR_ATTACH_TRANSPORT_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_TRANSPORT_NAME_A] = "BRUTUS_PR_ATTACH_TRANSPORT_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_LONG_PATHNAME] = "BRUTUS_PR_ATTACH_LONG_PATHNAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_LONG_PATHNAME_W] = "BRUTUS_PR_ATTACH_LONG_PATHNAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_LONG_PATHNAME_A] = "BRUTUS_PR_ATTACH_LONG_PATHNAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_MIME_TAG] = "BRUTUS_PR_ATTACH_MIME_TAG";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_MIME_TAG_W] = "BRUTUS_PR_ATTACH_MIME_TAG_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_MIME_TAG_A] = "BRUTUS_PR_ATTACH_MIME_TAG_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_ADDITIONAL_INFO] = "BRUTUS_PR_ATTACH_ADDITIONAL_INFO";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_TYPE] = "BRUTUS_PR_DISPLAY_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_TEMPLATEID] = "BRUTUS_PR_TEMPLATEID";
	ptag_arr[::BRUTUS::BRUTUS_PR_PRIMARY_CAPABILITY] = "BRUTUS_PR_PRIMARY_CAPABILITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_7BIT_DISPLAY_NAME] = "BRUTUS_PR_7BIT_DISPLAY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ACCOUNT] = "BRUTUS_PR_ACCOUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_ACCOUNT_W] = "BRUTUS_PR_ACCOUNT_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ACCOUNT_A] = "BRUTUS_PR_ACCOUNT_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ALTERNATE_RECIPIENT] = "BRUTUS_PR_ALTERNATE_RECIPIENT";
	ptag_arr[::BRUTUS::BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER] = "BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER_W] = "BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER_A] = "BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONVERSION_PROHIBITED] = "BRUTUS_PR_CONVERSION_PROHIBITED";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISCLOSE_RECIPIENTS] = "BRUTUS_PR_DISCLOSE_RECIPIENTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_GENERATION] = "BRUTUS_PR_GENERATION";
	ptag_arr[::BRUTUS::BRUTUS_PR_GENERATION_W] = "BRUTUS_PR_GENERATION_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_GENERATION_A] = "BRUTUS_PR_GENERATION_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_GIVEN_NAME] = "BRUTUS_PR_GIVEN_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_GIVEN_NAME_W] = "BRUTUS_PR_GIVEN_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_GIVEN_NAME_A] = "BRUTUS_PR_GIVEN_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_GOVERNMENT_ID_NUMBER] = "BRUTUS_PR_GOVERNMENT_ID_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_GOVERNMENT_ID_NUMBER_W] = "BRUTUS_PR_GOVERNMENT_ID_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_GOVERNMENT_ID_NUMBER_A] = "BRUTUS_PR_GOVERNMENT_ID_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER] = "BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER_W] = "BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER_A] = "BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_TELEPHONE_NUMBER] = "BRUTUS_PR_HOME_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_TELEPHONE_NUMBER_W] = "BRUTUS_PR_HOME_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_TELEPHONE_NUMBER_A] = "BRUTUS_PR_HOME_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_INITIALS] = "BRUTUS_PR_INITIALS";
	ptag_arr[::BRUTUS::BRUTUS_PR_INITIALS_W] = "BRUTUS_PR_INITIALS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_INITIALS_A] = "BRUTUS_PR_INITIALS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_KEYWORD] = "BRUTUS_PR_KEYWORD";
	ptag_arr[::BRUTUS::BRUTUS_PR_KEYWORD_W] = "BRUTUS_PR_KEYWORD_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_KEYWORD_A] = "BRUTUS_PR_KEYWORD_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_LANGUAGE] = "BRUTUS_PR_LANGUAGE";
	ptag_arr[::BRUTUS::BRUTUS_PR_LANGUAGE_W] = "BRUTUS_PR_LANGUAGE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_LANGUAGE_A] = "BRUTUS_PR_LANGUAGE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_LOCATION] = "BRUTUS_PR_LOCATION";
	ptag_arr[::BRUTUS::BRUTUS_PR_LOCATION_W] = "BRUTUS_PR_LOCATION_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_LOCATION_A] = "BRUTUS_PR_LOCATION_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_MAIL_PERMISSION] = "BRUTUS_PR_MAIL_PERMISSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_MHS_COMMON_NAME] = "BRUTUS_PR_MHS_COMMON_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_MHS_COMMON_NAME_W] = "BRUTUS_PR_MHS_COMMON_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_MHS_COMMON_NAME_A] = "BRUTUS_PR_MHS_COMMON_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER] = "BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER_W] = "BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER_A] = "BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SURNAME] = "BRUTUS_PR_SURNAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_SURNAME_W] = "BRUTUS_PR_SURNAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SURNAME_A] = "BRUTUS_PR_SURNAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_ENTRYID] = "BRUTUS_PR_ORIGINAL_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_NAME] = "BRUTUS_PR_ORIGINAL_DISPLAY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_NAME_W] = "BRUTUS_PR_ORIGINAL_DISPLAY_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_DISPLAY_NAME_A] = "BRUTUS_PR_ORIGINAL_DISPLAY_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINAL_SEARCH_KEY] = "BRUTUS_PR_ORIGINAL_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_POSTAL_ADDRESS] = "BRUTUS_PR_POSTAL_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_POSTAL_ADDRESS_W] = "BRUTUS_PR_POSTAL_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_POSTAL_ADDRESS_A] = "BRUTUS_PR_POSTAL_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMPANY_NAME] = "BRUTUS_PR_COMPANY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMPANY_NAME_W] = "BRUTUS_PR_COMPANY_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMPANY_NAME_A] = "BRUTUS_PR_COMPANY_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_TITLE] = "BRUTUS_PR_TITLE";
	ptag_arr[::BRUTUS::BRUTUS_PR_TITLE_W] = "BRUTUS_PR_TITLE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_TITLE_A] = "BRUTUS_PR_TITLE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEPARTMENT_NAME] = "BRUTUS_PR_DEPARTMENT_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEPARTMENT_NAME_W] = "BRUTUS_PR_DEPARTMENT_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEPARTMENT_NAME_A] = "BRUTUS_PR_DEPARTMENT_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_OFFICE_LOCATION] = "BRUTUS_PR_OFFICE_LOCATION";
	ptag_arr[::BRUTUS::BRUTUS_PR_OFFICE_LOCATION_W] = "BRUTUS_PR_OFFICE_LOCATION_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_OFFICE_LOCATION_A] = "BRUTUS_PR_OFFICE_LOCATION_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER] = "BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER_W] = "BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER_A] = "BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER] = "BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER_W] = "BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER_A] = "BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_MOBILE_TELEPHONE_NUMBER] = "BRUTUS_PR_MOBILE_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_MOBILE_TELEPHONE_NUMBER_W] = "BRUTUS_PR_MOBILE_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_MOBILE_TELEPHONE_NUMBER_A] = "BRUTUS_PR_MOBILE_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_RADIO_TELEPHONE_NUMBER] = "BRUTUS_PR_RADIO_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_RADIO_TELEPHONE_NUMBER_W] = "BRUTUS_PR_RADIO_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RADIO_TELEPHONE_NUMBER_A] = "BRUTUS_PR_RADIO_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CAR_TELEPHONE_NUMBER] = "BRUTUS_PR_CAR_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_CAR_TELEPHONE_NUMBER_W] = "BRUTUS_PR_CAR_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_CAR_TELEPHONE_NUMBER_A] = "BRUTUS_PR_CAR_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_TELEPHONE_NUMBER] = "BRUTUS_PR_OTHER_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_TELEPHONE_NUMBER_W] = "BRUTUS_PR_OTHER_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_TELEPHONE_NUMBER_A] = "BRUTUS_PR_OTHER_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME] = "BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME_W] = "BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME_A] = "BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_PAGER_TELEPHONE_NUMBER] = "BRUTUS_PR_PAGER_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_PAGER_TELEPHONE_NUMBER_W] = "BRUTUS_PR_PAGER_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_PAGER_TELEPHONE_NUMBER_A] = "BRUTUS_PR_PAGER_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_USER_CERTIFICATE] = "BRUTUS_PR_USER_CERTIFICATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_PRIMARY_FAX_NUMBER] = "BRUTUS_PR_PRIMARY_FAX_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_PRIMARY_FAX_NUMBER_W] = "BRUTUS_PR_PRIMARY_FAX_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_PRIMARY_FAX_NUMBER_A] = "BRUTUS_PR_PRIMARY_FAX_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS_FAX_NUMBER] = "BRUTUS_PR_BUSINESS_FAX_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS_FAX_NUMBER_W] = "BRUTUS_PR_BUSINESS_FAX_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS_FAX_NUMBER_A] = "BRUTUS_PR_BUSINESS_FAX_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_FAX_NUMBER] = "BRUTUS_PR_HOME_FAX_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_FAX_NUMBER_W] = "BRUTUS_PR_HOME_FAX_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_FAX_NUMBER_A] = "BRUTUS_PR_HOME_FAX_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_COUNTRY] = "BRUTUS_PR_COUNTRY";
	ptag_arr[::BRUTUS::BRUTUS_PR_COUNTRY_W] = "BRUTUS_PR_COUNTRY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_COUNTRY_A] = "BRUTUS_PR_COUNTRY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_LOCALITY] = "BRUTUS_PR_LOCALITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_LOCALITY_W] = "BRUTUS_PR_LOCALITY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_LOCALITY_A] = "BRUTUS_PR_LOCALITY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_STATE_OR_PROVINCE] = "BRUTUS_PR_STATE_OR_PROVINCE";
	ptag_arr[::BRUTUS::BRUTUS_PR_STATE_OR_PROVINCE_W] = "BRUTUS_PR_STATE_OR_PROVINCE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_STATE_OR_PROVINCE_A] = "BRUTUS_PR_STATE_OR_PROVINCE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_STREET_ADDRESS] = "BRUTUS_PR_STREET_ADDRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_STREET_ADDRESS_W] = "BRUTUS_PR_STREET_ADDRESS_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_STREET_ADDRESS_A] = "BRUTUS_PR_STREET_ADDRESS_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_POSTAL_CODE] = "BRUTUS_PR_POSTAL_CODE";
	ptag_arr[::BRUTUS::BRUTUS_PR_POSTAL_CODE_W] = "BRUTUS_PR_POSTAL_CODE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_POSTAL_CODE_A] = "BRUTUS_PR_POSTAL_CODE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_POST_OFFICE_BOX] = "BRUTUS_PR_POST_OFFICE_BOX";
	ptag_arr[::BRUTUS::BRUTUS_PR_POST_OFFICE_BOX_W] = "BRUTUS_PR_POST_OFFICE_BOX_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_POST_OFFICE_BOX_A] = "BRUTUS_PR_POST_OFFICE_BOX_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_TELEX_NUMBER] = "BRUTUS_PR_TELEX_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_TELEX_NUMBER_W] = "BRUTUS_PR_TELEX_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_TELEX_NUMBER_A] = "BRUTUS_PR_TELEX_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ISDN_NUMBER] = "BRUTUS_PR_ISDN_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_ISDN_NUMBER_W] = "BRUTUS_PR_ISDN_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ISDN_NUMBER_A] = "BRUTUS_PR_ISDN_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER] = "BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER_W] = "BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER_A] = "BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME2_TELEPHONE_NUMBER] = "BRUTUS_PR_HOME2_TELEPHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME2_TELEPHONE_NUMBER_W] = "BRUTUS_PR_HOME2_TELEPHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME2_TELEPHONE_NUMBER_A] = "BRUTUS_PR_HOME2_TELEPHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSISTANT] = "BRUTUS_PR_ASSISTANT";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSISTANT_W] = "BRUTUS_PR_ASSISTANT_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSISTANT_A] = "BRUTUS_PR_ASSISTANT_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SEND_RICH_INFO] = "BRUTUS_PR_SEND_RICH_INFO";
	ptag_arr[::BRUTUS::BRUTUS_PR_WEDDING_ANNIVERSARY] = "BRUTUS_PR_WEDDING_ANNIVERSARY";
	ptag_arr[::BRUTUS::BRUTUS_PR_BIRTHDAY] = "BRUTUS_PR_BIRTHDAY";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOBBIES] = "BRUTUS_PR_HOBBIES";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOBBIES_W] = "BRUTUS_PR_HOBBIES_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOBBIES_A] = "BRUTUS_PR_HOBBIES_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_MIDDLE_NAME] = "BRUTUS_PR_MIDDLE_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_MIDDLE_NAME_W] = "BRUTUS_PR_MIDDLE_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_MIDDLE_NAME_A] = "BRUTUS_PR_MIDDLE_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_NAME_PREFIX] = "BRUTUS_PR_DISPLAY_NAME_PREFIX";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_NAME_PREFIX_W] = "BRUTUS_PR_DISPLAY_NAME_PREFIX_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISPLAY_NAME_PREFIX_A] = "BRUTUS_PR_DISPLAY_NAME_PREFIX_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFESSION] = "BRUTUS_PR_PROFESSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFESSION_W] = "BRUTUS_PR_PROFESSION_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFESSION_A] = "BRUTUS_PR_PROFESSION_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_PREFERRED_BY_NAME] = "BRUTUS_PR_PREFERRED_BY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_PREFERRED_BY_NAME_W] = "BRUTUS_PR_PREFERRED_BY_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_PREFERRED_BY_NAME_A] = "BRUTUS_PR_PREFERRED_BY_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SPOUSE_NAME] = "BRUTUS_PR_SPOUSE_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_SPOUSE_NAME_W] = "BRUTUS_PR_SPOUSE_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SPOUSE_NAME_A] = "BRUTUS_PR_SPOUSE_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMPUTER_NETWORK_NAME] = "BRUTUS_PR_COMPUTER_NETWORK_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMPUTER_NETWORK_NAME_W] = "BRUTUS_PR_COMPUTER_NETWORK_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMPUTER_NETWORK_NAME_A] = "BRUTUS_PR_COMPUTER_NETWORK_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CUSTOMER_ID] = "BRUTUS_PR_CUSTOMER_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_CUSTOMER_ID_W] = "BRUTUS_PR_CUSTOMER_ID_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_CUSTOMER_ID_A] = "BRUTUS_PR_CUSTOMER_ID_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_TTYTDD_PHONE_NUMBER] = "BRUTUS_PR_TTYTDD_PHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_TTYTDD_PHONE_NUMBER_W] = "BRUTUS_PR_TTYTDD_PHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_TTYTDD_PHONE_NUMBER_A] = "BRUTUS_PR_TTYTDD_PHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_FTP_SITE] = "BRUTUS_PR_FTP_SITE";
	ptag_arr[::BRUTUS::BRUTUS_PR_FTP_SITE_W] = "BRUTUS_PR_FTP_SITE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_FTP_SITE_A] = "BRUTUS_PR_FTP_SITE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_GENDER] = "BRUTUS_PR_GENDER";
	ptag_arr[::BRUTUS::BRUTUS_PR_MANAGER_NAME] = "BRUTUS_PR_MANAGER_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_MANAGER_NAME_W] = "BRUTUS_PR_MANAGER_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_MANAGER_NAME_A] = "BRUTUS_PR_MANAGER_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_NICKNAME] = "BRUTUS_PR_NICKNAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_NICKNAME_W] = "BRUTUS_PR_NICKNAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_NICKNAME_A] = "BRUTUS_PR_NICKNAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_PERSONAL_HOME_PAGE] = "BRUTUS_PR_PERSONAL_HOME_PAGE";
	ptag_arr[::BRUTUS::BRUTUS_PR_PERSONAL_HOME_PAGE_W] = "BRUTUS_PR_PERSONAL_HOME_PAGE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_PERSONAL_HOME_PAGE_A] = "BRUTUS_PR_PERSONAL_HOME_PAGE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS_HOME_PAGE] = "BRUTUS_PR_BUSINESS_HOME_PAGE";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS_HOME_PAGE_W] = "BRUTUS_PR_BUSINESS_HOME_PAGE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_BUSINESS_HOME_PAGE_A] = "BRUTUS_PR_BUSINESS_HOME_PAGE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_VERSION] = "BRUTUS_PR_CONTACT_VERSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_ENTRYIDS] = "BRUTUS_PR_CONTACT_ENTRYIDS";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_ADDRTYPES] = "BRUTUS_PR_CONTACT_ADDRTYPES";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_ADDRTYPES_W] = "BRUTUS_PR_CONTACT_ADDRTYPES_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_ADDRTYPES_A] = "BRUTUS_PR_CONTACT_ADDRTYPES_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_DEFAULT_ADDRESS_INDEX] = "BRUTUS_PR_CONTACT_DEFAULT_ADDRESS_INDEX";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_EMAIL_ADDRESSES] = "BRUTUS_PR_CONTACT_EMAIL_ADDRESSES";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_EMAIL_ADDRESSES_W] = "BRUTUS_PR_CONTACT_EMAIL_ADDRESSES_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_EMAIL_ADDRESSES_A] = "BRUTUS_PR_CONTACT_EMAIL_ADDRESSES_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER] = "BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER_W] = "BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER_A] = "BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_CHILDRENS_NAMES] = "BRUTUS_PR_CHILDRENS_NAMES";
	ptag_arr[::BRUTUS::BRUTUS_PR_CHILDRENS_NAMES_W] = "BRUTUS_PR_CHILDRENS_NAMES_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_CHILDRENS_NAMES_A] = "BRUTUS_PR_CHILDRENS_NAMES_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_CITY] = "BRUTUS_PR_HOME_ADDRESS_CITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_CITY_W] = "BRUTUS_PR_HOME_ADDRESS_CITY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_CITY_A] = "BRUTUS_PR_HOME_ADDRESS_CITY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_COUNTRY] = "BRUTUS_PR_HOME_ADDRESS_COUNTRY";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_COUNTRY_W] = "BRUTUS_PR_HOME_ADDRESS_COUNTRY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_COUNTRY_A] = "BRUTUS_PR_HOME_ADDRESS_COUNTRY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE] = "BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE_W] = "BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE_A] = "BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE] = "BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE_W] = "BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE_A] = "BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_STREET] = "BRUTUS_PR_HOME_ADDRESS_STREET";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_STREET_W] = "BRUTUS_PR_HOME_ADDRESS_STREET_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_STREET_A] = "BRUTUS_PR_HOME_ADDRESS_STREET_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX] = "BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX_W] = "BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX_A] = "BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_CITY] = "BRUTUS_PR_OTHER_ADDRESS_CITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_CITY_W] = "BRUTUS_PR_OTHER_ADDRESS_CITY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_CITY_A] = "BRUTUS_PR_OTHER_ADDRESS_CITY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_COUNTRY] = "BRUTUS_PR_OTHER_ADDRESS_COUNTRY";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_COUNTRY_W] = "BRUTUS_PR_OTHER_ADDRESS_COUNTRY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_COUNTRY_A] = "BRUTUS_PR_OTHER_ADDRESS_COUNTRY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE] = "BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE_W] = "BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE_A] = "BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE] = "BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE_W] = "BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A] = "BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_STREET] = "BRUTUS_PR_OTHER_ADDRESS_STREET";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_STREET_W] = "BRUTUS_PR_OTHER_ADDRESS_STREET_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_STREET_A] = "BRUTUS_PR_OTHER_ADDRESS_STREET_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX] = "BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX_W] = "BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX_A] = "BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_STORE_PROVIDERS] = "BRUTUS_PR_STORE_PROVIDERS";
	ptag_arr[::BRUTUS::BRUTUS_PR_AB_PROVIDERS] = "BRUTUS_PR_AB_PROVIDERS";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSPORT_PROVIDERS] = "BRUTUS_PR_TRANSPORT_PROVIDERS";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEFAULT_PROFILE] = "BRUTUS_PR_DEFAULT_PROFILE";
	ptag_arr[::BRUTUS::BRUTUS_PR_AB_SEARCH_PATH] = "BRUTUS_PR_AB_SEARCH_PATH";
	ptag_arr[::BRUTUS::BRUTUS_PR_AB_DEFAULT_DIR] = "BRUTUS_PR_AB_DEFAULT_DIR";
	ptag_arr[::BRUTUS::BRUTUS_PR_AB_DEFAULT_PAB] = "BRUTUS_PR_AB_DEFAULT_PAB";
	ptag_arr[::BRUTUS::BRUTUS_PR_FILTERING_HOOKS] = "BRUTUS_PR_FILTERING_HOOKS";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_NAME] = "BRUTUS_PR_SERVICE_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_NAME_W] = "BRUTUS_PR_SERVICE_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_NAME_A] = "BRUTUS_PR_SERVICE_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_DLL_NAME] = "BRUTUS_PR_SERVICE_DLL_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_DLL_NAME_W] = "BRUTUS_PR_SERVICE_DLL_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_DLL_NAME_A] = "BRUTUS_PR_SERVICE_DLL_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_ENTRY_NAME] = "BRUTUS_PR_SERVICE_ENTRY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_UID] = "BRUTUS_PR_SERVICE_UID";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_EXTRA_UIDS] = "BRUTUS_PR_SERVICE_EXTRA_UIDS";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICES] = "BRUTUS_PR_SERVICES";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_SUPPORT_FILES] = "BRUTUS_PR_SERVICE_SUPPORT_FILES";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_SUPPORT_FILES_W] = "BRUTUS_PR_SERVICE_SUPPORT_FILES_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_SUPPORT_FILES_A] = "BRUTUS_PR_SERVICE_SUPPORT_FILES_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_DELETE_FILES] = "BRUTUS_PR_SERVICE_DELETE_FILES";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_DELETE_FILES_W] = "BRUTUS_PR_SERVICE_DELETE_FILES_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_SERVICE_DELETE_FILES_A] = "BRUTUS_PR_SERVICE_DELETE_FILES_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_AB_SEARCH_PATH_UPDATE] = "BRUTUS_PR_AB_SEARCH_PATH_UPDATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_NAME] = "BRUTUS_PR_PROFILE_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_NAME_A] = "BRUTUS_PR_PROFILE_NAME_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_NAME_W] = "BRUTUS_PR_PROFILE_NAME_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_IDENTITY_DISPLAY] = "BRUTUS_PR_IDENTITY_DISPLAY";
	ptag_arr[::BRUTUS::BRUTUS_PR_IDENTITY_DISPLAY_W] = "BRUTUS_PR_IDENTITY_DISPLAY_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_IDENTITY_DISPLAY_A] = "BRUTUS_PR_IDENTITY_DISPLAY_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_IDENTITY_ENTRYID] = "BRUTUS_PR_IDENTITY_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESOURCE_METHODS] = "BRUTUS_PR_RESOURCE_METHODS";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESOURCE_TYPE] = "BRUTUS_PR_RESOURCE_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_STATUS_CODE] = "BRUTUS_PR_STATUS_CODE";
	ptag_arr[::BRUTUS::BRUTUS_PR_IDENTITY_SEARCH_KEY] = "BRUTUS_PR_IDENTITY_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_OWN_STORE_ENTRYID] = "BRUTUS_PR_OWN_STORE_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESOURCE_PATH] = "BRUTUS_PR_RESOURCE_PATH";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESOURCE_PATH_W] = "BRUTUS_PR_RESOURCE_PATH_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESOURCE_PATH_A] = "BRUTUS_PR_RESOURCE_PATH_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_STATUS_STRING] = "BRUTUS_PR_STATUS_STRING";
	ptag_arr[::BRUTUS::BRUTUS_PR_STATUS_STRING_W] = "BRUTUS_PR_STATUS_STRING_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_STATUS_STRING_A] = "BRUTUS_PR_STATUS_STRING_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_X400_DEFERRED_DELIVERY_CANCEL] = "BRUTUS_PR_X400_DEFERRED_DELIVERY_CANCEL";
	ptag_arr[::BRUTUS::BRUTUS_PR_HEADER_FOLDER_ENTRYID] = "BRUTUS_PR_HEADER_FOLDER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_REMOTE_PROGRESS] = "BRUTUS_PR_REMOTE_PROGRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_REMOTE_PROGRESS_TEXT] = "BRUTUS_PR_REMOTE_PROGRESS_TEXT";
	ptag_arr[::BRUTUS::BRUTUS_PR_REMOTE_PROGRESS_TEXT_W] = "BRUTUS_PR_REMOTE_PROGRESS_TEXT_W";
	ptag_arr[::BRUTUS::BRUTUS_PR_REMOTE_PROGRESS_TEXT_A] = "BRUTUS_PR_REMOTE_PROGRESS_TEXT_A";
	ptag_arr[::BRUTUS::BRUTUS_PR_REMOTE_VALIDATE_OK] = "BRUTUS_PR_REMOTE_VALIDATE_OK";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTROL_FLAGS] = "BRUTUS_PR_CONTROL_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTROL_STRUCTURE] = "BRUTUS_PR_CONTROL_STRUCTURE";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTROL_TYPE] = "BRUTUS_PR_CONTROL_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELTAX] = "BRUTUS_PR_DELTAX";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELTAY] = "BRUTUS_PR_DELTAY";
	ptag_arr[::BRUTUS::BRUTUS_PR_XPOS] = "BRUTUS_PR_XPOS";
	ptag_arr[::BRUTUS::BRUTUS_PR_YPOS] = "BRUTUS_PR_YPOS";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTROL_ID] = "BRUTUS_PR_CONTROL_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_INITIAL_DETAILS_PANE] = "BRUTUS_PR_INITIAL_DETAILS_PANE";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_VERSION] = "BRUTUS_PR_PROFILE_VERSION";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_CONFIG_FLAGS] = "BRUTUS_PR_PROFILE_CONFIG_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_HOME_SERVER] = "BRUTUS_PR_PROFILE_HOME_SERVER";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_HOME_SERVER_DN] = "BRUTUS_PR_PROFILE_HOME_SERVER_DN";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_HOME_SERVER_ADDRS] = "BRUTUS_PR_PROFILE_HOME_SERVER_ADDRS";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_USER] = "BRUTUS_PR_PROFILE_USER";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_CONNECT_FLAGS] = "BRUTUS_PR_PROFILE_CONNECT_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_TRANSPORT_FLAGS] = "BRUTUS_PR_PROFILE_TRANSPORT_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_UI_STATE] = "BRUTUS_PR_PROFILE_UI_STATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_UNRESOLVED_NAME] = "BRUTUS_PR_PROFILE_UNRESOLVED_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_UNRESOLVED_SERVER] = "BRUTUS_PR_PROFILE_UNRESOLVED_SERVER";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_BINDING_ORDER] = "BRUTUS_PR_PROFILE_BINDING_ORDER";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_MAX_RESTRICT] = "BRUTUS_PR_PROFILE_MAX_RESTRICT";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_AB_FILES_PATH] = "BRUTUS_PR_PROFILE_AB_FILES_PATH";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_OFFLINE_STORE_PATH] = "BRUTUS_PR_PROFILE_OFFLINE_STORE_PATH";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_OFFLINE_INFO] = "BRUTUS_PR_PROFILE_OFFLINE_INFO";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_ADDR_INFO] = "BRUTUS_PR_PROFILE_ADDR_INFO";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_OPTIONS_DATA] = "BRUTUS_PR_PROFILE_OPTIONS_DATA";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_SECURE_MAILBOX] = "BRUTUS_PR_PROFILE_SECURE_MAILBOX";
	ptag_arr[::BRUTUS::BRUTUS_PR_DISABLE_WINSOCK] = "BRUTUS_PR_DISABLE_WINSOCK";
	ptag_arr[::BRUTUS::BRUTUS_PR_OST_ENCRYPTION] = "BRUTUS_PR_OST_ENCRYPTION";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_OPEN_FLAGS] = "BRUTUS_PR_PROFILE_OPEN_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_TYPE] = "BRUTUS_PR_PROFILE_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_MAILBOX] = "BRUTUS_PR_PROFILE_MAILBOX";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_SERVER] = "BRUTUS_PR_PROFILE_SERVER";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_SERVER_DN] = "BRUTUS_PR_PROFILE_SERVER_DN";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_FAVFLD_DISPLAY_NAME] = "BRUTUS_PR_PROFILE_FAVFLD_DISPLAY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_FAVFLD_COMMENT] = "BRUTUS_PR_PROFILE_FAVFLD_COMMENT";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_ALLPUB_DISPLAY_NAME] = "BRUTUS_PR_PROFILE_ALLPUB_DISPLAY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_PROFILE_ALLPUB_COMMENT] = "BRUTUS_PR_PROFILE_ALLPUB_COMMENT";
	ptag_arr[::BRUTUS::BRUTUS_PR_USER_ENTRYID] = "BRUTUS_PR_USER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_USER_NAME] = "BRUTUS_PR_USER_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_MAILBOX_OWNER_ENTRYID] = "BRUTUS_PR_MAILBOX_OWNER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_MAILBOX_OWNER_NAME] = "BRUTUS_PR_MAILBOX_OWNER_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_OOF_STATE] = "BRUTUS_PR_OOF_STATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_HIERARCHY_SERVER] = "BRUTUS_PR_HIERARCHY_SERVER";
	ptag_arr[::BRUTUS::BRUTUS_PR_SCHEDULE_FOLDER_ENTRYID] = "BRUTUS_PR_SCHEDULE_FOLDER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_DAF_ENTRYID] = "BRUTUS_PR_IPM_DAF_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_NON_IPM_SUBTREE_ENTRYID] = "BRUTUS_PR_NON_IPM_SUBTREE_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_EFORMS_REGISTRY_ENTRYID] = "BRUTUS_PR_EFORMS_REGISTRY_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_SPLUS_FREE_BUSY_ENTRYID] = "BRUTUS_PR_SPLUS_FREE_BUSY_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_OFFLINE_ADDRBOOK_ENTRYID] = "BRUTUS_PR_OFFLINE_ADDRBOOK_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_EFORMS_FOR_LOCALE_ENTRYID] = "BRUTUS_PR_EFORMS_FOR_LOCALE_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_FREE_BUSY_FOR_LOCAL_SITE_ENTRYID] = "BRUTUS_PR_FREE_BUSY_FOR_LOCAL_SITE_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_ADDRBOOK_FOR_LOCAL_SITE_ENTRYID] = "BRUTUS_PR_ADDRBOOK_FOR_LOCAL_SITE_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_OFFLINE_MESSAGE_ENTRYID] = "BRUTUS_PR_OFFLINE_MESSAGE_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_FAVORITES_ENTRYID] = "BRUTUS_PR_IPM_FAVORITES_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_IPM_PUBLIC_FOLDERS_ENTRYID] = "BRUTUS_PR_IPM_PUBLIC_FOLDERS_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_GW_MTSIN_ENTRYID] = "BRUTUS_PR_GW_MTSIN_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_GW_MTSOUT_ENTRYID] = "BRUTUS_PR_GW_MTSOUT_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRANSFER_ENABLED] = "BRUTUS_PR_TRANSFER_ENABLED";
	ptag_arr[::BRUTUS::BRUTUS_PR_TEST_LINE_SPEED] = "BRUTUS_PR_TEST_LINE_SPEED";
	ptag_arr[::BRUTUS::BRUTUS_PR_HIERARCHY_SYNCHRONIZER] = "BRUTUS_PR_HIERARCHY_SYNCHRONIZER";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENTS_SYNCHRONIZER] = "BRUTUS_PR_CONTENTS_SYNCHRONIZER";
	ptag_arr[::BRUTUS::BRUTUS_PR_COLLECTOR] = "BRUTUS_PR_COLLECTOR";
	ptag_arr[::BRUTUS::BRUTUS_PR_FAST_TRANSFER] = "BRUTUS_PR_FAST_TRANSFER";
	ptag_arr[::BRUTUS::BRUTUS_PR_STORE_OFFLINE] = "BRUTUS_PR_STORE_OFFLINE";
	ptag_arr[::BRUTUS::BRUTUS_PR_IN_TRANSIT] = "BRUTUS_PR_IN_TRANSIT";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLICATION_STYLE] = "BRUTUS_PR_REPLICATION_STYLE";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLICATION_SCHEDULE] = "BRUTUS_PR_REPLICATION_SCHEDULE";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLICATION_MESSAGE_PRIORITY] = "BRUTUS_PR_REPLICATION_MESSAGE_PRIORITY";
	ptag_arr[::BRUTUS::BRUTUS_PR_OVERALL_MSG_AGE_LIMIT] = "BRUTUS_PR_OVERALL_MSG_AGE_LIMIT";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLICATION_ALWAYS_INTERVAL] = "BRUTUS_PR_REPLICATION_ALWAYS_INTERVAL";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLICATION_MSG_SIZE] = "BRUTUS_PR_REPLICATION_MSG_SIZE";
	ptag_arr[::BRUTUS::BRUTUS_PR_SOURCE_KEY] = "BRUTUS_PR_SOURCE_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_PARENT_SOURCE_KEY] = "BRUTUS_PR_PARENT_SOURCE_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_CHANGE_KEY] = "BRUTUS_PR_CHANGE_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_PREDECESSOR_CHANGE_LIST] = "BRUTUS_PR_PREDECESSOR_CHANGE_LIST";
	ptag_arr[::BRUTUS::BRUTUS_PR_FOLDER_CHILD_COUNT] = "BRUTUS_PR_FOLDER_CHILD_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_RIGHTS] = "BRUTUS_PR_RIGHTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_ACL_TABLE] = "BRUTUS_PR_ACL_TABLE";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULES_TABLE] = "BRUTUS_PR_RULES_TABLE";
	ptag_arr[::BRUTUS::BRUTUS_PR_HAS_RULES] = "BRUTUS_PR_HAS_RULES";
	ptag_arr[::BRUTUS::BRUTUS_PR_ADDRESS_BOOK_ENTRYID] = "BRUTUS_PR_ADDRESS_BOOK_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_ACL_DATA] = "BRUTUS_PR_ACL_DATA";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULES_DATA] = "BRUTUS_PR_RULES_DATA";
	ptag_arr[::BRUTUS::BRUTUS_PR_FOLDER_DESIGN_FLAGS] = "BRUTUS_PR_FOLDER_DESIGN_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_DESIGN_IN_PROGRESS] = "BRUTUS_PR_DESIGN_IN_PROGRESS";
	ptag_arr[::BRUTUS::BRUTUS_PR_SECURE_ORIGINATION] = "BRUTUS_PR_SECURE_ORIGINATION";
	ptag_arr[::BRUTUS::BRUTUS_PR_PUBLISH_IN_ADDRESS_BOOK] = "BRUTUS_PR_PUBLISH_IN_ADDRESS_BOOK";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESOLVE_METHOD] = "BRUTUS_PR_RESOLVE_METHOD";
	ptag_arr[::BRUTUS::BRUTUS_PR_ADDRESS_BOOK_DISPLAY_NAME] = "BRUTUS_PR_ADDRESS_BOOK_DISPLAY_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_EFORMS_LOCALE_ID] = "BRUTUS_PR_EFORMS_LOCALE_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLICA_LIST] = "BRUTUS_PR_REPLICA_LIST";
	ptag_arr[::BRUTUS::BRUTUS_PR_OVERALL_AGE_LIMIT] = "BRUTUS_PR_OVERALL_AGE_LIMIT";
	ptag_arr[::BRUTUS::BRUTUS_PR_PUBLIC_FOLDER_ENTRYID] = "BRUTUS_PR_PUBLIC_FOLDER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_HAS_NAMED_PROPERTIES] = "BRUTUS_PR_HAS_NAMED_PROPERTIES";
	ptag_arr[::BRUTUS::BRUTUS_PR_CREATOR_NAME] = "BRUTUS_PR_CREATOR_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_CREATOR_ENTRYID] = "BRUTUS_PR_CREATOR_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_LAST_MODIFIER_NAME] = "BRUTUS_PR_LAST_MODIFIER_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_LAST_MODIFIER_ENTRYID] = "BRUTUS_PR_LAST_MODIFIER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_HAS_DAMS] = "BRUTUS_PR_HAS_DAMS";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_TRIGGER_HISTORY] = "BRUTUS_PR_RULE_TRIGGER_HISTORY";
	ptag_arr[::BRUTUS::BRUTUS_PR_MOVE_TO_STORE_ENTRYID] = "BRUTUS_PR_MOVE_TO_STORE_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_MOVE_TO_FOLDER_ENTRYID] = "BRUTUS_PR_MOVE_TO_FOLDER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLICA_SERVER] = "BRUTUS_PR_REPLICA_SERVER";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEFERRED_SEND_NUMBER] = "BRUTUS_PR_DEFERRED_SEND_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEFERRED_SEND_UNITS] = "BRUTUS_PR_DEFERRED_SEND_UNITS";
	ptag_arr[::BRUTUS::BRUTUS_PR_EXPIRY_NUMBER] = "BRUTUS_PR_EXPIRY_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_EXPIRY_UNITS] = "BRUTUS_PR_EXPIRY_UNITS";
	ptag_arr[::BRUTUS::BRUTUS_PR_DEFERRED_SEND_TIME] = "BRUTUS_PR_DEFERRED_SEND_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_GW_ADMIN_OPERATIONS] = "BRUTUS_PR_GW_ADMIN_OPERATIONS";
	ptag_arr[::BRUTUS::BRUTUS_PR_P1_CONTENT] = "BRUTUS_PR_P1_CONTENT";
	ptag_arr[::BRUTUS::BRUTUS_PR_P1_CONTENT_TYPE] = "BRUTUS_PR_P1_CONTENT_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_CLIENT_ACTIONS] = "BRUTUS_PR_CLIENT_ACTIONS";
	ptag_arr[::BRUTUS::BRUTUS_PR_DAM_ORIGINAL_ENTRYID] = "BRUTUS_PR_DAM_ORIGINAL_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_DAM_BACK_PATCHED] = "BRUTUS_PR_DAM_BACK_PATCHED";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_ERROR] = "BRUTUS_PR_RULE_ERROR";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_ACTION_TYPE] = "BRUTUS_PR_RULE_ACTION_TYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_ACTION_NUMBER] = "BRUTUS_PR_RULE_ACTION_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_FOLDER_ENTRYID] = "BRUTUS_PR_RULE_FOLDER_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONFLICT_ENTRYID] = "BRUTUS_PR_CONFLICT_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_LOCALE_ID] = "BRUTUS_PR_MESSAGE_LOCALE_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_STORAGE_QUOTA_LIMIT] = "BRUTUS_PR_STORAGE_QUOTA_LIMIT";
	ptag_arr[::BRUTUS::BRUTUS_PR_EXCESS_STORAGE_USED] = "BRUTUS_PR_EXCESS_STORAGE_USED";
	ptag_arr[::BRUTUS::BRUTUS_PR_SVR_GENERATING_QUOTA_MSG] = "BRUTUS_PR_SVR_GENERATING_QUOTA_MSG";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELEGATED_BY_RULE] = "BRUTUS_PR_DELEGATED_BY_RULE";
	ptag_arr[::BRUTUS::BRUTUS_PR_IN_CONFLICT] = "BRUTUS_PR_IN_CONFLICT";
	ptag_arr[::BRUTUS::BRUTUS_PR_LONGTERM_ENTRYID_FROM_TABLE] = "BRUTUS_PR_LONGTERM_ENTRYID_FROM_TABLE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_NAME] = "BRUTUS_PR_ORIGINATOR_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_ADDR] = "BRUTUS_PR_ORIGINATOR_ADDR";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_ADDRTYPE] = "BRUTUS_PR_ORIGINATOR_ADDRTYPE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ORIGINATOR_ENTRYID] = "BRUTUS_PR_ORIGINATOR_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_ARRIVAL_TIME] = "BRUTUS_PR_ARRIVAL_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_TRACE_INFO] = "BRUTUS_PR_TRACE_INFO";
	ptag_arr[::BRUTUS::BRUTUS_PR_INTERNAL_TRACE_INFO] = "BRUTUS_PR_INTERNAL_TRACE_INFO";
	ptag_arr[::BRUTUS::BRUTUS_PR_SUBJECT_TRACE_INFO] = "BRUTUS_PR_SUBJECT_TRACE_INFO";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_NUMBER] = "BRUTUS_PR_RECIPIENT_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_MTS_SUBJECT_ID] = "BRUTUS_PR_MTS_SUBJECT_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_DESTINATION_NAME] = "BRUTUS_PR_REPORT_DESTINATION_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPORT_DESTINATION_ENTRYID] = "BRUTUS_PR_REPORT_DESTINATION_ENTRYID";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTENT_SEARCH_KEY] = "BRUTUS_PR_CONTENT_SEARCH_KEY";
	ptag_arr[::BRUTUS::BRUTUS_PR_FOREIGN_ID] = "BRUTUS_PR_FOREIGN_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_FOREIGN_REPORT_ID] = "BRUTUS_PR_FOREIGN_REPORT_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_FOREIGN_SUBJECT_ID] = "BRUTUS_PR_FOREIGN_SUBJECT_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_MEMBER_ID] = "BRUTUS_PR_MEMBER_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_MEMBER_NAME] = "BRUTUS_PR_MEMBER_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_MEMBER_RIGHTS] = "BRUTUS_PR_MEMBER_RIGHTS";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_ID] = "BRUTUS_PR_RULE_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_IDS] = "BRUTUS_PR_RULE_IDS";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_SEQUENCE] = "BRUTUS_PR_RULE_SEQUENCE";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_STATE] = "BRUTUS_PR_RULE_STATE";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_USER_FLAGS] = "BRUTUS_PR_RULE_USER_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_CONDITION] = "BRUTUS_PR_RULE_CONDITION";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_ACTIONS] = "BRUTUS_PR_RULE_ACTIONS";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_PROVIDER] = "BRUTUS_PR_RULE_PROVIDER";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_NAME] = "BRUTUS_PR_RULE_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_LEVEL] = "BRUTUS_PR_RULE_LEVEL";
	ptag_arr[::BRUTUS::BRUTUS_PR_RULE_PROVIDER_DATA] = "BRUTUS_PR_RULE_PROVIDER_DATA";
	ptag_arr[::BRUTUS::BRUTUS_PR_NT_USER_NAME] = "BRUTUS_PR_NT_USER_NAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_LOCALE_ID] = "BRUTUS_PR_LOCALE_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_LAST_LOGON_TIME] = "BRUTUS_PR_LAST_LOGON_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_LAST_LOGOFF_TIME] = "BRUTUS_PR_LAST_LOGOFF_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_STORAGE_LIMIT_INFORMATION] = "BRUTUS_PR_STORAGE_LIMIT_INFORMATION";
	ptag_arr[::BRUTUS::BRUTUS_PR_FOLDER_FLAGS] = "BRUTUS_PR_FOLDER_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_LAST_ACCESS_TIME] = "BRUTUS_PR_LAST_ACCESS_TIME";
	ptag_arr[::BRUTUS::BRUTUS_PR_RESTRICTION_COUNT] = "BRUTUS_PR_RESTRICTION_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_CATEG_COUNT] = "BRUTUS_PR_CATEG_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_CACHED_COLUMN_COUNT] = "BRUTUS_PR_CACHED_COLUMN_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_NORMAL_MSG_W_ATTACH_COUNT] = "BRUTUS_PR_NORMAL_MSG_W_ATTACH_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSOC_MSG_W_ATTACH_COUNT] = "BRUTUS_PR_ASSOC_MSG_W_ATTACH_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_ON_NORMAL_MSG_COUNT] = "BRUTUS_PR_RECIPIENT_ON_NORMAL_MSG_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_RECIPIENT_ON_ASSOC_MSG_COUNT] = "BRUTUS_PR_RECIPIENT_ON_ASSOC_MSG_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_ON_NORMAL_MSG_COUNT] = "BRUTUS_PR_ATTACH_ON_NORMAL_MSG_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_ATTACH_ON_ASSOC_MSG_COUNT] = "BRUTUS_PR_ATTACH_ON_ASSOC_MSG_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_NORMAL_MESSAGE_SIZE] = "BRUTUS_PR_NORMAL_MESSAGE_SIZE";
	ptag_arr[::BRUTUS::BRUTUS_PR_NORMAL_MESSAGE_SIZE_EXTENDED] = "BRUTUS_PR_NORMAL_MESSAGE_SIZE_EXTENDED";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSOC_MESSAGE_SIZE] = "BRUTUS_PR_ASSOC_MESSAGE_SIZE";
	ptag_arr[::BRUTUS::BRUTUS_PR_ASSOC_MESSAGE_SIZE_EXTENDED] = "BRUTUS_PR_ASSOC_MESSAGE_SIZE_EXTENDED";
	ptag_arr[::BRUTUS::BRUTUS_PR_FOLDER_PATHNAME] = "BRUTUS_PR_FOLDER_PATHNAME";
	ptag_arr[::BRUTUS::BRUTUS_PR_OWNER_COUNT] = "BRUTUS_PR_OWNER_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_CONTACT_COUNT] = "BRUTUS_PR_CONTACT_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_MESSAGE_SIZE_EXTENDED] = "BRUTUS_PR_MESSAGE_SIZE_EXTENDED";
	ptag_arr[::BRUTUS::BRUTUS_PR_OFFLINE_FLAGS] = "BRUTUS_PR_OFFLINE_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_SYNCHRONIZE_FLAGS] = "BRUTUS_PR_SYNCHRONIZE_FLAGS";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELETED_MESSAGE_SIZE_EXTENDED] = "BRUTUS_PR_DELETED_MESSAGE_SIZE_EXTENDED";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELETED_NORMAL_MESSAGE_SIZE_EXTENDED] = "BRUTUS_PR_DELETED_NORMAL_MESSAGE_SIZE_EXTENDED";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELETED_ASSOC_MESSAGE_SIZE_EXTENDED] = "BRUTUS_PR_DELETED_ASSOC_MESSAGE_SIZE_EXTENDED";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELETED_MSG_COUNT] = "BRUTUS_PR_DELETED_MSG_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELETED_ASSOC_MSG_COUNT] = "BRUTUS_PR_DELETED_ASSOC_MSG_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_CODE_PAGE_ID] = "BRUTUS_PR_CODE_PAGE_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_SORT_LOCALE_ID] = "BRUTUS_PR_SORT_LOCALE_ID";
	ptag_arr[::BRUTUS::BRUTUS_PR_DELETED_FOLDER_COUNT] = "BRUTUS_PR_DELETED_FOLDER_COUNT";
	ptag_arr[::BRUTUS::BRUTUS_PR_EXTENDED_ACL_DATA] = "BRUTUS_PR_EXTENDED_ACL_DATA";
	ptag_arr[::BRUTUS::BRUTUS_PR_INTERNET_ARTICLE_NUMBER] = "BRUTUS_PR_INTERNET_ARTICLE_NUMBER";
	ptag_arr[::BRUTUS::BRUTUS_PR_REPLICA_VERSION] = "BRUTUS_PR_REPLICA_VERSION";
}

const char *CPropTag::proptag_to_str(::BRUTUS::BDEFINE PropTag)
{
	return ptag_arr[PropTag];
}

const char *CPropTag::proptype_to_str(::BRUTUS::PT_TYPE PropType)
{
	return ptype_arr[PropType];
}
