/*
 * Brutus sample source file for the IMAPIAdviseSink servant.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "IMAPIAdviseSinkS_impl.h"

#include <idl_output/definesC.h>
#include <map>


class CNotifyConv {
public:
        CNotifyConv(void)
		{
			descr_arr[::BRUTUS::BRUTUS_fnevCriticalError] = "BRUTUS_fnevCriticalError";
			descr_arr[::BRUTUS::BRUTUS_fnevNewMail] = "BRUTUS_fnevNewMail";
			descr_arr[::BRUTUS::BRUTUS_fnevObjectCreated] = "BRUTUS_fnevObjectCreated";
			descr_arr[::BRUTUS::BRUTUS_fnevObjectDeleted] = "BRUTUS_fnevObjectDeleted";
			descr_arr[::BRUTUS::BRUTUS_fnevObjectModified] = "BRUTUS_fnevObjectModified";
			descr_arr[::BRUTUS::BRUTUS_fnevObjectMoved] = "BRUTUS_fnevObjectMoved";
			descr_arr[::BRUTUS::BRUTUS_fnevObjectCopied] = "BRUTUS_fnevObjectCopied";
			descr_arr[::BRUTUS::BRUTUS_fnevSearchComplete] = "BRUTUS_fnevSearchComplete";
			descr_arr[::BRUTUS::BRUTUS_fnevTableModified] = "BRUTUS_fnevTableModified";
			descr_arr[::BRUTUS::BRUTUS_fnevTableModified] = "BRUTUS_fnevTableModified";
			descr_arr[::BRUTUS::BRUTUS_fnevStatusObjectModified] = "BRUTUS_fnevStatusObjectModified";
			descr_arr[::BRUTUS::BRUTUS_fnevReservedForMapi] = "BRUTUS_fnevReservedForMapi";
			descr_arr[::BRUTUS::BRUTUS_fnevExtended] = "BRUTUS_fnevExtended";
		};

        ~CNotifyConv(void)
		{ 
		};

	const char *bnot_to_str(::BRUTUS::BDEFINE descr)
		{
			return descr_arr[descr];
		};

private:
	std::map< ::BRUTUS::BDEFINE, const char*> descr_arr;
};


// Implementation skeleton constructor
BRUTUS_IMAPIAdviseSink_i::BRUTUS_IMAPIAdviseSink_i(unsigned long *Pin)
	: pin_(Pin)
{
}

// Implementation skeleton destructor
BRUTUS_IMAPIAdviseSink_i::~BRUTUS_IMAPIAdviseSink_i(void)
{
}

void BRUTUS_IMAPIAdviseSink_i::OnNotify(const ::BRUTUS::seq_NOTIFICATION & lpNotifications)
	ACE_THROW_SPEC((CORBA::SystemException))
{
	CNotifyConv not_cnv;

	printf("\n\tNotifications recieved - count is %d\n", lpNotifications.length());
	
	for (CORBA::ULong n=0; n<lpNotifications.length(); n++) {
		printf("\tNotification[%d] event type is %s\n", n, not_cnv.bnot_to_str(lpNotifications[n].ulEventType));
		switch (lpNotifications[n].info._d()) {
		case ::BRUTUS::BRUTUS_fnevObjectCopied : 
		case ::BRUTUS::BRUTUS_fnevObjectCreated : 
		case ::BRUTUS::BRUTUS_fnevObjectDeleted :
		case ::BRUTUS::BRUTUS_fnevObjectModified :
		case ::BRUTUS::BRUTUS_fnevObjectMoved :
		case ::BRUTUS::BRUTUS_fnevSearchComplete :
			printf("\t\tObject notification, affected object type is ");
			switch (lpNotifications[n].info.obj().ulObjType) {
			case ::BRUTUS::BRUTUS_MAPI_STORE :
				printf("::BRUTUS::BRUTUS_MAPI_STORE");
				break;
			case ::BRUTUS::BRUTUS_MAPI_ADDRBOOK :
				printf("::BRUTUS::BRUTUS_MAPI_ADDRBOOK");
				break;
			case ::BRUTUS::BRUTUS_MAPI_FOLDER :
				printf("::BRUTUS::BRUTUS_MAPI_FOLDER");
				break;
			case ::BRUTUS::BRUTUS_MAPI_ABCONT :
				printf("::BRUTUS::BRUTUS_MAPI_ABCONT");
				break;
			case ::BRUTUS::BRUTUS_MAPI_MESSAGE :
				printf("::BRUTUS::BRUTUS_MAPI_MESSAGE");
				break;
			case ::BRUTUS::BRUTUS_MAPI_MAILUSER :
				printf("::BRUTUS::BRUTUS_MAPI_MAILUSER");
				break;
			case ::BRUTUS::BRUTUS_MAPI_ATTACH :
				printf("::BRUTUS::BRUTUS_MAPI_ATTACH");
				break;
			case ::BRUTUS::BRUTUS_MAPI_DISTLIST :
				printf("::BRUTUS::BRUTUS_MAPI_DISTLIST");
				break;
			case ::BRUTUS::BRUTUS_MAPI_PROFSECT :
				printf("::BRUTUS::BRUTUS_MAPI_PROFSECT");
				break;
			case ::BRUTUS::BRUTUS_MAPI_STATUS :
				printf("::BRUTUS::BRUTUS_MAPI_STATUS");
				break;
			case ::BRUTUS::BRUTUS_MAPI_SESSION :
				printf("::BRUTUS::BRUTUS_MAPI_SESSION");
				break;
			default :
				printf("UNKNOWN");
				break;
			}
			printf("\n");
			break;
		case ::BRUTUS::BRUTUS_fnevCriticalError : 
			printf("\t\tError notification\n");
			break;
		case ::BRUTUS::BRUTUS_fnevExtended :
			printf("\t\tExtended notification\n");
			break;
		case ::BRUTUS::BRUTUS_fnevNewMail : 
			printf("\t\tNew Mail notification\n");
			break;
		case ::BRUTUS::BRUTUS_fnevTableModified : 
			printf("\t\tTable notification\n");
			break;
		case ::BRUTUS::BRUTUS_fnevStatusObjectModified :
			printf("\t\tStatus Object notification\n");
			break;
		default :
			printf("\t\tUNKNOWN Notification\n");
		}
	}

	*pin_ = 1;
}

void BRUTUS_IMAPIAdviseSink_i::InternalError(::BRUTUS::BRESULT ErrorCode)
	ACE_THROW_SPEC((CORBA::SystemException))
{
	printf("Internal error\n");
	*pin_ = 1;
}

