/*
 * Brutus sample source file for the IMAPIProgress servant.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#include "IMAPIProgressS_impl.h"


BRUTUS_IMAPIProgress_i::BRUTUS_IMAPIProgress_i(PortableServer::POA_ptr Poa)
        : poa_(PortableServer::POA::_duplicate(Poa))
{
	// Do other initialization stuff here
}

  
::BRUTUS::BRESULT BRUTUS_IMAPIProgress_i::Progress(CORBA::ULong ulValue,
						   CORBA::ULong ulCount,
						   CORBA::ULong ulTotal
						   ACE_ENV_ARG_DECL)
	ACE_THROW_SPEC((CORBA::SystemException))

{
	// Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}
  
::BRUTUS::BRESULT BRUTUS_IMAPIProgress_i::GetFlags(CORBA::ULong_out lpulFlags
						   ACE_ENV_ARG_DECL)
	ACE_THROW_SPEC((CORBA::SystemException))

{
	// Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}
  
::BRUTUS::BRESULT BRUTUS_IMAPIProgress_i::GetMax(CORBA::ULong_out lpulMax
						 ACE_ENV_ARG_DECL)
	ACE_THROW_SPEC((CORBA::SystemException))

{
	// Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}
  
::BRUTUS::BRESULT BRUTUS_IMAPIProgress_i::GetMin(CORBA::ULong_out lpulMin
						 ACE_ENV_ARG_DECL)
	ACE_THROW_SPEC((CORBA::SystemException))

{
	// Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}
  
::BRUTUS::BRESULT BRUTUS_IMAPIProgress_i::SetLimits(CORBA::ULong lpulMin,
						    CORBA::ULong lpulMax,
						    CORBA::ULong lpulFlags
						    ACE_ENV_ARG_DECL)
	ACE_THROW_SPEC((CORBA::SystemException))

{
	// Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}
  
::BRUTUS::BRESULT BRUTUS_IMAPIProgress_i::QueryInterface(const char * iid,
							 ::BRUTUS::IUnknown_out ppvObject
							 ACE_ENV_ARG_DECL)
        ACE_THROW_SPEC((CORBA::SystemException))
{
        ppvObject = ::BRUTUS::IUnknown::_nil();

	return ::BRUTUS::BRUTUS_MAPI_E_INTERFACE_NOT_SUPPORTED;
}

void BRUTUS_IMAPIProgress_i::Destroy(CORBA::ULong InstanceID
				     ACE_ENV_ARG_DECL)
	ACE_THROW_SPEC((CORBA::SystemException))

{
	PortableServer::ObjectId_var oid;
	oid = poa_->servant_to_id(this);

	poa_->deactivate_object(oid);
}
  
