/*
 * Brutus sample header file for the IMAPIProgress servant.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __IMAPIPROGRESSS_IMPL_H_
#define __IMAPIPROGRESSS_IMPL_H_

#include <idl_output/IMAPIProgressS.h>


#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

class  BRUTUS_IMAPIProgress_i : public virtual POA_BRUTUS::IMAPIProgress,
                                public virtual PortableServer::RefCountServantBase
{
public:
        BRUTUS_IMAPIProgress_i(PortableServer::POA_ptr Poa);

        virtual ~BRUTUS_IMAPIProgress_i(void)
                {
			// Do destructor stuff here
                };

  
        virtual ::BRUTUS::BRESULT Progress(CORBA::ULong ulValue,
					   CORBA::ULong ulCount,
					   CORBA::ULong ulTotal
					   ACE_ENV_ARG_DECL)
		ACE_THROW_SPEC((CORBA::SystemException));


	virtual ::BRUTUS::BRESULT GetFlags(CORBA::ULong_out lpulFlags
					   ACE_ENV_ARG_DECL)
		ACE_THROW_SPEC((CORBA::SystemException));


	virtual ::BRUTUS::BRESULT GetMax(CORBA::ULong_out lpulMax
					 ACE_ENV_ARG_DECL)
		ACE_THROW_SPEC((CORBA::SystemException));


	virtual ::BRUTUS::BRESULT GetMin(CORBA::ULong_out lpulMin
					 ACE_ENV_ARG_DECL)
		ACE_THROW_SPEC((CORBA::SystemException));


	virtual ::BRUTUS::BRESULT SetLimits(CORBA::ULong lpulMin,
					    CORBA::ULong lpulMax,
					    CORBA::ULong lpulFlags
					    ACE_ENV_ARG_DECL)
		ACE_THROW_SPEC((CORBA::SystemException));

  
        virtual ::BRUTUS::BRESULT QueryInterface(const char * iid,
                                                 ::BRUTUS::IUnknown_out ppvObject
                                                 ACE_ENV_ARG_DECL)
                ACE_THROW_SPEC((CORBA::SystemException));


        virtual void Destroy(CORBA::ULong InstanceID
                             ACE_ENV_ARG_DECL)
                ACE_THROW_SPEC ((CORBA::SystemException));
  

private: 
        BRUTUS_IMAPIProgress_i(void)
                { };

        PortableServer::POA_var poa_;
};

#endif /* __IMAPIPROGRESSS_IMPL_H_  */

/*
 * Local variables:
 * mode: C++
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 */
