/*
 * Brutus sample source file for the IUnknown and SRestriction servants.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * This file contains a sample implementation of ::BRUTUS::IUnknown:: and 
 * ::BRUTUS::SRestriction:: related servants. The shown implementation is 
 * just one way of doing it and in no way the required way. Design issues
 * regarding object lifetimes are especialy sensitive to your choices when
 * implementating the Destroy() methods.
 *
 * Please consider this implementation purely an educational suggestion.
 */


#include "typesS_impl.h"


// ******************************** //
// ***         IUnknown         *** //
// ******************************** //

// You don't really need to implement this object. All casting is
// done by narrow_() on the server side. This is how it could be 
// done anyway...
BRUTUS_IUnknown_i::BRUTUS_IUnknown_i(PortableServer::POA_ptr Poa)
        : poa_(PortableServer::POA::_duplicate(Poa))
{
	// Do other initialization stuff here
}
  
::BRUTUS::BRESULT BRUTUS_IUnknown_i::QueryInterface(const char * iid,
                                                    ::BRUTUS::IUnknown_out ppvObject
                                                    ACE_ENV_ARG_DECL)
        ACE_THROW_SPEC((CORBA::SystemException))
{
        ppvObject = ::BRUTUS::IUnknown::_nil();

	// Again.. is this what you want?
	return ::BRUTUS::BRUTUS_MAPI_E_INTERFACE_NOT_SUPPORTED;
}


// You really don't need to destroy the object here. The Destroy() stuff
// is only relevant on the Brutus server side due to state and resource
// cleanup. I am showing how to do it though, but you would probably
// want to manage the object lifetime yourself insterad of trusting the 
// server/client
void BRUTUS_IUnknown_i::Destroy(CORBA::ULong InstanceID
				ACE_ENV_ARG_DECL)
        ACE_THROW_SPEC((CORBA::SystemException))

{
        PortableServer::ObjectId_var oid;
        oid = poa_->servant_to_id(this);

        poa_->deactivate_object(oid);
}


// ********************************* //
// ***   SRestrictionContainer   *** //
// ********************************* //

// All objects within the SRestriction "Res" must be registered under "Poa"
// if Destroy() is going to work as designed. The design goal has been to 
// let SRestrictionContainer::Destroy() take care of etherealizing all
// embedded objects. You can choose to do it differently, but please 
// consider the mess that you will create if you have to keep track of all
// servants yourself.
//
// Individual SRestrictions should therefore never be etherealized after 
// they have been embedded into an SRestrictionContainer. The 
// SRestrictionContainer should etherealize all embedded servants.
//
// You must manage the lifetime of this servant yourself or implement
// functionality to let Destroy() do it for you, which is consistent with 
// the current implementation. It is a bug for a client to access a 
// Destroy()'ed object. You can catch this and throw an exception or just 
// silently ignore it (I'll leave that as an exercise).

BRUTUS_SRestrictionContainer_i::BRUTUS_SRestrictionContainer_i(::BRUTUS::SRestriction *Res,
							       PortableServer::POA_ptr Poa)
        : res_(Res), // takes ownership 
          poa_(Poa)  // takes ownership of content POA 
{
}
 
::BRUTUS::SRestriction * BRUTUS_SRestrictionContainer_i::content()
        ACE_THROW_SPEC((CORBA::SystemException))
{
        ::BRUTUS::SRestriction_var retval = res_;

        return retval._retn();
}

// You really don't need to destroy the object here. The Destroy() stuff
// is only relevant on the Brutus server side due to state and resource
// cleanup. I am showing how to do it though, but you would probably
// want to manage the object lifetime yourself.
void BRUTUS_SRestrictionContainer_i::Destroy()
        ACE_THROW_SPEC((CORBA::SystemException))

{
	// get the content POA manager
        PortableServer::POAManager_var poa_manager = poa_->the_POAManager();

        // makes sure that all content objects are closed from the world
        poa_manager->deactivate(0, 1);

        // initiate etheralize() by calling _remove_ref() on
        // all objects in the content poa.
        poa_->destroy(1, 0);
}


// ********************************* //
// ***    SRestriction types     *** //
// ********************************* //


BRUTUS_SAndRestriction_i::BRUTUS_SAndRestriction_i(::BRUTUS::seq_SRestriction *Res)
        : res_(Res) // takes ownership 
{
	// Do other initialization stuff here
}
    
::BRUTUS::seq_SRestriction * BRUTUS_SAndRestriction_i::lpRes()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        ::BRUTUS::seq_SRestriction_var retval = res_;

        return retval._retn();
}

 
BRUTUS_SOrRestriction_i::BRUTUS_SOrRestriction_i(::BRUTUS::seq_SRestriction *Res)
        : res_(Res) // takes ownership 
{
	// Do other initialization stuff here
}
    
::BRUTUS::seq_SRestriction * BRUTUS_SOrRestriction_i::lpRes()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        ::BRUTUS::seq_SRestriction_var retval = res_;

        return retval._retn();
}

  
BRUTUS_SNotRestriction_i::BRUTUS_SNotRestriction_i(::BRUTUS::SRestriction *Res,
						   CORBA::ULong Reserved)
        : res_(Res), // takes ownership
	  reserved_(Reserved) // Reserved must be zero
{
	// Do other initialization stuff here
}
    
CORBA::ULong BRUTUS_SNotRestriction_i::ulReserved()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return reserved_;
}
  
void BRUTUS_SNotRestriction_i::ulReserved(CORBA::ULong Reserved
                                          ACE_ENV_ARG_DECL)
        ACE_THROW_SPEC((CORBA::SystemException))

{
        reserved_ = Reserved;
}
  
::BRUTUS::SRestriction * BRUTUS_SNotRestriction_i::lpRes()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        ::BRUTUS::SRestriction_var retval = res_;

        return retval._retn();
}
  

BRUTUS_SContentRestriction_i::BRUTUS_SContentRestriction_i(::BRUTUS::FUZZY_TYPE FuzzyLevel,
							   CORBA::ULong PropTag,
							   ::BRUTUS::SPropValue *Prop)
        : fuzzyLevel_(FuzzyLevel),
	  ulPropTag_(PropTag),
	  pv_(Prop)
{
	// Do other initialization stuff here
}

::BRUTUS::FUZZY_TYPE BRUTUS_SContentRestriction_i::ulFuzzyLevel()
        ACE_THROW_SPEC((CORBA::SystemException))
{
        return fuzzyLevel_;
}

CORBA::ULong BRUTUS_SContentRestriction_i::ulPropTag()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return ulPropTag_;
}
  
::BRUTUS::SPropValue * BRUTUS_SContentRestriction_i::lpProp()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        ::BRUTUS::SPropValue_var retval = pv_;

        return retval._retn();
}
  
BRUTUS_SPropertyRestriction_i::BRUTUS_SPropertyRestriction_i(::BRUTUS::RELOP_TYPE Relop,
							     CORBA::ULong PropTag,
							     ::BRUTUS::SPropValue *Prop)
        : relop_(Relop),
	  prop_tag_(PropTag),
	  pv_(Prop)
{
	// Do other initialization stuff here
}
    
::BRUTUS::RELOP_TYPE BRUTUS_SPropertyRestriction_i::relop()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return relop_;
}

  
CORBA::ULong BRUTUS_SPropertyRestriction_i::ulPropTag()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return prop_tag_;
}

  
::BRUTUS::SPropValue * BRUTUS_SPropertyRestriction_i::lpProp()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        ::BRUTUS::SPropValue_var retval = pv_;

        return retval._retn();
}
  

BRUTUS_SComparePropsRestriction_i::BRUTUS_SComparePropsRestriction_i(::BRUTUS::RELOP_TYPE Relop,
								     CORBA::ULong PropTag1,
								     CORBA::ULong PropTag2)
        : relop_(Relop),
	  prop_tag1_(PropTag1),
	  prop_tag2_(PropTag2)
{
	// Do other initialization stuff here
}
    
::BRUTUS::RELOP_TYPE BRUTUS_SComparePropsRestriction_i::relop()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return relop_;
}
  
CORBA::ULong BRUTUS_SComparePropsRestriction_i::ulPropTag1()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return prop_tag1_;
}
  
CORBA::ULong BRUTUS_SComparePropsRestriction_i::ulPropTag2()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return prop_tag2_;
}

BRUTUS_SBitMaskRestriction_i::BRUTUS_SBitMaskRestriction_i(::BRUTUS::BMR_TYPE RelBmr,
							   CORBA::ULong PropTag,
							   CORBA::ULong Mask)
        : rel_bmr_(RelBmr),
	  prop_tag_(PropTag),
	  mask_(Mask)
{
	// Do other initialization stuff here
}
    
::BRUTUS::BMR_TYPE BRUTUS_SBitMaskRestriction_i::relBMR()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return rel_bmr_;
}
  
CORBA::ULong BRUTUS_SBitMaskRestriction_i::ulPropTag()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return prop_tag_;
}
  
CORBA::ULong BRUTUS_SBitMaskRestriction_i::ulMask()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return mask_;
}
  
BRUTUS_SSizeRestriction_i::BRUTUS_SSizeRestriction_i(::BRUTUS::RELOP_TYPE Relop,
						     CORBA::ULong PropTag,
						     CORBA::ULong CB)
        : relop_(Relop),
	  prop_tag_(PropTag),
	  cb_(CB)
{
	// Do other initialization stuff here
}
    
::BRUTUS::RELOP_TYPE BRUTUS_SSizeRestriction_i::relop()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return relop_;
}
  
CORBA::ULong BRUTUS_SSizeRestriction_i::ulPropTag()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return prop_tag_;
}
  
CORBA::ULong BRUTUS_SSizeRestriction_i::cb()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return cb_;
}

BRUTUS_SExistRestriction_i::BRUTUS_SExistRestriction_i(CORBA::ULong Reserved1,
						       CORBA::ULong PropTag,
						       CORBA::ULong Reserved2)
        : reserved1_(Reserved1), // Reserved1 must be zero
	  prop_tag_(PropTag),
	  reserved2_(Reserved2) // Reserved2 must be zero
{
	// Do other initialization stuff here
}
    
CORBA::ULong BRUTUS_SExistRestriction_i::ulReserved1()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return reserved1_;
}
  
void BRUTUS_SExistRestriction_i::ulReserved1(CORBA::ULong Reserved1
                                             ACE_ENV_ARG_DECL)
        ACE_THROW_SPEC((CORBA::SystemException))

{
        reserved1_ = Reserved1;
}
  
CORBA::ULong BRUTUS_SExistRestriction_i::ulPropTag()
        ACE_THROW_SPEC((CORBA::SystemException))

{
	return prop_tag_;
}
  
CORBA::ULong BRUTUS_SExistRestriction_i::ulReserved2()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        return reserved2_;
}
  
void BRUTUS_SExistRestriction_i::ulReserved2(CORBA::ULong Reserved2
                                             ACE_ENV_ARG_DECL)
        ACE_THROW_SPEC((CORBA::SystemException))

{
        reserved2_ = Reserved2;
}
  

BRUTUS_SSubRestriction_i::BRUTUS_SSubRestriction_i(CORBA::ULong SubObject,
						   ::BRUTUS::SRestriction *Res)
        : sub_obj_(SubObject),
	  res_(Res)
{
	// Do other initialization stuff here
}
    

::BRUTUS::BDEFINE BRUTUS_SSubRestriction_i::ulSubObject()
        ACE_THROW_SPEC((CORBA::SystemException))
{
        return sub_obj_;
}
  
::BRUTUS::SRestriction * BRUTUS_SSubRestriction_i::lpRes()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        ::BRUTUS::SRestriction_var retval = res_;

        return retval._retn();
}
  

BRUTUS_SCommentRestriction_i::BRUTUS_SCommentRestriction_i(::BRUTUS::SRestriction *Res,
							   ::BRUTUS::seq_SPropValue *Prop)
        : res_(Res),
	  seq_pv_(Prop)
{
	// Do other initialization stuff here
}
    
::BRUTUS::SRestriction * BRUTUS_SCommentRestriction_i::lpRes()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        ::BRUTUS::SRestriction_var retval = res_;

        return retval._retn();
}


::BRUTUS::seq_SPropValue * BRUTUS_SCommentRestriction_i::lpProp()
        ACE_THROW_SPEC((CORBA::SystemException))

{
        ::BRUTUS::seq_SPropValue_var retval = seq_pv_;

        return retval._retn();
}
  
