/*
 * Brutus sample header file for the IUnknown and SRestriction servants.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _TYPESS_IMPL_H_
#define _TYPESS_IMPL_H_

#include <idl_output/typesS.h>

#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */


class BRUTUS_IUnknown_i : public virtual POA_BRUTUS::IUnknown,
                          public virtual PortableServer::RefCountServantBase

{
public:

        BRUTUS_IUnknown_i(PortableServer::POA_ptr Poa);
  
        virtual ~BRUTUS_IUnknown_i(void)
                {
			// Do destructor stuff here
                };

        virtual ::BRUTUS::BRESULT QueryInterface(const char * iid,
                                                 ::BRUTUS::IUnknown_out ppvObject
                                                 ACE_ENV_ARG_DECL)
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual void Destroy(CORBA::ULong InstanceID
                             ACE_ENV_ARG_DECL)
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        // Skeleton constructor 
        BRUTUS_IUnknown_i(void)
                { };

        PortableServer::POA_var poa_;
};


class BRUTUS_SRestrictionContainer_i : public virtual POA_BRUTUS::SRestrictionContainer,
				       public virtual PortableServer::RefCountServantBase
{
public:
        BRUTUS_SRestrictionContainer_i(::BRUTUS::SRestriction *Res,
				       PortableServer::POA_ptr Poa);

        virtual ~BRUTUS_SRestrictionContainer_i(void)
                { 
                };
  
        virtual ::BRUTUS::SRestriction * content()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual void Destroy()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SRestrictionContainer_i(void)
                { };
  
        ::BRUTUS::SRestriction_var res_;
	PortableServer::POA_var poa_;
};


class BRUTUS_SAndRestriction_i : public virtual POA_BRUTUS::SAndRestriction,
                                 public virtual PortableServer::RefCountServantBase

{
public:
        BRUTUS_SAndRestriction_i(::BRUTUS::seq_SRestriction *Res);

        virtual ~BRUTUS_SAndRestriction_i(void)
                { 
                };

        virtual ::BRUTUS::seq_SRestriction * lpRes()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SAndRestriction_i(void)
                { };
  
        ::BRUTUS::seq_SRestriction_var res_;
};


class BRUTUS_SOrRestriction_i : public virtual POA_BRUTUS::SOrRestriction,
                                public virtual PortableServer::RefCountServantBase

{
public:
        BRUTUS_SOrRestriction_i(::BRUTUS::seq_SRestriction *Res);

        virtual ~BRUTUS_SOrRestriction_i(void)
                { 
                };

        virtual ::BRUTUS::seq_SRestriction * lpRes()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SOrRestriction_i (void)
                { };
  
        ::BRUTUS::seq_SRestriction_var res_;
};


class BRUTUS_SNotRestriction_i : public virtual POA_BRUTUS::SNotRestriction,
                                 public virtual PortableServer::RefCountServantBase

{
public:
        BRUTUS_SNotRestriction_i(::BRUTUS::SRestriction *Res,
				 CORBA::ULong Reserved);

        virtual ~BRUTUS_SNotRestriction_i (void)
                { 
                };

        virtual CORBA::ULong ulReserved()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual void ulReserved(CORBA::ULong Reserved
                                ACE_ENV_ARG_DECL)
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual ::BRUTUS::SRestriction * lpRes()
                ACE_THROW_SPEC((CORBA::SystemException));


private:
        BRUTUS_SNotRestriction_i(void)
                { };
  
        ::BRUTUS::SRestriction_var res_;
	CORBA::ULong reserved_;
};


class BRUTUS_SContentRestriction_i : public virtual POA_BRUTUS::SContentRestriction,
                                     public virtual PortableServer::RefCountServantBase

{
public:
        BRUTUS_SContentRestriction_i(::BRUTUS::FUZZY_TYPE FuzzyLevel,
                                     CORBA::ULong PropTag,
                                     ::BRUTUS::SPropValue *Prop);

        virtual ~BRUTUS_SContentRestriction_i(void)
                { 
                };

        virtual ::BRUTUS::FUZZY_TYPE ulFuzzyLevel()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong ulPropTag()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual ::BRUTUS::SPropValue * lpProp()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SContentRestriction_i(void)
                { };
  
	::BRUTUS::FUZZY_TYPE fuzzyLevel_;
	CORBA::ULong ulPropTag_;
	::BRUTUS::SPropValue_var pv_;
};


class BRUTUS_SPropertyRestriction_i : public virtual POA_BRUTUS::SPropertyRestriction,
                                      public virtual PortableServer::RefCountServantBase

{
public:
        BRUTUS_SPropertyRestriction_i(::BRUTUS::RELOP_TYPE Relop,
				      CORBA::ULong PropTag,
				      ::BRUTUS::SPropValue *Prop);

        virtual ~BRUTUS_SPropertyRestriction_i (void)
                { 
                };

        virtual ::BRUTUS::RELOP_TYPE relop()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong ulPropTag()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual ::BRUTUS::SPropValue * lpProp()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SPropertyRestriction_i (void)
                { };
  
	::BRUTUS::RELOP_TYPE relop_;
	CORBA::ULong prop_tag_;
	::BRUTUS::SPropValue_var pv_;
};


class BRUTUS_SComparePropsRestriction_i : public virtual POA_BRUTUS::SComparePropsRestriction,
                                          public virtual PortableServer::RefCountServantBase

{
public:
        BRUTUS_SComparePropsRestriction_i(::BRUTUS::RELOP_TYPE Relop,
					  CORBA::ULong PropTag1,
					  CORBA::ULong PropTag2);

        virtual ~BRUTUS_SComparePropsRestriction_i(void)
                { };

        virtual ::BRUTUS::RELOP_TYPE relop()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong ulPropTag1()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong ulPropTag2()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SComparePropsRestriction_i(void)
                { };
  
	::BRUTUS::RELOP_TYPE relop_;
	CORBA::ULong prop_tag1_;
	CORBA::ULong prop_tag2_;
};


class BRUTUS_SBitMaskRestriction_i : public virtual POA_BRUTUS::SBitMaskRestriction,
                                     public virtual PortableServer::RefCountServantBase
{
public:
        BRUTUS_SBitMaskRestriction_i(::BRUTUS::BMR_TYPE RelBmr,
				     CORBA::ULong PropTag,
				     CORBA::ULong Mask);

        virtual ~BRUTUS_SBitMaskRestriction_i(void)
                { };

        virtual ::BRUTUS::BMR_TYPE relBMR()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong ulPropTag()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong ulMask()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SBitMaskRestriction_i(void)
                { };
  
	::BRUTUS::BMR_TYPE rel_bmr_;
	CORBA::ULong prop_tag_;
	CORBA::ULong mask_;
};


class BRUTUS_SSizeRestriction_i : public virtual POA_BRUTUS::SSizeRestriction,
                                  public virtual PortableServer::RefCountServantBase
{
public:
        BRUTUS_SSizeRestriction_i(::BRUTUS::RELOP_TYPE Relop,
				  CORBA::ULong PropTag,
				  CORBA::ULong CB);

        virtual ~BRUTUS_SSizeRestriction_i (void)
                { };

        virtual ::BRUTUS::RELOP_TYPE relop()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong ulPropTag()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong cb()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SSizeRestriction_i (void)
                { };
  
	::BRUTUS::RELOP_TYPE relop_;
	CORBA::ULong prop_tag_;
	CORBA::ULong cb_;
};


class BRUTUS_SExistRestriction_i : public virtual POA_BRUTUS::SExistRestriction,
                                   public virtual PortableServer::RefCountServantBase
{
public:
        BRUTUS_SExistRestriction_i(CORBA::ULong Reserved1,
				   CORBA::ULong PropTag,
				   CORBA::ULong Reserved2);

        virtual ~BRUTUS_SExistRestriction_i(void)
                { };

        virtual CORBA::ULong ulReserved1()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual void ulReserved1(CORBA::ULong Reserved1
                                 ACE_ENV_ARG_DECL)
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong ulPropTag()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual CORBA::ULong ulReserved2()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual void ulReserved2(CORBA::ULong Reserved2
                                 ACE_ENV_ARG_DECL)
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SExistRestriction_i (void)
                { };
  
	CORBA::ULong reserved1_;
	CORBA::ULong prop_tag_;
	CORBA::ULong reserved2_;
};


class BRUTUS_SSubRestriction_i : public virtual POA_BRUTUS::SSubRestriction,
                                 public virtual PortableServer::RefCountServantBase
{
public:
        BRUTUS_SSubRestriction_i(CORBA::ULong SubObject,
				 ::BRUTUS::SRestriction *Res);

        virtual ~BRUTUS_SSubRestriction_i(void)
                { 
                };

        virtual ::BRUTUS::BDEFINE ulSubObject()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual ::BRUTUS::SRestriction * lpRes()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SSubRestriction_i(void)
                { };
  
	CORBA::ULong sub_obj_;
        ::BRUTUS::SRestriction_var res_;
};


class BRUTUS_SCommentRestriction_i : public virtual POA_BRUTUS::SCommentRestriction,
                                     public virtual PortableServer::RefCountServantBase
{
public:
        BRUTUS_SCommentRestriction_i(::BRUTUS::SRestriction *Res,
				     ::BRUTUS::seq_SPropValue *Prop);

        virtual ~BRUTUS_SCommentRestriction_i(void)
                { 
                };

        virtual ::BRUTUS::SRestriction * lpRes()
                ACE_THROW_SPEC((CORBA::SystemException));

        virtual ::BRUTUS::seq_SPropValue * lpProp()
                ACE_THROW_SPEC((CORBA::SystemException));

private:
        BRUTUS_SCommentRestriction_i(void)
                { };

	::BRUTUS::SRestriction_var res_;
	::BRUTUS::seq_SPropValue_var seq_pv_;
};

#endif //_TYPESS_IMPL_H_

/*
 * Local variables:
 * mode: C++
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 */
