/*
 * Brutus source file for implementing a value to string helper function.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#include "bresult.h"

const char *bresult_to_str(const BRUTUS_BRESULT code)
{
	switch (code) {
	case BRUTUS_BRUTUS_INTERNAL_ERROR :
		return "BRUTUS_INTERNAL_ERROR";
	case BRUTUS_BRUTUS_UNKNOWN_ERROR :
		return "BRUTUS_UNKNOWN_ERROR";
	case BRUTUS_BRUTUS_NO_MAPI_SESSION :
		return "BRUTUS_NO_MAPI_SESSION";
	case BRUTUS_BRUTUS_EXCEPTION_FROM_CLIENT :
		return "BRUTUS_EXCEPTION_FROM_CLIENT";
	case BRUTUS_BRUTUS_LIFELINE_TIMEOUT :
		return "BRUTUS_LIFELINE_TIMEOUT";
	case BRUTUS_BRUTUS_S_OK :
		return "BRUTUS_S_OK";
	case BRUTUS_BRUTUS_MAPI_E_CALL_FAILED :
		return "BRUTUS_MAPI_E_CALL_FAILED";
	case BRUTUS_BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY :
		return "BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY";
	case BRUTUS_BRUTUS_MAPI_E_INVALID_PARAMETER :
		return "BRUTUS_MAPI_E_INVALID_PARAMETER";
	case BRUTUS_BRUTUS_MAPI_E_INTERFACE_NOT_SUPPORTED :
		return "BRUTUS_MAPI_E_INTERFACE_NOT_SUPPORTED";
	case BRUTUS_BRUTUS_MAPI_E_NO_ACCESS :
		return "BRUTUS_MAPI_E_NO_ACCESS";
	case BRUTUS_BRUTUS_MAPI_E_NO_SUPPORT :
		return "BRUTUS_MAPI_E_NO_SUPPORT";
	case BRUTUS_BRUTUS_MAPI_E_BAD_CHARWIDTH :
		return "BRUTUS_MAPI_E_BAD_CHARWIDTH";
	case BRUTUS_BRUTUS_MAPI_E_STRING_TOO_LONG :
		return "BRUTUS_MAPI_E_STRING_TOO_LONG";
	case BRUTUS_BRUTUS_MAPI_E_UNKNOWN_FLAGS :
		return "BRUTUS_MAPI_E_UNKNOWN_FLAGS";
	case BRUTUS_BRUTUS_MAPI_E_INVALID_ENTRYID :
		return "BRUTUS_MAPI_E_INVALID_ENTRYID";
	case BRUTUS_BRUTUS_MAPI_E_INVALID_OBJECT :
		return "BRUTUS_MAPI_E_INVALID_OBJECT";
	case BRUTUS_BRUTUS_MAPI_E_OBJECT_CHANGED :
		return "BRUTUS_MAPI_E_OBJECT_CHANGED";
	case BRUTUS_BRUTUS_MAPI_E_OBJECT_DELETED :
		return "BRUTUS_MAPI_E_OBJECT_DELETED";
	case BRUTUS_BRUTUS_MAPI_E_BUSY :
		return "BRUTUS_MAPI_E_BUSY";
	case BRUTUS_BRUTUS_MAPI_E_NOT_ENOUGH_DISK :
		return "BRUTUS_MAPI_E_NOT_ENOUGH_DISK";
	case BRUTUS_BRUTUS_MAPI_E_NOT_ENOUGH_RESOURCES :
		return "BRUTUS_MAPI_E_NOT_ENOUGH_RESOURCES";
	case BRUTUS_BRUTUS_MAPI_E_NOT_FOUND :
		return "BRUTUS_MAPI_E_NOT_FOUND";
	case BRUTUS_BRUTUS_MAPI_E_VERSION :
		return "BRUTUS_MAPI_E_VERSION";
	case BRUTUS_BRUTUS_MAPI_E_LOGON_FAILED :
		return "BRUTUS_MAPI_E_LOGON_FAILED";
	case BRUTUS_BRUTUS_MAPI_E_SESSION_LIMIT :
		return "BRUTUS_MAPI_E_SESSION_LIMIT";
	case BRUTUS_BRUTUS_MAPI_E_USER_CANCEL :
		return "BRUTUS_MAPI_E_USER_CANCEL";
	case BRUTUS_BRUTUS_MAPI_E_UNABLE_TO_ABORT :
		return "BRUTUS_MAPI_E_UNABLE_TO_ABORT";
	case BRUTUS_BRUTUS_MAPI_E_NETWORK_ERROR :
		return "BRUTUS_MAPI_E_NETWORK_ERROR";
	case BRUTUS_BRUTUS_MAPI_E_DISK_ERROR :
		return "BRUTUS_MAPI_E_DISK_ERROR";
	case BRUTUS_BRUTUS_MAPI_E_TOO_COMPLEX :
		return "BRUTUS_MAPI_E_TOO_COMPLEX";
	case BRUTUS_BRUTUS_MAPI_E_BAD_COLUMN :
		return "BRUTUS_MAPI_E_BAD_COLUMN";
	case BRUTUS_BRUTUS_MAPI_E_EXTENDED_ERROR :
		return "BRUTUS_MAPI_E_EXTENDED_ERROR";
	case BRUTUS_BRUTUS_MAPI_E_COMPUTED :
		return "BRUTUS_MAPI_E_COMPUTED";
	case BRUTUS_BRUTUS_MAPI_E_CORRUPT_DATA :
		return "BRUTUS_MAPI_E_CORRUPT_DATA";
	case BRUTUS_BRUTUS_MAPI_E_UNCONFIGURED :
		return "BRUTUS_MAPI_E_UNCONFIGURED";
	case BRUTUS_BRUTUS_MAPI_E_FAILONEPROVIDER :
		return "BRUTUS_MAPI_E_FAILONEPROVIDER";
	case BRUTUS_BRUTUS_MAPI_E_UNKNOWN_CPID :
		return "BRUTUS_MAPI_E_UNKNOWN_CPID";
	case BRUTUS_BRUTUS_MAPI_E_UNKNOWN_LCID :
		return "BRUTUS_MAPI_E_UNKNOWN_LCID";
	case BRUTUS_BRUTUS_MAPI_E_PASSWORD_CHANGE_REQUIRED :
		return "BRUTUS_MAPI_E_PASSWORD_CHANGE_REQUIRED";
	case BRUTUS_BRUTUS_MAPI_E_PASSWORD_EXPIRED :
		return "BRUTUS_MAPI_E_PASSWORD_EXPIRED";
	case BRUTUS_BRUTUS_MAPI_E_INVALID_WORKSTATION_ACCOUNT :
		return "BRUTUS_MAPI_E_INVALID_WORKSTATION_ACCOUNT";
	case BRUTUS_BRUTUS_MAPI_E_INVALID_ACCESS_TIME :
		return "BRUTUS_MAPI_E_INVALID_ACCESS_TIME";
	case BRUTUS_BRUTUS_MAPI_E_ACCOUNT_DISABLED :
		return "BRUTUS_MAPI_E_ACCOUNT_DISABLED";
	case BRUTUS_BRUTUS_MAPI_E_END_OF_SESSION :
		return "BRUTUS_MAPI_E_END_OF_SESSION";
	case BRUTUS_BRUTUS_MAPI_E_UNKNOWN_ENTRYID :
		return "BRUTUS_MAPI_E_UNKNOWN_ENTRYID";
	case BRUTUS_BRUTUS_MAPI_E_MISSING_REQUIRED_COLUMN :
		return "BRUTUS_MAPI_E_MISSING_REQUIRED_COLUMN";
	case BRUTUS_BRUTUS_MAPI_W_NO_SERVICE :
		return "BRUTUS_MAPI_W_NO_SERVICE";
	case BRUTUS_BRUTUS_MAPI_E_BAD_VALUE :
		return "BRUTUS_MAPI_E_BAD_VALUE";
	case BRUTUS_BRUTUS_MAPI_E_INVALID_TYPE :
		return "BRUTUS_MAPI_E_INVALID_TYPE";
	case BRUTUS_BRUTUS_MAPI_E_TYPE_NO_SUPPORT :
		return "BRUTUS_MAPI_E_TYPE_NO_SUPPORT";
	case BRUTUS_BRUTUS_MAPI_E_UNEXPECTED_TYPE :
		return "BRUTUS_MAPI_E_UNEXPECTED_TYPE";
	case BRUTUS_BRUTUS_MAPI_E_TOO_BIG :
		return "BRUTUS_MAPI_E_TOO_BIG";
	case BRUTUS_BRUTUS_MAPI_E_DECLINE_COPY :
		return "BRUTUS_MAPI_E_DECLINE_COPY";
	case BRUTUS_BRUTUS_MAPI_E_UNEXPECTED_ID :
		return "BRUTUS_MAPI_E_UNEXPECTED_ID";
	case BRUTUS_BRUTUS_MAPI_W_ERRORS_RETURNED :
		return "BRUTUS_MAPI_W_ERRORS_RETURNED";
	case BRUTUS_BRUTUS_MAPI_E_UNABLE_TO_COMPLETE :
		return "BRUTUS_MAPI_E_UNABLE_TO_COMPLETE";
	case BRUTUS_BRUTUS_MAPI_E_TIMEOUT :
		return "BRUTUS_MAPI_E_TIMEOUT";
	case BRUTUS_BRUTUS_MAPI_E_TABLE_EMPTY :
		return "BRUTUS_MAPI_E_TABLE_EMPTY";
	case BRUTUS_BRUTUS_MAPI_E_TABLE_TOO_BIG :
		return "BRUTUS_MAPI_E_TABLE_TOO_BIG";
	case BRUTUS_BRUTUS_MAPI_E_INVALID_BOOKMARK :
		return "BRUTUS_MAPI_E_INVALID_BOOKMARK";
	case BRUTUS_BRUTUS_MAPI_W_POSITION_CHANGED :
		return "BRUTUS_MAPI_W_POSITION_CHANGED";
	case BRUTUS_BRUTUS_MAPI_W_APPROX_COUNT :
		return "BRUTUS_MAPI_W_APPROX_COUNT";
	case BRUTUS_BRUTUS_MAPI_E_WAIT :
		return "BRUTUS_MAPI_E_WAIT";
	case BRUTUS_BRUTUS_MAPI_E_CANCEL :
		return "BRUTUS_MAPI_E_CANCEL";
	case BRUTUS_BRUTUS_MAPI_E_NOT_ME :
		return "BRUTUS_MAPI_E_NOT_ME";
	case BRUTUS_BRUTUS_MAPI_W_CANCEL_MESSAGE :
		return "BRUTUS_MAPI_W_CANCEL_MESSAGE";
	case BRUTUS_BRUTUS_MAPI_E_CORRUPT_STORE :
		return "BRUTUS_MAPI_E_CORRUPT_STORE";
	case BRUTUS_BRUTUS_MAPI_E_NOT_IN_QUEUE :
		return "BRUTUS_MAPI_E_NOT_IN_QUEUE";
	case BRUTUS_BRUTUS_MAPI_E_NO_SUPPRESS :
		return "BRUTUS_MAPI_E_NO_SUPPRESS";
	case BRUTUS_BRUTUS_MAPI_E_COLLISION :
		return "BRUTUS_MAPI_E_COLLISION";
	case BRUTUS_BRUTUS_MAPI_E_NOT_INITIALIZED :
		return "BRUTUS_MAPI_E_NOT_INITIALIZED";
	case BRUTUS_BRUTUS_MAPI_E_NON_STANDARD :
		return "BRUTUS_MAPI_E_NON_STANDARD";
	case BRUTUS_BRUTUS_MAPI_E_NO_RECIPIENTS :
		return "BRUTUS_MAPI_E_NO_RECIPIENTS";
	case BRUTUS_BRUTUS_MAPI_E_SUBMITTED :
		return "BRUTUS_MAPI_E_SUBMITTED";
	case BRUTUS_BRUTUS_MAPI_E_HAS_FOLDERS :
		return "BRUTUS_MAPI_E_HAS_FOLDERS";
	case BRUTUS_BRUTUS_MAPI_E_HAS_MESSAGES :
		return "BRUTUS_MAPI_E_HAS_MESSAGES";
	case BRUTUS_BRUTUS_MAPI_E_FOLDER_CYCLE :
		return "BRUTUS_MAPI_E_FOLDER_CYCLE";
	case BRUTUS_BRUTUS_MAPI_W_PARTIAL_COMPLETION :
		return "BRUTUS_MAPI_W_PARTIAL_COMPLETION";
	case BRUTUS_BRUTUS_MAPI_E_AMBIGUOUS_RECIP :
		return "BRUTUS_MAPI_E_AMBIGUOUS_RECIP";
	case BRUTUS_BRUTUS_OLEOBJ_S_CANNOT_DOVERB_NOW :
		return "BRUTUS_OLEOBJ_S_CANNOT_DOVERB_NOW";
	case BRUTUS_BRUTUS_STG_E_INVALIDFUNCTION :
		return "BRUTUS_STG_E_INVALIDFUNCTION";
	case BRUTUS_BRUTUS_STG_E_FILENOTFOUND :
		return "BRUTUS_STG_E_FILENOTFOUND";
	case BRUTUS_BRUTUS_STG_E_PATHNOTFOUND :
		return "BRUTUS_STG_E_PATHNOTFOUND";
	case BRUTUS_BRUTUS_STG_E_TOOMANYOPENFILES :
		return "BRUTUS_STG_E_TOOMANYOPENFILES";
	case BRUTUS_BRUTUS_STG_E_ACCESSDENIED :
		return "BRUTUS_STG_E_ACCESSDENIED";
	case BRUTUS_BRUTUS_STG_E_INVALIDHANDLE :
		return "BRUTUS_STG_E_INVALIDHANDLE";
	case BRUTUS_BRUTUS_STG_E_INSUFFICIENTMEMORY :
		return "BRUTUS_STG_E_INSUFFICIENTMEMORY";
	case BRUTUS_BRUTUS_STG_E_INVALIDPOINTER :
		return "BRUTUS_STG_E_INVALIDPOINTER";
	case BRUTUS_BRUTUS_STG_E_NOMOREFILES :
		return "BRUTUS_STG_E_NOMOREFILES";
	case BRUTUS_BRUTUS_STG_E_DISKISWRITEPROTECTED :
		return "BRUTUS_STG_E_DISKISWRITEPROTECTED";
	case BRUTUS_BRUTUS_STG_E_SEEKERROR :
		return "BRUTUS_STG_E_SEEKERROR";
	case BRUTUS_BRUTUS_STG_E_WRITEFAULT :
		return "BRUTUS_STG_E_WRITEFAULT";
	case BRUTUS_BRUTUS_STG_E_READFAULT :
		return "BRUTUS_STG_E_READFAULT";
	case BRUTUS_BRUTUS_STG_E_SHAREVIOLATION :
		return "BRUTUS_STG_E_SHAREVIOLATION";
	case BRUTUS_BRUTUS_STG_E_LOCKVIOLATION :
		return "BRUTUS_STG_E_LOCKVIOLATION";
	case BRUTUS_BRUTUS_STG_E_FILEALREADYEXISTS :
		return "BRUTUS_STG_E_FILEALREADYEXISTS";
	case BRUTUS_BRUTUS_STG_E_INVALIDPARAMETER :
		return "BRUTUS_STG_E_INVALIDPARAMETER";
	case BRUTUS_BRUTUS_STG_E_MEDIUMFULL :
		return "BRUTUS_STG_E_MEDIUMFULL";
	case BRUTUS_BRUTUS_STG_E_PROPSETMISMATCHED :
		return "BRUTUS_STG_E_PROPSETMISMATCHED";
	case BRUTUS_BRUTUS_STG_E_ABNORMALAPIEXIT :
		return "BRUTUS_STG_E_ABNORMALAPIEXIT";
	case BRUTUS_BRUTUS_STG_E_INVALIDHEADER :
		return "BRUTUS_STG_E_INVALIDHEADER";
	case BRUTUS_BRUTUS_STG_E_INVALIDNAME :
		return "BRUTUS_STG_E_INVALIDNAME";
	case BRUTUS_BRUTUS_STG_E_UNKNOWN :
		return "BRUTUS_STG_E_UNKNOWN";
	case BRUTUS_BRUTUS_STG_E_UNIMPLEMENTEDFUNCTION :
		return "BRUTUS_STG_E_UNIMPLEMENTEDFUNCTION";
	case BRUTUS_BRUTUS_STG_E_INVALIDFLAG :
		return "BRUTUS_STG_E_INVALIDFLAG";
	case BRUTUS_BRUTUS_STG_E_INUSE :
		return "BRUTUS_STG_E_INUSE";
	case BRUTUS_BRUTUS_STG_E_NOTCURRENT :
		return "BRUTUS_STG_E_NOTCURRENT";
	case BRUTUS_BRUTUS_STG_E_REVERTED :
		return "BRUTUS_STG_E_REVERTED";
	case BRUTUS_BRUTUS_STG_E_CANTSAVE :
		return "BRUTUS_STG_E_CANTSAVE";
	case BRUTUS_BRUTUS_STG_E_OLDFORMAT :
		return "BRUTUS_STG_E_OLDFORMAT";
	case BRUTUS_BRUTUS_STG_E_OLDDLL :
		return "BRUTUS_STG_E_OLDDLL";
	case BRUTUS_BRUTUS_STG_E_SHAREREQUIRED :
		return "BRUTUS_STG_E_SHAREREQUIRED";
	case BRUTUS_BRUTUS_STG_E_NOTFILEBASEDSTORAGE :
		return "BRUTUS_STG_E_NOTFILEBASEDSTORAGE";
	case BRUTUS_BRUTUS_STG_E_EXTANTMARSHALLINGS :
		return "BRUTUS_STG_E_EXTANTMARSHALLINGS";
	case BRUTUS_BRUTUS_STG_E_DOCFILECORRUPT :
		return "BRUTUS_STG_E_DOCFILECORRUPT";
	case BRUTUS_BRUTUS_STG_E_BADBASEADDRESS :
		return "BRUTUS_STG_E_BADBASEADDRESS";
	case BRUTUS_BRUTUS_STG_E_INCOMPLETE :
		return "BRUTUS_STG_E_INCOMPLETE";
	case BRUTUS_BRUTUS_STG_E_TERMINATED :
		return "BRUTUS_STG_E_TERMINATED";
	case BRUTUS_BRUTUS_STG_S_CONVERTED :
		return "BRUTUS_STG_S_CONVERTED";
	case BRUTUS_BRUTUS_STG_S_BLOCK :
		return "BRUTUS_STG_S_BLOCK";
	case BRUTUS_BRUTUS_STG_S_RETRYNOW :
		return "BRUTUS_STG_S_RETRYNOW";
	case BRUTUS_BRUTUS_STG_S_MONITORING :
		return "BRUTUS_STG_S_MONITORING";
	case BRUTUS_BRUTUS_STG_S_MULTIPLEOPENS :
		return "BRUTUS_STG_S_MULTIPLEOPENS";
	case BRUTUS_BRUTUS_STG_S_CONSOLIDATIONFAILED :
		return "BRUTUS_STG_S_CONSOLIDATIONFAILED";
	case BRUTUS_BRUTUS_STG_S_CANNOTCONSOLIDATE :
		return "BRUTUS_STG_S_CANNOTCONSOLIDATE";
	case BRUTUS_BRUTUS_E_PENDING :
		return "BRUTUS_E_PENDING";
	case BRUTUS_BRUTUS_SYNC_E_OBJECT_DELETED :
		return "BRUTUS_SYNC_E_OBJECT_DELETED";
	case BRUTUS_BRUTUS_SYNC_E_IGNORE :
		return "BRUTUS_SYNC_E_IGNORE";
	case BRUTUS_BRUTUS_SYNC_E_CONFLICT :
		return "BRUTUS_SYNC_E_CONFLICT";
	case BRUTUS_BRUTUS_SYNC_E_NO_PARENT :
		return "BRUTUS_SYNC_E_NO_PARENT";
	case BRUTUS_BRUTUS_SYNC_E_INCEST :
		return "BRUTUS_SYNC_E_INCEST";
	case BRUTUS_BRUTUS_SYNC_E_UNSYNCHRONIZED :
		return "BRUTUS_SYNC_E_UNSYNCHRONIZED";
	case BRUTUS_BRUTUS_SYNC_W_PROGRESS :
		return "BRUTUS_SYNC_W_PROGRESS";
	case BRUTUS_BRUTUS_SYNC_W_CLIENT_CHANGE_NEWER :
		return "BRUTUS_SYNC_W_CLIENT_CHANGE_NEWER";
	case BRUTUS_BRUTUS_EC_EDK_E_FAIL :
		return "BRUTUS_EC_EDK_E_FAIL";
	case BRUTUS_BRUTUS_EC_EDK_E_OUTOFMEMORY :
		return "BRUTUS_EC_EDK_E_OUTOFMEMORY";
	case BRUTUS_BRUTUS_EC_EDK_E_INVALIDARG :
		return "BRUTUS_EC_EDK_E_INVALIDARG";
	case BRUTUS_BRUTUS_EC_EDK_E_NOTIMPL :
		return "BRUTUS_EC_EDK_E_NOTIMPL";
	case BRUTUS_BRUTUS_EC_EDK_E_NOINTERFACE :
		return "BRUTUS_EC_EDK_E_NOINTERFACE";
	case BRUTUS_BRUTUS_EC_EDK_E_ACCESSDENIED :
		return "BRUTUS_EC_EDK_E_ACCESSDENIED";
	case BRUTUS_BRUTUS_EC_EDK_E_UNKNOWN :
		return "BRUTUS_EC_EDK_E_UNKNOWN";
	case BRUTUS_BRUTUS_EC_EDK_E_NOT_FOUND :
		return "BRUTUS_EC_EDK_E_NOT_FOUND";
	case BRUTUS_BRUTUS_EDK_E_NOT_FOUND :
		return "BRUTUS_EDK_E_NOT_FOUND";
	case BRUTUS_BRUTUS_EC_EDK_E_SHUTDOWN_SERVICE :
		return "BRUTUS_EC_EDK_E_SHUTDOWN_SERVICE";
	case BRUTUS_BRUTUS_EDK_E_SHUTDOWN_SERVICE :
		return "BRUTUS_EDK_E_SHUTDOWN_SERVICE";
	case BRUTUS_BRUTUS_EC_EDK_E_ALREADY_EXISTS :
		return "BRUTUS_EC_EDK_E_ALREADY_EXISTS";
	case BRUTUS_BRUTUS_EDK_E_ALREADY_EXISTS :
		return "BRUTUS_EDK_E_ALREADY_EXISTS";
	case BRUTUS_BRUTUS_EC_EDK_E_END_OF_FILE :
		return "BRUTUS_EC_EDK_E_END_OF_FILE";
	case BRUTUS_BRUTUS_EDK_E_END_OF_FILE :
		return "BRUTUS_EDK_E_END_OF_FILE";
	case BRUTUS_BRUTUS_EC_EDK_E_AMBIGUOUS :
		return "BRUTUS_EC_EDK_E_AMBIGUOUS";
	case BRUTUS_BRUTUS_EDK_E_AMBIGUOUS :
		return "BRUTUS_EDK_E_AMBIGUOUS";
	case BRUTUS_BRUTUS_EC_EDK_E_PARSE :
		return "BRUTUS_EC_EDK_E_PARSE";
	case BRUTUS_BRUTUS_EDK_E_PARSE :
		return "BRUTUS_EDK_E_PARSE";
	default :
		return "ERROR: Unknown BRESULT";
	}

	return NULL;
}
