/*
 * Brutus header file for Brutus test/sample macros.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _BRUTUS_MACROS_H_
#define _BRUTUS_MACROS_H_

#include <glib/gmacros.h>
#include <stdio.h>

#undef ORBIT2_EX
#define ORBIT2_EX(_ev_) ((NULL != _ev_) && ((_ev_)->_major != CORBA_NO_EXCEPTION)) 

#undef ORBIT2_PRINT_EX
#define ORBIT2_PRINT_EX(_str_, _ev_) \
        G_STMT_START {                                                              \
		switch ((_ev_)->_major) {                                           \
		case CORBA_NO_EXCEPTION :                                           \
			g_message(_str_ "No exception.\n");                         \
			break;                                                      \
		case CORBA_USER_EXCEPTION :                                         \
			g_message(_str_ "%s@l%d: User Exception : %s\n",            \
                                  __FILE__, __LINE__, CORBA_exception_id ((_ev_))); \
			break;                                                      \
		case CORBA_SYSTEM_EXCEPTION :                                       \
			g_message(_str_ "%s@l%d: System Exception : %s\n",          \
                                  __FILE__, __LINE__, CORBA_exception_id ((_ev_))); \
			break;                                                      \
		default :                                                           \
			break;                                                      \
		}                                                                   \
	} G_STMT_END;

#endif // _BRUTUS_MACROS_H_
