/*
 * Brutus header file for Brutus test/sample utility functions.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _BRUTUS_UTILS_H_
#define _BRUTUS_UTILS_H_

#include <idl_output/types.h>
#include <idl_output/return_codes.h>
#include <idl_output/IMAPITable.h>
#include <idl_output/IMAPIProp.h>
#include <idl_output/IMAPISession.h>
#include <idl_output/IMsgStore.h>
#include <idl_output/IMAPIFolder.h>


extern PortableServer_POA get_root_poa(const CORBA_ORB Orb,
				       CORBA_Environment *ev);

extern PortableServer_POA create_poa(const char *Name,
				     PortableServer_POAManager PoaManager,
				     PortableServer_POA ParentPOA,
				     CORBA_Environment *ev);

/*
 * Converts a binary BLOB to a BRUTUS_ENTRYID
 */
extern void sbinary_to_entryid(BRUTUS_SBinary *Bin,
			       BRUTUS_ENTRYID **Eid);

/*
 * Will write a stringified version of the value to stdout
 */
extern void print_spropvalue(BRUTUS_SPropValue *PropValue);


/*
 * This is the Brutus equivalent of HrQueryAllRows()
 */
extern BRUTUS_BRESULT BrQueryAllRows(BRUTUS_IMAPITable ptable,
				     BRUTUS_SPropTagArray *ptags,
				     BRUTUS_SRestrictionContainer pres,
				     BRUTUS_SSortOrderSet *psort,
				     CORBA_long crowsMax,
				     BRUTUS_SRowSet **pprows,
				     CORBA_Environment *ev);

/*
 * This is the Brutus equivalent of HrGetOneProp()
 */
extern BRUTUS_BRESULT BrGetOneProp(BRUTUS_IMAPIProp MapiProp,
				   BRUTUS_BDEFINE PropTag,
				   BRUTUS_SPropValue **PropValue,
				   CORBA_Environment *ev);

/*
 * MsgStore is a reference to the default message store
 * upon return or CORBA_OBJECT_NIL
 */
extern BRUTUS_BRESULT get_default_message_store(BRUTUS_IMAPISession Session,
						PortableServer_POA ParentPoa,
						BRUTUS_IMsgStore *MsgStore,
						CORBA_Environment *ev);

/*
 * RootFolder is a reference to the root folder in MsgStore
 * upon return or NIL
 */
extern BRUTUS_BRESULT get_root_folder(BRUTUS_IMsgStore MsgStore,
				      BRUTUS_IMAPIFolder *RootFolder,
				      CORBA_Environment *ev);

/*
 * MsgStore is normally the default message store for the profile.
 * Folder is a reference to the requested Outlook specific folder
 * upon return or NIL. Currently predefined tags are:
 *
 *   BRUTUS_BRUTUS_PR_OUTLOOK_CALENDAR
 *   BRUTUS_BRUTUS_PR_OUTLOOK_CONTACTS
 *   BRUTUS_BRUTUS_PR_OUTLOOK_JOURNAL
 *   BRUTUS_BRUTUS_PR_OUTLOOK_NOTES
 *   BRUTUS_BRUTUS_PR_OUTLOOK_TASKS
 *   BRUTUS_BRUTUS_PR_OUTLOOK_REMINDERS
 *   BRUTUS_BRUTUS_PR_OUTLOOK_DRAFTS
 *
 * These tags are at the least valid for the default message store.
 */
extern BRUTUS_BRESULT get_outlook_folder(BRUTUS_IMsgStore MsgStore,
					 BRUTUS_BDEFINE PropTag,
					 BRUTUS_IMAPIFolder *Folder,
					 CORBA_Environment *ev);

/*
 * Will list the value of the ListBy property tag for all objects
 * that are returned when GetContentsTable() are invoked on Container.
 */
extern BRUTUS_BRESULT list_container(BRUTUS_IMAPIContainer Folder,
				     BRUTUS_BDEFINE ListBy,
				     CORBA_Environment *ev);

/*
 * Will print all columns for the given row.
 */
extern BRUTUS_BRESULT dump_contentstable_row(BRUTUS_IMAPIContainer Container,
					     unsigned int row,
					     CORBA_Environment *ev);

/*
 * Will dump the content of the container for all objects
 * that are returned when GetContentsTable() are invoked 
 * on Container as well as the properties of the container 
 * itself.
 */
extern BRUTUS_BRESULT dump_container(BRUTUS_IMAPIContainer Container,
				     CORBA_ORB orb,
				     CORBA_Environment *ev);

/*
 * Will list the value of all properties for the object on stdout
 */
extern BRUTUS_BRESULT print_properties(BRUTUS_IMAPIProp PropObject,
				       CORBA_Environment *ev);

/*
 * Will print a summary of the recurrence pattern for 
 * objects in the calendar folder.
 */
extern BRUTUS_BRESULT summarize_calendar_recurrences(BRUTUS_IMsgStore MsgStore,
						     CORBA_Environment *ev);
/*
 * Will print a recurence state structure
 */
extern BRUTUS_BRESULT print_recurrence_state(BRUTUS_RecurrenceState *state);


#endif // _BRUTUS_UTILS_H_


