/*
 * Brutus header file for configuration file helper functions.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _CONFIG_H_
#define _CONFIG_H_

#include <stdlib.h>


struct Config {
	// public - must be initiated by user
	const char *config_file;
	const char *stack_token;

	// private - do not touch
	int _lnum;
	char *_fbuf;
	size_t _fsize;
	struct item {
		char *token;
		char *value;
	} *_items;
};
	
/* Will load the configuration file specified in cfg. Returns
 * zero on success or a positive number which indicates a 
 * faulty configuration line or a negative number which
 * indicates that the configuration file is to big or can not 
 * be read for some reason or another. */
extern int init_config(struct Config *cfg);


/* Free all private elements. Callee controls the lifetime of 
 * the public elements. */
extern void free_config(struct Config *cfg);


/* Will return the corresponding value string or NULL if 
 * non-existent. Makes multible like-named options are possible
 * if stak_token are non-NULL. get_value() will sequentially 
 * read them all when repeatedly invoked. 
 *
 * The return value must be freed by callee. */
extern char *get_config_value(const char *token,
			      struct Config *cfg);

#endif // _CONFIG_H_
