/*
 * Brutus source file for implementing property tag to string helper functions.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


#include "proptag.h"

const char *proptype_to_str(BRUTUS_PT_TYPE PropType)
{
	// Property types
	switch (PropType) {
	case BRUTUS_BRUTUS_PT_UNSPECIFIED :
		return "BRUTUS_PT_UNSPECIFIED";
	case BRUTUS_BRUTUS_PT_NULL :
		return "BRUTUS_PT_NULL";
	case BRUTUS_BRUTUS_PT_SHORT :
		return "BRUTUS_PT_SHORT";
	case BRUTUS_BRUTUS_PT_USHORT :
		return "BRUTUS_PT_USHORT";
	case BRUTUS_BRUTUS_PT_LONG :
		return "BRUTUS_PT_LONG";
	case BRUTUS_BRUTUS_PT_ULONG :
		return "BRUTUS_PT_ULONG";
	case BRUTUS_BRUTUS_PT_FLOAT :
		return "BRUTUS_PT_FLOAT";
	case BRUTUS_BRUTUS_PT_DOUBLE :
		return "BRUTUS_PT_DOUBLE";
	case BRUTUS_BRUTUS_PT_BOOLEAN :
		return "BRUTUS_PT_BOOLEAN";
	case BRUTUS_BRUTUS_PT_CURRENCY :
		return "BRUTUS_PT_CURRENCY";
	case BRUTUS_BRUTUS_PT_APPTIME :
		return "BRUTUS_PT_APPTIME";
	case BRUTUS_BRUTUS_PT_SYSTIME :
		return "BRUTUS_PT_SYSTIME";
	case BRUTUS_BRUTUS_PT_STRING8 :
		return "BRUTUS_PT_STRING8";
	case BRUTUS_BRUTUS_PT_BINARY :
		return "BRUTUS_PT_BINARY";
	case BRUTUS_BRUTUS_PT_UNICODE :
		return "BRUTUS_PT_UNICODE";
	case BRUTUS_BRUTUS_PT_CLSID :
		return "BRUTUS_PT_CLSID";
	case BRUTUS_BRUTUS_PT_LONGLONG :
		return "BRUTUS_PT_LONGLONG";
	case BRUTUS_BRUTUS_PT_MV_SHORT :
		return "BRUTUS_PT_MV_SHORT";
	case BRUTUS_BRUTUS_PT_MV_LONG :
		return "BRUTUS_PT_MV_LONG";
	case BRUTUS_BRUTUS_PT_MV_FLOAT :
		return "BRUTUS_PT_MV_FLOAT";
	case BRUTUS_BRUTUS_PT_MV_DOUBLE :
		return "BRUTUS_PT_MV_DOUBLE";
	case BRUTUS_BRUTUS_PT_MV_CURRENCY :
		return "BRUTUS_PT_MV_CURRENCY";
	case BRUTUS_BRUTUS_PT_MV_APPTIME :
		return "BRUTUS_PT_MV_APPTIME";
	case BRUTUS_BRUTUS_PT_MV_SYSTIME :
		return "BRUTUS_PT_MV_SYSTIME";
	case BRUTUS_BRUTUS_PT_MV_BINARY :
		return "BRUTUS_PT_MV_BINARY";
	case BRUTUS_BRUTUS_PT_MV_STRING8 :
		return "BRUTUS_PT_MV_STRING8";
	case BRUTUS_BRUTUS_PT_MV_UNICODE :
		return "BRUTUS_PT_MV_UNICODE";
	case BRUTUS_BRUTUS_PT_MV_CLSID :
		return "BRUTUS_PT_MV_CLSID";
	case BRUTUS_BRUTUS_PT_MV_LONGLONG :
		return "BRUTUS_PT_MV_LONGLONG";
	case BRUTUS_BRUTUS_PT_MVI_SHORT :
		return "BRUTUS_PT_MVI_SHORT";
	case BRUTUS_BRUTUS_PT_MVI_LONG :
		return "BRUTUS_PT_MVI_LONG";
	case BRUTUS_BRUTUS_PT_MVI_FLOAT :
		return "BRUTUS_PT_MVI_FLOAT";
	case BRUTUS_BRUTUS_PT_MVI_DOUBLE :
		return "BRUTUS_PT_MVI_DOUBLE";
	case BRUTUS_BRUTUS_PT_MVI_CURRENCY :
		return "BRUTUS_PT_MVI_CURRENCY";
	case BRUTUS_BRUTUS_PT_MVI_APPTIME :
		return "BRUTUS_PT_MVI_APPTIME";
	case BRUTUS_BRUTUS_PT_MVI_SYSTIME :
		return "BRUTUS_PT_MVI_SYSTIME";
	case BRUTUS_BRUTUS_PT_MVI_BINARY :
		return "BRUTUS_PT_MVI_BINARY";
	case BRUTUS_BRUTUS_PT_MVI_STRING8 :
		return "BRUTUS_PT_MVI_STRING8";
	case BRUTUS_BRUTUS_PT_MVI_UNICODE :
		return "BRUTUS_PT_MVI_UNICODE";
	case BRUTUS_BRUTUS_PT_MVI_CLSID :
		return "BRUTUS_PT_MVI_CLSID";
	case BRUTUS_BRUTUS_PT_MVI_LONGLONG :
		return "BRUTUS_PT_MVI_LONGLONG";
	case BRUTUS_BRUTUS_PT_ERROR :
		return "BRUTUS_PT_ERROR";
	case BRUTUS_BRUTUS_PT_OBJECT :
		return "BRUTUS_PT_OBJECT";
	default :
		return "ERROR: unknown property type";
	};
}

/* Duplicate values has been commented out */
const char *proptag_to_str(BRUTUS_BDEFINE PropTag)
{
	// Property tags
	switch (PropTag) {
	case BRUTUS_BRUTUS_PR_ACKNOWLEDGEMENT_MODE :
		return "BRUTUS_PR_ACKNOWLEDGEMENT_MODE";
	case BRUTUS_BRUTUS_PR_ALTERNATE_RECIPIENT_ALLOWED :
		return "BRUTUS_PR_ALTERNATE_RECIPIENT_ALLOWED";
	case BRUTUS_BRUTUS_PR_AUTHORIZING_USERS :
		return "BRUTUS_PR_AUTHORIZING_USERS";
	case BRUTUS_BRUTUS_PR_AUTO_FORWARD_COMMENT :
		return "BRUTUS_PR_AUTO_FORWARD_COMMENT / BRUTUS_PR_AUTO_FORWARD_COMMENT_A";
	case BRUTUS_BRUTUS_PR_AUTO_FORWARD_COMMENT_W :
		return "BRUTUS_PR_AUTO_FORWARD_COMMENT_W";
	case BRUTUS_BRUTUS_PR_AUTO_FORWARDED :
		return "BRUTUS_PR_AUTO_FORWARDED";
	case BRUTUS_BRUTUS_PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID :
		return "BRUTUS_PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID";
	case BRUTUS_BRUTUS_PR_CONTENT_CORRELATOR :
		return "BRUTUS_PR_CONTENT_CORRELATOR";
	case BRUTUS_BRUTUS_PR_CONTENT_IDENTIFIER :
		return "BRUTUS_PR_CONTENT_IDENTIFIER / BRUTUS_PR_CONTENT_IDENTIFIER_A";
	case BRUTUS_BRUTUS_PR_CONTENT_IDENTIFIER_W :
		return "BRUTUS_PR_CONTENT_IDENTIFIER_W";
/*	case BRUTUS_BRUTUS_PR_CONTENT_IDENTIFIER_A : */
/*		return "BRUTUS_PR_CONTENT_IDENTIFIER_A"; */
	case BRUTUS_BRUTUS_PR_CONTENT_LENGTH :
		return "BRUTUS_PR_CONTENT_LENGTH";
	case BRUTUS_BRUTUS_PR_CONTENT_RETURN_REQUESTED :
		return "BRUTUS_PR_CONTENT_RETURN_REQUESTED";
	case BRUTUS_BRUTUS_PR_CONVERSATION_KEY :
		return "BRUTUS_PR_CONVERSATION_KEY";
	case BRUTUS_BRUTUS_PR_CONVERSION_EITS :
		return "BRUTUS_PR_CONVERSION_EITS";
	case BRUTUS_BRUTUS_PR_CONVERSION_WITH_LOSS_PROHIBITED :
		return "BRUTUS_PR_CONVERSION_WITH_LOSS_PROHIBITED";
	case BRUTUS_BRUTUS_PR_CONVERTED_EITS :
		return "BRUTUS_PR_CONVERTED_EITS";
	case BRUTUS_BRUTUS_PR_DEFERRED_DELIVERY_TIME :
		return "BRUTUS_PR_DEFERRED_DELIVERY_TIME";
	case BRUTUS_BRUTUS_PR_DELIVER_TIME :
		return "BRUTUS_PR_DELIVER_TIME";
	case BRUTUS_BRUTUS_PR_DISCARD_REASON :
		return "BRUTUS_PR_DISCARD_REASON";
	case BRUTUS_BRUTUS_PR_DISCLOSURE_OF_RECIPIENTS :
		return "BRUTUS_PR_DISCLOSURE_OF_RECIPIENTS";
	case BRUTUS_BRUTUS_PR_DL_EXPANSION_HISTORY :
		return "BRUTUS_PR_DL_EXPANSION_HISTORY";
	case BRUTUS_BRUTUS_PR_DL_EXPANSION_PROHIBITED :
		return "BRUTUS_PR_DL_EXPANSION_PROHIBITED";
	case BRUTUS_BRUTUS_PR_EXPIRY_TIME :
		return "BRUTUS_PR_EXPIRY_TIME";
	case BRUTUS_BRUTUS_PR_IMPLICIT_CONVERSION_PROHIBITED :
		return "BRUTUS_PR_IMPLICIT_CONVERSION_PROHIBITED";
	case BRUTUS_BRUTUS_PR_IMPORTANCE :
		return "BRUTUS_PR_IMPORTANCE";
	case BRUTUS_BRUTUS_PR_IPM_ID :
		return "BRUTUS_PR_IPM_ID";
	case BRUTUS_BRUTUS_PR_LATEST_DELIVERY_TIME :
		return "BRUTUS_PR_LATEST_DELIVERY_TIME";
	case BRUTUS_BRUTUS_PR_MESSAGE_CLASS :
		return "BRUTUS_PR_MESSAGE_CLASS / BRUTUS_PR_MESSAGE_CLASS_A";
	case BRUTUS_BRUTUS_PR_MESSAGE_CLASS_W :
		return "BRUTUS_PR_MESSAGE_CLASS_W";
/*	case BRUTUS_BRUTUS_PR_MESSAGE_CLASS_A : */
/*		return "BRUTUS_PR_MESSAGE_CLASS_A"; */
	case BRUTUS_BRUTUS_PR_MESSAGE_DELIVERY_ID :
		return "BRUTUS_PR_MESSAGE_DELIVERY_ID";
	case BRUTUS_BRUTUS_PR_MESSAGE_SECURITY_LABEL :
		return "BRUTUS_PR_MESSAGE_SECURITY_LABEL";
	case BRUTUS_BRUTUS_PR_OBSOLETED_IPMS :
		return "BRUTUS_PR_OBSOLETED_IPMS";
	case BRUTUS_BRUTUS_PR_ORIGINALLY_INTENDED_RECIPIENT_NAME :
		return "BRUTUS_PR_ORIGINALLY_INTENDED_RECIPIENT_NAME";
	case BRUTUS_BRUTUS_PR_ORIGINAL_EITS :
		return "BRUTUS_PR_ORIGINAL_EITS";
	case BRUTUS_BRUTUS_PR_ORIGINATOR_CERTIFICATE :
		return "BRUTUS_PR_ORIGINATOR_CERTIFICATE";
	case BRUTUS_BRUTUS_PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED :
		return "BRUTUS_PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED";
	case BRUTUS_BRUTUS_PR_ORIGINATOR_RETURN_ADDRESS :
		return "BRUTUS_PR_ORIGINATOR_RETURN_ADDRESS";
	case BRUTUS_BRUTUS_PR_PARENT_KEY :
		return "BRUTUS_PR_PARENT_KEY";
	case BRUTUS_BRUTUS_PR_PRIORITY :
		return "BRUTUS_PR_PRIORITY";
	case BRUTUS_BRUTUS_PR_ORIGIN_CHECK :
		return "BRUTUS_PR_ORIGIN_CHECK";
	case BRUTUS_BRUTUS_PR_PROOF_OF_SUBMISSION_REQUESTED :
		return "BRUTUS_PR_PROOF_OF_SUBMISSION_REQUESTED";
	case BRUTUS_BRUTUS_PR_READ_RECEIPT_REQUESTED :
		return "BRUTUS_PR_READ_RECEIPT_REQUESTED";
	case BRUTUS_BRUTUS_PR_RECEIPT_TIME :
		return "BRUTUS_PR_RECEIPT_TIME";
	case BRUTUS_BRUTUS_PR_RECIPIENT_REASSIGNMENT_PROHIBITED :
		return "BRUTUS_PR_RECIPIENT_REASSIGNMENT_PROHIBITED";
	case BRUTUS_BRUTUS_PR_REDIRECTION_HISTORY :
		return "BRUTUS_PR_REDIRECTION_HISTORY";
	case BRUTUS_BRUTUS_PR_RELATED_IPMS :
		return "BRUTUS_PR_RELATED_IPMS";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENSITIVITY :
		return "BRUTUS_PR_ORIGINAL_SENSITIVITY";
	case BRUTUS_BRUTUS_PR_LANGUAGES :
		return "BRUTUS_PR_LANGUAGES / BRUTUS_PR_LANGUAGES_A";
	case BRUTUS_BRUTUS_PR_LANGUAGES_W :
		return "BRUTUS_PR_LANGUAGES_W";
/*	case BRUTUS_BRUTUS_PR_LANGUAGES_A : */
/*		return "BRUTUS_PR_LANGUAGES_A"; */
	case BRUTUS_BRUTUS_PR_REPLY_TIME :
		return "BRUTUS_PR_REPLY_TIME";
	case BRUTUS_BRUTUS_PR_REPORT_TAG :
		return "BRUTUS_PR_REPORT_TAG";
	case BRUTUS_BRUTUS_PR_REPORT_TIME :
		return "BRUTUS_PR_REPORT_TIME";
	case BRUTUS_BRUTUS_PR_RETURNED_IPM :
		return "BRUTUS_PR_RETURNED_IPM";
	case BRUTUS_BRUTUS_PR_SECURITY :
		return "BRUTUS_PR_SECURITY";
	case BRUTUS_BRUTUS_PR_INCOMPLETE_COPY :
		return "BRUTUS_PR_INCOMPLETE_COPY";
	case BRUTUS_BRUTUS_PR_SENSITIVITY :
		return "BRUTUS_PR_SENSITIVITY";
	case BRUTUS_BRUTUS_PR_SUBJECT :
		return "BRUTUS_PR_SUBJECT / BRUTUS_PR_SUBJECT_A";
	case BRUTUS_BRUTUS_PR_SUBJECT_W :
		return "BRUTUS_PR_SUBJECT_W";
/*	case BRUTUS_BRUTUS_PR_SUBJECT_A : */
/*		return "BRUTUS_PR_SUBJECT_A"; */
	case BRUTUS_BRUTUS_PR_SUBJECT_IPM :
		return "BRUTUS_PR_SUBJECT_IPM";
	case BRUTUS_BRUTUS_PR_CLIENT_SUBMIT_TIME :
		return "BRUTUS_PR_CLIENT_SUBMIT_TIME";
	case BRUTUS_BRUTUS_PR_REPORT_NAME :
		return "BRUTUS_PR_REPORT_NAME / BRUTUS_PR_REPORT_NAME_A";
	case BRUTUS_BRUTUS_PR_REPORT_NAME_W :
		return "BRUTUS_PR_REPORT_NAME_W";
/*	case BRUTUS_BRUTUS_PR_REPORT_NAME_A : */
/*		return "BRUTUS_PR_REPORT_NAME_A"; */
	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_SEARCH_KEY :
		return "BRUTUS_PR_SENT_REPRESENTING_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_X400_CONTENT_TYPE :
		return "BRUTUS_PR_X400_CONTENT_TYPE";
	case BRUTUS_BRUTUS_PR_SUBJECT_PREFIX :
		return "BRUTUS_PR_SUBJECT_PREFIX / BRUTUS_PR_SUBJECT_PREFIX_A";
	case BRUTUS_BRUTUS_PR_SUBJECT_PREFIX_W :
		return "BRUTUS_PR_SUBJECT_PREFIX_W";
/*	case BRUTUS_BRUTUS_PR_SUBJECT_PREFIX_A : */
/*		return "BRUTUS_PR_SUBJECT_PREFIX_A"; */
	case BRUTUS_BRUTUS_PR_NON_RECEIPT_REASON :
		return "BRUTUS_PR_NON_RECEIPT_REASON";
	case BRUTUS_BRUTUS_PR_RECEIVED_BY_ENTRYID :
		return "BRUTUS_PR_RECEIVED_BY_ENTRYID";
	case BRUTUS_BRUTUS_PR_RECEIVED_BY_NAME :
		return "BRUTUS_PR_RECEIVED_BY_NAME / BRUTUS_PR_RECEIVED_BY_NAME_A";
	case BRUTUS_BRUTUS_PR_RECEIVED_BY_NAME_W :
		return "BRUTUS_PR_RECEIVED_BY_NAME_W";
/*	case BRUTUS_BRUTUS_PR_RECEIVED_BY_NAME_A : */
/*		return "BRUTUS_PR_RECEIVED_BY_NAME_A"; */
	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_ENTRYID :
		return "BRUTUS_PR_SENT_REPRESENTING_ENTRYID";
	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_NAME :
		return "BRUTUS_PR_SENT_REPRESENTING_NAME / BRUTUS_PR_SENT_REPRESENTING_NAME_A";
	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_NAME_W :
		return "BRUTUS_PR_SENT_REPRESENTING_NAME_W";
/*	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_NAME_A : */
/*		return "BRUTUS_PR_SENT_REPRESENTING_NAME_A"; */
	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_ENTRYID :
		return "BRUTUS_PR_RCVD_REPRESENTING_ENTRYID";
	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_NAME :
		return "BRUTUS_PR_RCVD_REPRESENTING_NAME / BRUTUS_PR_RCVD_REPRESENTING_NAME_A";
	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_NAME_W :
		return "BRUTUS_PR_RCVD_REPRESENTING_NAME_W";
/*	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_NAME_A : */
/*		return "BRUTUS_PR_RCVD_REPRESENTING_NAME_A"; */
	case BRUTUS_BRUTUS_PR_REPORT_ENTRYID :
		return "BRUTUS_PR_REPORT_ENTRYID";
	case BRUTUS_BRUTUS_PR_READ_RECEIPT_ENTRYID :
		return "BRUTUS_PR_READ_RECEIPT_ENTRYID";
	case BRUTUS_BRUTUS_PR_MESSAGE_SUBMISSION_ID :
		return "BRUTUS_PR_MESSAGE_SUBMISSION_ID";
	case BRUTUS_BRUTUS_PR_PROVIDER_SUBMIT_TIME :
		return "BRUTUS_PR_PROVIDER_SUBMIT_TIME";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SUBJECT :
		return "BRUTUS_PR_ORIGINAL_SUBJECT / BRUTUS_PR_ORIGINAL_SUBJECT_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SUBJECT_W :
		return "BRUTUS_PR_ORIGINAL_SUBJECT_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_SUBJECT_A : */
/*		return "BRUTUS_PR_ORIGINAL_SUBJECT_A"; */
	case BRUTUS_BRUTUS_PR_DISC_VAL :
		return "BRUTUS_PR_DISC_VAL";
	case BRUTUS_BRUTUS_PR_ORIG_MESSAGE_CLASS :
		return "BRUTUS_PR_ORIG_MESSAGE_CLASS / BRUTUS_PR_ORIG_MESSAGE_CLASS_A";
	case BRUTUS_BRUTUS_PR_ORIG_MESSAGE_CLASS_W :
		return "BRUTUS_PR_ORIG_MESSAGE_CLASS_W";
/*	case BRUTUS_BRUTUS_PR_ORIG_MESSAGE_CLASS_A : */
/*		return "BRUTUS_PR_ORIG_MESSAGE_CLASS_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_ENTRYID :
		return "BRUTUS_PR_ORIGINAL_AUTHOR_ENTRYID";
	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_NAME :
		return "BRUTUS_PR_ORIGINAL_AUTHOR_NAME / BRUTUS_PR_ORIGINAL_AUTHOR_NAME_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_NAME_W :
		return "BRUTUS_PR_ORIGINAL_AUTHOR_NAME_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_NAME_A : */
/*		return "BRUTUS_PR_ORIGINAL_AUTHOR_NAME_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_SUBMIT_TIME :
		return "BRUTUS_PR_ORIGINAL_SUBMIT_TIME";
	case BRUTUS_BRUTUS_PR_REPLY_RECIPIENT_ENTRIES :
		return "BRUTUS_PR_REPLY_RECIPIENT_ENTRIES";
	case BRUTUS_BRUTUS_PR_REPLY_RECIPIENT_NAMES :
		return "BRUTUS_PR_REPLY_RECIPIENT_NAMES / BRUTUS_PR_REPLY_RECIPIENT_NAMES_A";
	case BRUTUS_BRUTUS_PR_REPLY_RECIPIENT_NAMES_W :
		return "BRUTUS_PR_REPLY_RECIPIENT_NAMES_W";
/*	case BRUTUS_BRUTUS_PR_REPLY_RECIPIENT_NAMES_A : */
/*		return "BRUTUS_PR_REPLY_RECIPIENT_NAMES_A"; */
	case BRUTUS_BRUTUS_PR_RECEIVED_BY_SEARCH_KEY :
		return "BRUTUS_PR_RECEIVED_BY_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_SEARCH_KEY :
		return "BRUTUS_PR_RCVD_REPRESENTING_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_READ_RECEIPT_SEARCH_KEY :
		return "BRUTUS_PR_READ_RECEIPT_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_REPORT_SEARCH_KEY :
		return "BRUTUS_PR_REPORT_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_ORIGINAL_DELIVERY_TIME :
		return "BRUTUS_PR_ORIGINAL_DELIVERY_TIME";
	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_SEARCH_KEY :
		return "BRUTUS_PR_ORIGINAL_AUTHOR_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_MESSAGE_TO_ME :
		return "BRUTUS_PR_MESSAGE_TO_ME";
	case BRUTUS_BRUTUS_PR_MESSAGE_CC_ME :
		return "BRUTUS_PR_MESSAGE_CC_ME";
	case BRUTUS_BRUTUS_PR_MESSAGE_RECIP_ME :
		return "BRUTUS_PR_MESSAGE_RECIP_ME";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_NAME :
		return "BRUTUS_PR_ORIGINAL_SENDER_NAME / BRUTUS_PR_ORIGINAL_SENDER_NAME_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_NAME_W :
		return "BRUTUS_PR_ORIGINAL_SENDER_NAME_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_NAME_A : */
/*		return "BRUTUS_PR_ORIGINAL_SENDER_NAME_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_ENTRYID :
		return "BRUTUS_PR_ORIGINAL_SENDER_ENTRYID";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_SEARCH_KEY :
		return "BRUTUS_PR_ORIGINAL_SENDER_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME :
		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME / BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME_W :
		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME_A : */
/*		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_NAME_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ENTRYID :
		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ENTRYID";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY :
		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_START_DATE :
		return "BRUTUS_PR_START_DATE";
	case BRUTUS_BRUTUS_PR_END_DATE :
		return "BRUTUS_PR_END_DATE";
	case BRUTUS_BRUTUS_PR_OWNER_APPT_ID :
		return "BRUTUS_PR_OWNER_APPT_ID";
	case BRUTUS_BRUTUS_PR_RESPONSE_REQUESTED :
		return "BRUTUS_PR_RESPONSE_REQUESTED";
	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE :
		return "BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE / BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE_A";
	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE_W :
		return "BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE_W";
/*	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE_A : */
/*		return "BRUTUS_PR_SENT_REPRESENTING_ADDRTYPE_A"; */
	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS :
		return "BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS / BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS_W :
		return "BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS_A : */
/*		return "BRUTUS_PR_SENT_REPRESENTING_EMAIL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE :
		return "BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE / BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE_W :
		return "BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE_A : */
/*		return "BRUTUS_PR_ORIGINAL_SENDER_ADDRTYPE_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS :
		return "BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS / BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS_W :
		return "BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A : */
/*		return "BRUTUS_PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE :
		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE / BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_W :
		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A : */
/*		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS :
		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS / BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_W :
		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A : */
/*		return "BRUTUS_PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_CONVERSATION_TOPIC :
		return "BRUTUS_PR_CONVERSATION_TOPIC / BRUTUS_PR_CONVERSATION_TOPIC_A";
	case BRUTUS_BRUTUS_PR_CONVERSATION_TOPIC_W :
		return "BRUTUS_PR_CONVERSATION_TOPIC_W";
/*	case BRUTUS_BRUTUS_PR_CONVERSATION_TOPIC_A : */
/*		return "BRUTUS_PR_CONVERSATION_TOPIC_A"; */
	case BRUTUS_BRUTUS_PR_CONVERSATION_INDEX :
		return "BRUTUS_PR_CONVERSATION_INDEX";
	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_BCC :
		return "BRUTUS_PR_ORIGINAL_DISPLAY_BCC / BRUTUS_PR_ORIGINAL_DISPLAY_BCC_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_BCC_W :
		return "BRUTUS_PR_ORIGINAL_DISPLAY_BCC_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_BCC_A : */
/*		return "BRUTUS_PR_ORIGINAL_DISPLAY_BCC_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_CC :
		return "BRUTUS_PR_ORIGINAL_DISPLAY_CC / BRUTUS_PR_ORIGINAL_DISPLAY_CC_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_CC_W :
		return "BRUTUS_PR_ORIGINAL_DISPLAY_CC_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_CC_A : */
/*		return "BRUTUS_PR_ORIGINAL_DISPLAY_CC_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_TO :
		return "BRUTUS_PR_ORIGINAL_DISPLAY_TO / BRUTUS_PR_ORIGINAL_DISPLAY_TO_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_TO_W :
		return "BRUTUS_PR_ORIGINAL_DISPLAY_TO_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_TO_A : */
/*		return "BRUTUS_PR_ORIGINAL_DISPLAY_TO_A"; */
	case BRUTUS_BRUTUS_PR_RECEIVED_BY_ADDRTYPE :
		return "BRUTUS_PR_RECEIVED_BY_ADDRTYPE / BRUTUS_PR_RECEIVED_BY_ADDRTYPE_A";
	case BRUTUS_BRUTUS_PR_RECEIVED_BY_ADDRTYPE_W :
		return "BRUTUS_PR_RECEIVED_BY_ADDRTYPE_W";
/*	case BRUTUS_BRUTUS_PR_RECEIVED_BY_ADDRTYPE_A : */
/*		return "BRUTUS_PR_RECEIVED_BY_ADDRTYPE_A"; */
	case BRUTUS_BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS :
		return "BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS / BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS_W :
		return "BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS_A : */
/*		return "BRUTUS_PR_RECEIVED_BY_EMAIL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE :
		return "BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE / BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE_A";
	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE_W :
		return "BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE_W";
/*	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE_A : */
/*		return "BRUTUS_PR_RCVD_REPRESENTING_ADDRTYPE_A"; */
	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS :
		return "BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS / BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS_W :
		return "BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A : */
/*		return "BRUTUS_PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE :
		return "BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE / BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE_W :
		return "BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE_A : */
/*		return "BRUTUS_PR_ORIGINAL_AUTHOR_ADDRTYPE_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS :
		return "BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS / BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_W :
		return "BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A : */
/*		return "BRUTUS_PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE :
		return "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE / BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A";
	case BRUTUS_BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_W :
		return "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A : */
/*		return "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS :
		return "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS / BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_W :
		return "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A : */
/*		return "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS :
		return "BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS / BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS_A";
	case BRUTUS_BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS_W :
		return "BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS_W";
/*	case BRUTUS_BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS_A : */
/*		return "BRUTUS_PR_TRANSPORT_MESSAGE_HEADERS_A"; */
	case BRUTUS_BRUTUS_PR_DELEGATION :
		return "BRUTUS_PR_DELEGATION";
	case BRUTUS_BRUTUS_PR_TNEF_CORRELATION_KEY :
		return "BRUTUS_PR_TNEF_CORRELATION_KEY";
	case BRUTUS_BRUTUS_PR_BODY :
		return "BRUTUS_PR_BODY / BRUTUS_PR_BODY_A";
	case BRUTUS_BRUTUS_PR_BODY_W :
		return "BRUTUS_PR_BODY_W";
/*	case BRUTUS_BRUTUS_PR_BODY_A : */
/*		return "BRUTUS_PR_BODY_A"; */
	case BRUTUS_BRUTUS_PR_REPORT_TEXT :
		return "BRUTUS_PR_REPORT_TEXT / BRUTUS_PR_REPORT_TEXT_A";
	case BRUTUS_BRUTUS_PR_REPORT_TEXT_W :
		return "BRUTUS_PR_REPORT_TEXT_W";
/*	case BRUTUS_BRUTUS_PR_REPORT_TEXT_A : */
/*		return "BRUTUS_PR_REPORT_TEXT_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY :
		return "BRUTUS_PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY";
	case BRUTUS_BRUTUS_PR_REPORTING_DL_NAME :
		return "BRUTUS_PR_REPORTING_DL_NAME";
	case BRUTUS_BRUTUS_PR_REPORTING_MTA_CERTIFICATE :
		return "BRUTUS_PR_REPORTING_MTA_CERTIFICATE";
	case BRUTUS_BRUTUS_PR_RTF_SYNC_BODY_CRC :
		return "BRUTUS_PR_RTF_SYNC_BODY_CRC";
	case BRUTUS_BRUTUS_PR_RTF_SYNC_BODY_COUNT :
		return "BRUTUS_PR_RTF_SYNC_BODY_COUNT";
	case BRUTUS_BRUTUS_PR_RTF_SYNC_BODY_TAG :
		return "BRUTUS_PR_RTF_SYNC_BODY_TAG / BRUTUS_PR_RTF_SYNC_BODY_TAG_A";
	case BRUTUS_BRUTUS_PR_RTF_SYNC_BODY_TAG_W :
		return "BRUTUS_PR_RTF_SYNC_BODY_TAG_W";
/*	case BRUTUS_BRUTUS_PR_RTF_SYNC_BODY_TAG_A : */
/*		return "BRUTUS_PR_RTF_SYNC_BODY_TAG_A"; */
	case BRUTUS_BRUTUS_PR_RTF_COMPRESSED :
		return "BRUTUS_PR_RTF_COMPRESSED";
	case BRUTUS_BRUTUS_PR_RTF_SYNC_PREFIX_COUNT :
		return "BRUTUS_PR_RTF_SYNC_PREFIX_COUNT";
	case BRUTUS_BRUTUS_PR_RTF_SYNC_TRAILING_COUNT :
		return "BRUTUS_PR_RTF_SYNC_TRAILING_COUNT";
	case BRUTUS_BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ENTRYID :
		return "BRUTUS_PR_ORIGINALLY_INTENDED_RECIP_ENTRYID";
	case BRUTUS_BRUTUS_PR_CONTENT_INTEGRITY_CHECK :
		return "BRUTUS_PR_CONTENT_INTEGRITY_CHECK";
	case BRUTUS_BRUTUS_PR_EXPLICIT_CONVERSION :
		return "BRUTUS_PR_EXPLICIT_CONVERSION";
	case BRUTUS_BRUTUS_PR_IPM_RETURN_REQUESTED :
		return "BRUTUS_PR_IPM_RETURN_REQUESTED";
	case BRUTUS_BRUTUS_PR_MESSAGE_TOKEN :
		return "BRUTUS_PR_MESSAGE_TOKEN";
	case BRUTUS_BRUTUS_PR_NDR_REASON_CODE :
		return "BRUTUS_PR_NDR_REASON_CODE";
	case BRUTUS_BRUTUS_PR_NDR_DIAG_CODE :
		return "BRUTUS_PR_NDR_DIAG_CODE";
	case BRUTUS_BRUTUS_PR_NON_RECEIPT_NOTIFICATION_REQUESTED :
		return "BRUTUS_PR_NON_RECEIPT_NOTIFICATION_REQUESTED";
	case BRUTUS_BRUTUS_PR_DELIVERY_POINT :
		return "BRUTUS_PR_DELIVERY_POINT";
	case BRUTUS_BRUTUS_PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED :
		return "BRUTUS_PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED";
	case BRUTUS_BRUTUS_PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT :
		return "BRUTUS_PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT";
	case BRUTUS_BRUTUS_PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY :
		return "BRUTUS_PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY";
	case BRUTUS_BRUTUS_PR_PHYSICAL_DELIVERY_MODE :
		return "BRUTUS_PR_PHYSICAL_DELIVERY_MODE";
	case BRUTUS_BRUTUS_PR_PHYSICAL_DELIVERY_REPORT_REQUEST :
		return "BRUTUS_PR_PHYSICAL_DELIVERY_REPORT_REQUEST";
	case BRUTUS_BRUTUS_PR_PHYSICAL_FORWARDING_ADDRESS :
		return "BRUTUS_PR_PHYSICAL_FORWARDING_ADDRESS";
	case BRUTUS_BRUTUS_PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED :
		return "BRUTUS_PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED";
	case BRUTUS_BRUTUS_PR_PHYSICAL_FORWARDING_PROHIBITED :
		return "BRUTUS_PR_PHYSICAL_FORWARDING_PROHIBITED";
	case BRUTUS_BRUTUS_PR_PHYSICAL_RENDITION_ATTRIBUTES :
		return "BRUTUS_PR_PHYSICAL_RENDITION_ATTRIBUTES";
	case BRUTUS_BRUTUS_PR_PROOF_OF_DELIVERY :
		return "BRUTUS_PR_PROOF_OF_DELIVERY";
	case BRUTUS_BRUTUS_PR_PROOF_OF_DELIVERY_REQUESTED :
		return "BRUTUS_PR_PROOF_OF_DELIVERY_REQUESTED";
	case BRUTUS_BRUTUS_PR_RECIPIENT_CERTIFICATE :
		return "BRUTUS_PR_RECIPIENT_CERTIFICATE";
	case BRUTUS_BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE :
		return "BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE / BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE_A";
	case BRUTUS_BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE_W :
		return "BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE_W";
/*	case BRUTUS_BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE_A : */
/*		return "BRUTUS_PR_RECIPIENT_NUMBER_FOR_ADVICE_A"; */
	case BRUTUS_BRUTUS_PR_RECIPIENT_TYPE :
		return "BRUTUS_PR_RECIPIENT_TYPE";
	case BRUTUS_BRUTUS_PR_REGISTERED_MAIL_TYPE :
		return "BRUTUS_PR_REGISTERED_MAIL_TYPE";
	case BRUTUS_BRUTUS_PR_REPLY_REQUESTED :
		return "BRUTUS_PR_REPLY_REQUESTED";
	case BRUTUS_BRUTUS_PR_REQUESTED_DELIVERY_METHOD :
		return "BRUTUS_PR_REQUESTED_DELIVERY_METHOD";
	case BRUTUS_BRUTUS_PR_SENDER_ENTRYID :
		return "BRUTUS_PR_SENDER_ENTRYID";
	case BRUTUS_BRUTUS_PR_SENDER_NAME :
		return "BRUTUS_PR_SENDER_NAME / BRUTUS_PR_SENDER_NAME_A";
	case BRUTUS_BRUTUS_PR_SENDER_NAME_W :
		return "BRUTUS_PR_SENDER_NAME_W";
/*	case BRUTUS_BRUTUS_PR_SENDER_NAME_A : */
/*		return "BRUTUS_PR_SENDER_NAME_A"; */
	case BRUTUS_BRUTUS_PR_SUPPLEMENTARY_INFO :
		return "BRUTUS_PR_SUPPLEMENTARY_INFO / BRUTUS_PR_SUPPLEMENTARY_INFO_A";
	case BRUTUS_BRUTUS_PR_SUPPLEMENTARY_INFO_W :
		return "BRUTUS_PR_SUPPLEMENTARY_INFO_W";
/*	case BRUTUS_BRUTUS_PR_SUPPLEMENTARY_INFO_A : */
/*		return "BRUTUS_PR_SUPPLEMENTARY_INFO_A"; */
	case BRUTUS_BRUTUS_PR_TYPE_OF_MTS_USER :
		return "BRUTUS_PR_TYPE_OF_MTS_USER";
	case BRUTUS_BRUTUS_PR_SENDER_SEARCH_KEY :
		return "BRUTUS_PR_SENDER_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_SENDER_ADDRTYPE :
		return "BRUTUS_PR_SENDER_ADDRTYPE / BRUTUS_PR_SENDER_ADDRTYPE_A";
	case BRUTUS_BRUTUS_PR_SENDER_ADDRTYPE_W :
		return "BRUTUS_PR_SENDER_ADDRTYPE_W";
/*	case BRUTUS_BRUTUS_PR_SENDER_ADDRTYPE_A : */
/*		return "BRUTUS_PR_SENDER_ADDRTYPE_A"; */
	case BRUTUS_BRUTUS_PR_SENDER_EMAIL_ADDRESS :
		return "BRUTUS_PR_SENDER_EMAIL_ADDRESS / BRUTUS_PR_SENDER_EMAIL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_SENDER_EMAIL_ADDRESS_W :
		return "BRUTUS_PR_SENDER_EMAIL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_SENDER_EMAIL_ADDRESS_A : */
/*		return "BRUTUS_PR_SENDER_EMAIL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_CURRENT_VERSION :
		return "BRUTUS_PR_CURRENT_VERSION";
	case BRUTUS_BRUTUS_PR_DELETE_AFTER_SUBMIT :
		return "BRUTUS_PR_DELETE_AFTER_SUBMIT";
	case BRUTUS_BRUTUS_PR_DISPLAY_BCC :
		return "BRUTUS_PR_DISPLAY_BCC / BRUTUS_PR_DISPLAY_BCC_A";
	case BRUTUS_BRUTUS_PR_DISPLAY_BCC_W :
		return "BRUTUS_PR_DISPLAY_BCC_W";
/*	case BRUTUS_BRUTUS_PR_DISPLAY_BCC_A : */
/*		return "BRUTUS_PR_DISPLAY_BCC_A"; */
	case BRUTUS_BRUTUS_PR_DISPLAY_CC :
		return "BRUTUS_PR_DISPLAY_CC / BRUTUS_PR_DISPLAY_CC_A";
	case BRUTUS_BRUTUS_PR_DISPLAY_CC_W :
		return "BRUTUS_PR_DISPLAY_CC_W";
/*	case BRUTUS_BRUTUS_PR_DISPLAY_CC_A : */
/*		return "BRUTUS_PR_DISPLAY_CC_A"; */
	case BRUTUS_BRUTUS_PR_DISPLAY_TO :
		return "BRUTUS_PR_DISPLAY_TO / BRUTUS_PR_DISPLAY_TO_A";
	case BRUTUS_BRUTUS_PR_DISPLAY_TO_W :
		return "BRUTUS_PR_DISPLAY_TO_W";
/*	case BRUTUS_BRUTUS_PR_DISPLAY_TO_A : */
/*		return "BRUTUS_PR_DISPLAY_TO_A"; */
	case BRUTUS_BRUTUS_PR_PARENT_DISPLAY :
		return "BRUTUS_PR_PARENT_DISPLAY / BRUTUS_PR_PARENT_DISPLAY_A";
	case BRUTUS_BRUTUS_PR_PARENT_DISPLAY_W :
		return "BRUTUS_PR_PARENT_DISPLAY_W";
/*	case BRUTUS_BRUTUS_PR_PARENT_DISPLAY_A : */
/*		return "BRUTUS_PR_PARENT_DISPLAY_A"; */
	case BRUTUS_BRUTUS_PR_MESSAGE_DELIVERY_TIME :
		return "BRUTUS_PR_MESSAGE_DELIVERY_TIME";
	case BRUTUS_BRUTUS_PR_MESSAGE_FLAGS :
		return "BRUTUS_PR_MESSAGE_FLAGS";
	case BRUTUS_BRUTUS_PR_MESSAGE_SIZE :
		return "BRUTUS_PR_MESSAGE_SIZE";
	case BRUTUS_BRUTUS_PR_PARENT_ENTRYID :
		return "BRUTUS_PR_PARENT_ENTRYID";
	case BRUTUS_BRUTUS_PR_SENTMAIL_ENTRYID :
		return "BRUTUS_PR_SENTMAIL_ENTRYID";
	case BRUTUS_BRUTUS_PR_CORRELATE :
		return "BRUTUS_PR_CORRELATE";
	case BRUTUS_BRUTUS_PR_CORRELATE_MTSID :
		return "BRUTUS_PR_CORRELATE_MTSID";
	case BRUTUS_BRUTUS_PR_DISCRETE_VALUES :
		return "BRUTUS_PR_DISCRETE_VALUES";
	case BRUTUS_BRUTUS_PR_RESPONSIBILITY :
		return "BRUTUS_PR_RESPONSIBILITY";
	case BRUTUS_BRUTUS_PR_SPOOLER_STATUS :
		return "BRUTUS_PR_SPOOLER_STATUS";
	case BRUTUS_BRUTUS_PR_TRANSPORT_STATUS :
		return "BRUTUS_PR_TRANSPORT_STATUS";
	case BRUTUS_BRUTUS_PR_MESSAGE_RECIPIENTS :
		return "BRUTUS_PR_MESSAGE_RECIPIENTS";
	case BRUTUS_BRUTUS_PR_MESSAGE_ATTACHMENTS :
		return "BRUTUS_PR_MESSAGE_ATTACHMENTS";
	case BRUTUS_BRUTUS_PR_SUBMIT_FLAGS :
		return "BRUTUS_PR_SUBMIT_FLAGS";
	case BRUTUS_BRUTUS_PR_RECIPIENT_STATUS :
		return "BRUTUS_PR_RECIPIENT_STATUS";
	case BRUTUS_BRUTUS_PR_TRANSPORT_KEY :
		return "BRUTUS_PR_TRANSPORT_KEY";
	case BRUTUS_BRUTUS_PR_MSG_STATUS :
		return "BRUTUS_PR_MSG_STATUS";
	case BRUTUS_BRUTUS_PR_MESSAGE_DOWNLOAD_TIME :
		return "BRUTUS_PR_MESSAGE_DOWNLOAD_TIME";
	case BRUTUS_BRUTUS_PR_CREATION_VERSION :
		return "BRUTUS_PR_CREATION_VERSION";
	case BRUTUS_BRUTUS_PR_MODIFY_VERSION :
		return "BRUTUS_PR_MODIFY_VERSION";
	case BRUTUS_BRUTUS_PR_HASATTACH :
		return "BRUTUS_PR_HASATTACH";
	case BRUTUS_BRUTUS_PR_BODY_CRC :
		return "BRUTUS_PR_BODY_CRC";
	case BRUTUS_BRUTUS_PR_NORMALIZED_SUBJECT :
		return "BRUTUS_PR_NORMALIZED_SUBJECT / BRUTUS_PR_NORMALIZED_SUBJECT_A";
	case BRUTUS_BRUTUS_PR_NORMALIZED_SUBJECT_W :
		return "BRUTUS_PR_NORMALIZED_SUBJECT_W";
/*	case BRUTUS_BRUTUS_PR_NORMALIZED_SUBJECT_A : */
/*		return "BRUTUS_PR_NORMALIZED_SUBJECT_A"; */
	case BRUTUS_BRUTUS_PR_RTF_IN_SYNC :
		return "BRUTUS_PR_RTF_IN_SYNC";
	case BRUTUS_BRUTUS_PR_ATTACH_SIZE :
		return "BRUTUS_PR_ATTACH_SIZE";
	case BRUTUS_BRUTUS_PR_ATTACH_NUM :
		return "BRUTUS_PR_ATTACH_NUM";
	case BRUTUS_BRUTUS_PR_PREPROCESS :
		return "BRUTUS_PR_PREPROCESS";
	case BRUTUS_BRUTUS_PR_ORIGINATING_MTA_CERTIFICATE :
		return "BRUTUS_PR_ORIGINATING_MTA_CERTIFICATE";
	case BRUTUS_BRUTUS_PR_PROOF_OF_SUBMISSION :
		return "BRUTUS_PR_PROOF_OF_SUBMISSION";
	case BRUTUS_BRUTUS_PR_ENTRYID :
		return "BRUTUS_PR_ENTRYID";
	case BRUTUS_BRUTUS_PR_OBJECT_TYPE :
		return "BRUTUS_PR_OBJECT_TYPE";
	case BRUTUS_BRUTUS_PR_ICON :
		return "BRUTUS_PR_ICON";
	case BRUTUS_BRUTUS_PR_MINI_ICON :
		return "BRUTUS_PR_MINI_ICON";
	case BRUTUS_BRUTUS_PR_STORE_ENTRYID :
		return "BRUTUS_PR_STORE_ENTRYID";
	case BRUTUS_BRUTUS_PR_STORE_RECORD_KEY :
		return "BRUTUS_PR_STORE_RECORD_KEY";
	case BRUTUS_BRUTUS_PR_RECORD_KEY :
		return "BRUTUS_PR_RECORD_KEY";
	case BRUTUS_BRUTUS_PR_MAPPING_SIGNATURE :
		return "BRUTUS_PR_MAPPING_SIGNATURE";
	case BRUTUS_BRUTUS_PR_ACCESS_LEVEL :
		return "BRUTUS_PR_ACCESS_LEVEL";
	case BRUTUS_BRUTUS_PR_INSTANCE_KEY :
		return "BRUTUS_PR_INSTANCE_KEY";
	case BRUTUS_BRUTUS_PR_ROW_TYPE :
		return "BRUTUS_PR_ROW_TYPE";
	case BRUTUS_BRUTUS_PR_ACCESS :
		return "BRUTUS_PR_ACCESS";
	case BRUTUS_BRUTUS_PR_ROWID :
		return "BRUTUS_PR_ROWID";
	case BRUTUS_BRUTUS_PR_DISPLAY_NAME :
		return "BRUTUS_PR_DISPLAY_NAME / BRUTUS_PR_DISPLAY_NAME_A";
	case BRUTUS_BRUTUS_PR_DISPLAY_NAME_W :
		return "BRUTUS_PR_DISPLAY_NAME_W";
/*	case BRUTUS_BRUTUS_PR_DISPLAY_NAME_A : */
/*		return "BRUTUS_PR_DISPLAY_NAME_A"; */
	case BRUTUS_BRUTUS_PR_ADDRTYPE :
		return "BRUTUS_PR_ADDRTYPE / BRUTUS_PR_ADDRTYPE_A";
	case BRUTUS_BRUTUS_PR_ADDRTYPE_W :
		return "BRUTUS_PR_ADDRTYPE_W";
/*	case BRUTUS_BRUTUS_PR_ADDRTYPE_A : */
/*		return "BRUTUS_PR_ADDRTYPE_A"; */
	case BRUTUS_BRUTUS_PR_EMAIL_ADDRESS :
		return "BRUTUS_PR_EMAIL_ADDRESS / BRUTUS_PR_EMAIL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_EMAIL_ADDRESS_W :
		return "BRUTUS_PR_EMAIL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_EMAIL_ADDRESS_A : */
/*		return "BRUTUS_PR_EMAIL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_COMMENT :
		return "BRUTUS_PR_COMMENT / BRUTUS_PR_COMMENT_A";
	case BRUTUS_BRUTUS_PR_COMMENT_W :
		return "BRUTUS_PR_COMMENT_W";
/*	case BRUTUS_BRUTUS_PR_COMMENT_A : */
/*		return "BRUTUS_PR_COMMENT_A"; */
	case BRUTUS_BRUTUS_PR_DEPTH :
		return "BRUTUS_PR_DEPTH";
	case BRUTUS_BRUTUS_PR_PROVIDER_DISPLAY :
		return "BRUTUS_PR_PROVIDER_DISPLAY / BRUTUS_PR_PROVIDER_DISPLAY_A";
	case BRUTUS_BRUTUS_PR_PROVIDER_DISPLAY_W :
		return "BRUTUS_PR_PROVIDER_DISPLAY_W";
/*	case BRUTUS_BRUTUS_PR_PROVIDER_DISPLAY_A : */
/*		return "BRUTUS_PR_PROVIDER_DISPLAY_A"; */
	case BRUTUS_BRUTUS_PR_CREATION_TIME :
		return "BRUTUS_PR_CREATION_TIME";
	case BRUTUS_BRUTUS_PR_LAST_MODIFICATION_TIME :
		return "BRUTUS_PR_LAST_MODIFICATION_TIME";
	case BRUTUS_BRUTUS_PR_RESOURCE_FLAGS :
		return "BRUTUS_PR_RESOURCE_FLAGS";
	case BRUTUS_BRUTUS_PR_PROVIDER_DLL_NAME :
		return "BRUTUS_PR_PROVIDER_DLL_NAME / BRUTUS_PR_PROVIDER_DLL_NAME_A";
	case BRUTUS_BRUTUS_PR_PROVIDER_DLL_NAME_W :
		return "BRUTUS_PR_PROVIDER_DLL_NAME_W";
/*	case BRUTUS_BRUTUS_PR_PROVIDER_DLL_NAME_A : */
/*		return "BRUTUS_PR_PROVIDER_DLL_NAME_A"; */
	case BRUTUS_BRUTUS_PR_SEARCH_KEY :
		return "BRUTUS_PR_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_PROVIDER_UID :
		return "BRUTUS_PR_PROVIDER_UID";
	case BRUTUS_BRUTUS_PR_PROVIDER_ORDINAL :
		return "BRUTUS_PR_PROVIDER_ORDINAL";
	case BRUTUS_BRUTUS_PR_FORM_VERSION :
		return "BRUTUS_PR_FORM_VERSION / BRUTUS_PR_FORM_VERSION_A";
	case BRUTUS_BRUTUS_PR_FORM_VERSION_W :
		return "BRUTUS_PR_FORM_VERSION_W";
/*	case BRUTUS_BRUTUS_PR_FORM_VERSION_A : */
/*		return "BRUTUS_PR_FORM_VERSION_A"; */
	case BRUTUS_BRUTUS_PR_FORM_CLSID :
		return "BRUTUS_PR_FORM_CLSID";
	case BRUTUS_BRUTUS_PR_FORM_CONTACT_NAME :
		return "BRUTUS_PR_FORM_CONTACT_NAME / BRUTUS_PR_FORM_CONTACT_NAME_A";
	case BRUTUS_BRUTUS_PR_FORM_CONTACT_NAME_W :
		return "BRUTUS_PR_FORM_CONTACT_NAME_W";
/*	case BRUTUS_BRUTUS_PR_FORM_CONTACT_NAME_A : */
/*		return "BRUTUS_PR_FORM_CONTACT_NAME_A"; */
	case BRUTUS_BRUTUS_PR_FORM_CATEGORY :
		return "BRUTUS_PR_FORM_CATEGORY / BRUTUS_PR_FORM_CATEGORY_A";
	case BRUTUS_BRUTUS_PR_FORM_CATEGORY_W :
		return "BRUTUS_PR_FORM_CATEGORY_W";
/*	case BRUTUS_BRUTUS_PR_FORM_CATEGORY_A : */
/*		return "BRUTUS_PR_FORM_CATEGORY_A"; */
	case BRUTUS_BRUTUS_PR_FORM_CATEGORY_SUB :
		return "BRUTUS_PR_FORM_CATEGORY_SUB / BRUTUS_PR_FORM_CATEGORY_SUB_A";
	case BRUTUS_BRUTUS_PR_FORM_CATEGORY_SUB_W :
		return "BRUTUS_PR_FORM_CATEGORY_SUB_W";
/*	case BRUTUS_BRUTUS_PR_FORM_CATEGORY_SUB_A : */
/*		return "BRUTUS_PR_FORM_CATEGORY_SUB_A"; */
	case BRUTUS_BRUTUS_PR_FORM_HOST_MAP :
		return "BRUTUS_PR_FORM_HOST_MAP";
	case BRUTUS_BRUTUS_PR_FORM_HIDDEN :
		return "BRUTUS_PR_FORM_HIDDEN";
	case BRUTUS_BRUTUS_PR_FORM_DESIGNER_NAME :
		return "BRUTUS_PR_FORM_DESIGNER_NAME / BRUTUS_PR_FORM_DESIGNER_NAME_A";
	case BRUTUS_BRUTUS_PR_FORM_DESIGNER_NAME_W :
		return "BRUTUS_PR_FORM_DESIGNER_NAME_W";
/*	case BRUTUS_BRUTUS_PR_FORM_DESIGNER_NAME_A : */
/*		return "BRUTUS_PR_FORM_DESIGNER_NAME_A"; */
	case BRUTUS_BRUTUS_PR_FORM_DESIGNER_GUID :
		return "BRUTUS_PR_FORM_DESIGNER_GUID";
	case BRUTUS_BRUTUS_PR_FORM_MESSAGE_BEHAVIOR :
		return "BRUTUS_PR_FORM_MESSAGE_BEHAVIOR";
	case BRUTUS_BRUTUS_PR_DEFAULT_STORE :
		return "BRUTUS_PR_DEFAULT_STORE";
	case BRUTUS_BRUTUS_PR_STORE_SUPPORT_MASK :
		return "BRUTUS_PR_STORE_SUPPORT_MASK";
	case BRUTUS_BRUTUS_PR_STORE_STATE :
		return "BRUTUS_PR_STORE_STATE";
	case BRUTUS_BRUTUS_PR_IPM_SUBTREE_SEARCH_KEY :
		return "BRUTUS_PR_IPM_SUBTREE_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_IPM_OUTBOX_SEARCH_KEY :
		return "BRUTUS_PR_IPM_OUTBOX_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_IPM_WASTEBASKET_SEARCH_KEY :
		return "BRUTUS_PR_IPM_WASTEBASKET_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_IPM_SENTMAIL_SEARCH_KEY :
		return "BRUTUS_PR_IPM_SENTMAIL_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_MDB_PROVIDER :
		return "BRUTUS_PR_MDB_PROVIDER";
	case BRUTUS_BRUTUS_PR_RECEIVE_FOLDER_SETTINGS :
		return "BRUTUS_PR_RECEIVE_FOLDER_SETTINGS";
	case BRUTUS_BRUTUS_PR_VALID_FOLDER_MASK :
		return "BRUTUS_PR_VALID_FOLDER_MASK";
	case BRUTUS_BRUTUS_PR_IPM_SUBTREE_ENTRYID :
		return "BRUTUS_PR_IPM_SUBTREE_ENTRYID";
	case BRUTUS_BRUTUS_PR_IPM_OUTBOX_ENTRYID :
		return "BRUTUS_PR_IPM_OUTBOX_ENTRYID";
	case BRUTUS_BRUTUS_PR_IPM_WASTEBASKET_ENTRYID :
		return "BRUTUS_PR_IPM_WASTEBASKET_ENTRYID";
	case BRUTUS_BRUTUS_PR_IPM_SENTMAIL_ENTRYID :
		return "BRUTUS_PR_IPM_SENTMAIL_ENTRYID";
	case BRUTUS_BRUTUS_PR_VIEWS_ENTRYID :
		return "BRUTUS_PR_VIEWS_ENTRYID";
	case BRUTUS_BRUTUS_PR_COMMON_VIEWS_ENTRYID :
		return "BRUTUS_PR_COMMON_VIEWS_ENTRYID";
	case BRUTUS_BRUTUS_PR_FINDER_ENTRYID :
		return "BRUTUS_PR_FINDER_ENTRYID";
	case BRUTUS_BRUTUS_PR_CONTAINER_FLAGS :
		return "BRUTUS_PR_CONTAINER_FLAGS";
	case BRUTUS_BRUTUS_PR_FOLDER_TYPE :
		return "BRUTUS_PR_FOLDER_TYPE";
	case BRUTUS_BRUTUS_PR_CONTENT_COUNT :
		return "BRUTUS_PR_CONTENT_COUNT";
	case BRUTUS_BRUTUS_PR_CONTENT_UNREAD :
		return "BRUTUS_PR_CONTENT_UNREAD";
	case BRUTUS_BRUTUS_PR_CREATE_TEMPLATES :
		return "BRUTUS_PR_CREATE_TEMPLATES";
	case BRUTUS_BRUTUS_PR_DETAILS_TABLE :
		return "BRUTUS_PR_DETAILS_TABLE";
	case BRUTUS_BRUTUS_PR_SEARCH :
		return "BRUTUS_PR_SEARCH";
	case BRUTUS_BRUTUS_PR_SELECTABLE :
		return "BRUTUS_PR_SELECTABLE";
	case BRUTUS_BRUTUS_PR_SUBFOLDERS :
		return "BRUTUS_PR_SUBFOLDERS";
	case BRUTUS_BRUTUS_PR_STATUS :
		return "BRUTUS_PR_STATUS";
	case BRUTUS_BRUTUS_PR_ANR :
		return "BRUTUS_PR_ANR / BRUTUS_PR_ANR_A";
	case BRUTUS_BRUTUS_PR_ANR_W :
		return "BRUTUS_PR_ANR_W";
/*	case BRUTUS_BRUTUS_PR_ANR_A : */
/*		return "BRUTUS_PR_ANR_A"; */
	case BRUTUS_BRUTUS_PR_CONTENTS_SORT_ORDER :
		return "BRUTUS_PR_CONTENTS_SORT_ORDER";
	case BRUTUS_BRUTUS_PR_CONTAINER_HIERARCHY :
		return "BRUTUS_PR_CONTAINER_HIERARCHY";
	case BRUTUS_BRUTUS_PR_CONTAINER_CONTENTS :
		return "BRUTUS_PR_CONTAINER_CONTENTS";
	case BRUTUS_BRUTUS_PR_FOLDER_ASSOCIATED_CONTENTS :
		return "BRUTUS_PR_FOLDER_ASSOCIATED_CONTENTS";
	case BRUTUS_BRUTUS_PR_DEF_CREATE_DL :
		return "BRUTUS_PR_DEF_CREATE_DL";
	case BRUTUS_BRUTUS_PR_DEF_CREATE_MAILUSER :
		return "BRUTUS_PR_DEF_CREATE_MAILUSER";
	case BRUTUS_BRUTUS_PR_CONTAINER_CLASS :
		return "BRUTUS_PR_CONTAINER_CLASS / BRUTUS_PR_CONTAINER_CLASS_A";
	case BRUTUS_BRUTUS_PR_CONTAINER_CLASS_W :
		return "BRUTUS_PR_CONTAINER_CLASS_W";
/*	case BRUTUS_BRUTUS_PR_CONTAINER_CLASS_A : */
/*		return "BRUTUS_PR_CONTAINER_CLASS_A"; */
	case BRUTUS_BRUTUS_PR_CONTAINER_MODIFY_VERSION :
		return "BRUTUS_PR_CONTAINER_MODIFY_VERSION";
	case BRUTUS_BRUTUS_PR_AB_PROVIDER_ID :
		return "BRUTUS_PR_AB_PROVIDER_ID";
	case BRUTUS_BRUTUS_PR_DEFAULT_VIEW_ENTRYID :
		return "BRUTUS_PR_DEFAULT_VIEW_ENTRYID";
	case BRUTUS_BRUTUS_PR_ASSOC_CONTENT_COUNT :
		return "BRUTUS_PR_ASSOC_CONTENT_COUNT";
	case BRUTUS_BRUTUS_PR_OUTLOOK_CALENDAR :
		return "BRUTUS_PR_OUTLOOK_CALENDAR";
	case BRUTUS_BRUTUS_PR_OUTLOOK_CONTACTS :
		return "BRUTUS_PR_OUTLOOK_CONTACTS";
	case BRUTUS_BRUTUS_PR_OUTLOOK_JOURNAL :
		return "BRUTUS_PR_OUTLOOK_JOURNAL";
	case BRUTUS_BRUTUS_PR_OUTLOOK_NOTES :
		return "BRUTUS_PR_OUTLOOK_NOTES";
	case BRUTUS_BRUTUS_PR_OUTLOOK_TASKS :
		return "BRUTUS_PR_OUTLOOK_TASKS";
	case BRUTUS_BRUTUS_PR_OUTLOOK_ONLINE_REMINDERS :
		return "BRUTUS_PR_OUTLOOK_ONLINE_REMINDERS";
	case BRUTUS_BRUTUS_PR_OUTLOOK_OFFLINE_REMINDERS :
		return "BRUTUS_PR_OUTLOOK_OFFLINE_REMINDERS";
	case BRUTUS_BRUTUS_PR_OUTLOOK_DRAFTS :
		return "BRUTUS_PR_OUTLOOK_DRAFTS";
	case BRUTUS_BRUTUS_PR_ATTACHMENT_X400_PARAMETERS :
		return "BRUTUS_PR_ATTACHMENT_X400_PARAMETERS";
	case BRUTUS_BRUTUS_PR_ATTACH_DATA_OBJ :
		return "BRUTUS_PR_ATTACH_DATA_OBJ";
	case BRUTUS_BRUTUS_PR_ATTACH_DATA_BIN :
		return "BRUTUS_PR_ATTACH_DATA_BIN";
	case BRUTUS_BRUTUS_PR_ATTACH_ENCODING :
		return "BRUTUS_PR_ATTACH_ENCODING";
	case BRUTUS_BRUTUS_PR_ATTACH_EXTENSION :
		return "BRUTUS_PR_ATTACH_EXTENSION / BRUTUS_PR_ATTACH_EXTENSION_A";
	case BRUTUS_BRUTUS_PR_ATTACH_EXTENSION_W :
		return "BRUTUS_PR_ATTACH_EXTENSION_W";
/*	case BRUTUS_BRUTUS_PR_ATTACH_EXTENSION_A : */
/*		return "BRUTUS_PR_ATTACH_EXTENSION_A"; */
	case BRUTUS_BRUTUS_PR_ATTACH_FILENAME :
		return "BRUTUS_PR_ATTACH_FILENAME / BRUTUS_PR_ATTACH_FILENAME_A";
	case BRUTUS_BRUTUS_PR_ATTACH_FILENAME_W :
		return "BRUTUS_PR_ATTACH_FILENAME_W";
/*	case BRUTUS_BRUTUS_PR_ATTACH_FILENAME_A : */
/*		return "BRUTUS_PR_ATTACH_FILENAME_A"; */
	case BRUTUS_BRUTUS_PR_ATTACH_METHOD :
		return "BRUTUS_PR_ATTACH_METHOD";
	case BRUTUS_BRUTUS_PR_ATTACH_LONG_FILENAME :
		return "BRUTUS_PR_ATTACH_LONG_FILENAME / BRUTUS_PR_ATTACH_LONG_FILENAME_A";
	case BRUTUS_BRUTUS_PR_ATTACH_LONG_FILENAME_W :
		return "BRUTUS_PR_ATTACH_LONG_FILENAME_W";
/*	case BRUTUS_BRUTUS_PR_ATTACH_LONG_FILENAME_A : */
/*		return "BRUTUS_PR_ATTACH_LONG_FILENAME_A"; */
	case BRUTUS_BRUTUS_PR_ATTACH_PATHNAME :
		return "BRUTUS_PR_ATTACH_PATHNAME / BRUTUS_PR_ATTACH_PATHNAME_A";
	case BRUTUS_BRUTUS_PR_ATTACH_PATHNAME_W :
		return "BRUTUS_PR_ATTACH_PATHNAME_W";
/*	case BRUTUS_BRUTUS_PR_ATTACH_PATHNAME_A : */
/*		return "BRUTUS_PR_ATTACH_PATHNAME_A"; */
	case BRUTUS_BRUTUS_PR_ATTACH_RENDERING :
		return "BRUTUS_PR_ATTACH_RENDERING";
	case BRUTUS_BRUTUS_PR_ATTACH_TAG :
		return "BRUTUS_PR_ATTACH_TAG";
	case BRUTUS_BRUTUS_PR_RENDERING_POSITION :
		return "BRUTUS_PR_RENDERING_POSITION";
	case BRUTUS_BRUTUS_PR_ATTACH_TRANSPORT_NAME :
		return "BRUTUS_PR_ATTACH_TRANSPORT_NAME / BRUTUS_PR_ATTACH_TRANSPORT_NAME_A";
	case BRUTUS_BRUTUS_PR_ATTACH_TRANSPORT_NAME_W :
		return "BRUTUS_PR_ATTACH_TRANSPORT_NAME_W";
/*	case BRUTUS_BRUTUS_PR_ATTACH_TRANSPORT_NAME_A : */
/*		return "BRUTUS_PR_ATTACH_TRANSPORT_NAME_A"; */
	case BRUTUS_BRUTUS_PR_ATTACH_LONG_PATHNAME :
		return "BRUTUS_PR_ATTACH_LONG_PATHNAME / BRUTUS_PR_ATTACH_LONG_PATHNAME_A";
	case BRUTUS_BRUTUS_PR_ATTACH_LONG_PATHNAME_W :
		return "BRUTUS_PR_ATTACH_LONG_PATHNAME_W";
/*	case BRUTUS_BRUTUS_PR_ATTACH_LONG_PATHNAME_A : */
/*		return "BRUTUS_PR_ATTACH_LONG_PATHNAME_A"; */
	case BRUTUS_BRUTUS_PR_ATTACH_MIME_TAG :
		return "BRUTUS_PR_ATTACH_MIME_TAG / BRUTUS_PR_ATTACH_MIME_TAG_A";
	case BRUTUS_BRUTUS_PR_ATTACH_MIME_TAG_W :
		return "BRUTUS_PR_ATTACH_MIME_TAG_W";
/*	case BRUTUS_BRUTUS_PR_ATTACH_MIME_TAG_A : */
/*		return "BRUTUS_PR_ATTACH_MIME_TAG_A"; */
	case BRUTUS_BRUTUS_PR_ATTACH_ADDITIONAL_INFO :
		return "BRUTUS_PR_ATTACH_ADDITIONAL_INFO";
	case BRUTUS_BRUTUS_PR_DISPLAY_TYPE :
		return "BRUTUS_PR_DISPLAY_TYPE";
	case BRUTUS_BRUTUS_PR_TEMPLATEID :
		return "BRUTUS_PR_TEMPLATEID";
	case BRUTUS_BRUTUS_PR_PRIMARY_CAPABILITY :
		return "BRUTUS_PR_PRIMARY_CAPABILITY";
	case BRUTUS_BRUTUS_PR_7BIT_DISPLAY_NAME :
		return "BRUTUS_PR_7BIT_DISPLAY_NAME";
	case BRUTUS_BRUTUS_PR_ACCOUNT :
		return "BRUTUS_PR_ACCOUNT / BRUTUS_PR_ACCOUNT_A";
	case BRUTUS_BRUTUS_PR_ACCOUNT_W :
		return "BRUTUS_PR_ACCOUNT_W";
/*	case BRUTUS_BRUTUS_PR_ACCOUNT_A : */
/*		return "BRUTUS_PR_ACCOUNT_A"; */
	case BRUTUS_BRUTUS_PR_ALTERNATE_RECIPIENT :
		return "BRUTUS_PR_ALTERNATE_RECIPIENT";
	case BRUTUS_BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER :
		return "BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER / BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_CALLBACK_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_CONVERSION_PROHIBITED :
		return "BRUTUS_PR_CONVERSION_PROHIBITED";
	case BRUTUS_BRUTUS_PR_DISCLOSE_RECIPIENTS :
		return "BRUTUS_PR_DISCLOSE_RECIPIENTS";
	case BRUTUS_BRUTUS_PR_GENERATION :
		return "BRUTUS_PR_GENERATION / BRUTUS_PR_GENERATION_A";
	case BRUTUS_BRUTUS_PR_GENERATION_W :
		return "BRUTUS_PR_GENERATION_W";
/*	case BRUTUS_BRUTUS_PR_GENERATION_A : */
/*		return "BRUTUS_PR_GENERATION_A"; */
	case BRUTUS_BRUTUS_PR_GIVEN_NAME :
		return "BRUTUS_PR_GIVEN_NAME / BRUTUS_PR_GIVEN_NAME_A";
	case BRUTUS_BRUTUS_PR_GIVEN_NAME_W :
		return "BRUTUS_PR_GIVEN_NAME_W";
/*	case BRUTUS_BRUTUS_PR_GIVEN_NAME_A : */
/*		return "BRUTUS_PR_GIVEN_NAME_A"; */
	case BRUTUS_BRUTUS_PR_GOVERNMENT_ID_NUMBER :
		return "BRUTUS_PR_GOVERNMENT_ID_NUMBER / BRUTUS_PR_GOVERNMENT_ID_NUMBER_A";
	case BRUTUS_BRUTUS_PR_GOVERNMENT_ID_NUMBER_W :
		return "BRUTUS_PR_GOVERNMENT_ID_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_GOVERNMENT_ID_NUMBER_A : */
/*		return "BRUTUS_PR_GOVERNMENT_ID_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER :
		return "BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER / BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_BUSINESS_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_HOME_TELEPHONE_NUMBER :
		return "BRUTUS_PR_HOME_TELEPHONE_NUMBER / BRUTUS_PR_HOME_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_HOME_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_HOME_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_HOME_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_HOME_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_INITIALS :
		return "BRUTUS_PR_INITIALS / BRUTUS_PR_INITIALS_A";
	case BRUTUS_BRUTUS_PR_INITIALS_W :
		return "BRUTUS_PR_INITIALS_W";
/*	case BRUTUS_BRUTUS_PR_INITIALS_A : */
/*		return "BRUTUS_PR_INITIALS_A"; */
	case BRUTUS_BRUTUS_PR_KEYWORD :
		return "BRUTUS_PR_KEYWORD / BRUTUS_PR_KEYWORD_A";
	case BRUTUS_BRUTUS_PR_KEYWORD_W :
		return "BRUTUS_PR_KEYWORD_W";
/*	case BRUTUS_BRUTUS_PR_KEYWORD_A : */
/*		return "BRUTUS_PR_KEYWORD_A"; */
	case BRUTUS_BRUTUS_PR_LANGUAGE :
		return "BRUTUS_PR_LANGUAGE / BRUTUS_PR_LANGUAGE_A";
	case BRUTUS_BRUTUS_PR_LANGUAGE_W :
		return "BRUTUS_PR_LANGUAGE_W";
/*	case BRUTUS_BRUTUS_PR_LANGUAGE_A : */
/*		return "BRUTUS_PR_LANGUAGE_A"; */
	case BRUTUS_BRUTUS_PR_LOCATION :
		return "BRUTUS_PR_LOCATION / BRUTUS_PR_LOCATION_A";
	case BRUTUS_BRUTUS_PR_LOCATION_W :
		return "BRUTUS_PR_LOCATION_W";
/*	case BRUTUS_BRUTUS_PR_LOCATION_A : */
/*		return "BRUTUS_PR_LOCATION_A"; */
	case BRUTUS_BRUTUS_PR_MAIL_PERMISSION :
		return "BRUTUS_PR_MAIL_PERMISSION";
	case BRUTUS_BRUTUS_PR_MHS_COMMON_NAME :
		return "BRUTUS_PR_MHS_COMMON_NAME / BRUTUS_PR_MHS_COMMON_NAME_A";
	case BRUTUS_BRUTUS_PR_MHS_COMMON_NAME_W :
		return "BRUTUS_PR_MHS_COMMON_NAME_W";
/*	case BRUTUS_BRUTUS_PR_MHS_COMMON_NAME_A : */
/*		return "BRUTUS_PR_MHS_COMMON_NAME_A"; */
	case BRUTUS_BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER :
		return "BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER / BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER_A";
	case BRUTUS_BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER_W :
		return "BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER_A : */
/*		return "BRUTUS_PR_ORGANIZATIONAL_ID_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_SURNAME :
		return "BRUTUS_PR_SURNAME / BRUTUS_PR_SURNAME_A";
	case BRUTUS_BRUTUS_PR_SURNAME_W :
		return "BRUTUS_PR_SURNAME_W";
/*	case BRUTUS_BRUTUS_PR_SURNAME_A : */
/*		return "BRUTUS_PR_SURNAME_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_ENTRYID :
		return "BRUTUS_PR_ORIGINAL_ENTRYID";
	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_NAME :
		return "BRUTUS_PR_ORIGINAL_DISPLAY_NAME / BRUTUS_PR_ORIGINAL_DISPLAY_NAME_A";
	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_NAME_W :
		return "BRUTUS_PR_ORIGINAL_DISPLAY_NAME_W";
/*	case BRUTUS_BRUTUS_PR_ORIGINAL_DISPLAY_NAME_A : */
/*		return "BRUTUS_PR_ORIGINAL_DISPLAY_NAME_A"; */
	case BRUTUS_BRUTUS_PR_ORIGINAL_SEARCH_KEY :
		return "BRUTUS_PR_ORIGINAL_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_POSTAL_ADDRESS :
		return "BRUTUS_PR_POSTAL_ADDRESS / BRUTUS_PR_POSTAL_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_POSTAL_ADDRESS_W :
		return "BRUTUS_PR_POSTAL_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_POSTAL_ADDRESS_A : */
/*		return "BRUTUS_PR_POSTAL_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_COMPANY_NAME :
		return "BRUTUS_PR_COMPANY_NAME / BRUTUS_PR_COMPANY_NAME_A";
	case BRUTUS_BRUTUS_PR_COMPANY_NAME_W :
		return "BRUTUS_PR_COMPANY_NAME_W";
/*	case BRUTUS_BRUTUS_PR_COMPANY_NAME_A : */
/*		return "BRUTUS_PR_COMPANY_NAME_A"; */
	case BRUTUS_BRUTUS_PR_TITLE :
		return "BRUTUS_PR_TITLE / BRUTUS_PR_TITLE_A";
	case BRUTUS_BRUTUS_PR_TITLE_W :
		return "BRUTUS_PR_TITLE_W";
/*	case BRUTUS_BRUTUS_PR_TITLE_A : */
/*		return "BRUTUS_PR_TITLE_A"; */
	case BRUTUS_BRUTUS_PR_DEPARTMENT_NAME :
		return "BRUTUS_PR_DEPARTMENT_NAME / BRUTUS_PR_DEPARTMENT_NAME_A";
	case BRUTUS_BRUTUS_PR_DEPARTMENT_NAME_W :
		return "BRUTUS_PR_DEPARTMENT_NAME_W";
/*	case BRUTUS_BRUTUS_PR_DEPARTMENT_NAME_A : */
/*		return "BRUTUS_PR_DEPARTMENT_NAME_A"; */
	case BRUTUS_BRUTUS_PR_OFFICE_LOCATION :
		return "BRUTUS_PR_OFFICE_LOCATION / BRUTUS_PR_OFFICE_LOCATION_A";
	case BRUTUS_BRUTUS_PR_OFFICE_LOCATION_W :
		return "BRUTUS_PR_OFFICE_LOCATION_W";
/*	case BRUTUS_BRUTUS_PR_OFFICE_LOCATION_A : */
/*		return "BRUTUS_PR_OFFICE_LOCATION_A"; */
	case BRUTUS_BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER :
		return "BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER / BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_PRIMARY_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER :
		return "BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER / BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_BUSINESS2_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_MOBILE_TELEPHONE_NUMBER :
		return "BRUTUS_PR_MOBILE_TELEPHONE_NUMBER / BRUTUS_PR_MOBILE_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_MOBILE_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_MOBILE_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_MOBILE_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_MOBILE_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_RADIO_TELEPHONE_NUMBER :
		return "BRUTUS_PR_RADIO_TELEPHONE_NUMBER / BRUTUS_PR_RADIO_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_RADIO_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_RADIO_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_RADIO_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_RADIO_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_CAR_TELEPHONE_NUMBER :
		return "BRUTUS_PR_CAR_TELEPHONE_NUMBER / BRUTUS_PR_CAR_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_CAR_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_CAR_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_CAR_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_CAR_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_OTHER_TELEPHONE_NUMBER :
		return "BRUTUS_PR_OTHER_TELEPHONE_NUMBER / BRUTUS_PR_OTHER_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_OTHER_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_OTHER_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_OTHER_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_OTHER_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME :
		return "BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME / BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME_A";
	case BRUTUS_BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME_W :
		return "BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME_W";
/*	case BRUTUS_BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME_A : */
/*		return "BRUTUS_PR_TRANSMITABLE_DISPLAY_NAME_A"; */
	case BRUTUS_BRUTUS_PR_PAGER_TELEPHONE_NUMBER :
		return "BRUTUS_PR_PAGER_TELEPHONE_NUMBER / BRUTUS_PR_PAGER_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_PAGER_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_PAGER_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_PAGER_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_PAGER_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_USER_CERTIFICATE :
		return "BRUTUS_PR_USER_CERTIFICATE";
	case BRUTUS_BRUTUS_PR_PRIMARY_FAX_NUMBER :
		return "BRUTUS_PR_PRIMARY_FAX_NUMBER / BRUTUS_PR_PRIMARY_FAX_NUMBER_A";
	case BRUTUS_BRUTUS_PR_PRIMARY_FAX_NUMBER_W :
		return "BRUTUS_PR_PRIMARY_FAX_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_PRIMARY_FAX_NUMBER_A : */
/*		return "BRUTUS_PR_PRIMARY_FAX_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_BUSINESS_FAX_NUMBER :
		return "BRUTUS_PR_BUSINESS_FAX_NUMBER / BRUTUS_PR_BUSINESS_FAX_NUMBER_A";
	case BRUTUS_BRUTUS_PR_BUSINESS_FAX_NUMBER_W :
		return "BRUTUS_PR_BUSINESS_FAX_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_BUSINESS_FAX_NUMBER_A : */
/*		return "BRUTUS_PR_BUSINESS_FAX_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_HOME_FAX_NUMBER :
		return "BRUTUS_PR_HOME_FAX_NUMBER / BRUTUS_PR_HOME_FAX_NUMBER_A";
	case BRUTUS_BRUTUS_PR_HOME_FAX_NUMBER_W :
		return "BRUTUS_PR_HOME_FAX_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_HOME_FAX_NUMBER_A : */
/*		return "BRUTUS_PR_HOME_FAX_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_COUNTRY :
		return "BRUTUS_PR_COUNTRY / BRUTUS_PR_COUNTRY_A";
	case BRUTUS_BRUTUS_PR_COUNTRY_W :
		return "BRUTUS_PR_COUNTRY_W";
/*	case BRUTUS_BRUTUS_PR_COUNTRY_A : */
/*		return "BRUTUS_PR_COUNTRY_A"; */
	case BRUTUS_BRUTUS_PR_LOCALITY :
		return "BRUTUS_PR_LOCALITY / BRUTUS_PR_LOCALITY_A";
	case BRUTUS_BRUTUS_PR_LOCALITY_W :
		return "BRUTUS_PR_LOCALITY_W";
/*	case BRUTUS_BRUTUS_PR_LOCALITY_A : */
/*		return "BRUTUS_PR_LOCALITY_A"; */
	case BRUTUS_BRUTUS_PR_STATE_OR_PROVINCE :
		return "BRUTUS_PR_STATE_OR_PROVINCE / BRUTUS_PR_STATE_OR_PROVINCE_A";
	case BRUTUS_BRUTUS_PR_STATE_OR_PROVINCE_W :
		return "BRUTUS_PR_STATE_OR_PROVINCE_W";
/*	case BRUTUS_BRUTUS_PR_STATE_OR_PROVINCE_A : */
/*		return "BRUTUS_PR_STATE_OR_PROVINCE_A"; */
	case BRUTUS_BRUTUS_PR_STREET_ADDRESS :
		return "BRUTUS_PR_STREET_ADDRESS / BRUTUS_PR_STREET_ADDRESS_A";
	case BRUTUS_BRUTUS_PR_STREET_ADDRESS_W :
		return "BRUTUS_PR_STREET_ADDRESS_W";
/*	case BRUTUS_BRUTUS_PR_STREET_ADDRESS_A : */
/*		return "BRUTUS_PR_STREET_ADDRESS_A"; */
	case BRUTUS_BRUTUS_PR_POSTAL_CODE :
		return "BRUTUS_PR_POSTAL_CODE / BRUTUS_PR_POSTAL_CODE_A";
	case BRUTUS_BRUTUS_PR_POSTAL_CODE_W :
		return "BRUTUS_PR_POSTAL_CODE_W";
/*	case BRUTUS_BRUTUS_PR_POSTAL_CODE_A : */
/*		return "BRUTUS_PR_POSTAL_CODE_A"; */
	case BRUTUS_BRUTUS_PR_POST_OFFICE_BOX :
		return "BRUTUS_PR_POST_OFFICE_BOX / BRUTUS_PR_POST_OFFICE_BOX_A";
	case BRUTUS_BRUTUS_PR_POST_OFFICE_BOX_W :
		return "BRUTUS_PR_POST_OFFICE_BOX_W";
/*	case BRUTUS_BRUTUS_PR_POST_OFFICE_BOX_A : */
/*		return "BRUTUS_PR_POST_OFFICE_BOX_A"; */
	case BRUTUS_BRUTUS_PR_TELEX_NUMBER :
		return "BRUTUS_PR_TELEX_NUMBER / BRUTUS_PR_TELEX_NUMBER_A";
	case BRUTUS_BRUTUS_PR_TELEX_NUMBER_W :
		return "BRUTUS_PR_TELEX_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_TELEX_NUMBER_A : */
/*		return "BRUTUS_PR_TELEX_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_ISDN_NUMBER :
		return "BRUTUS_PR_ISDN_NUMBER / BRUTUS_PR_ISDN_NUMBER_A";
	case BRUTUS_BRUTUS_PR_ISDN_NUMBER_W :
		return "BRUTUS_PR_ISDN_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_ISDN_NUMBER_A : */
/*		return "BRUTUS_PR_ISDN_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER :
		return "BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER / BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_ASSISTANT_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_HOME2_TELEPHONE_NUMBER :
		return "BRUTUS_PR_HOME2_TELEPHONE_NUMBER / BRUTUS_PR_HOME2_TELEPHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_HOME2_TELEPHONE_NUMBER_W :
		return "BRUTUS_PR_HOME2_TELEPHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_HOME2_TELEPHONE_NUMBER_A : */
/*		return "BRUTUS_PR_HOME2_TELEPHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_ASSISTANT :
		return "BRUTUS_PR_ASSISTANT / BRUTUS_PR_ASSISTANT_A";
	case BRUTUS_BRUTUS_PR_ASSISTANT_W :
		return "BRUTUS_PR_ASSISTANT_W";
/*	case BRUTUS_BRUTUS_PR_ASSISTANT_A : */
/*		return "BRUTUS_PR_ASSISTANT_A"; */
	case BRUTUS_BRUTUS_PR_SEND_RICH_INFO :
		return "BRUTUS_PR_SEND_RICH_INFO";
	case BRUTUS_BRUTUS_PR_WEDDING_ANNIVERSARY :
		return "BRUTUS_PR_WEDDING_ANNIVERSARY";
	case BRUTUS_BRUTUS_PR_BIRTHDAY :
		return "BRUTUS_PR_BIRTHDAY";
	case BRUTUS_BRUTUS_PR_HOBBIES :
		return "BRUTUS_PR_HOBBIES / BRUTUS_PR_HOBBIES_A";
	case BRUTUS_BRUTUS_PR_HOBBIES_W :
		return "BRUTUS_PR_HOBBIES_W";
/*	case BRUTUS_BRUTUS_PR_HOBBIES_A : */
/*		return "BRUTUS_PR_HOBBIES_A"; */
	case BRUTUS_BRUTUS_PR_MIDDLE_NAME :
		return "BRUTUS_PR_MIDDLE_NAME / BRUTUS_PR_MIDDLE_NAME_A";
	case BRUTUS_BRUTUS_PR_MIDDLE_NAME_W :
		return "BRUTUS_PR_MIDDLE_NAME_W";
/*	case BRUTUS_BRUTUS_PR_MIDDLE_NAME_A : */
/*		return "BRUTUS_PR_MIDDLE_NAME_A"; */
	case BRUTUS_BRUTUS_PR_DISPLAY_NAME_PREFIX :
		return "BRUTUS_PR_DISPLAY_NAME_PREFIX / BRUTUS_PR_DISPLAY_NAME_PREFIX_A";
	case BRUTUS_BRUTUS_PR_DISPLAY_NAME_PREFIX_W :
		return "BRUTUS_PR_DISPLAY_NAME_PREFIX_W";
/*	case BRUTUS_BRUTUS_PR_DISPLAY_NAME_PREFIX_A : */
/*		return "BRUTUS_PR_DISPLAY_NAME_PREFIX_A"; */
	case BRUTUS_BRUTUS_PR_PROFESSION :
		return "BRUTUS_PR_PROFESSION / BRUTUS_PR_PROFESSION_A";
	case BRUTUS_BRUTUS_PR_PROFESSION_W :
		return "BRUTUS_PR_PROFESSION_W";
/*	case BRUTUS_BRUTUS_PR_PROFESSION_A : */
/*		return "BRUTUS_PR_PROFESSION_A"; */
	case BRUTUS_BRUTUS_PR_PREFERRED_BY_NAME :
		return "BRUTUS_PR_PREFERRED_BY_NAME / BRUTUS_PR_PREFERRED_BY_NAME_A";
	case BRUTUS_BRUTUS_PR_PREFERRED_BY_NAME_W :
		return "BRUTUS_PR_PREFERRED_BY_NAME_W";
/*	case BRUTUS_BRUTUS_PR_PREFERRED_BY_NAME_A : */
/*		return "BRUTUS_PR_PREFERRED_BY_NAME_A"; */
	case BRUTUS_BRUTUS_PR_SPOUSE_NAME :
		return "BRUTUS_PR_SPOUSE_NAME / BRUTUS_PR_SPOUSE_NAME_A";
	case BRUTUS_BRUTUS_PR_SPOUSE_NAME_W :
		return "BRUTUS_PR_SPOUSE_NAME_W";
/*	case BRUTUS_BRUTUS_PR_SPOUSE_NAME_A : */
/*		return "BRUTUS_PR_SPOUSE_NAME_A"; */
	case BRUTUS_BRUTUS_PR_COMPUTER_NETWORK_NAME :
		return "BRUTUS_PR_COMPUTER_NETWORK_NAME / BRUTUS_PR_COMPUTER_NETWORK_NAME_A";
	case BRUTUS_BRUTUS_PR_COMPUTER_NETWORK_NAME_W :
		return "BRUTUS_PR_COMPUTER_NETWORK_NAME_W";
/*	case BRUTUS_BRUTUS_PR_COMPUTER_NETWORK_NAME_A : */
/*		return "BRUTUS_PR_COMPUTER_NETWORK_NAME_A"; */
	case BRUTUS_BRUTUS_PR_CUSTOMER_ID :
		return "BRUTUS_PR_CUSTOMER_ID / BRUTUS_PR_CUSTOMER_ID_A";
	case BRUTUS_BRUTUS_PR_CUSTOMER_ID_W :
		return "BRUTUS_PR_CUSTOMER_ID_W";
/*	case BRUTUS_BRUTUS_PR_CUSTOMER_ID_A : */
/*		return "BRUTUS_PR_CUSTOMER_ID_A"; */
	case BRUTUS_BRUTUS_PR_TTYTDD_PHONE_NUMBER :
		return "BRUTUS_PR_TTYTDD_PHONE_NUMBER / BRUTUS_PR_TTYTDD_PHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_TTYTDD_PHONE_NUMBER_W :
		return "BRUTUS_PR_TTYTDD_PHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_TTYTDD_PHONE_NUMBER_A : */
/*		return "BRUTUS_PR_TTYTDD_PHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_FTP_SITE :
		return "BRUTUS_PR_FTP_SITE / BRUTUS_PR_FTP_SITE_A";
	case BRUTUS_BRUTUS_PR_FTP_SITE_W :
		return "BRUTUS_PR_FTP_SITE_W";
/*	case BRUTUS_BRUTUS_PR_FTP_SITE_A : */
/*		return "BRUTUS_PR_FTP_SITE_A"; */
	case BRUTUS_BRUTUS_PR_GENDER :
		return "BRUTUS_PR_GENDER";
	case BRUTUS_BRUTUS_PR_MANAGER_NAME :
		return "BRUTUS_PR_MANAGER_NAME / BRUTUS_PR_MANAGER_NAME_A";
	case BRUTUS_BRUTUS_PR_MANAGER_NAME_W :
		return "BRUTUS_PR_MANAGER_NAME_W";
/*	case BRUTUS_BRUTUS_PR_MANAGER_NAME_A : */
/*		return "BRUTUS_PR_MANAGER_NAME_A"; */
	case BRUTUS_BRUTUS_PR_NICKNAME :
		return "BRUTUS_PR_NICKNAME / BRUTUS_PR_NICKNAME_A";
	case BRUTUS_BRUTUS_PR_NICKNAME_W :
		return "BRUTUS_PR_NICKNAME_W";
/*	case BRUTUS_BRUTUS_PR_NICKNAME_A : */
/*		return "BRUTUS_PR_NICKNAME_A"; */
	case BRUTUS_BRUTUS_PR_PERSONAL_HOME_PAGE :
		return "BRUTUS_PR_PERSONAL_HOME_PAGE / BRUTUS_PR_PERSONAL_HOME_PAGE_A";
	case BRUTUS_BRUTUS_PR_PERSONAL_HOME_PAGE_W :
		return "BRUTUS_PR_PERSONAL_HOME_PAGE_W";
/*	case BRUTUS_BRUTUS_PR_PERSONAL_HOME_PAGE_A : */
/*		return "BRUTUS_PR_PERSONAL_HOME_PAGE_A"; */
	case BRUTUS_BRUTUS_PR_BUSINESS_HOME_PAGE :
		return "BRUTUS_PR_BUSINESS_HOME_PAGE / BRUTUS_PR_BUSINESS_HOME_PAGE_A";
	case BRUTUS_BRUTUS_PR_BUSINESS_HOME_PAGE_W :
		return "BRUTUS_PR_BUSINESS_HOME_PAGE_W";
/*	case BRUTUS_BRUTUS_PR_BUSINESS_HOME_PAGE_A : */
/*		return "BRUTUS_PR_BUSINESS_HOME_PAGE_A"; */
	case BRUTUS_BRUTUS_PR_CONTACT_VERSION :
		return "BRUTUS_PR_CONTACT_VERSION";
	case BRUTUS_BRUTUS_PR_CONTACT_ENTRYIDS :
		return "BRUTUS_PR_CONTACT_ENTRYIDS";
	case BRUTUS_BRUTUS_PR_CONTACT_ADDRTYPES :
		return "BRUTUS_PR_CONTACT_ADDRTYPES / BRUTUS_PR_CONTACT_ADDRTYPES_A";
	case BRUTUS_BRUTUS_PR_CONTACT_ADDRTYPES_W :
		return "BRUTUS_PR_CONTACT_ADDRTYPES_W";
/*	case BRUTUS_BRUTUS_PR_CONTACT_ADDRTYPES_A : */
/*		return "BRUTUS_PR_CONTACT_ADDRTYPES_A"; */
	case BRUTUS_BRUTUS_PR_CONTACT_DEFAULT_ADDRESS_INDEX :
		return "BRUTUS_PR_CONTACT_DEFAULT_ADDRESS_INDEX";
	case BRUTUS_BRUTUS_PR_CONTACT_EMAIL_ADDRESSES :
		return "BRUTUS_PR_CONTACT_EMAIL_ADDRESSES / BRUTUS_PR_CONTACT_EMAIL_ADDRESSES_A";
	case BRUTUS_BRUTUS_PR_CONTACT_EMAIL_ADDRESSES_W :
		return "BRUTUS_PR_CONTACT_EMAIL_ADDRESSES_W";
/*	case BRUTUS_BRUTUS_PR_CONTACT_EMAIL_ADDRESSES_A : */
/*		return "BRUTUS_PR_CONTACT_EMAIL_ADDRESSES_A"; */
	case BRUTUS_BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER :
		return "BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER / BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER_A";
	case BRUTUS_BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER_W :
		return "BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER_W";
/*	case BRUTUS_BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER_A : */
/*		return "BRUTUS_PR_COMPANY_MAIN_PHONE_NUMBER_A"; */
	case BRUTUS_BRUTUS_PR_CHILDRENS_NAMES :
		return "BRUTUS_PR_CHILDRENS_NAMES / BRUTUS_PR_CHILDRENS_NAMES_A";
	case BRUTUS_BRUTUS_PR_CHILDRENS_NAMES_W :
		return "BRUTUS_PR_CHILDRENS_NAMES_W";
/*	case BRUTUS_BRUTUS_PR_CHILDRENS_NAMES_A : */
/*		return "BRUTUS_PR_CHILDRENS_NAMES_A"; */
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_CITY :
		return "BRUTUS_PR_HOME_ADDRESS_CITY / BRUTUS_PR_HOME_ADDRESS_CITY_A";
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_CITY_W :
		return "BRUTUS_PR_HOME_ADDRESS_CITY_W";
/*	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_CITY_A : */
/*		return "BRUTUS_PR_HOME_ADDRESS_CITY_A"; */
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_COUNTRY :
		return "BRUTUS_PR_HOME_ADDRESS_COUNTRY / BRUTUS_PR_HOME_ADDRESS_COUNTRY_A";
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_COUNTRY_W :
		return "BRUTUS_PR_HOME_ADDRESS_COUNTRY_W";
/*	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_COUNTRY_A : */
/*		return "BRUTUS_PR_HOME_ADDRESS_COUNTRY_A"; */
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE :
		return "BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE / BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE_A";
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE_W :
		return "BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE_W";
/*	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE_A : */
/*		return "BRUTUS_PR_HOME_ADDRESS_POSTAL_CODE_A"; */
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE :
		return "BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE / BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE_A";
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE_W :
		return "BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE_W";
/*	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE_A : */
/*		return "BRUTUS_PR_HOME_ADDRESS_STATE_OR_PROVINCE_A"; */
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_STREET :
		return "BRUTUS_PR_HOME_ADDRESS_STREET / BRUTUS_PR_HOME_ADDRESS_STREET_A";
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_STREET_W :
		return "BRUTUS_PR_HOME_ADDRESS_STREET_W";
/*	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_STREET_A : */
/*		return "BRUTUS_PR_HOME_ADDRESS_STREET_A"; */
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX :
		return "BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX / BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX_A";
	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX_W :
		return "BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX_W";
/*	case BRUTUS_BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX_A : */
/*		return "BRUTUS_PR_HOME_ADDRESS_POST_OFFICE_BOX_A"; */
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_CITY :
		return "BRUTUS_PR_OTHER_ADDRESS_CITY / BRUTUS_PR_OTHER_ADDRESS_CITY_A";
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_CITY_W :
		return "BRUTUS_PR_OTHER_ADDRESS_CITY_W";
/*	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_CITY_A : */
/*		return "BRUTUS_PR_OTHER_ADDRESS_CITY_A"; */
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_COUNTRY :
		return "BRUTUS_PR_OTHER_ADDRESS_COUNTRY / BRUTUS_PR_OTHER_ADDRESS_COUNTRY_A";
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_COUNTRY_W :
		return "BRUTUS_PR_OTHER_ADDRESS_COUNTRY_W";
/*	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_COUNTRY_A : */
/*		return "BRUTUS_PR_OTHER_ADDRESS_COUNTRY_A"; */
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE :
		return "BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE / BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE_A";
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE_W :
		return "BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE_W";
/*	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE_A : */
/*		return "BRUTUS_PR_OTHER_ADDRESS_POSTAL_CODE_A"; */
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE :
		return "BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE / BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A";
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE_W :
		return "BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE_W";
/*	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A : */
/*		return "BRUTUS_PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A"; */
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_STREET :
		return "BRUTUS_PR_OTHER_ADDRESS_STREET / BRUTUS_PR_OTHER_ADDRESS_STREET_A";
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_STREET_W :
		return "BRUTUS_PR_OTHER_ADDRESS_STREET_W";
/*	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_STREET_A : */
/*		return "BRUTUS_PR_OTHER_ADDRESS_STREET_A"; */
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX :
		return "BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX / BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX_A";
	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX_W :
		return "BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX_W";
/*	case BRUTUS_BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX_A : */
/*		return "BRUTUS_PR_OTHER_ADDRESS_POST_OFFICE_BOX_A"; */
	case BRUTUS_BRUTUS_PR_STORE_PROVIDERS :
		return "BRUTUS_PR_STORE_PROVIDERS";
	case BRUTUS_BRUTUS_PR_AB_PROVIDERS :
		return "BRUTUS_PR_AB_PROVIDERS";
	case BRUTUS_BRUTUS_PR_TRANSPORT_PROVIDERS :
		return "BRUTUS_PR_TRANSPORT_PROVIDERS";
	case BRUTUS_BRUTUS_PR_DEFAULT_PROFILE :
		return "BRUTUS_PR_DEFAULT_PROFILE";
	case BRUTUS_BRUTUS_PR_AB_SEARCH_PATH :
		return "BRUTUS_PR_AB_SEARCH_PATH";
	case BRUTUS_BRUTUS_PR_AB_DEFAULT_DIR :
		return "BRUTUS_PR_AB_DEFAULT_DIR";
	case BRUTUS_BRUTUS_PR_AB_DEFAULT_PAB :
		return "BRUTUS_PR_AB_DEFAULT_PAB";
	case BRUTUS_BRUTUS_PR_FILTERING_HOOKS :
		return "BRUTUS_PR_FILTERING_HOOKS";
	case BRUTUS_BRUTUS_PR_SERVICE_NAME :
		return "BRUTUS_PR_SERVICE_NAME / BRUTUS_PR_SERVICE_NAME_A";
	case BRUTUS_BRUTUS_PR_SERVICE_NAME_W :
		return "BRUTUS_PR_SERVICE_NAME_W";
/*	case BRUTUS_BRUTUS_PR_SERVICE_NAME_A : */
/*		return "BRUTUS_PR_SERVICE_NAME_A"; */
	case BRUTUS_BRUTUS_PR_SERVICE_DLL_NAME :
		return "BRUTUS_PR_SERVICE_DLL_NAME / BRUTUS_PR_SERVICE_DLL_NAME_A";
	case BRUTUS_BRUTUS_PR_SERVICE_DLL_NAME_W :
		return "BRUTUS_PR_SERVICE_DLL_NAME_W";
/*	case BRUTUS_BRUTUS_PR_SERVICE_DLL_NAME_A : */
/*		return "BRUTUS_PR_SERVICE_DLL_NAME_A"; */
	case BRUTUS_BRUTUS_PR_SERVICE_ENTRY_NAME :
		return "BRUTUS_PR_SERVICE_ENTRY_NAME";
	case BRUTUS_BRUTUS_PR_SERVICE_UID :
		return "BRUTUS_PR_SERVICE_UID";
	case BRUTUS_BRUTUS_PR_SERVICE_EXTRA_UIDS :
		return "BRUTUS_PR_SERVICE_EXTRA_UIDS";
	case BRUTUS_BRUTUS_PR_SERVICES :
		return "BRUTUS_PR_SERVICES";
	case BRUTUS_BRUTUS_PR_SERVICE_SUPPORT_FILES :
		return "BRUTUS_PR_SERVICE_SUPPORT_FILES / BRUTUS_PR_SERVICE_SUPPORT_FILES_A";
	case BRUTUS_BRUTUS_PR_SERVICE_SUPPORT_FILES_W :
		return "BRUTUS_PR_SERVICE_SUPPORT_FILES_W";
/*	case BRUTUS_BRUTUS_PR_SERVICE_SUPPORT_FILES_A : */
/*		return "BRUTUS_PR_SERVICE_SUPPORT_FILES_A"; */
	case BRUTUS_BRUTUS_PR_SERVICE_DELETE_FILES :
		return "BRUTUS_PR_SERVICE_DELETE_FILES / BRUTUS_PR_SERVICE_DELETE_FILES_A";
	case BRUTUS_BRUTUS_PR_SERVICE_DELETE_FILES_W :
		return "BRUTUS_PR_SERVICE_DELETE_FILES_W";
/*	case BRUTUS_BRUTUS_PR_SERVICE_DELETE_FILES_A : */
/*		return "BRUTUS_PR_SERVICE_DELETE_FILES_A"; */
	case BRUTUS_BRUTUS_PR_AB_SEARCH_PATH_UPDATE :
		return "BRUTUS_PR_AB_SEARCH_PATH_UPDATE";
	case BRUTUS_BRUTUS_PR_PROFILE_NAME :
		return "BRUTUS_PR_PROFILE_NAME / BRUTUS_PR_PROFILE_NAME_A";
/*	case BRUTUS_BRUTUS_PR_PROFILE_NAME_A : */
/*		return "BRUTUS_PR_PROFILE_NAME_A"; */
	case BRUTUS_BRUTUS_PR_PROFILE_NAME_W :
		return "BRUTUS_PR_PROFILE_NAME_W";
	case BRUTUS_BRUTUS_PR_IDENTITY_DISPLAY :
		return "BRUTUS_PR_IDENTITY_DISPLAY / BRUTUS_PR_IDENTITY_DISPLAY_A";
	case BRUTUS_BRUTUS_PR_IDENTITY_DISPLAY_W :
		return "BRUTUS_PR_IDENTITY_DISPLAY_W";
/*	case BRUTUS_BRUTUS_PR_IDENTITY_DISPLAY_A : */
/*		return "BRUTUS_PR_IDENTITY_DISPLAY_A"; */
	case BRUTUS_BRUTUS_PR_IDENTITY_ENTRYID :
		return "BRUTUS_PR_IDENTITY_ENTRYID";
	case BRUTUS_BRUTUS_PR_RESOURCE_METHODS :
		return "BRUTUS_PR_RESOURCE_METHODS";
	case BRUTUS_BRUTUS_PR_RESOURCE_TYPE :
		return "BRUTUS_PR_RESOURCE_TYPE";
	case BRUTUS_BRUTUS_PR_STATUS_CODE :
		return "BRUTUS_PR_STATUS_CODE";
	case BRUTUS_BRUTUS_PR_IDENTITY_SEARCH_KEY :
		return "BRUTUS_PR_IDENTITY_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_OWN_STORE_ENTRYID :
		return "BRUTUS_PR_OWN_STORE_ENTRYID";
	case BRUTUS_BRUTUS_PR_RESOURCE_PATH :
		return "BRUTUS_PR_RESOURCE_PATH / BRUTUS_PR_RESOURCE_PATH_A";
	case BRUTUS_BRUTUS_PR_RESOURCE_PATH_W :
		return "BRUTUS_PR_RESOURCE_PATH_W";
/*	case BRUTUS_BRUTUS_PR_RESOURCE_PATH_A : */
/*		return "BRUTUS_PR_RESOURCE_PATH_A"; */
	case BRUTUS_BRUTUS_PR_STATUS_STRING :
		return "BRUTUS_PR_STATUS_STRING / BRUTUS_PR_STATUS_STRING_A";
	case BRUTUS_BRUTUS_PR_STATUS_STRING_W :
		return "BRUTUS_PR_STATUS_STRING_W";
/*	case BRUTUS_BRUTUS_PR_STATUS_STRING_A : */
/*		return "BRUTUS_PR_STATUS_STRING_A"; */
	case BRUTUS_BRUTUS_PR_X400_DEFERRED_DELIVERY_CANCEL :
		return "BRUTUS_PR_X400_DEFERRED_DELIVERY_CANCEL";
	case BRUTUS_BRUTUS_PR_HEADER_FOLDER_ENTRYID :
		return "BRUTUS_PR_HEADER_FOLDER_ENTRYID";
	case BRUTUS_BRUTUS_PR_REMOTE_PROGRESS :
		return "BRUTUS_PR_REMOTE_PROGRESS";
	case BRUTUS_BRUTUS_PR_REMOTE_PROGRESS_TEXT :
		return "BRUTUS_PR_REMOTE_PROGRESS_TEXT / BRUTUS_PR_REMOTE_PROGRESS_TEXT_A";
	case BRUTUS_BRUTUS_PR_REMOTE_PROGRESS_TEXT_W :
		return "BRUTUS_PR_REMOTE_PROGRESS_TEXT_W";
/*	case BRUTUS_BRUTUS_PR_REMOTE_PROGRESS_TEXT_A : */
/*		return "BRUTUS_PR_REMOTE_PROGRESS_TEXT_A"; */
	case BRUTUS_BRUTUS_PR_REMOTE_VALIDATE_OK :
		return "BRUTUS_PR_REMOTE_VALIDATE_OK";
	case BRUTUS_BRUTUS_PR_CONTROL_FLAGS :
		return "BRUTUS_PR_CONTROL_FLAGS";
	case BRUTUS_BRUTUS_PR_CONTROL_STRUCTURE :
		return "BRUTUS_PR_CONTROL_STRUCTURE";
	case BRUTUS_BRUTUS_PR_CONTROL_TYPE :
		return "BRUTUS_PR_CONTROL_TYPE";
	case BRUTUS_BRUTUS_PR_DELTAX :
		return "BRUTUS_PR_DELTAX";
	case BRUTUS_BRUTUS_PR_DELTAY :
		return "BRUTUS_PR_DELTAY";
	case BRUTUS_BRUTUS_PR_XPOS :
		return "BRUTUS_PR_XPOS";
	case BRUTUS_BRUTUS_PR_YPOS :
		return "BRUTUS_PR_YPOS";
	case BRUTUS_BRUTUS_PR_CONTROL_ID :
		return "BRUTUS_PR_CONTROL_ID";
	case BRUTUS_BRUTUS_PR_INITIAL_DETAILS_PANE :
		return "BRUTUS_PR_INITIAL_DETAILS_PANE";
	case BRUTUS_BRUTUS_PR_PROFILE_VERSION :
		return "BRUTUS_PR_PROFILE_VERSION";
	case BRUTUS_BRUTUS_PR_PROFILE_CONFIG_FLAGS :
		return "BRUTUS_PR_PROFILE_CONFIG_FLAGS";
	case BRUTUS_BRUTUS_PR_PROFILE_HOME_SERVER :
		return "BRUTUS_PR_PROFILE_HOME_SERVER";
	case BRUTUS_BRUTUS_PR_PROFILE_HOME_SERVER_DN :
		return "BRUTUS_PR_PROFILE_HOME_SERVER_DN";
	case BRUTUS_BRUTUS_PR_PROFILE_HOME_SERVER_ADDRS :
		return "BRUTUS_PR_PROFILE_HOME_SERVER_ADDRS";
	case BRUTUS_BRUTUS_PR_PROFILE_USER :
		return "BRUTUS_PR_PROFILE_USER";
	case BRUTUS_BRUTUS_PR_PROFILE_CONNECT_FLAGS :
		return "BRUTUS_PR_PROFILE_CONNECT_FLAGS";
	case BRUTUS_BRUTUS_PR_PROFILE_TRANSPORT_FLAGS :
		return "BRUTUS_PR_PROFILE_TRANSPORT_FLAGS";
	case BRUTUS_BRUTUS_PR_PROFILE_UI_STATE :
		return "BRUTUS_PR_PROFILE_UI_STATE";
	case BRUTUS_BRUTUS_PR_PROFILE_UNRESOLVED_NAME :
		return "BRUTUS_PR_PROFILE_UNRESOLVED_NAME";
	case BRUTUS_BRUTUS_PR_PROFILE_UNRESOLVED_SERVER :
		return "BRUTUS_PR_PROFILE_UNRESOLVED_SERVER";
	case BRUTUS_BRUTUS_PR_PROFILE_BINDING_ORDER :
		return "BRUTUS_PR_PROFILE_BINDING_ORDER";
	case BRUTUS_BRUTUS_PR_PROFILE_MAX_RESTRICT :
		return "BRUTUS_PR_PROFILE_MAX_RESTRICT";
	case BRUTUS_BRUTUS_PR_PROFILE_AB_FILES_PATH :
		return "BRUTUS_PR_PROFILE_AB_FILES_PATH";
	case BRUTUS_BRUTUS_PR_PROFILE_OFFLINE_STORE_PATH :
		return "BRUTUS_PR_PROFILE_OFFLINE_STORE_PATH";
	case BRUTUS_BRUTUS_PR_PROFILE_OFFLINE_INFO :
		return "BRUTUS_PR_PROFILE_OFFLINE_INFO";
	case BRUTUS_BRUTUS_PR_PROFILE_ADDR_INFO :
		return "BRUTUS_PR_PROFILE_ADDR_INFO";
	case BRUTUS_BRUTUS_PR_PROFILE_OPTIONS_DATA :
		return "BRUTUS_PR_PROFILE_OPTIONS_DATA";
	case BRUTUS_BRUTUS_PR_PROFILE_SECURE_MAILBOX :
		return "BRUTUS_PR_PROFILE_SECURE_MAILBOX";
	case BRUTUS_BRUTUS_PR_DISABLE_WINSOCK :
		return "BRUTUS_PR_DISABLE_WINSOCK";
	case BRUTUS_BRUTUS_PR_OST_ENCRYPTION :
		return "BRUTUS_PR_OST_ENCRYPTION";
	case BRUTUS_BRUTUS_PR_PROFILE_OPEN_FLAGS :
		return "BRUTUS_PR_PROFILE_OPEN_FLAGS";
	case BRUTUS_BRUTUS_PR_PROFILE_TYPE :
		return "BRUTUS_PR_PROFILE_TYPE";
	case BRUTUS_BRUTUS_PR_PROFILE_MAILBOX :
		return "BRUTUS_PR_PROFILE_MAILBOX";
	case BRUTUS_BRUTUS_PR_PROFILE_SERVER :
		return "BRUTUS_PR_PROFILE_SERVER";
	case BRUTUS_BRUTUS_PR_PROFILE_SERVER_DN :
		return "BRUTUS_PR_PROFILE_SERVER_DN";
	case BRUTUS_BRUTUS_PR_PROFILE_FAVFLD_DISPLAY_NAME :
		return "BRUTUS_PR_PROFILE_FAVFLD_DISPLAY_NAME";
	case BRUTUS_BRUTUS_PR_PROFILE_FAVFLD_COMMENT :
		return "BRUTUS_PR_PROFILE_FAVFLD_COMMENT";
	case BRUTUS_BRUTUS_PR_PROFILE_ALLPUB_DISPLAY_NAME :
		return "BRUTUS_PR_PROFILE_ALLPUB_DISPLAY_NAME";
	case BRUTUS_BRUTUS_PR_PROFILE_ALLPUB_COMMENT :
		return "BRUTUS_PR_PROFILE_ALLPUB_COMMENT";
	case BRUTUS_BRUTUS_PR_USER_ENTRYID :
		return "BRUTUS_PR_USER_ENTRYID";
	case BRUTUS_BRUTUS_PR_USER_NAME :
		return "BRUTUS_PR_USER_NAME";
	case BRUTUS_BRUTUS_PR_MAILBOX_OWNER_ENTRYID :
		return "BRUTUS_PR_MAILBOX_OWNER_ENTRYID";
	case BRUTUS_BRUTUS_PR_MAILBOX_OWNER_NAME :
		return "BRUTUS_PR_MAILBOX_OWNER_NAME";
	case BRUTUS_BRUTUS_PR_OOF_STATE :
		return "BRUTUS_PR_OOF_STATE";
	case BRUTUS_BRUTUS_PR_HIERARCHY_SERVER :
		return "BRUTUS_PR_HIERARCHY_SERVER";
	case BRUTUS_BRUTUS_PR_SCHEDULE_FOLDER_ENTRYID :
		return "BRUTUS_PR_SCHEDULE_FOLDER_ENTRYID";
	case BRUTUS_BRUTUS_PR_IPM_DAF_ENTRYID :
		return "BRUTUS_PR_IPM_DAF_ENTRYID";
	case BRUTUS_BRUTUS_PR_NON_IPM_SUBTREE_ENTRYID :
		return "BRUTUS_PR_NON_IPM_SUBTREE_ENTRYID";
	case BRUTUS_BRUTUS_PR_EFORMS_REGISTRY_ENTRYID :
		return "BRUTUS_PR_EFORMS_REGISTRY_ENTRYID";
	case BRUTUS_BRUTUS_PR_SPLUS_FREE_BUSY_ENTRYID :
		return "BRUTUS_PR_SPLUS_FREE_BUSY_ENTRYID";
	case BRUTUS_BRUTUS_PR_OFFLINE_ADDRBOOK_ENTRYID :
		return "BRUTUS_PR_OFFLINE_ADDRBOOK_ENTRYID";
	case BRUTUS_BRUTUS_PR_EFORMS_FOR_LOCALE_ENTRYID :
		return "BRUTUS_PR_EFORMS_FOR_LOCALE_ENTRYID";
	case BRUTUS_BRUTUS_PR_FREE_BUSY_FOR_LOCAL_SITE_ENTRYID :
		return "BRUTUS_PR_FREE_BUSY_FOR_LOCAL_SITE_ENTRYID";
	case BRUTUS_BRUTUS_PR_ADDRBOOK_FOR_LOCAL_SITE_ENTRYID :
		return "BRUTUS_PR_ADDRBOOK_FOR_LOCAL_SITE_ENTRYID";
	case BRUTUS_BRUTUS_PR_OFFLINE_MESSAGE_ENTRYID :
		return "BRUTUS_PR_OFFLINE_MESSAGE_ENTRYID";
	case BRUTUS_BRUTUS_PR_IPM_FAVORITES_ENTRYID :
		return "BRUTUS_PR_IPM_FAVORITES_ENTRYID";
	case BRUTUS_BRUTUS_PR_IPM_PUBLIC_FOLDERS_ENTRYID :
		return "BRUTUS_PR_IPM_PUBLIC_FOLDERS_ENTRYID";
	case BRUTUS_BRUTUS_PR_GW_MTSIN_ENTRYID :
		return "BRUTUS_PR_GW_MTSIN_ENTRYID";
	case BRUTUS_BRUTUS_PR_GW_MTSOUT_ENTRYID :
		return "BRUTUS_PR_GW_MTSOUT_ENTRYID";
	case BRUTUS_BRUTUS_PR_TRANSFER_ENABLED :
		return "BRUTUS_PR_TRANSFER_ENABLED";
	case BRUTUS_BRUTUS_PR_TEST_LINE_SPEED :
		return "BRUTUS_PR_TEST_LINE_SPEED";
	case BRUTUS_BRUTUS_PR_HIERARCHY_SYNCHRONIZER :
		return "BRUTUS_PR_HIERARCHY_SYNCHRONIZER";
	case BRUTUS_BRUTUS_PR_CONTENTS_SYNCHRONIZER :
		return "BRUTUS_PR_CONTENTS_SYNCHRONIZER";
	case BRUTUS_BRUTUS_PR_COLLECTOR :
		return "BRUTUS_PR_COLLECTOR";
	case BRUTUS_BRUTUS_PR_FAST_TRANSFER :
		return "BRUTUS_PR_FAST_TRANSFER";
	case BRUTUS_BRUTUS_PR_STORE_OFFLINE :
		return "BRUTUS_PR_STORE_OFFLINE";
	case BRUTUS_BRUTUS_PR_IN_TRANSIT :
		return "BRUTUS_PR_IN_TRANSIT";
	case BRUTUS_BRUTUS_PR_REPLICATION_STYLE :
		return "BRUTUS_PR_REPLICATION_STYLE";
	case BRUTUS_BRUTUS_PR_REPLICATION_SCHEDULE :
		return "BRUTUS_PR_REPLICATION_SCHEDULE";
	case BRUTUS_BRUTUS_PR_REPLICATION_MESSAGE_PRIORITY :
		return "BRUTUS_PR_REPLICATION_MESSAGE_PRIORITY";
	case BRUTUS_BRUTUS_PR_OVERALL_MSG_AGE_LIMIT :
		return "BRUTUS_PR_OVERALL_MSG_AGE_LIMIT";
	case BRUTUS_BRUTUS_PR_REPLICATION_ALWAYS_INTERVAL :
		return "BRUTUS_PR_REPLICATION_ALWAYS_INTERVAL";
	case BRUTUS_BRUTUS_PR_REPLICATION_MSG_SIZE :
		return "BRUTUS_PR_REPLICATION_MSG_SIZE";
	case BRUTUS_BRUTUS_PR_SOURCE_KEY :
		return "BRUTUS_PR_SOURCE_KEY";
	case BRUTUS_BRUTUS_PR_PARENT_SOURCE_KEY :
		return "BRUTUS_PR_PARENT_SOURCE_KEY";
	case BRUTUS_BRUTUS_PR_CHANGE_KEY :
		return "BRUTUS_PR_CHANGE_KEY";
	case BRUTUS_BRUTUS_PR_PREDECESSOR_CHANGE_LIST :
		return "BRUTUS_PR_PREDECESSOR_CHANGE_LIST";
	case BRUTUS_BRUTUS_PR_FOLDER_CHILD_COUNT :
		return "BRUTUS_PR_FOLDER_CHILD_COUNT";
	case BRUTUS_BRUTUS_PR_RIGHTS :
		return "BRUTUS_PR_RIGHTS";
	case BRUTUS_BRUTUS_PR_ACL_TABLE :
		return "BRUTUS_PR_ACL_TABLE";
	case BRUTUS_BRUTUS_PR_RULES_TABLE :
		return "BRUTUS_PR_RULES_TABLE";
	case BRUTUS_BRUTUS_PR_HAS_RULES :
		return "BRUTUS_PR_HAS_RULES";
	case BRUTUS_BRUTUS_PR_ADDRESS_BOOK_ENTRYID :
		return "BRUTUS_PR_ADDRESS_BOOK_ENTRYID";
	case BRUTUS_BRUTUS_PR_ACL_DATA :
		return "BRUTUS_PR_ACL_DATA";
	case BRUTUS_BRUTUS_PR_RULES_DATA :
		return "BRUTUS_PR_RULES_DATA";
	case BRUTUS_BRUTUS_PR_FOLDER_DESIGN_FLAGS :
		return "BRUTUS_PR_FOLDER_DESIGN_FLAGS";
	case BRUTUS_BRUTUS_PR_DESIGN_IN_PROGRESS :
		return "BRUTUS_PR_DESIGN_IN_PROGRESS";
	case BRUTUS_BRUTUS_PR_SECURE_ORIGINATION :
		return "BRUTUS_PR_SECURE_ORIGINATION";
	case BRUTUS_BRUTUS_PR_PUBLISH_IN_ADDRESS_BOOK :
		return "BRUTUS_PR_PUBLISH_IN_ADDRESS_BOOK";
	case BRUTUS_BRUTUS_PR_RESOLVE_METHOD :
		return "BRUTUS_PR_RESOLVE_METHOD";
	case BRUTUS_BRUTUS_PR_ADDRESS_BOOK_DISPLAY_NAME :
		return "BRUTUS_PR_ADDRESS_BOOK_DISPLAY_NAME";
	case BRUTUS_BRUTUS_PR_EFORMS_LOCALE_ID :
		return "BRUTUS_PR_EFORMS_LOCALE_ID";
	case BRUTUS_BRUTUS_PR_REPLICA_LIST :
		return "BRUTUS_PR_REPLICA_LIST";
	case BRUTUS_BRUTUS_PR_OVERALL_AGE_LIMIT :
		return "BRUTUS_PR_OVERALL_AGE_LIMIT";
	case BRUTUS_BRUTUS_PR_PUBLIC_FOLDER_ENTRYID :
		return "BRUTUS_PR_PUBLIC_FOLDER_ENTRYID";
	case BRUTUS_BRUTUS_PR_HAS_NAMED_PROPERTIES :
		return "BRUTUS_PR_HAS_NAMED_PROPERTIES";
	case BRUTUS_BRUTUS_PR_CREATOR_NAME :
		return "BRUTUS_PR_CREATOR_NAME";
	case BRUTUS_BRUTUS_PR_CREATOR_ENTRYID :
		return "BRUTUS_PR_CREATOR_ENTRYID";
	case BRUTUS_BRUTUS_PR_LAST_MODIFIER_NAME :
		return "BRUTUS_PR_LAST_MODIFIER_NAME";
	case BRUTUS_BRUTUS_PR_LAST_MODIFIER_ENTRYID :
		return "BRUTUS_PR_LAST_MODIFIER_ENTRYID";
	case BRUTUS_BRUTUS_PR_HAS_DAMS :
		return "BRUTUS_PR_HAS_DAMS";
	case BRUTUS_BRUTUS_PR_RULE_TRIGGER_HISTORY :
		return "BRUTUS_PR_RULE_TRIGGER_HISTORY";
	case BRUTUS_BRUTUS_PR_MOVE_TO_STORE_ENTRYID :
		return "BRUTUS_PR_MOVE_TO_STORE_ENTRYID";
	case BRUTUS_BRUTUS_PR_MOVE_TO_FOLDER_ENTRYID :
		return "BRUTUS_PR_MOVE_TO_FOLDER_ENTRYID";
	case BRUTUS_BRUTUS_PR_REPLICA_SERVER :
		return "BRUTUS_PR_REPLICA_SERVER";
	case BRUTUS_BRUTUS_PR_DEFERRED_SEND_NUMBER :
		return "BRUTUS_PR_DEFERRED_SEND_NUMBER";
	case BRUTUS_BRUTUS_PR_DEFERRED_SEND_UNITS :
		return "BRUTUS_PR_DEFERRED_SEND_UNITS";
	case BRUTUS_BRUTUS_PR_EXPIRY_NUMBER :
		return "BRUTUS_PR_EXPIRY_NUMBER";
	case BRUTUS_BRUTUS_PR_EXPIRY_UNITS :
		return "BRUTUS_PR_EXPIRY_UNITS";
	case BRUTUS_BRUTUS_PR_DEFERRED_SEND_TIME :
		return "BRUTUS_PR_DEFERRED_SEND_TIME";
	case BRUTUS_BRUTUS_PR_GW_ADMIN_OPERATIONS :
		return "BRUTUS_PR_GW_ADMIN_OPERATIONS";
	case BRUTUS_BRUTUS_PR_P1_CONTENT :
		return "BRUTUS_PR_P1_CONTENT";
	case BRUTUS_BRUTUS_PR_P1_CONTENT_TYPE :
		return "BRUTUS_PR_P1_CONTENT_TYPE";
	case BRUTUS_BRUTUS_PR_CLIENT_ACTIONS :
		return "BRUTUS_PR_CLIENT_ACTIONS";
	case BRUTUS_BRUTUS_PR_DAM_ORIGINAL_ENTRYID :
		return "BRUTUS_PR_DAM_ORIGINAL_ENTRYID";
	case BRUTUS_BRUTUS_PR_DAM_BACK_PATCHED :
		return "BRUTUS_PR_DAM_BACK_PATCHED";
	case BRUTUS_BRUTUS_PR_RULE_ERROR :
		return "BRUTUS_PR_RULE_ERROR";
	case BRUTUS_BRUTUS_PR_RULE_ACTION_TYPE :
		return "BRUTUS_PR_RULE_ACTION_TYPE";
	case BRUTUS_BRUTUS_PR_RULE_ACTION_NUMBER :
		return "BRUTUS_PR_RULE_ACTION_NUMBER";
	case BRUTUS_BRUTUS_PR_RULE_FOLDER_ENTRYID :
		return "BRUTUS_PR_RULE_FOLDER_ENTRYID";
	case BRUTUS_BRUTUS_PR_CONFLICT_ENTRYID :
		return "BRUTUS_PR_CONFLICT_ENTRYID";
	case BRUTUS_BRUTUS_PR_MESSAGE_LOCALE_ID :
		return "BRUTUS_PR_MESSAGE_LOCALE_ID";
	case BRUTUS_BRUTUS_PR_STORAGE_QUOTA_LIMIT :
		return "BRUTUS_PR_STORAGE_QUOTA_LIMIT";
	case BRUTUS_BRUTUS_PR_EXCESS_STORAGE_USED :
		return "BRUTUS_PR_EXCESS_STORAGE_USED";
	case BRUTUS_BRUTUS_PR_SVR_GENERATING_QUOTA_MSG :
		return "BRUTUS_PR_SVR_GENERATING_QUOTA_MSG";
	case BRUTUS_BRUTUS_PR_DELEGATED_BY_RULE :
		return "BRUTUS_PR_DELEGATED_BY_RULE";
	case BRUTUS_BRUTUS_PR_IN_CONFLICT :
		return "BRUTUS_PR_IN_CONFLICT";
	case BRUTUS_BRUTUS_PR_LONGTERM_ENTRYID_FROM_TABLE :
		return "BRUTUS_PR_LONGTERM_ENTRYID_FROM_TABLE";
	case BRUTUS_BRUTUS_PR_ORIGINATOR_NAME :
		return "BRUTUS_PR_ORIGINATOR_NAME";
	case BRUTUS_BRUTUS_PR_ORIGINATOR_ADDR :
		return "BRUTUS_PR_ORIGINATOR_ADDR";
	case BRUTUS_BRUTUS_PR_ORIGINATOR_ADDRTYPE :
		return "BRUTUS_PR_ORIGINATOR_ADDRTYPE";
	case BRUTUS_BRUTUS_PR_ORIGINATOR_ENTRYID :
		return "BRUTUS_PR_ORIGINATOR_ENTRYID";
	case BRUTUS_BRUTUS_PR_ARRIVAL_TIME :
		return "BRUTUS_PR_ARRIVAL_TIME";
	case BRUTUS_BRUTUS_PR_TRACE_INFO :
		return "BRUTUS_PR_TRACE_INFO";
	case BRUTUS_BRUTUS_PR_INTERNAL_TRACE_INFO :
		return "BRUTUS_PR_INTERNAL_TRACE_INFO";
	case BRUTUS_BRUTUS_PR_SUBJECT_TRACE_INFO :
		return "BRUTUS_PR_SUBJECT_TRACE_INFO";
	case BRUTUS_BRUTUS_PR_RECIPIENT_NUMBER :
		return "BRUTUS_PR_RECIPIENT_NUMBER";
	case BRUTUS_BRUTUS_PR_MTS_SUBJECT_ID :
		return "BRUTUS_PR_MTS_SUBJECT_ID";
	case BRUTUS_BRUTUS_PR_REPORT_DESTINATION_NAME :
		return "BRUTUS_PR_REPORT_DESTINATION_NAME";
	case BRUTUS_BRUTUS_PR_REPORT_DESTINATION_ENTRYID :
		return "BRUTUS_PR_REPORT_DESTINATION_ENTRYID";
	case BRUTUS_BRUTUS_PR_CONTENT_SEARCH_KEY :
		return "BRUTUS_PR_CONTENT_SEARCH_KEY";
	case BRUTUS_BRUTUS_PR_FOREIGN_ID :
		return "BRUTUS_PR_FOREIGN_ID";
	case BRUTUS_BRUTUS_PR_FOREIGN_REPORT_ID :
		return "BRUTUS_PR_FOREIGN_REPORT_ID";
	case BRUTUS_BRUTUS_PR_FOREIGN_SUBJECT_ID :
		return "BRUTUS_PR_FOREIGN_SUBJECT_ID";
	case BRUTUS_BRUTUS_PR_MEMBER_ID :
		return "BRUTUS_PR_MEMBER_ID";
	case BRUTUS_BRUTUS_PR_MEMBER_NAME :
		return "BRUTUS_PR_MEMBER_NAME";
	case BRUTUS_BRUTUS_PR_MEMBER_RIGHTS :
		return "BRUTUS_PR_MEMBER_RIGHTS";
	case BRUTUS_BRUTUS_PR_RULE_ID :
		return "BRUTUS_PR_RULE_ID";
	case BRUTUS_BRUTUS_PR_RULE_IDS :
		return "BRUTUS_PR_RULE_IDS";
	case BRUTUS_BRUTUS_PR_RULE_SEQUENCE :
		return "BRUTUS_PR_RULE_SEQUENCE";
	case BRUTUS_BRUTUS_PR_RULE_STATE :
		return "BRUTUS_PR_RULE_STATE";
	case BRUTUS_BRUTUS_PR_RULE_USER_FLAGS :
		return "BRUTUS_PR_RULE_USER_FLAGS";
	case BRUTUS_BRUTUS_PR_RULE_CONDITION :
		return "BRUTUS_PR_RULE_CONDITION";
	case BRUTUS_BRUTUS_PR_RULE_ACTIONS :
		return "BRUTUS_PR_RULE_ACTIONS";
	case BRUTUS_BRUTUS_PR_RULE_PROVIDER :
		return "BRUTUS_PR_RULE_PROVIDER";
	case BRUTUS_BRUTUS_PR_RULE_NAME :
		return "BRUTUS_PR_RULE_NAME";
	case BRUTUS_BRUTUS_PR_RULE_LEVEL :
		return "BRUTUS_PR_RULE_LEVEL";
	case BRUTUS_BRUTUS_PR_RULE_PROVIDER_DATA :
		return "BRUTUS_PR_RULE_PROVIDER_DATA";
	case BRUTUS_BRUTUS_PR_NT_USER_NAME :
		return "BRUTUS_PR_NT_USER_NAME";
	case BRUTUS_BRUTUS_PR_LOCALE_ID :
		return "BRUTUS_PR_LOCALE_ID";
	case BRUTUS_BRUTUS_PR_LAST_LOGON_TIME :
		return "BRUTUS_PR_LAST_LOGON_TIME";
	case BRUTUS_BRUTUS_PR_LAST_LOGOFF_TIME :
		return "BRUTUS_PR_LAST_LOGOFF_TIME";
	case BRUTUS_BRUTUS_PR_STORAGE_LIMIT_INFORMATION :
		return "BRUTUS_PR_STORAGE_LIMIT_INFORMATION";
	case BRUTUS_BRUTUS_PR_FOLDER_FLAGS :
		return "BRUTUS_PR_FOLDER_FLAGS";
	case BRUTUS_BRUTUS_PR_LAST_ACCESS_TIME :
		return "BRUTUS_PR_LAST_ACCESS_TIME";
	case BRUTUS_BRUTUS_PR_RESTRICTION_COUNT :
		return "BRUTUS_PR_RESTRICTION_COUNT";
	case BRUTUS_BRUTUS_PR_CATEG_COUNT :
		return "BRUTUS_PR_CATEG_COUNT";
	case BRUTUS_BRUTUS_PR_CACHED_COLUMN_COUNT :
		return "BRUTUS_PR_CACHED_COLUMN_COUNT";
	case BRUTUS_BRUTUS_PR_NORMAL_MSG_W_ATTACH_COUNT :
		return "BRUTUS_PR_NORMAL_MSG_W_ATTACH_COUNT";
	case BRUTUS_BRUTUS_PR_ASSOC_MSG_W_ATTACH_COUNT :
		return "BRUTUS_PR_ASSOC_MSG_W_ATTACH_COUNT";
	case BRUTUS_BRUTUS_PR_RECIPIENT_ON_NORMAL_MSG_COUNT :
		return "BRUTUS_PR_RECIPIENT_ON_NORMAL_MSG_COUNT";
	case BRUTUS_BRUTUS_PR_RECIPIENT_ON_ASSOC_MSG_COUNT :
		return "BRUTUS_PR_RECIPIENT_ON_ASSOC_MSG_COUNT";
	case BRUTUS_BRUTUS_PR_ATTACH_ON_NORMAL_MSG_COUNT :
		return "BRUTUS_PR_ATTACH_ON_NORMAL_MSG_COUNT";
	case BRUTUS_BRUTUS_PR_ATTACH_ON_ASSOC_MSG_COUNT :
		return "BRUTUS_PR_ATTACH_ON_ASSOC_MSG_COUNT";
	case BRUTUS_BRUTUS_PR_NORMAL_MESSAGE_SIZE :
		return "BRUTUS_PR_NORMAL_MESSAGE_SIZE";
	case BRUTUS_BRUTUS_PR_NORMAL_MESSAGE_SIZE_EXTENDED :
		return "BRUTUS_PR_NORMAL_MESSAGE_SIZE_EXTENDED";
	case BRUTUS_BRUTUS_PR_ASSOC_MESSAGE_SIZE :
		return "BRUTUS_PR_ASSOC_MESSAGE_SIZE";
	case BRUTUS_BRUTUS_PR_ASSOC_MESSAGE_SIZE_EXTENDED :
		return "BRUTUS_PR_ASSOC_MESSAGE_SIZE_EXTENDED";
	case BRUTUS_BRUTUS_PR_FOLDER_PATHNAME :
		return "BRUTUS_PR_FOLDER_PATHNAME";
	case BRUTUS_BRUTUS_PR_OWNER_COUNT :
		return "BRUTUS_PR_OWNER_COUNT";
	case BRUTUS_BRUTUS_PR_CONTACT_COUNT :
		return "BRUTUS_PR_CONTACT_COUNT";
	case BRUTUS_BRUTUS_PR_MESSAGE_SIZE_EXTENDED :
		return "BRUTUS_PR_MESSAGE_SIZE_EXTENDED";
	case BRUTUS_BRUTUS_PR_OFFLINE_FLAGS :
		return "BRUTUS_PR_OFFLINE_FLAGS";
	case BRUTUS_BRUTUS_PR_SYNCHRONIZE_FLAGS :
		return "BRUTUS_PR_SYNCHRONIZE_FLAGS";
	case BRUTUS_BRUTUS_PR_DELETED_MESSAGE_SIZE_EXTENDED :
		return "BRUTUS_PR_DELETED_MESSAGE_SIZE_EXTENDED";
	case BRUTUS_BRUTUS_PR_DELETED_NORMAL_MESSAGE_SIZE_EXTENDED :
		return "BRUTUS_PR_DELETED_NORMAL_MESSAGE_SIZE_EXTENDED";
	case BRUTUS_BRUTUS_PR_DELETED_ASSOC_MESSAGE_SIZE_EXTENDED :
		return "BRUTUS_PR_DELETED_ASSOC_MESSAGE_SIZE_EXTENDED";
	case BRUTUS_BRUTUS_PR_DELETED_MSG_COUNT :
		return "BRUTUS_PR_DELETED_MSG_COUNT";
	case BRUTUS_BRUTUS_PR_DELETED_ASSOC_MSG_COUNT :
		return "BRUTUS_PR_DELETED_ASSOC_MSG_COUNT";
	case BRUTUS_BRUTUS_PR_CODE_PAGE_ID :
		return "BRUTUS_PR_CODE_PAGE_ID";
	case BRUTUS_BRUTUS_PR_SORT_LOCALE_ID :
		return "BRUTUS_PR_SORT_LOCALE_ID";
	case BRUTUS_BRUTUS_PR_DELETED_FOLDER_COUNT :
		return "BRUTUS_PR_DELETED_FOLDER_COUNT";
	case BRUTUS_BRUTUS_PR_EXTENDED_ACL_DATA :
		return "BRUTUS_PR_EXTENDED_ACL_DATA";
	case BRUTUS_BRUTUS_PR_INTERNET_ARTICLE_NUMBER :
		return "BRUTUS_PR_INTERNET_ARTICLE_NUMBER";
	case BRUTUS_BRUTUS_PR_REPLICA_VERSION :
		return "BRUTUS_PR_REPLICA_VERSION";
	case BRUTUS_BRUTUS_PR_SMTP_ADDRESS :
		return "BRUTUS_PR_SMTP_ADDRESS";
	/*
	 * The following are only valid for address book entries
	 */
	case BRUTUS_BRUTUS_PR_EMS_AB_SERVER :
		return "BRUTUS_PR_EMS_AB_SERVER";
	case BRUTUS_BRUTUS_PR_EMS_AB_OBJ_DIST_NAME :
		return "BRUTUS_PR_EMS_AB_OBJ_DIST_NAME";
	case BRUTUS_BRUTUS_PR_EMS_AB_HIERARCHY_PATH :
		return "BRUTUS_PR_EMS_AB_HIERARCHY_PATH";
	case BRUTUS_BRUTUS_PR_EMS_AB_DESCRIPTION :
		return "BRUTUS_PR_EMS_AB_DESCRIPTION";
	case BRUTUS_BRUTUS_PR_EMS_AB_INSTANCE_TYPE :
		return "BRUTUS_PR_EMS_AB_INSTANCE_TYPE";
	case BRUTUS_BRUTUS_PR_EMS_AB_USN_CREATED :
		return "BRUTUS_PR_EMS_AB_USN_CREATED";
	case BRUTUS_BRUTUS_PR_EMS_AB_IS_MEMBER_OF_DL :
		return "BRUTUS_PR_EMS_AB_IS_MEMBER_OF_DL";
	case BRUTUS_BRUTUS_PR_EMS_AB_USN_CHANGED :
		return "BRUTUS_PR_EMS_AB_USN_CHANGED";
	case BRUTUS_BRUTUS_PR_EMS_AB_HOME_MTA :
		return "BRUTUS_PR_EMS_AB_HOME_MTA";
	case BRUTUS_BRUTUS_PR_EMS_AB_PROXY_ADDRESSES :
		return "BRUTUS_PR_EMS_AB_PROXY_ADDRESSES";
	case BRUTUS_BRUTUS_PR_EMS_AB_HOME_MDB_O :
		return "BRUTUS_PR_EMS_AB_HOME_MDB_O";
	case BRUTUS_BRUTUS_PR_EMS_AB_HOME_MDB :
		return "BRUTUS_PR_EMS_AB_HOME_MDB";
	case BRUTUS_BRUTUS_PR_EMS_AB_MDB_USE_DEFAULTS :
		return "BRUTUS_PR_EMS_AB_MDB_USE_DEFAULTS";
	case BRUTUS_BRUTUS_PR_EMS_AB_ASSOC_NT_ACCOUNT :
		return "BRUTUS_PR_EMS_AB_ASSOC_NT_ACCOUNT";
	default :
		return "ERROR: unknown property tag";
	}
}
