/*
 * Implementation file for Brutus BrutusCheck servant.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/* This is a template file generated by command */
/* orbit-idl-2 --skeleton-impl BrutusCheck.idl */
/* User must edit this file, inserting servant  */
/* specific code between markers. */

#include "BrutusCheck.h"
#include <stdio.h>
#include <unistd.h>

/*** App-specific servant structures ***/

#if !defined(_typedef_impl_POA_BRUTUS_BrutusCheck_)
#define _typedef_impl_POA_BRUTUS_BrutusCheck_ 1
typedef struct {
	POA_BRUTUS_BrutusCheck servant;
	PortableServer_POA poa;
	/* ------ add private attributes here ------ */
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_BrutusCheck;
#endif


/*** Implementation stub prototypes ***/

#if !defined(_decl_impl_BRUTUS_BrutusCheck__destroy_)
#define _decl_impl_BRUTUS_BrutusCheck__destroy_ 1
static void impl_BRUTUS_BrutusCheck__destroy(impl_POA_BRUTUS_BrutusCheck *servant,
					     CORBA_Environment *ev);
#endif

#if !defined(_decl_impl_BRUTUS_BrutusCheck_ping_)
#define _decl_impl_BRUTUS_BrutusCheck_ping_ 1
static void
impl_BRUTUS_BrutusCheck_ping(impl_POA_BRUTUS_BrutusCheck *servant,
			     CORBA_Environment *ev);
#endif


/*** epv structures ***/

#if !defined(_impl_BRUTUS_BrutusCheck_base_epv_)
#define _impl_BRUTUS_BrutusCheck_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_BrutusCheck_base_epv = {
	NULL,             /* _private data */
	(gpointer) & impl_BRUTUS_BrutusCheck__destroy, /* finalize routine */
	NULL,             /* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_BrutusCheck_epv_)
#define _impl_BRUTUS_BrutusCheck_epv_ 1
static POA_BRUTUS_BrutusCheck__epv impl_BRUTUS_BrutusCheck_epv = {
	NULL, /* _private */
	(gpointer)&impl_BRUTUS_BrutusCheck_ping,
};
#endif


/*** vepv structures ***/

#if !defined(_impl_BRUTUS_BrutusCheck_vepv_)
#define _impl_BRUTUS_BrutusCheck_vepv_ 1
static POA_BRUTUS_BrutusCheck__vepv impl_BRUTUS_BrutusCheck_vepv = {
	&impl_BRUTUS_BrutusCheck_base_epv,
	&impl_BRUTUS_BrutusCheck_epv,
};
#endif


/*** Stub implementations ***/

#if !defined(_impl_BRUTUS_BrutusCheck__create_)
#define _impl_BRUTUS_BrutusCheck__create_ 1
static BRUTUS_BrutusCheck impl_BRUTUS_BrutusCheck__create(PortableServer_POA poa, 
							  CORBA_Environment *ev)
{
	BRUTUS_BrutusCheck retval;
	impl_POA_BRUTUS_BrutusCheck *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_BrutusCheck, 1);
	newservant->servant.vepv = &impl_BRUTUS_BrutusCheck_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object)poa, ev);
	POA_BRUTUS_BrutusCheck__init((PortableServer_Servant)newservant, ev);
	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_BrutusCheck__destroy_)
#define _impl_BRUTUS_BrutusCheck__destroy_ 1
static void impl_BRUTUS_BrutusCheck__destroy(impl_POA_BRUTUS_BrutusCheck *servant, 
					     CORBA_Environment *ev)
{
	CORBA_Object_release ((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 * servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_BrutusCheck__fini((PortableServer_Servant)servant, ev);

	g_free (servant);
}
#endif

#if !defined(_impl_BRUTUS_BrutusCheck_ping_)
#define _impl_BRUTUS_BrutusCheck_ping_ 1
static void impl_BRUTUS_BrutusCheck_ping(impl_POA_BRUTUS_BrutusCheck *servant,
					 CORBA_Environment *ev)
{
	/* ------   insert method code here   ------ */
 	printf("\nBrutusCheck PING!\n");
	/* ------ ---------- end ------------ ------ */
}
#endif

