/*
 *    Implementation file for Brutus servant test/sample utility functions.
 *    Copyright (C) 2005 OMC Denmark ApS.
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "servant_utils.h"

#define NDEBUG
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

void free_orbit_object(CORBA_Object obj,
                       PortableServer_POA poa,
                       CORBA_Environment *ev)
{
        PortableServer_ObjectId *objid = NULL;


        objid = PortableServer_POA_reference_to_id(poa, obj, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);

        /* Servant: deactivation - will invoke  __destroy destructor */
        PortableServer_POA_deactivate_object(poa, objid, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);

        /* free associated memory */
        CORBA_Object_release(obj, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);

        CORBA_free(objid);
}

void free_orbit_poa(PortableServer_POA poa, 
                    CORBA_Environment *ev)
{
        PortableServer_POAManager poa_manager = CORBA_OBJECT_NIL;

        poa_manager = PortableServer_POA__get_the_POAManager(poa, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);

	PortableServer_POAManager_State state = PortableServer_POAManager_get_state(poa_manager, ev);
	assert(ev->_major == CORBA_NO_EXCEPTION);
	if (PortableServer_POAManager_ACTIVE == state) {
		PortableServer_POAManager_deactivate(poa_manager, CORBA_TRUE,
						     CORBA_TRUE, ev);
		assert(ev->_major == CORBA_NO_EXCEPTION);
	}

        CORBA_Object_release((CORBA_Object) poa_manager, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);

        PortableServer_POA_destroy(poa, CORBA_TRUE, CORBA_TRUE, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);

        CORBA_Object_release((CORBA_Object) poa, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);
}

void deactivate_orbit_poa(PortableServer_POA poa, 
                          CORBA_Environment *ev)
{
        PortableServer_POAManager poa_manager = CORBA_OBJECT_NIL;


        poa_manager = PortableServer_POA__get_the_POAManager(poa, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);

        PortableServer_POAManager_deactivate(poa_manager, CORBA_TRUE,
                                             CORBA_TRUE, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);

        CORBA_Object_release((CORBA_Object) poa_manager, ev);
        assert(ev->_major == CORBA_NO_EXCEPTION);
}
