/*
 *    Brutus header file for Brutus servant test/sample utility functions.
 *    Copyright (C) 2005 OMC Denmark ApS.
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */


#ifndef _SERVANT_UTILS_H_
#define _SERVANT_UTILS_H_

#include <orbit/orbit.h>
#include "types.h"

/* Releases the object and frees associated memory  */
extern void free_orbit_object(CORBA_Object ref,
                              PortableServer_POA poa,
                              CORBA_Environment *ev);

/* Frees the POA */
extern void free_orbit_poa(PortableServer_POA poa,
                           CORBA_Environment *ev);

/* Deactivates the POA so that no more requests are served */
extern void deactivate_orbit_poa(PortableServer_POA poa,
                                 CORBA_Environment *ev);


#endif // _SERVANT_UTILS_H_
