/*
 * Servant implementation file for Brutus "types.idl"-defined interfaces.
 * Copyright (C) 2004-2007 OMC Denmark ApS.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/* This is a template file generated by command */
/* orbit-idl-2 --skeleton-impl types.idl */
/* User must edit this file, inserting servant  */
/* specific code between markers. */

#include "types.h"
#include "servant_utils.h"
#include <idl_output/uid.h>
#include <string.h>
#include <stdlib.h>


/*** App-specific servant structures ***/

#if !defined(_typedef_impl_POA_BRUTUS_IUnknown_)
#define _typedef_impl_POA_BRUTUS_IUnknown_ 1
typedef struct {
	POA_BRUTUS_IUnknown servant;
	PortableServer_POA poa;
	/* ------ add private attributes here ------ */
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_IUnknown;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SRestrictionContainer_)
#define _typedef_impl_POA_BRUTUS_SRestrictionContainer_ 1
typedef struct {
	POA_BRUTUS_SRestrictionContainer servant;
	PortableServer_POA poa;
	BRUTUS_SRestriction attr_content;
	/* ------ add private attributes here ------ */
	PortableServer_POA child_poa;
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_SRestrictionContainer;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SAndRestriction_)
#define _typedef_impl_POA_BRUTUS_SAndRestriction_ 1
typedef struct {
	POA_BRUTUS_SAndRestriction servant;
	PortableServer_POA poa;
	BRUTUS_seq_SRestriction attr_lpRes;
	/* ------ add private attributes here ------ */
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_SAndRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SOrRestriction_)
#define _typedef_impl_POA_BRUTUS_SOrRestriction_ 1
typedef struct {
	POA_BRUTUS_SOrRestriction servant;
	PortableServer_POA poa;
	BRUTUS_seq_SRestriction attr_lpRes;
	/* ------ add private attributes here ------ */
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_SOrRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SNotRestriction_)
#define _typedef_impl_POA_BRUTUS_SNotRestriction_ 1
typedef struct {
	POA_BRUTUS_SNotRestriction servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_ulReserved;
	BRUTUS_SRestriction attr_lpRes;
	/* ------ add private attributes here ------ */
	CORBA_unsigned_long ulReserved;
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_SNotRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SContentRestriction_)
#define _typedef_impl_POA_BRUTUS_SContentRestriction_ 1
typedef struct {
	POA_BRUTUS_SContentRestriction servant;
	PortableServer_POA poa;
	BRUTUS_FUZZY_TYPE attr_ulFuzzyLevel;
	BRUTUS_BDEFINE attr_ulPropTag;
	BRUTUS_SPropValue attr_lpProp;	// not used

	/* ------ add private attributes here ------ */

	// much easier to define this pointer than to manually copy by value into attr_lpProp
	BRUTUS_SPropValue *lpProp;

	/* ------ ---------- end ------------ ------ */

} impl_POA_BRUTUS_SContentRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SPropertyRestriction_)
#define _typedef_impl_POA_BRUTUS_SPropertyRestriction_ 1
typedef struct {
	POA_BRUTUS_SPropertyRestriction servant;
	PortableServer_POA poa;
	BRUTUS_RELOP_TYPE attr_relop;
	BRUTUS_BDEFINE attr_ulPropTag;
	BRUTUS_SPropValue attr_lpProp;	// not used

	/* ------ add private attributes here ------ */
	// much easier to define this pointer than to manually copy by value into attr_lpProp
	BRUTUS_SPropValue *lpProp;

	/* ------ ---------- end ------------ ------ */

} impl_POA_BRUTUS_SPropertyRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SComparePropsRestriction_)
#define _typedef_impl_POA_BRUTUS_SComparePropsRestriction_ 1
typedef struct {
	POA_BRUTUS_SComparePropsRestriction servant;
	PortableServer_POA poa;
	BRUTUS_RELOP_TYPE attr_relop;
	BRUTUS_BDEFINE attr_ulPropTag1;
	BRUTUS_BDEFINE attr_ulPropTag2;
	/* ------ add private attributes here ------ */
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_SComparePropsRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SBitMaskRestriction_)
#define _typedef_impl_POA_BRUTUS_SBitMaskRestriction_ 1
typedef struct {
	POA_BRUTUS_SBitMaskRestriction servant;
	PortableServer_POA poa;
	BRUTUS_BMR_TYPE attr_relBMR;
	BRUTUS_BDEFINE attr_ulPropTag;
	BRUTUS_BDEFINE attr_ulMask;
	/* ------ add private attributes here ------ */
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_SBitMaskRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SSizeRestriction_)
#define _typedef_impl_POA_BRUTUS_SSizeRestriction_ 1
typedef struct {
	POA_BRUTUS_SSizeRestriction servant;
	PortableServer_POA poa;
	BRUTUS_RELOP_TYPE attr_relop;
	BRUTUS_BDEFINE attr_ulPropTag;
	CORBA_unsigned_long attr_cb;
	/* ------ add private attributes here ------ */
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_SSizeRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SExistRestriction_)
#define _typedef_impl_POA_BRUTUS_SExistRestriction_ 1
typedef struct {
	POA_BRUTUS_SExistRestriction servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_ulReserved1;
	BRUTUS_BDEFINE attr_ulPropTag;
	CORBA_unsigned_long attr_ulReserved2;
	/* ------ add private attributes here ------ */
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_SExistRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SSubRestriction_)
#define _typedef_impl_POA_BRUTUS_SSubRestriction_ 1
typedef struct {
	POA_BRUTUS_SSubRestriction servant;
	PortableServer_POA poa;
	BRUTUS_BDEFINE attr_ulSubObject;
	BRUTUS_SRestriction attr_lpRes;
	/* ------ add private attributes here ------ */
	/* ------ ---------- end ------------ ------ */
} impl_POA_BRUTUS_SSubRestriction;
#endif

#if !defined(_typedef_impl_POA_BRUTUS_SCommentRestriction_)
#define _typedef_impl_POA_BRUTUS_SCommentRestriction_ 1
typedef struct {
	POA_BRUTUS_SCommentRestriction servant;
	PortableServer_POA poa;
	BRUTUS_SRestriction attr_lpRes;
	BRUTUS_seq_SPropValue attr_lpProp;	// not used

	/* ------ add private attributes here ------ */
	BRUTUS_seq_SPropValue *lpProp;
	/* ------ ---------- end ------------ ------ */

} impl_POA_BRUTUS_SCommentRestriction;
#endif

/*** Implementation stub prototypes ***/

#if !defined(_decl_impl_BRUTUS_IUnknown__destroy_)
#define _decl_impl_BRUTUS_IUnknown__destroy_ 1
static void impl_BRUTUS_IUnknown__destroy(impl_POA_BRUTUS_IUnknown * servant,
					  CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_IUnknown_QueryInterface_)
#define _decl_impl_BRUTUS_IUnknown_QueryInterface_ 1
static BRUTUS_BRESULT impl_BRUTUS_IUnknown_QueryInterface(impl_POA_BRUTUS_IUnknown * servant,
							  const CORBA_char * iid,
							  BRUTUS_IUnknown * ppvObject,
							  CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_IUnknown_Destroy_)
#define _decl_impl_BRUTUS_IUnknown_Destroy_ 1
static void impl_BRUTUS_IUnknown_Destroy(impl_POA_BRUTUS_IUnknown * servant,
					 const CORBA_unsigned_long InstanceID,
					 CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SRestrictionContainer__destroy_)
#define _decl_impl_BRUTUS_SRestrictionContainer__destroy_ 1
static void impl_BRUTUS_SRestrictionContainer__destroy(impl_POA_BRUTUS_SRestrictionContainer * servant,
						       CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SRestrictionContainer__get_content_)
#define _decl_impl_BRUTUS_SRestrictionContainer__get_content_ 1
static BRUTUS_SRestriction *impl_BRUTUS_SRestrictionContainer__get_content(impl_POA_BRUTUS_SRestrictionContainer * servant,
									   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SRestrictionContainer_Destroy_)
#define _decl_impl_BRUTUS_SRestrictionContainer_Destroy_ 1
static void impl_BRUTUS_SRestrictionContainer_Destroy(impl_POA_BRUTUS_SRestrictionContainer * servant,
						      CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SAndRestriction__destroy_)
#define _decl_impl_BRUTUS_SAndRestriction__destroy_ 1
static void impl_BRUTUS_SAndRestriction__destroy(impl_POA_BRUTUS_SAndRestriction * servant,
						 CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SAndRestriction__get_lpRes_)
#define _decl_impl_BRUTUS_SAndRestriction__get_lpRes_ 1
static BRUTUS_seq_SRestriction *impl_BRUTUS_SAndRestriction__get_lpRes(impl_POA_BRUTUS_SAndRestriction * servant,
								       CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SOrRestriction__destroy_)
#define _decl_impl_BRUTUS_SOrRestriction__destroy_ 1
static void impl_BRUTUS_SOrRestriction__destroy(impl_POA_BRUTUS_SOrRestriction * servant,
						CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SOrRestriction__get_lpRes_)
#define _decl_impl_BRUTUS_SOrRestriction__get_lpRes_ 1
static BRUTUS_seq_SRestriction *impl_BRUTUS_SOrRestriction__get_lpRes(impl_POA_BRUTUS_SOrRestriction * servant,
								      CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SNotRestriction__destroy_)
#define _decl_impl_BRUTUS_SNotRestriction__destroy_ 1
static void impl_BRUTUS_SNotRestriction__destroy(impl_POA_BRUTUS_SNotRestriction * servant,
						 CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SNotRestriction__get_ulReserved_)
#define _decl_impl_BRUTUS_SNotRestriction__get_ulReserved_ 1
static CORBA_unsigned_long impl_BRUTUS_SNotRestriction__get_ulReserved(impl_POA_BRUTUS_SNotRestriction * servant,
								       CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SNotRestriction__set_ulReserved_)
#define _decl_impl_BRUTUS_SNotRestriction__set_ulReserved_ 1
static void impl_BRUTUS_SNotRestriction__set_ulReserved(impl_POA_BRUTUS_SNotRestriction * servant,
							const CORBA_unsigned_long value,
							CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SNotRestriction__get_lpRes_)
#define _decl_impl_BRUTUS_SNotRestriction__get_lpRes_ 1
static BRUTUS_SRestriction *impl_BRUTUS_SNotRestriction__get_lpRes(impl_POA_BRUTUS_SNotRestriction * servant,
								   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SContentRestriction__destroy_)
#define _decl_impl_BRUTUS_SContentRestriction__destroy_ 1
static void impl_BRUTUS_SContentRestriction__destroy(impl_POA_BRUTUS_SContentRestriction * servant,
						     CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SContentRestriction__get_ulFuzzyLevel_)
#define _decl_impl_BRUTUS_SContentRestriction__get_ulFuzzyLevel_ 1
static BRUTUS_FUZZY_TYPE impl_BRUTUS_SContentRestriction__get_ulFuzzyLevel(impl_POA_BRUTUS_SContentRestriction * servant,
									   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SContentRestriction__get_ulPropTag_)
#define _decl_impl_BRUTUS_SContentRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SContentRestriction__get_ulPropTag(impl_POA_BRUTUS_SContentRestriction * servant,
								     CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SContentRestriction__get_lpProp_)
#define _decl_impl_BRUTUS_SContentRestriction__get_lpProp_ 1
static BRUTUS_SPropValue *impl_BRUTUS_SContentRestriction__get_lpProp(impl_POA_BRUTUS_SContentRestriction * servant,
								      CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SPropertyRestriction__destroy_)
#define _decl_impl_BRUTUS_SPropertyRestriction__destroy_ 1
static void impl_BRUTUS_SPropertyRestriction__destroy(impl_POA_BRUTUS_SPropertyRestriction * servant,
						      CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SPropertyRestriction__get_relop_)
#define _decl_impl_BRUTUS_SPropertyRestriction__get_relop_ 1
static BRUTUS_RELOP_TYPE impl_BRUTUS_SPropertyRestriction__get_relop(impl_POA_BRUTUS_SPropertyRestriction * servant,
								     CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SPropertyRestriction__get_ulPropTag_)
#define _decl_impl_BRUTUS_SPropertyRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SPropertyRestriction__get_ulPropTag(impl_POA_BRUTUS_SPropertyRestriction * servant,
								      CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SPropertyRestriction__get_lpProp_)
#define _decl_impl_BRUTUS_SPropertyRestriction__get_lpProp_ 1
static BRUTUS_SPropValue *impl_BRUTUS_SPropertyRestriction__get_lpProp(impl_POA_BRUTUS_SPropertyRestriction * servant,
								       CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SComparePropsRestriction__destroy_)
#define _decl_impl_BRUTUS_SComparePropsRestriction__destroy_ 1
static void impl_BRUTUS_SComparePropsRestriction__destroy(impl_POA_BRUTUS_SComparePropsRestriction * servant,
							  CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SComparePropsRestriction__get_relop_)
#define _decl_impl_BRUTUS_SComparePropsRestriction__get_relop_ 1
static BRUTUS_RELOP_TYPE impl_BRUTUS_SComparePropsRestriction__get_relop(impl_POA_BRUTUS_SComparePropsRestriction * servant,
									 CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SComparePropsRestriction__get_ulPropTag1_)
#define _decl_impl_BRUTUS_SComparePropsRestriction__get_ulPropTag1_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SComparePropsRestriction__get_ulPropTag1(impl_POA_BRUTUS_SComparePropsRestriction * servant,
									   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SComparePropsRestriction__get_ulPropTag2_)
#define _decl_impl_BRUTUS_SComparePropsRestriction__get_ulPropTag2_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SComparePropsRestriction__get_ulPropTag2(impl_POA_BRUTUS_SComparePropsRestriction * servant,
									   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SBitMaskRestriction__destroy_)
#define _decl_impl_BRUTUS_SBitMaskRestriction__destroy_ 1
static void impl_BRUTUS_SBitMaskRestriction__destroy(impl_POA_BRUTUS_SBitMaskRestriction * servant,
						     CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SBitMaskRestriction__get_relBMR_)
#define _decl_impl_BRUTUS_SBitMaskRestriction__get_relBMR_ 1
static BRUTUS_BMR_TYPE impl_BRUTUS_SBitMaskRestriction__get_relBMR(impl_POA_BRUTUS_SBitMaskRestriction * servant,
								   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SBitMaskRestriction__get_ulPropTag_)
#define _decl_impl_BRUTUS_SBitMaskRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SBitMaskRestriction__get_ulPropTag(impl_POA_BRUTUS_SBitMaskRestriction * servant,
								     CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SBitMaskRestriction__get_ulMask_)
#define _decl_impl_BRUTUS_SBitMaskRestriction__get_ulMask_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SBitMaskRestriction__get_ulMask(impl_POA_BRUTUS_SBitMaskRestriction * servant,
								  CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SSizeRestriction__destroy_)
#define _decl_impl_BRUTUS_SSizeRestriction__destroy_ 1
static void impl_BRUTUS_SSizeRestriction__destroy(impl_POA_BRUTUS_SSizeRestriction * servant,
						  CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SSizeRestriction__get_relop_)
#define _decl_impl_BRUTUS_SSizeRestriction__get_relop_ 1
static BRUTUS_RELOP_TYPE impl_BRUTUS_SSizeRestriction__get_relop(impl_POA_BRUTUS_SSizeRestriction * servant,
								 CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SSizeRestriction__get_ulPropTag_)
#define _decl_impl_BRUTUS_SSizeRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SSizeRestriction__get_ulPropTag(impl_POA_BRUTUS_SSizeRestriction * servant,
								  CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SSizeRestriction__get_cb_)
#define _decl_impl_BRUTUS_SSizeRestriction__get_cb_ 1
static CORBA_unsigned_long impl_BRUTUS_SSizeRestriction__get_cb(impl_POA_BRUTUS_SSizeRestriction * servant,
								CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SExistRestriction__destroy_)
#define _decl_impl_BRUTUS_SExistRestriction__destroy_ 1
static void impl_BRUTUS_SExistRestriction__destroy(impl_POA_BRUTUS_SExistRestriction * servant,
						   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SExistRestriction__get_ulReserved1_)
#define _decl_impl_BRUTUS_SExistRestriction__get_ulReserved1_ 1
static CORBA_unsigned_long impl_BRUTUS_SExistRestriction__get_ulReserved1(impl_POA_BRUTUS_SExistRestriction * servant,
									  CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SExistRestriction__set_ulReserved1_)
#define _decl_impl_BRUTUS_SExistRestriction__set_ulReserved1_ 1
static void impl_BRUTUS_SExistRestriction__set_ulReserved1(impl_POA_BRUTUS_SExistRestriction * servant,
							   const CORBA_unsigned_long value,
							   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SExistRestriction__get_ulPropTag_)
#define _decl_impl_BRUTUS_SExistRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SExistRestriction__get_ulPropTag(impl_POA_BRUTUS_SExistRestriction * servant,
								   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SExistRestriction__get_ulReserved2_)
#define _decl_impl_BRUTUS_SExistRestriction__get_ulReserved2_ 1
static CORBA_unsigned_long impl_BRUTUS_SExistRestriction__get_ulReserved2(impl_POA_BRUTUS_SExistRestriction * servant,
									  CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SExistRestriction__set_ulReserved2_)
#define _decl_impl_BRUTUS_SExistRestriction__set_ulReserved2_ 1
static void impl_BRUTUS_SExistRestriction__set_ulReserved2(impl_POA_BRUTUS_SExistRestriction * servant,
							   const CORBA_unsigned_long value,
							   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SSubRestriction__destroy_)
#define _decl_impl_BRUTUS_SSubRestriction__destroy_ 1
static void impl_BRUTUS_SSubRestriction__destroy(impl_POA_BRUTUS_SSubRestriction * servant,
						 CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SSubRestriction__get_ulSubObject_)
#define _decl_impl_BRUTUS_SSubRestriction__get_ulSubObject_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SSubRestriction__get_ulSubObject(impl_POA_BRUTUS_SSubRestriction * servant,
								   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SSubRestriction__get_lpRes_)
#define _decl_impl_BRUTUS_SSubRestriction__get_lpRes_ 1
static BRUTUS_SRestriction *impl_BRUTUS_SSubRestriction__get_lpRes(impl_POA_BRUTUS_SSubRestriction * servant,
								   CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SCommentRestriction__destroy_)
#define _decl_impl_BRUTUS_SCommentRestriction__destroy_ 1
static void impl_BRUTUS_SCommentRestriction__destroy(impl_POA_BRUTUS_SCommentRestriction * servant,
						     CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SCommentRestriction__get_lpRes_)
#define _decl_impl_BRUTUS_SCommentRestriction__get_lpRes_ 1
static BRUTUS_SRestriction *impl_BRUTUS_SCommentRestriction__get_lpRes(impl_POA_BRUTUS_SCommentRestriction * servant,
								       CORBA_Environment * ev);
#endif

#if !defined(_decl_impl_BRUTUS_SCommentRestriction__get_lpProp_)
#define _decl_impl_BRUTUS_SCommentRestriction__get_lpProp_ 1
static BRUTUS_seq_SPropValue *impl_BRUTUS_SCommentRestriction__get_lpProp(impl_POA_BRUTUS_SCommentRestriction * servant,
									  CORBA_Environment * ev);
#endif

/*** epv structures ***/

#if !defined(_impl_BRUTUS_IUnknown_base_epv_)
#define _impl_BRUTUS_IUnknown_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_IUnknown_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_IUnknown__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_IUnknown_epv_)
#define _impl_BRUTUS_IUnknown_epv_ 1
static POA_BRUTUS_IUnknown__epv impl_BRUTUS_IUnknown_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_IUnknown_QueryInterface,
	(gpointer) & impl_BRUTUS_IUnknown_Destroy,
};
#endif

#if !defined(_impl_BRUTUS_SRestrictionContainer_base_epv_)
#define _impl_BRUTUS_SRestrictionContainer_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SRestrictionContainer_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SRestrictionContainer__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SRestrictionContainer_epv_)
#define _impl_BRUTUS_SRestrictionContainer_epv_ 1
static POA_BRUTUS_SRestrictionContainer__epv impl_BRUTUS_SRestrictionContainer_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SRestrictionContainer__get_content,
	(gpointer) & impl_BRUTUS_SRestrictionContainer_Destroy,
};
#endif

#if !defined(_impl_BRUTUS_SAndRestriction_base_epv_)
#define _impl_BRUTUS_SAndRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SAndRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SAndRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SAndRestriction_epv_)
#define _impl_BRUTUS_SAndRestriction_epv_ 1
static POA_BRUTUS_SAndRestriction__epv impl_BRUTUS_SAndRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SAndRestriction__get_lpRes,
};
#endif

#if !defined(_impl_BRUTUS_SOrRestriction_base_epv_)
#define _impl_BRUTUS_SOrRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SOrRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SOrRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SOrRestriction_epv_)
#define _impl_BRUTUS_SOrRestriction_epv_ 1
static POA_BRUTUS_SOrRestriction__epv impl_BRUTUS_SOrRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SOrRestriction__get_lpRes,
};
#endif

#if !defined(_impl_BRUTUS_SNotRestriction_base_epv_)
#define _impl_BRUTUS_SNotRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SNotRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SNotRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SNotRestriction_epv_)
#define _impl_BRUTUS_SNotRestriction_epv_ 1
static POA_BRUTUS_SNotRestriction__epv impl_BRUTUS_SNotRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SNotRestriction__get_ulReserved,
	(gpointer) & impl_BRUTUS_SNotRestriction__set_ulReserved,
	(gpointer) & impl_BRUTUS_SNotRestriction__get_lpRes,
};
#endif

#if !defined(_impl_BRUTUS_SContentRestriction_base_epv_)
#define _impl_BRUTUS_SContentRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SContentRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SContentRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SContentRestriction_epv_)
#define _impl_BRUTUS_SContentRestriction_epv_ 1
static POA_BRUTUS_SContentRestriction__epv impl_BRUTUS_SContentRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SContentRestriction__get_ulFuzzyLevel,
	(gpointer) & impl_BRUTUS_SContentRestriction__get_ulPropTag,
	(gpointer) & impl_BRUTUS_SContentRestriction__get_lpProp,
};
#endif

#if !defined(_impl_BRUTUS_SPropertyRestriction_base_epv_)
#define _impl_BRUTUS_SPropertyRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SPropertyRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SPropertyRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SPropertyRestriction_epv_)
#define _impl_BRUTUS_SPropertyRestriction_epv_ 1
static POA_BRUTUS_SPropertyRestriction__epv impl_BRUTUS_SPropertyRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SPropertyRestriction__get_relop,
	(gpointer) & impl_BRUTUS_SPropertyRestriction__get_ulPropTag,
	(gpointer) & impl_BRUTUS_SPropertyRestriction__get_lpProp,
};
#endif

#if !defined(_impl_BRUTUS_SComparePropsRestriction_base_epv_)
#define _impl_BRUTUS_SComparePropsRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SComparePropsRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SComparePropsRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SComparePropsRestriction_epv_)
#define _impl_BRUTUS_SComparePropsRestriction_epv_ 1
static POA_BRUTUS_SComparePropsRestriction__epv impl_BRUTUS_SComparePropsRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SComparePropsRestriction__get_relop,
	(gpointer) & impl_BRUTUS_SComparePropsRestriction__get_ulPropTag1,
	(gpointer) & impl_BRUTUS_SComparePropsRestriction__get_ulPropTag2,
};
#endif

#if !defined(_impl_BRUTUS_SBitMaskRestriction_base_epv_)
#define _impl_BRUTUS_SBitMaskRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SBitMaskRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SBitMaskRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SBitMaskRestriction_epv_)
#define _impl_BRUTUS_SBitMaskRestriction_epv_ 1
static POA_BRUTUS_SBitMaskRestriction__epv impl_BRUTUS_SBitMaskRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SBitMaskRestriction__get_relBMR,
	(gpointer) & impl_BRUTUS_SBitMaskRestriction__get_ulPropTag,
	(gpointer) & impl_BRUTUS_SBitMaskRestriction__get_ulMask,
};
#endif

#if !defined(_impl_BRUTUS_SSizeRestriction_base_epv_)
#define _impl_BRUTUS_SSizeRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SSizeRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SSizeRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SSizeRestriction_epv_)
#define _impl_BRUTUS_SSizeRestriction_epv_ 1
static POA_BRUTUS_SSizeRestriction__epv impl_BRUTUS_SSizeRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SSizeRestriction__get_relop,
	(gpointer) & impl_BRUTUS_SSizeRestriction__get_ulPropTag,
	(gpointer) & impl_BRUTUS_SSizeRestriction__get_cb,
};
#endif

#if !defined(_impl_BRUTUS_SExistRestriction_base_epv_)
#define _impl_BRUTUS_SExistRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SExistRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SExistRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SExistRestriction_epv_)
#define _impl_BRUTUS_SExistRestriction_epv_ 1
static POA_BRUTUS_SExistRestriction__epv impl_BRUTUS_SExistRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SExistRestriction__get_ulReserved1,
	(gpointer) & impl_BRUTUS_SExistRestriction__set_ulReserved1,
	(gpointer) & impl_BRUTUS_SExistRestriction__get_ulPropTag,
	(gpointer) & impl_BRUTUS_SExistRestriction__get_ulReserved2,
	(gpointer) & impl_BRUTUS_SExistRestriction__set_ulReserved2,
};
#endif

#if !defined(_impl_BRUTUS_SSubRestriction_base_epv_)
#define _impl_BRUTUS_SSubRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SSubRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SSubRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SSubRestriction_epv_)
#define _impl_BRUTUS_SSubRestriction_epv_ 1
static POA_BRUTUS_SSubRestriction__epv impl_BRUTUS_SSubRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SSubRestriction__get_ulSubObject,
	(gpointer) & impl_BRUTUS_SSubRestriction__get_lpRes,
};
#endif

#if !defined(_impl_BRUTUS_SCommentRestriction_base_epv_)
#define _impl_BRUTUS_SCommentRestriction_base_epv_ 1
static PortableServer_ServantBase__epv impl_BRUTUS_SCommentRestriction_base_epv = {
	NULL,			/* _private data */
	(gpointer) & impl_BRUTUS_SCommentRestriction__destroy,	/* finalize routine */
	NULL,			/* default_POA routine */
};
#endif

#if !defined(_impl_BRUTUS_SCommentRestriction_epv_)
#define _impl_BRUTUS_SCommentRestriction_epv_ 1
static POA_BRUTUS_SCommentRestriction__epv impl_BRUTUS_SCommentRestriction_epv = {
	NULL,			/* _private */
	(gpointer) & impl_BRUTUS_SCommentRestriction__get_lpRes,
	(gpointer) & impl_BRUTUS_SCommentRestriction__get_lpProp,
};
#endif

/*** vepv structures ***/

#if !defined(_impl_BRUTUS_IUnknown_vepv_)
#define _impl_BRUTUS_IUnknown_vepv_ 1
static POA_BRUTUS_IUnknown__vepv impl_BRUTUS_IUnknown_vepv = {
	&impl_BRUTUS_IUnknown_base_epv,
	&impl_BRUTUS_IUnknown_epv,
};
#endif

#if !defined(_impl_BRUTUS_SRestrictionContainer_vepv_)
#define _impl_BRUTUS_SRestrictionContainer_vepv_ 1
static POA_BRUTUS_SRestrictionContainer__vepv impl_BRUTUS_SRestrictionContainer_vepv = {
	&impl_BRUTUS_SRestrictionContainer_base_epv,
	&impl_BRUTUS_SRestrictionContainer_epv,
};
#endif

#if !defined(_impl_BRUTUS_SAndRestriction_vepv_)
#define _impl_BRUTUS_SAndRestriction_vepv_ 1
static POA_BRUTUS_SAndRestriction__vepv impl_BRUTUS_SAndRestriction_vepv = {
	&impl_BRUTUS_SAndRestriction_base_epv,
	&impl_BRUTUS_SAndRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SOrRestriction_vepv_)
#define _impl_BRUTUS_SOrRestriction_vepv_ 1
static POA_BRUTUS_SOrRestriction__vepv impl_BRUTUS_SOrRestriction_vepv = {
	&impl_BRUTUS_SOrRestriction_base_epv,
	&impl_BRUTUS_SOrRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SNotRestriction_vepv_)
#define _impl_BRUTUS_SNotRestriction_vepv_ 1
static POA_BRUTUS_SNotRestriction__vepv impl_BRUTUS_SNotRestriction_vepv = {
	&impl_BRUTUS_SNotRestriction_base_epv,
	&impl_BRUTUS_SNotRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SContentRestriction_vepv_)
#define _impl_BRUTUS_SContentRestriction_vepv_ 1
static POA_BRUTUS_SContentRestriction__vepv impl_BRUTUS_SContentRestriction_vepv = {
	&impl_BRUTUS_SContentRestriction_base_epv,
	&impl_BRUTUS_SContentRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SPropertyRestriction_vepv_)
#define _impl_BRUTUS_SPropertyRestriction_vepv_ 1
static POA_BRUTUS_SPropertyRestriction__vepv impl_BRUTUS_SPropertyRestriction_vepv = {
	&impl_BRUTUS_SPropertyRestriction_base_epv,
	&impl_BRUTUS_SPropertyRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SComparePropsRestriction_vepv_)
#define _impl_BRUTUS_SComparePropsRestriction_vepv_ 1
static POA_BRUTUS_SComparePropsRestriction__vepv impl_BRUTUS_SComparePropsRestriction_vepv = {
	&impl_BRUTUS_SComparePropsRestriction_base_epv,
	&impl_BRUTUS_SComparePropsRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SBitMaskRestriction_vepv_)
#define _impl_BRUTUS_SBitMaskRestriction_vepv_ 1
static POA_BRUTUS_SBitMaskRestriction__vepv impl_BRUTUS_SBitMaskRestriction_vepv = {
	&impl_BRUTUS_SBitMaskRestriction_base_epv,
	&impl_BRUTUS_SBitMaskRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SSizeRestriction_vepv_)
#define _impl_BRUTUS_SSizeRestriction_vepv_ 1
static POA_BRUTUS_SSizeRestriction__vepv impl_BRUTUS_SSizeRestriction_vepv = {
	&impl_BRUTUS_SSizeRestriction_base_epv,
	&impl_BRUTUS_SSizeRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SExistRestriction_vepv_)
#define _impl_BRUTUS_SExistRestriction_vepv_ 1
static POA_BRUTUS_SExistRestriction__vepv impl_BRUTUS_SExistRestriction_vepv = {
	&impl_BRUTUS_SExistRestriction_base_epv,
	&impl_BRUTUS_SExistRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SSubRestriction_vepv_)
#define _impl_BRUTUS_SSubRestriction_vepv_ 1
static POA_BRUTUS_SSubRestriction__vepv impl_BRUTUS_SSubRestriction_vepv = {
	&impl_BRUTUS_SSubRestriction_base_epv,
	&impl_BRUTUS_SSubRestriction_epv,
};
#endif

#if !defined(_impl_BRUTUS_SCommentRestriction_vepv_)
#define _impl_BRUTUS_SCommentRestriction_vepv_ 1
static POA_BRUTUS_SCommentRestriction__vepv impl_BRUTUS_SCommentRestriction_vepv = {
	&impl_BRUTUS_SCommentRestriction_base_epv,
	&impl_BRUTUS_SCommentRestriction_epv,
};
#endif



/*** Stub implementations ***/


// ******************************** //
// ***         IUnknown         *** //
// ******************************** //

#if !defined(_impl_BRUTUS_IUnknown__create_)
#define _impl_BRUTUS_IUnknown__create_ 1
static BRUTUS_IUnknown impl_BRUTUS_IUnknown__create(PortableServer_POA poa,
						    CORBA_Environment * ev)
{
	BRUTUS_IUnknown retval;
	impl_POA_BRUTUS_IUnknown *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_IUnknown, 1);
	newservant->servant.vepv = &impl_BRUTUS_IUnknown_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_IUnknown__init((PortableServer_Servant) newservant, ev);
	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_IUnknown__destroy_)
#define _impl_BRUTUS_IUnknown__destroy_ 1
static void impl_BRUTUS_IUnknown__destroy(impl_POA_BRUTUS_IUnknown * servant,
					  CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_IUnknown__fini((PortableServer_Servant) servant, ev);

	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_IUnknown_QueryInterface_)
#define _impl_BRUTUS_IUnknown_QueryInterface_ 1
static BRUTUS_BRESULT impl_BRUTUS_IUnknown_QueryInterface(impl_POA_BRUTUS_IUnknown * servant,
							  const CORBA_char * iid,
							  BRUTUS_IUnknown * ppvObject,
							  CORBA_Environment * ev)
{
	BRUTUS_BRESULT retval;

	/* ------   insert method code here   ------ */
	retval = BRUTUS_BRUTUS_MAPI_E_INTERFACE_NOT_SUPPORTED;

	if (strcmp(iid, BRUTUS_BRUTUS_IID_IUnknown))
		goto out;

	*ppvObject = PortableServer_POA_servant_to_reference(servant->poa, servant, ev);
	if (ev->_major != CORBA_NO_EXCEPTION)
		goto out;

	if (CORBA_OBJECT_NIL != ppvObject)
		retval = BRUTUS_BRUTUS_S_OK;
	/* ------ ---------- end ------------ ------ */

out:
	return retval;
}
#endif

#if !defined(_impl_BRUTUS_IUnknown_Destroy_)
#define _impl_BRUTUS_IUnknown_Destroy_ 1
static void impl_BRUTUS_IUnknown_Destroy(impl_POA_BRUTUS_IUnknown * servant,
					 const CORBA_unsigned_long InstanceID,
					 CORBA_Environment * ev)
{
	/* ------   insert method code here   ------ */
	/* ------ ---------- end ------------ ------ */
}
#endif

// ********************************************* //
// ***         SRestrictionContainer         *** //
// ********************************************* //

#if !defined(_impl_BRUTUS_SRestrictionContainer__create_)
#define _impl_BRUTUS_SRestrictionContainer__create_ 1
static BRUTUS_SRestrictionContainer impl_BRUTUS_SRestrictionContainer__create(BRUTUS_SRestriction * Content,
									      PortableServer_POA ChildPoa,
									      PortableServer_POA poa,
									      CORBA_Environment * ev)
{
	BRUTUS_SRestrictionContainer retval;
	impl_POA_BRUTUS_SRestrictionContainer *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SRestrictionContainer, 1);
	newservant->servant.vepv = &impl_BRUTUS_SRestrictionContainer_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SRestrictionContainer__init((PortableServer_Servant)
					       newservant, ev);
	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->child_poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object)
									    ChildPoa, ev);
	newservant->attr_content._d = Content->_d;
	switch (Content->_d) {
	case BRUTUS_BRUTUS_RES_ERROR:
		newservant->attr_content._u.Error = Content->_u.Error;
		break;
	case BRUTUS_BRUTUS_RES_AND:
		newservant->attr_content._u.resAnd = CORBA_Object_duplicate(Content->_u.resAnd, ev);
		break;
	case BRUTUS_BRUTUS_RES_OR:
		newservant->attr_content._u.resOr = CORBA_Object_duplicate(Content->_u.resOr, ev);
		break;
	case BRUTUS_BRUTUS_RES_NOT:
		newservant->attr_content._u.resNot = CORBA_Object_duplicate(Content->_u.resNot, ev);
		break;
	case BRUTUS_BRUTUS_RES_CONTENT:
		newservant->attr_content._u.resContent = CORBA_Object_duplicate(Content->_u.resContent, ev);
		break;
	case BRUTUS_BRUTUS_RES_PROPERTY:
		newservant->attr_content._u.resProperty = CORBA_Object_duplicate(Content->_u.resProperty, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMPAREPROPS:
		newservant->attr_content._u.resCompareProps = CORBA_Object_duplicate(Content->_u.resCompareProps, ev);
		break;
	case BRUTUS_BRUTUS_RES_BITMASK:
		newservant->attr_content._u.resBitMask = CORBA_Object_duplicate(Content->_u.resBitMask, ev);
		break;
	case BRUTUS_BRUTUS_RES_SIZE:
		newservant->attr_content._u.resSize = CORBA_Object_duplicate(Content->_u.resSize, ev);
		break;
	case BRUTUS_BRUTUS_RES_EXIST:
		newservant->attr_content._u.resExist = CORBA_Object_duplicate(Content->_u.resExist, ev);
		break;
	case BRUTUS_BRUTUS_RES_SUBRESTRICTION:
		newservant->attr_content._u.resSub = CORBA_Object_duplicate(Content->_u.resSub, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMMENT:
		newservant->attr_content._u.resComment = CORBA_Object_duplicate(Content->_u.resComment, ev);
		break;
	};
	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SRestrictionContainer__destroy_)
#define _impl_BRUTUS_SRestrictionContainer__destroy_ 1
static void impl_BRUTUS_SRestrictionContainer__destroy(impl_POA_BRUTUS_SRestrictionContainer * servant,
						       CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 * servant and you may free your private attributes. */

	/* ------ free private attributes here ------ */

	// This will stop requests being served towards 
	// any embedded restriction interfaces
	deactivate_orbit_poa(servant->child_poa, ev);

	switch (servant->attr_content._d) {
	case BRUTUS_BRUTUS_RES_ERROR:
		break;
	case BRUTUS_BRUTUS_RES_AND:
		free_orbit_object(servant->attr_content._u.resAnd, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_OR:
		free_orbit_object(servant->attr_content._u.resOr, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_NOT:
		free_orbit_object(servant->attr_content._u.resNot, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_CONTENT:
		free_orbit_object(servant->attr_content._u.resContent, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_PROPERTY:
		free_orbit_object(servant->attr_content._u.resProperty, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMPAREPROPS:
		free_orbit_object(servant->attr_content._u.resCompareProps, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_BITMASK:
		free_orbit_object(servant->attr_content._u.resBitMask, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_SIZE:
		free_orbit_object(servant->attr_content._u.resSize, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_EXIST:
		free_orbit_object(servant->attr_content._u.resExist, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_SUBRESTRICTION:
		free_orbit_object(servant->attr_content._u.resSub, servant->child_poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMMENT:
		free_orbit_object(servant->attr_content._u.resComment, servant->child_poa, ev);
		break;
	};

	free_orbit_poa(servant->child_poa, ev);
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SRestrictionContainer__fini((PortableServer_Servant)
					       servant, ev);

	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SRestrictionContainer__get_content_)
#define _impl_BRUTUS_SRestrictionContainer__get_content_ 1
static BRUTUS_SRestriction *impl_BRUTUS_SRestrictionContainer__get_content(impl_POA_BRUTUS_SRestrictionContainer * servant,
									   CORBA_Environment * ev)
{
	BRUTUS_SRestriction *retval;

	/* ------   insert method code here   ------ */
	retval = ORBit_copy_value(&servant->attr_content, TC_BRUTUS_SRestriction);
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SRestrictionContainer_Destroy_)
#define _impl_BRUTUS_SRestrictionContainer_Destroy_ 1
static void impl_BRUTUS_SRestrictionContainer_Destroy(impl_POA_BRUTUS_SRestrictionContainer * servant,
						      CORBA_Environment * ev)
{
	/* ------   insert method code here   ------ */
	/* ------ ---------- end ------------ ------ */
}
#endif


// *************************************** //
// ***         SAndRestriction         *** //
// *************************************** //

#if !defined(_impl_BRUTUS_SAndRestriction__create_)
#define _impl_BRUTUS_SAndRestriction__create_ 1
static BRUTUS_SAndRestriction impl_BRUTUS_SAndRestriction__create(BRUTUS_seq_SRestriction * Content,
								  PortableServer_POA poa,
								  CORBA_Environment * ev)
{
	BRUTUS_SAndRestriction retval;
	impl_POA_BRUTUS_SAndRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SAndRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SAndRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SAndRestriction__init((PortableServer_Servant)
					 newservant, ev);
	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */

	// make sure that _buffer is manually freed
	CORBA_sequence_set_release(&newservant->attr_lpRes, CORBA_FALSE);

	// copy _length and _maximum
	newservant->attr_lpRes._maximum = Content->_maximum;
	newservant->attr_lpRes._length = Content->_length;

	// move the _buffer
	BRUTUS_seq_SRestriction *res = ORBit_copy_value(Content,
							TC_CORBA_sequence_BRUTUS_SRestriction);
	CORBA_sequence_set_release(res, CORBA_FALSE);
	newservant->attr_lpRes._buffer = res->_buffer;
	res->_buffer = NULL;
	CORBA_free(res);

	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SAndRestriction__destroy_)
#define _impl_BRUTUS_SAndRestriction__destroy_ 1
static void impl_BRUTUS_SAndRestriction__destroy(impl_POA_BRUTUS_SAndRestriction * servant,
						 CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	CORBA_free(servant->attr_lpRes._buffer);
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SAndRestriction__fini((PortableServer_Servant) servant, ev);

	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SAndRestriction__get_lpRes_)
#define _impl_BRUTUS_SAndRestriction__get_lpRes_ 1
static BRUTUS_seq_SRestriction *impl_BRUTUS_SAndRestriction__get_lpRes(impl_POA_BRUTUS_SAndRestriction * servant,
								       CORBA_Environment * ev)
{
	BRUTUS_seq_SRestriction *retval;

	/* ------   insert method code here   ------ */
	retval = ORBit_copy_value(&servant->attr_lpRes, TC_CORBA_sequence_BRUTUS_SRestriction);
	CORBA_sequence_set_release(retval, CORBA_TRUE);
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif


// ************************************** //
// ***         SOrRestriction         *** //
// ************************************** //

#if !defined(_impl_BRUTUS_SOrRestriction__create_)
#define _impl_BRUTUS_SOrRestriction__create_ 1
static BRUTUS_SOrRestriction impl_BRUTUS_SOrRestriction__create(BRUTUS_seq_SRestriction * Content,
								PortableServer_POA poa,
								CORBA_Environment * ev)
{
	BRUTUS_SOrRestriction retval;
	impl_POA_BRUTUS_SOrRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SOrRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SOrRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SOrRestriction__init((PortableServer_Servant)
					newservant, ev);
	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */

	// make sure that _buffer is manually freed
	CORBA_sequence_set_release(&newservant->attr_lpRes, CORBA_FALSE);

	// copy _length and _maximum
	newservant->attr_lpRes._maximum = Content->_maximum;
	newservant->attr_lpRes._length = Content->_length;

	// move the _buffer
	BRUTUS_seq_SRestriction *res = ORBit_copy_value(Content,
							TC_CORBA_sequence_BRUTUS_SRestriction);
	CORBA_sequence_set_release(res, CORBA_FALSE);
	newservant->attr_lpRes._buffer = res->_buffer;
	res->_buffer = NULL;
	CORBA_free(res);

	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SOrRestriction__destroy_)
#define _impl_BRUTUS_SOrRestriction__destroy_ 1
static void impl_BRUTUS_SOrRestriction__destroy(impl_POA_BRUTUS_SOrRestriction * servant,
						CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	CORBA_free(servant->attr_lpRes._buffer);
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SOrRestriction__fini((PortableServer_Servant) servant, ev);

	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SOrRestriction__get_lpRes_)
#define _impl_BRUTUS_SOrRestriction__get_lpRes_ 1
static BRUTUS_seq_SRestriction *impl_BRUTUS_SOrRestriction__get_lpRes(impl_POA_BRUTUS_SOrRestriction * servant,
								      CORBA_Environment * ev)
{
	BRUTUS_seq_SRestriction *retval;

	/* ------   insert method code here   ------ */
	retval = ORBit_copy_value(&servant->attr_lpRes, TC_CORBA_sequence_BRUTUS_SRestriction);
	CORBA_sequence_set_release(retval, CORBA_TRUE);
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif


// *************************************** //
// ***         SNotRestriction         *** //
// *************************************** //

#if !defined(_impl_BRUTUS_SNotRestriction__create_)
#define _impl_BRUTUS_SNotRestriction__create_ 1
static BRUTUS_SNotRestriction impl_BRUTUS_SNotRestriction__create(CORBA_unsigned_long ulReserved,
								  BRUTUS_SRestriction * Content,
								  PortableServer_POA poa,
								  CORBA_Environment * ev)
{
	BRUTUS_SNotRestriction retval;
	impl_POA_BRUTUS_SNotRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SNotRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SNotRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SNotRestriction__init((PortableServer_Servant)
					 newservant, ev);
	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->ulReserved = ulReserved;
	newservant->attr_lpRes._d = Content->_d;
	switch (Content->_d) {
	case BRUTUS_BRUTUS_RES_ERROR:
		newservant->attr_lpRes._u.Error = Content->_u.Error;
		break;
	case BRUTUS_BRUTUS_RES_AND:
		newservant->attr_lpRes._u.resAnd = CORBA_Object_duplicate(Content->_u.resAnd, ev);
		break;
	case BRUTUS_BRUTUS_RES_OR:
		newservant->attr_lpRes._u.resOr = CORBA_Object_duplicate(Content->_u.resOr, ev);
		break;
	case BRUTUS_BRUTUS_RES_NOT:
		newservant->attr_lpRes._u.resNot = CORBA_Object_duplicate(Content->_u.resNot, ev);
		break;
	case BRUTUS_BRUTUS_RES_CONTENT:
		newservant->attr_lpRes._u.resContent = CORBA_Object_duplicate(Content->_u.resContent, ev);
		break;
	case BRUTUS_BRUTUS_RES_PROPERTY:
		newservant->attr_lpRes._u.resProperty = CORBA_Object_duplicate(Content->_u.resProperty, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMPAREPROPS:
		newservant->attr_lpRes._u.resCompareProps = CORBA_Object_duplicate(Content->_u.resCompareProps, ev);
		break;
	case BRUTUS_BRUTUS_RES_BITMASK:
		newservant->attr_lpRes._u.resBitMask = CORBA_Object_duplicate(Content->_u.resBitMask, ev);
		break;
	case BRUTUS_BRUTUS_RES_SIZE:
		newservant->attr_lpRes._u.resSize = CORBA_Object_duplicate(Content->_u.resSize, ev);
		break;
	case BRUTUS_BRUTUS_RES_EXIST:
		newservant->attr_lpRes._u.resExist = CORBA_Object_duplicate(Content->_u.resExist, ev);
		break;
	case BRUTUS_BRUTUS_RES_SUBRESTRICTION:
		newservant->attr_lpRes._u.resSub = CORBA_Object_duplicate(Content->_u.resSub, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMMENT:
		newservant->attr_lpRes._u.resComment = CORBA_Object_duplicate(Content->_u.resComment, ev);
		break;
	};

	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SNotRestriction__destroy_)
#define _impl_BRUTUS_SNotRestriction__destroy_ 1
static void impl_BRUTUS_SNotRestriction__destroy(impl_POA_BRUTUS_SNotRestriction * servant,
						 CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	switch (servant->attr_lpRes._d) {
	case BRUTUS_BRUTUS_RES_ERROR:
		break;
	case BRUTUS_BRUTUS_RES_AND:
		free_orbit_object(servant->attr_lpRes._u.resAnd, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_OR:
		free_orbit_object(servant->attr_lpRes._u.resOr, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_NOT:
		free_orbit_object(servant->attr_lpRes._u.resNot, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_CONTENT:
		free_orbit_object(servant->attr_lpRes._u.resContent, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_PROPERTY:
		free_orbit_object(servant->attr_lpRes._u.resProperty, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMPAREPROPS:
		free_orbit_object(servant->attr_lpRes._u.resCompareProps, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_BITMASK:
		free_orbit_object(servant->attr_lpRes._u.resBitMask, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_SIZE:
		free_orbit_object(servant->attr_lpRes._u.resSize, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_EXIST:
		free_orbit_object(servant->attr_lpRes._u.resExist, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_SUBRESTRICTION:
		free_orbit_object(servant->attr_lpRes._u.resSub, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMMENT:
		free_orbit_object(servant->attr_lpRes._u.resComment, servant->poa, ev);
		break;
	};
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SNotRestriction__fini((PortableServer_Servant) servant, ev);

	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SNotRestriction__get_ulReserved_)
#define _impl_BRUTUS_SNotRestriction__get_ulReserved_ 1
static CORBA_unsigned_long impl_BRUTUS_SNotRestriction__get_ulReserved(impl_POA_BRUTUS_SNotRestriction * servant,
								       CORBA_Environment * ev)
{
	CORBA_unsigned_long retval;

	/* ------   insert method code here   ------ */
	retval = servant->ulReserved;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SNotRestriction__set_ulReserved_)
#define _impl_BRUTUS_SNotRestriction__set_ulReserved_ 1
static void impl_BRUTUS_SNotRestriction__set_ulReserved(impl_POA_BRUTUS_SNotRestriction * servant,
							const CORBA_unsigned_long value,
							CORBA_Environment * ev)
{
	/* ------   insert method code here   ------ */
	servant->ulReserved = value;
	/* ------ ---------- end ------------ ------ */
}
#endif

#if !defined(_impl_BRUTUS_SNotRestriction__get_lpRes_)
#define _impl_BRUTUS_SNotRestriction__get_lpRes_ 1
static BRUTUS_SRestriction *impl_BRUTUS_SNotRestriction__get_lpRes(impl_POA_BRUTUS_SNotRestriction * servant,
								   CORBA_Environment * ev)
{
	BRUTUS_SRestriction *retval;

	/* ------   insert method code here   ------ */
	retval = ORBit_copy_value(&servant->attr_lpRes, TC_BRUTUS_SRestriction);
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif


// ******************************************* //
// ***         SContentRestriction         *** //
// ******************************************* //

#if !defined(_impl_BRUTUS_SContentRestriction__create_)
#define _impl_BRUTUS_SContentRestriction__create_ 1
static BRUTUS_SContentRestriction impl_BRUTUS_SContentRestriction__create(BRUTUS_FUZZY_TYPE FuzzyLevel,
									  BRUTUS_BDEFINE PropTag,
									  BRUTUS_SPropValue PropValue,
									  PortableServer_POA poa,
									  CORBA_Environment * ev)
{
	BRUTUS_SContentRestriction retval;
	impl_POA_BRUTUS_SContentRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SContentRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SContentRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SContentRestriction__init((PortableServer_Servant)
					     newservant, ev);

	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->attr_ulFuzzyLevel = FuzzyLevel;
	newservant->attr_ulPropTag = PropTag;
	newservant->lpProp = ORBit_copy_value(&PropValue, TC_BRUTUS_SPropValue);

	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SContentRestriction__destroy_)
#define _impl_BRUTUS_SContentRestriction__destroy_ 1
static void impl_BRUTUS_SContentRestriction__destroy(impl_POA_BRUTUS_SContentRestriction * servant,
						     CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	CORBA_free(servant->lpProp);
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SContentRestriction__fini((PortableServer_Servant)
					     servant, ev);
	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SContentRestriction__get_ulFuzzyLevel_)
#define _impl_BRUTUS_SContentRestriction__get_ulFuzzyLevel_ 1
static BRUTUS_FUZZY_TYPE impl_BRUTUS_SContentRestriction__get_ulFuzzyLevel(impl_POA_BRUTUS_SContentRestriction * servant,
									   CORBA_Environment * ev)
{
	BRUTUS_FUZZY_TYPE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulFuzzyLevel;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SContentRestriction__get_ulPropTag_)
#define _impl_BRUTUS_SContentRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SContentRestriction__get_ulPropTag(impl_POA_BRUTUS_SContentRestriction * servant,
								     CORBA_Environment * ev)
{
	BRUTUS_BDEFINE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulPropTag;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SContentRestriction__get_lpProp_)
#define _impl_BRUTUS_SContentRestriction__get_lpProp_ 1
static BRUTUS_SPropValue *impl_BRUTUS_SContentRestriction__get_lpProp(impl_POA_BRUTUS_SContentRestriction * servant,
								      CORBA_Environment * ev)
{
	BRUTUS_SPropValue *retval;

	/* ------   insert method code here   ------ */
	retval = ORBit_copy_value(servant->lpProp, TC_BRUTUS_SPropValue);
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif


// ******************************************** //
// ***         SPropertyRestriction         *** //
// ******************************************** //

#if !defined(_impl_BRUTUS_SPropertyRestriction__create_)
#define _impl_BRUTUS_SPropertyRestriction__create_ 1
static BRUTUS_SPropertyRestriction impl_BRUTUS_SPropertyRestriction__create(BRUTUS_RELOP_TYPE Relop,
									    BRUTUS_BDEFINE PropTag,
									    BRUTUS_SPropValue PropValue,
									    PortableServer_POA poa,
									    CORBA_Environment * ev)
{
	BRUTUS_SPropertyRestriction retval;
	impl_POA_BRUTUS_SPropertyRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SPropertyRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SPropertyRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SPropertyRestriction__init((PortableServer_Servant)
					      newservant, ev);

	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->attr_relop = Relop;
	newservant->attr_ulPropTag = PropTag;
	newservant->lpProp = ORBit_copy_value(&PropValue, TC_BRUTUS_SPropValue);
	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SPropertyRestriction__destroy_)
#define _impl_BRUTUS_SPropertyRestriction__destroy_ 1
static void impl_BRUTUS_SPropertyRestriction__destroy(impl_POA_BRUTUS_SPropertyRestriction * servant,
						      CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	CORBA_free(servant->lpProp);
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SPropertyRestriction__fini((PortableServer_Servant)
					      servant, ev);

	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SPropertyRestriction__get_relop_)
#define _impl_BRUTUS_SPropertyRestriction__get_relop_ 1
static BRUTUS_RELOP_TYPE impl_BRUTUS_SPropertyRestriction__get_relop(impl_POA_BRUTUS_SPropertyRestriction * servant,
								     CORBA_Environment * ev)
{
	BRUTUS_RELOP_TYPE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_relop;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SPropertyRestriction__get_ulPropTag_)
#define _impl_BRUTUS_SPropertyRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SPropertyRestriction__get_ulPropTag(impl_POA_BRUTUS_SPropertyRestriction * servant,
								      CORBA_Environment * ev)
{
	BRUTUS_BDEFINE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulPropTag;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SPropertyRestriction__get_lpProp_)
#define _impl_BRUTUS_SPropertyRestriction__get_lpProp_ 1
static BRUTUS_SPropValue *impl_BRUTUS_SPropertyRestriction__get_lpProp(impl_POA_BRUTUS_SPropertyRestriction * servant,
								       CORBA_Environment * ev)
{
	BRUTUS_SPropValue *retval;

	/* ------   insert method code here   ------ */
	retval = ORBit_copy_value(servant->lpProp, TC_BRUTUS_SPropValue);
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif


// ************************************************ //
// ***         SComparePropsRestriction         *** //
// ************************************************ //

#if !defined(_impl_BRUTUS_SComparePropsRestriction__create_)
#define _impl_BRUTUS_SComparePropsRestriction__create_ 1
static BRUTUS_SComparePropsRestriction impl_BRUTUS_SComparePropsRestriction__create(BRUTUS_RELOP_TYPE Relop,
										    BRUTUS_BDEFINE PropTag1,
										    BRUTUS_BDEFINE PropTag2,
										    PortableServer_POA poa,
										    CORBA_Environment * ev)
{
	BRUTUS_SComparePropsRestriction retval;
	impl_POA_BRUTUS_SComparePropsRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SComparePropsRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SComparePropsRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SComparePropsRestriction__init((PortableServer_Servant)
						  newservant, ev);

	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->attr_relop = Relop;
	newservant->attr_ulPropTag1 = PropTag1;
	newservant->attr_ulPropTag2 = PropTag2;
	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SComparePropsRestriction__destroy_)
#define _impl_BRUTUS_SComparePropsRestriction__destroy_ 1
static void impl_BRUTUS_SComparePropsRestriction__destroy(impl_POA_BRUTUS_SComparePropsRestriction * servant,
							  CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SComparePropsRestriction__fini((PortableServer_Servant)
						  servant, ev);
	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SComparePropsRestriction__get_relop_)
#define _impl_BRUTUS_SComparePropsRestriction__get_relop_ 1
static BRUTUS_RELOP_TYPE impl_BRUTUS_SComparePropsRestriction__get_relop(impl_POA_BRUTUS_SComparePropsRestriction * servant,
									 CORBA_Environment * ev)
{
	BRUTUS_RELOP_TYPE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_relop;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SComparePropsRestriction__get_ulPropTag1_)
#define _impl_BRUTUS_SComparePropsRestriction__get_ulPropTag1_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SComparePropsRestriction__get_ulPropTag1(impl_POA_BRUTUS_SComparePropsRestriction * servant,
									   CORBA_Environment * ev)
{
	BRUTUS_BDEFINE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulPropTag1;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SComparePropsRestriction__get_ulPropTag2_)
#define _impl_BRUTUS_SComparePropsRestriction__get_ulPropTag2_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SComparePropsRestriction__get_ulPropTag2(impl_POA_BRUTUS_SComparePropsRestriction * servant,
									   CORBA_Environment * ev)
{
	BRUTUS_BDEFINE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulPropTag2;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif


// ******************************************* //
// ***         SBitMaskRestriction         *** //
// ******************************************* //

#if !defined(_impl_BRUTUS_SBitMaskRestriction__create_)
#define _impl_BRUTUS_SBitMaskRestriction__create_ 1
static BRUTUS_SBitMaskRestriction impl_BRUTUS_SBitMaskRestriction__create(BRUTUS_BMR_TYPE BMR,
									  BRUTUS_BDEFINE PropTag,
									  BRUTUS_BDEFINE Mask,
									  PortableServer_POA poa,
									  CORBA_Environment * ev)
{
	BRUTUS_SBitMaskRestriction retval;
	impl_POA_BRUTUS_SBitMaskRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SBitMaskRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SBitMaskRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SBitMaskRestriction__init((PortableServer_Servant)
					     newservant, ev);

	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->attr_relBMR = BMR;
	newservant->attr_ulPropTag = PropTag;
	newservant->attr_ulMask = Mask;
	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SBitMaskRestriction__destroy_)
#define _impl_BRUTUS_SBitMaskRestriction__destroy_ 1
static void impl_BRUTUS_SBitMaskRestriction__destroy(impl_POA_BRUTUS_SBitMaskRestriction * servant,
						     CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SBitMaskRestriction__fini((PortableServer_Servant)
					     servant, ev);
	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SBitMaskRestriction__get_relBMR_)
#define _impl_BRUTUS_SBitMaskRestriction__get_relBMR_ 1
static BRUTUS_BMR_TYPE impl_BRUTUS_SBitMaskRestriction__get_relBMR(impl_POA_BRUTUS_SBitMaskRestriction * servant,
								   CORBA_Environment * ev)
{
	BRUTUS_BMR_TYPE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_relBMR;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SBitMaskRestriction__get_ulPropTag_)
#define _impl_BRUTUS_SBitMaskRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SBitMaskRestriction__get_ulPropTag(impl_POA_BRUTUS_SBitMaskRestriction * servant,
								     CORBA_Environment * ev)
{
	BRUTUS_BDEFINE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulPropTag;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SBitMaskRestriction__get_ulMask_)
#define _impl_BRUTUS_SBitMaskRestriction__get_ulMask_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SBitMaskRestriction__get_ulMask(impl_POA_BRUTUS_SBitMaskRestriction * servant,
								  CORBA_Environment * ev)
{
	BRUTUS_BDEFINE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulMask;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif


// **************************************** //
// ***         SSizeRestriction         *** //
// **************************************** //

#if !defined(_impl_BRUTUS_SSizeRestriction__create_)
#define _impl_BRUTUS_SSizeRestriction__create_ 1
static BRUTUS_SSizeRestriction impl_BRUTUS_SSizeRestriction__create(BRUTUS_RELOP_TYPE Relop,
								    BRUTUS_BDEFINE PropTag,
								    CORBA_unsigned_long Cb,
								    PortableServer_POA poa,
								    CORBA_Environment * ev)
{
	BRUTUS_SSizeRestriction retval;
	impl_POA_BRUTUS_SSizeRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SSizeRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SSizeRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SSizeRestriction__init((PortableServer_Servant)
					  newservant, ev);

	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->attr_relop = Relop;
	newservant->attr_ulPropTag = PropTag;
	newservant->attr_cb = Cb;
	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SSizeRestriction__destroy_)
#define _impl_BRUTUS_SSizeRestriction__destroy_ 1
static void impl_BRUTUS_SSizeRestriction__destroy(impl_POA_BRUTUS_SSizeRestriction * servant,
						  CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SSizeRestriction__fini((PortableServer_Servant) servant, ev);

	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SSizeRestriction__get_relop_)
#define _impl_BRUTUS_SSizeRestriction__get_relop_ 1
static BRUTUS_RELOP_TYPE impl_BRUTUS_SSizeRestriction__get_relop(impl_POA_BRUTUS_SSizeRestriction * servant,
								 CORBA_Environment * ev)
{
	BRUTUS_RELOP_TYPE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_relop;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SSizeRestriction__get_ulPropTag_)
#define _impl_BRUTUS_SSizeRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SSizeRestriction__get_ulPropTag(impl_POA_BRUTUS_SSizeRestriction * servant,
								  CORBA_Environment * ev)
{
	BRUTUS_BDEFINE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulPropTag;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SSizeRestriction__get_cb_)
#define _impl_BRUTUS_SSizeRestriction__get_cb_ 1
static CORBA_unsigned_long impl_BRUTUS_SSizeRestriction__get_cb(impl_POA_BRUTUS_SSizeRestriction * servant,
								CORBA_Environment * ev)
{
	CORBA_unsigned_long retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_cb;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif


// ***************************************** //
// ***         SExistRestriction         *** //
// ***************************************** //

#if !defined(_impl_BRUTUS_SExistRestriction__create_)
#define _impl_BRUTUS_SExistRestriction__create_ 1
static BRUTUS_SExistRestriction impl_BRUTUS_SExistRestriction__create(CORBA_unsigned_long Reserved1,
								      BRUTUS_BDEFINE PropTag,
								      CORBA_unsigned_long Reserved2,
								      PortableServer_POA poa,
								      CORBA_Environment * ev)
{
	BRUTUS_SExistRestriction retval;
	impl_POA_BRUTUS_SExistRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SExistRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SExistRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SExistRestriction__init((PortableServer_Servant)
					   newservant, ev);

	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->attr_ulReserved1 = Reserved1;
	newservant->attr_ulPropTag = PropTag;
	newservant->attr_ulReserved2 = Reserved2;
	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SExistRestriction__destroy_)
#define _impl_BRUTUS_SExistRestriction__destroy_ 1
static void impl_BRUTUS_SExistRestriction__destroy(impl_POA_BRUTUS_SExistRestriction * servant,
						   CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 *servant and you may free your private attributes. */
	/* ------ free private attributes here ------ */
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SExistRestriction__fini((PortableServer_Servant)
					   servant, ev);

	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SExistRestriction__get_ulReserved1_)
#define _impl_BRUTUS_SExistRestriction__get_ulReserved1_ 1
static CORBA_unsigned_long impl_BRUTUS_SExistRestriction__get_ulReserved1(impl_POA_BRUTUS_SExistRestriction * servant,
									  CORBA_Environment * ev)
{
	CORBA_unsigned_long retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulReserved1;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SExistRestriction__set_ulReserved1_)
#define _impl_BRUTUS_SExistRestriction__set_ulReserved1_ 1
static void impl_BRUTUS_SExistRestriction__set_ulReserved1(impl_POA_BRUTUS_SExistRestriction * servant,
							   const CORBA_unsigned_long value,
							   CORBA_Environment * ev)
{
	/* ------   insert method code here   ------ */
	servant->attr_ulReserved1 = value;
	/* ------ ---------- end ------------ ------ */
}
#endif

#if !defined(_impl_BRUTUS_SExistRestriction__get_ulPropTag_)
#define _impl_BRUTUS_SExistRestriction__get_ulPropTag_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SExistRestriction__get_ulPropTag(impl_POA_BRUTUS_SExistRestriction * servant,
								   CORBA_Environment * ev)
{
	BRUTUS_BDEFINE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulPropTag;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SExistRestriction__get_ulReserved2_)
#define _impl_BRUTUS_SExistRestriction__get_ulReserved2_ 1
static CORBA_unsigned_long impl_BRUTUS_SExistRestriction__get_ulReserved2(impl_POA_BRUTUS_SExistRestriction * servant,
									  CORBA_Environment * ev)
{
	CORBA_unsigned_long retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulReserved2;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SExistRestriction__set_ulReserved2_)
#define _impl_BRUTUS_SExistRestriction__set_ulReserved2_ 1
static void impl_BRUTUS_SExistRestriction__set_ulReserved2(impl_POA_BRUTUS_SExistRestriction * servant,
							   const CORBA_unsigned_long value,
							   CORBA_Environment * ev)
{
	/* ------   insert method code here   ------ */
	servant->attr_ulReserved2 = value;
	/* ------ ---------- end ------------ ------ */
}
#endif


// *************************************** //
// ***         SSubRestriction         *** //
// *************************************** //

#if !defined(_impl_BRUTUS_SSubRestriction__create_)
#define _impl_BRUTUS_SSubRestriction__create_ 1
static BRUTUS_SSubRestriction impl_BRUTUS_SSubRestriction__create(BRUTUS_BDEFINE SubObject,
								  BRUTUS_SRestriction * Content,
								  PortableServer_POA poa,
								  CORBA_Environment * ev)
{
	BRUTUS_SSubRestriction retval;
	impl_POA_BRUTUS_SSubRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SSubRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SSubRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SSubRestriction__init((PortableServer_Servant)
					 newservant, ev);

	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->attr_ulSubObject = SubObject;
	newservant->attr_lpRes._d = Content->_d;
	switch (Content->_d) {
	case BRUTUS_BRUTUS_RES_ERROR:
		newservant->attr_lpRes._u.Error = Content->_u.Error;
		break;
	case BRUTUS_BRUTUS_RES_AND:
		newservant->attr_lpRes._u.resAnd = CORBA_Object_duplicate(Content->_u.resAnd, ev);
		break;
	case BRUTUS_BRUTUS_RES_OR:
		newservant->attr_lpRes._u.resOr = CORBA_Object_duplicate(Content->_u.resOr, ev);
		break;
	case BRUTUS_BRUTUS_RES_NOT:
		newservant->attr_lpRes._u.resNot = CORBA_Object_duplicate(Content->_u.resNot, ev);
		break;
	case BRUTUS_BRUTUS_RES_CONTENT:
		newservant->attr_lpRes._u.resContent = CORBA_Object_duplicate(Content->_u.resContent, ev);
		break;
	case BRUTUS_BRUTUS_RES_PROPERTY:
		newservant->attr_lpRes._u.resProperty = CORBA_Object_duplicate(Content->_u.resProperty, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMPAREPROPS:
		newservant->attr_lpRes._u.resCompareProps = CORBA_Object_duplicate(Content->_u.resCompareProps, ev);
		break;
	case BRUTUS_BRUTUS_RES_BITMASK:
		newservant->attr_lpRes._u.resBitMask = CORBA_Object_duplicate(Content->_u.resBitMask, ev);
		break;
	case BRUTUS_BRUTUS_RES_SIZE:
		newservant->attr_lpRes._u.resSize = CORBA_Object_duplicate(Content->_u.resSize, ev);
		break;
	case BRUTUS_BRUTUS_RES_EXIST:
		newservant->attr_lpRes._u.resExist = CORBA_Object_duplicate(Content->_u.resExist, ev);
		break;
	case BRUTUS_BRUTUS_RES_SUBRESTRICTION:
		newservant->attr_lpRes._u.resSub = CORBA_Object_duplicate(Content->_u.resSub, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMMENT:
		newservant->attr_lpRes._u.resComment = CORBA_Object_duplicate(Content->_u.resComment, ev);
		break;
	};
	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SSubRestriction__destroy_)
#define _impl_BRUTUS_SSubRestriction__destroy_ 1
static void impl_BRUTUS_SSubRestriction__destroy(impl_POA_BRUTUS_SSubRestriction * servant,
						 CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 * servant and you may free your private attributes. */

	/* ------ free private attributes here ------ */
	switch (servant->attr_lpRes._d) {
	case BRUTUS_BRUTUS_RES_ERROR:
		break;
	case BRUTUS_BRUTUS_RES_AND:
		free_orbit_object(servant->attr_lpRes._u.resAnd, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_OR:
		free_orbit_object(servant->attr_lpRes._u.resOr, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_NOT:
		free_orbit_object(servant->attr_lpRes._u.resNot, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_CONTENT:
		free_orbit_object(servant->attr_lpRes._u.resContent, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_PROPERTY:
		free_orbit_object(servant->attr_lpRes._u.resProperty, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMPAREPROPS:
		free_orbit_object(servant->attr_lpRes._u.resCompareProps, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_BITMASK:
		free_orbit_object(servant->attr_lpRes._u.resBitMask, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_SIZE:
		free_orbit_object(servant->attr_lpRes._u.resSize, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_EXIST:
		free_orbit_object(servant->attr_lpRes._u.resExist, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_SUBRESTRICTION:
		free_orbit_object(servant->attr_lpRes._u.resSub, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMMENT:
		free_orbit_object(servant->attr_lpRes._u.resComment, servant->poa, ev);
		break;
	};
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SSubRestriction__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SSubRestriction__get_ulSubObject_)
#define _impl_BRUTUS_SSubRestriction__get_ulSubObject_ 1
static BRUTUS_BDEFINE impl_BRUTUS_SSubRestriction__get_ulSubObject(impl_POA_BRUTUS_SSubRestriction * servant,
								   CORBA_Environment * ev)
{
	BRUTUS_BDEFINE retval;

	/* ------   insert method code here   ------ */
	retval = servant->attr_ulSubObject;
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SSubRestriction__get_lpRes_)
#define _impl_BRUTUS_SSubRestriction__get_lpRes_ 1
static BRUTUS_SRestriction *impl_BRUTUS_SSubRestriction__get_lpRes(impl_POA_BRUTUS_SSubRestriction * servant,
								   CORBA_Environment * ev)
{
	BRUTUS_SRestriction *retval;

	/* ------   insert method code here   ------ */
	retval = ORBit_copy_value(&servant->attr_lpRes, TC_BRUTUS_SRestriction);
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif


// ******************************************* //
// ***         SCommentRestriction         *** //
// ******************************************* //

#if !defined(_impl_BRUTUS_SCommentRestriction__create_)
#define _impl_BRUTUS_SCommentRestriction__create_ 1
static BRUTUS_SCommentRestriction impl_BRUTUS_SCommentRestriction__create(BRUTUS_SRestriction * Content,
									  BRUTUS_seq_SPropValue * seq_SPropValue,
									  PortableServer_POA poa,
									  CORBA_Environment * ev)
{
	BRUTUS_SCommentRestriction retval;
	impl_POA_BRUTUS_SCommentRestriction *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_BRUTUS_SCommentRestriction, 1);
	newservant->servant.vepv = &impl_BRUTUS_SCommentRestriction_vepv;
	newservant->poa = (PortableServer_POA) CORBA_Object_duplicate((CORBA_Object) poa, ev);
	POA_BRUTUS_SCommentRestriction__init((PortableServer_Servant)
					     newservant, ev);

	/* Before servant is going to be activated all
	 * private attributes must be initialized.  */

	/* ------ init private attributes here ------ */
	newservant->attr_lpRes._d = Content->_d;
	switch (Content->_d) {
	case BRUTUS_BRUTUS_RES_ERROR:
		newservant->attr_lpRes._u.Error = Content->_u.Error;
		break;
	case BRUTUS_BRUTUS_RES_AND:
		newservant->attr_lpRes._u.resAnd = CORBA_Object_duplicate(Content->_u.resAnd, ev);
		break;
	case BRUTUS_BRUTUS_RES_OR:
		newservant->attr_lpRes._u.resOr = CORBA_Object_duplicate(Content->_u.resOr, ev);
		break;
	case BRUTUS_BRUTUS_RES_NOT:
		newservant->attr_lpRes._u.resNot = CORBA_Object_duplicate(Content->_u.resNot, ev);
		break;
	case BRUTUS_BRUTUS_RES_CONTENT:
		newservant->attr_lpRes._u.resContent = CORBA_Object_duplicate(Content->_u.resContent, ev);
		break;
	case BRUTUS_BRUTUS_RES_PROPERTY:
		newservant->attr_lpRes._u.resProperty = CORBA_Object_duplicate(Content->_u.resProperty, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMPAREPROPS:
		newservant->attr_lpRes._u.resCompareProps = CORBA_Object_duplicate(Content->_u.resCompareProps, ev);
		break;
	case BRUTUS_BRUTUS_RES_BITMASK:
		newservant->attr_lpRes._u.resBitMask = CORBA_Object_duplicate(Content->_u.resBitMask, ev);
		break;
	case BRUTUS_BRUTUS_RES_SIZE:
		newservant->attr_lpRes._u.resSize = CORBA_Object_duplicate(Content->_u.resSize, ev);
		break;
	case BRUTUS_BRUTUS_RES_EXIST:
		newservant->attr_lpRes._u.resExist = CORBA_Object_duplicate(Content->_u.resExist, ev);
		break;
	case BRUTUS_BRUTUS_RES_SUBRESTRICTION:
		newservant->attr_lpRes._u.resSub = CORBA_Object_duplicate(Content->_u.resSub, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMMENT:
		newservant->attr_lpRes._u.resComment = CORBA_Object_duplicate(Content->_u.resComment, ev);
		break;
	};

	newservant->lpProp = ORBit_copy_value(seq_SPropValue, TC_BRUTUS_seq_SPropValue);

	// reset the unused attribute
	newservant->attr_lpProp._maximum = 0;
	newservant->attr_lpProp._length = 0;
	newservant->attr_lpProp._buffer = NULL;
	CORBA_sequence_set_release(&newservant->attr_lpProp, CORBA_TRUE);

	/* ------ ---------- end ------------- ------ */

	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SCommentRestriction__destroy_)
#define _impl_BRUTUS_SCommentRestriction__destroy_ 1
static void impl_BRUTUS_SCommentRestriction__destroy(impl_POA_BRUTUS_SCommentRestriction * servant,
						     CORBA_Environment * ev)
{
	CORBA_Object_release((CORBA_Object) servant->poa, ev);

	/* No further remote method calls are delegated to 
	 * servant and you may free your private attributes. */

	/* ------ free private attributes here ------ */
	switch (servant->attr_lpRes._d) {
	case BRUTUS_BRUTUS_RES_ERROR:
		break;
	case BRUTUS_BRUTUS_RES_AND:
		free_orbit_object(servant->attr_lpRes._u.resAnd, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_OR:
		free_orbit_object(servant->attr_lpRes._u.resOr, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_NOT:
		free_orbit_object(servant->attr_lpRes._u.resNot, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_CONTENT:
		free_orbit_object(servant->attr_lpRes._u.resContent, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_PROPERTY:
		free_orbit_object(servant->attr_lpRes._u.resProperty, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMPAREPROPS:
		free_orbit_object(servant->attr_lpRes._u.resCompareProps, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_BITMASK:
		free_orbit_object(servant->attr_lpRes._u.resBitMask, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_SIZE:
		free_orbit_object(servant->attr_lpRes._u.resSize, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_EXIST:
		free_orbit_object(servant->attr_lpRes._u.resExist, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_SUBRESTRICTION:
		free_orbit_object(servant->attr_lpRes._u.resSub, servant->poa, ev);
		break;
	case BRUTUS_BRUTUS_RES_COMMENT:
		free_orbit_object(servant->attr_lpRes._u.resComment, servant->poa, ev);
		break;
	};
	CORBA_free(servant->lpProp);
	/* ------ ---------- end ------------- ------ */

	POA_BRUTUS_SCommentRestriction__fini((PortableServer_Servant)
					     servant, ev);
	g_free(servant);
}
#endif

#if !defined(_impl_BRUTUS_SCommentRestriction__get_lpRes_)
#define _impl_BRUTUS_SCommentRestriction__get_lpRes_ 1
static BRUTUS_SRestriction *impl_BRUTUS_SCommentRestriction__get_lpRes(impl_POA_BRUTUS_SCommentRestriction * servant,
								       CORBA_Environment * ev)
{
	BRUTUS_SRestriction *retval;

	/* ------   insert method code here   ------ */
	retval = ORBit_copy_value(&servant->attr_lpRes, TC_BRUTUS_SRestriction);
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif

#if !defined(_impl_BRUTUS_SCommentRestriction__get_lpProp_)
#define _impl_BRUTUS_SCommentRestriction__get_lpProp_ 1
static BRUTUS_seq_SPropValue *impl_BRUTUS_SCommentRestriction__get_lpProp(impl_POA_BRUTUS_SCommentRestriction * servant,
									  CORBA_Environment * ev)
{
	BRUTUS_seq_SPropValue *retval;

	/* ------   insert method code here   ------ */
	retval = ORBit_copy_value(servant->lpProp, TC_BRUTUS_seq_SPropValue);
	CORBA_sequence_set_release(retval, CORBA_TRUE);
	/* ------ ---------- end ------------ ------ */

	return retval;
}
#endif
