/* Copyright (C) 1991, 1992, 1995, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifdef WC_DEBUG
#include <stdio.h>
#endif
#include <stdlib.h>
#include <wchar.h>
#include "wcsmbsload.h"

extern mbstate_t __no_r_state;	/* Defined in mbtowc.c.  */

/* Convert the `wchar_t' string in PWCS to a multibyte character string
   in S, writing no more than N characters.  Return the number of bytes
   written, or (size_t) -1 if an invalid `wchar_t' was found.

   Attention: this function should NEVER be intentionally used.
   The interface is completely stupid.  The state is shared between
   all conversion functions.  You should use instead the restartable
   version `wcsrtombs'.  */
size_t
wcstombs (char *s, const wchar_t *pwcs, size_t n)
{
  mbstate_t state;
  size_t written=0;
  int moz_bug=0;

#ifdef WC_DEBUG
  fprintf(stderr, "begin: wcstombs\n");
  fprintf(stderr, "info: char  s    = [%s]\n", s ? "(something)" : "(null)");
  fprintf(stderr, "info: char  s(p) = [%p]\n", s);
  fprintf(stderr, "info: wchar pwcs = [%p]\n", pwcs);
  fprintf(stderr, "info: size  n    = [%d]\n", n);
#endif

#ifdef WC_DEBUG
  fprintf(stderr, "Info: HEXA  pwcs &FFFFFFFF   = [%08X]\n", (wchar_t)(pwcs[0]) & 0xFFFFFFFF );
#endif

  if ( ((wchar_t)(pwcs[0]) & 0xFFFF0000) != 0x00000000 ) {
#ifdef WC_DEBUG
     fprintf(stderr, "Info: *** Mozilla BUG ***: char  pwcs    = [%s]\n", pwcs ? pwcs : "(null)");
#endif
     moz_bug=1;
  }
  else {
#ifdef WC_DEBUG
     fprintf(stderr, "Info: OK. This is wchar_t string : wchar_t  pwcs   = [%S]\n", pwcs ? pwcs : "(null)");
#endif
     moz_bug=0;
  }
  memset (&state, '\0', sizeof state);
  if (n > 0) written = wcsrtombs (s, &pwcs, n, &state);
  memset (&state, '\0', sizeof state);
//  if (n > 0) written = wcsrtombs (s, &pwcs, n, &__no_r_state);

  if ( -1 == written) {
#ifdef WC_DEBUG
    fprintf(stderr, "Info: *** Mozilla BUG *** (failed wcsrtombs)\ninfo: Workaround using strncpy ***\n", n);
#endif

    if (moz_bug && n > 0) {
	strncpy(s, (char *)pwcs, n);
        // wcsrtombs()  .
	// #1 ҽ MB Ǹ   
        // ׳ (strncpy)Ѵ. Mozilla BUG #1
        written = s[n - 1]? n: strlen(s);
    } else if (moz_bug && n <= 0) {
	written = 0;
        // n<0   ̴.   ܼ null Ѵ.
        // Mozilla BUG #2 ?
        // n=0  glibc  wcsrtombs() assertion fail .
	// ܼ null Ѵ.
        // Glibc BUG #1
    }

    if (moz_bug == 0) {
#ifdef WC_DEBUG
       // Glibc BUG #2 ?
       fprintf(stderr, "Info: Glibc BUG pwcs = [%S]\n", pwcs ? pwcs:"(null)");
#endif
       if (n > 0) written = wcsrtombs (s, &pwcs, n, &state);
#ifdef WC_DEBUG
       fprintf(stderr, "Info: Glibc BUG pwcs = [%s](after)\n", s ? s:"(null)");
#endif
    }
  }

  /* Return how many we wrote (or maybe an error).  */
#ifdef WC_DEBUG
  fprintf(stderr, "Result: char  s    = [%s](after)\n", s ? s : "(null)");
  fprintf(stderr, "Result: return %d(wcstombs)\n", written);
#endif
  return written;
}
