/* Copyright (C) 1991, 92, 95, 96, 97, 98 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifdef WC2MB_DEBUG
#include <stdio.h>
#endif
#include <stdlib.h>
#include <wchar.h>
#include <gconv.h>
#include "wcsmbsload.h"

extern mbstate_t __no_r_state;	/* Defined in mbtowc.c.  */

/* Convert WCHAR into its multibyte character representation,
   putting this in S and returning its length.

   Attention: this function should NEVER be intentionally used.
   The interface is completely stupid.  The state is shared between
   all conversion functions.  You should use instead the restartable
   version `wcrtomb'.  */
int
wctomb (char *s, wchar_t wchar)
{
  int result=0,i;
  int moz_check=0;
  mbstate_t state,state_save;

#ifdef WC2MB_DEBUG
  fprintf(stderr,"Begin: wctomb\n");
  fprintf(stderr,"Info: char  s      =[%s]\n", s ? "(something)" : "(null)");
  fprintf(stderr,"Info: char  s      =[%c%c]\n", ((char *)s)[0],((char *)s)[1]);
  fprintf(stderr,"Info: char  s(p)   =[%p]\n", s);
//  fprintf(stderr,"Info: wchar_t wchar=[%C](before)\n",((wchar_t *)&wchar)[0]);
//  fprintf(stderr,"Info: wchar_t wchar=[%S](before)\n",&wchar);            
#endif

  /* If S is NULL the function has to return null or not null
     depending on the encoding having a state depending encoding or
     not.  */
  if (s == NULL)
    {
      /* Make sure we use the correct value.  */
      update_conversion_ptrs ();

      /* This is an extension in the Unix standard which does not directly
         violate ISO C.  */
      memset (&__no_r_state, '\0', sizeof __no_r_state);

      result = __wcsmbs_gconv_fcts.tomb->__stateful;
#ifdef WC2MB_DEBUG
      fprintf(stderr, "info: NULL return %d(wctomb)\n", result);            
#endif
      return result;
    }

//  BUG #4: Memory allocation error ??
  {
    char buf[4];
    static char obuf[1];
    buf[1]='\0';

    memset (&state, '\0', sizeof state);
    result = wcrtomb (buf, wchar, &state);
    memset (&state, '\0', sizeof state);

#if WC2MB_DEBUG
  fprintf(stderr,"info: OBUF %d %d %d\n",obuf[0],buf[0],buf[1]);
#endif
    if (!buf[0] && !buf[1] && result==-1) {
#if WC2MB_DEBUG
      fprintf(stderr,"info: RESET ERROR (%d) %X\n",result,obuf[0]);
#endif
      if (obuf[0]) result=0; /* HACK */
      obuf[0]=buf[0];
      return result;
    }
//    if (obuf[0]&0xFFFF0000 && !buf[0] && !buf[1]) {
//      fprintf(stderr,"info: BUS ERROR ?\n");
//      return -1;
//    }
#if WC2MB_DEBUG
  fprintf(stderr,"info: OBUF %d %d %d\n",obuf[0],buf[0],buf[1]);
#endif
    obuf[0]=buf[0];

    if (((char *)s)[0] == 8);
	// HACK TextField Cut & Paste BUS ERROR!!
	// do not call wcrtomb(), Only return the size of string.
    else result=wcrtomb(s,wchar,&state);
  }
#ifdef WC2MB_DEBUG
  moz_check=((char *)s)[0] == 8 ? 1:
	    ((char *)s)[0] == 0 ? 2:0;
		/* Cut & Past BUS ERROR in TextField */
		/* Double Click BUS ERROR in TextField */
  fprintf(stderr, "Info: MOZ CHECK %d\n",moz_check);

#endif
//  for (i=0;i<result;i++) fprintf(stderr,"%c ",*s+i);
#ifdef WC2MB_DEBUG
  fprintf(stderr,"Info: state =[%d]\n",state);
  fprintf(stderr,"Info: char  s      =[%c%c](after)\n", ((char *)s)[0],((char *)s)[1]);
  fprintf(stderr,"Info: char  s      =[%X %X](after)\n", ((char *)s)[0],((char *)s)[1]);
  fprintf(stderr,"info: return %d(wctomb)\n", result);            
#endif
  return result;
}
