/*
 * ncode version 2.0
 *
 * ncode.h - code conversion functions for ncode, combination code and KSC-5601.
 * Lee yongjae, setup@shiva.snu.ac.kr, 1996.9.
 *
 * Copyright (c) 1996 by Lee yongjae, in dept. of Computer Science
 * in Seoul National University, Korea.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the copyright holder
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission.
 *
 * This software is provided "as is" without express or implied warranty.
 *
 */

#ifndef _ncode_h_
#define _ncode_h_

#define NCODE_FIRST     0xa1
#define NCODE_F1        0xa1
#define NCODE_CH_FIRST  0xa2
#define NCODE_CH_O      0xad
#define NCODE_CH_LAST   0xb4
#define NCODE_F2        0xb5
#define NCODE_JU_FIRST  0xb6
#define NCODE_JU_LAST   0xca
#define NCODE_JO_FIRST  0xcb
#define NCODE_JO_LAST   0xe5
#define NCODE_LAST      0xe5

#define KS_PARTIAL_FIRST  0xa4a1
#define KS_PARTIAL_LAST   0xa4d3
#define KS_NORMAL_FIRST   0xb0a1 
#define KS_NORMAL_LAST    0xc8fe

#ifdef __cplusplus
extern "C" { 
#endif

unsigned char *ks_to_n(/* unsigned short c, unsigned char *buf */);
/*
 * Returns pointer to the next of the charaters consumed.
 * If conversion fails, the return value is buf.
 */

unsigned char *n_to_ks(/* unsigned char *buf, unsigned short *c_ret */);
/*
 * Returns pointer to the next of the charaters consumed.
 * If conversion fails, the return value is buf.
 */

unsigned char *comb_to_n(/* unsigned short c, unsigned char *buf */);
/*
 * Returns pointer to the next of the charaters consumed.
 * If conversion fails, the return value is buf.
 */

unsigned char *n_to_comb(/* unsigned char *buf, unsigned short *c_ret */);
/*
 * Returns pointer to the next of the charaters consumed.
 * If conversion fails, the return value is buf.
 */

unsigned short ks_to_comb(/* unsigned short c */);
/*
 * Returns 0 on conversion faiure.
 */

unsigned short comb_to_ks(/* unsigned short c */);
/*
 * Returns 0 on conversion failure.
 */

char *n_to_alpha(/* unsigned char c */);
/*
 * Returns pointer to local buffer or 0 on conversion failure.
 */

char *ks_to_alpha(/* unsigned short c */);
/*
 * Returns pointer to local buffer or 0 on conversion failure.
 */

#ifdef __cplusplus
}
#endif

#endif  /* _ncode_h_ */
