/*
 * RoverP5+ GPIO definitions.
 *
 * Authors: Konstantine A. Beklemishev (konstantine@r66.ru)
 */

#ifndef _ROVERP5P_GPIO_H_
#define _ROVERP5P_GPIO_H_

#define GET_ROVERP5P_GPIO(gpio) \
	(GPLR(GPIO_NR_ROVERP5P_ ## gpio) & GPIO_bit(GPIO_NR_ROVERP5P_ ## gpio))

#define SET_ROVERP5P_GPIO(gpio, setp) \
do { \
if (setp) \
	GPSR(GPIO_NR_ROVERP5P_ ## gpio) = GPIO_bit(GPIO_NR_ROVERP5P_ ## gpio); \
else \
	GPCR(GPIO_NR_ROVERP5P_ ## gpio) = GPIO_bit(GPIO_NR_ROVERP5P_ ## gpio); \
} while (0)

#define SET_ROVERP5P_GPIO_N(gpio, setp) \
do { \
if (setp) \
	GPCR(GPIO_NR_ROVERP5P_ ## gpio ## _N) = GPIO_bit(GPIO_NR_ROVERP5P_ ## gpio ## _N); \
else \
	GPSR(GPIO_NR_ROVERP5P_ ## gpio ## _N) = GPIO_bit(GPIO_NR_ROVERP5P_ ## gpio ## _N); \
} while (0)

#define ROVERP5P_IRQ(gpio) \
	IRQ_GPIO(GPIO_NR_ROVERP5P_ ## gpio)

#define GPIO_NR_ROVERP5P_POWER_BUTTON		(0)
#define GPIO_NR_ROVERP5P_RESET_BUTTON		(1)
#define GPIO_NR_ROVERP5P_CF_DETECT		(2)
#define GPIO_NR_ROVERP5P_RS232_CARIER_DETECT	(3)
#define GPIO_NR_ROVERP5P_PXA_AC97_IRQ		(4)
#define IRQ_NR_ROVERP5P_PXA_AC97			IRQ_GPIO(GPIO_NR_ROVERP5P_PXA_AC97_IRQ)
#define GPIO_NR_ROVERP5P_PXA_nMQINT		(5)

#define GPIO_NR_ROVERP5P_VOICE_REC		(7)

#define GPIO_NR_ROVERP5P_PXA_PRDY		(9)
#define GPIO_NR_ROVERP5P_BUTT_1			(10)
#define GPIO_NR_ROVERP5P_BUTT_2			(11)
#define GPIO_NR_ROVERP5P_USB_INT		(12)
#define GPIO_NR_ROVERP5P_BUTT_3			(13)
#define GPIO_NR_ROVERP5P_BUTT_4			(14)

#define GPIO_NR_ROVERP5P_CF_BUS_nON		(16)
#define GPIO_NR_ROVERP5P_RED_OFF		(17)
#define GPIO_NR_ROVERP5P_PXA_RDY		(18)
#define GPIO_NR_ROVERP5P_SLIDE_PUSH		(19)
#define GPIO_NR_ROVERP5P_SLIDE_DOWN		(20)
#define GPIO_NR_ROVERP5P_SLIDE_UP		(21)
#define GPIO_NR_ROVERP5P_PXA_MQ_nRESET		(22)
#define GPIO_NR_ROVERP5P_JOY_UP			(23)
#define GPIO_NR_ROVERP5P_JOY_DOWN		(24)
#define GPIO_NR_ROVERP5P_JOY_LEFT		(25)
#define GPIO_NR_ROVERP5P_JOY_RIGHT		(26)
#define GPIO_NR_ROVERP5P_ACIN			(27)
#define GPIO_NR_ROVERP5P_PXA_BITCLK		(28)
#define GPIO_NR_ROVERP5P_PXA_SDATA_IN		(29)
#define GPIO_NR_ROVERP5P_PXA_SDATA_OUT		(30)
#define GPIO_NR_ROVERP5P_PXA_SYNC		(31)
#define GPIO_NR_ROVERP5P_PXA_FLASH_ST		(32)
//#define GPIO_NR_ROVERP5P_nCS			(33)
#define GPIO_NR_ROVERP5P_PXA_RXD_1		(34)
#define GPIO_NR_ROVERP5P_PXA_CTS_1		(35)
#define GPIO_NR_ROVERP5P_PXA_DCD_1		(36)
#define GPIO_NR_ROVERP5P_PXA_DSR_1		(37)
#define GPIO_NR_ROVERP5P_PXA_RI_1		(38)
#define GPIO_NR_ROVERP5P_PXA_TXD_1		(39)
#define GPIO_NR_ROVERP5P_PXA_DTR_1		(40)
#define GPIO_NR_ROVERP5P_PXA_RTS_1		(41)
#define GPIO_NR_ROVERP5P_PXA_BT_RX		(42)
#define GPIO_NR_ROVERP5P_PXA_BT_TX		(43)
#define GPIO_NR_ROVERP5P_PXA_BT_CTS		(44)
#define GPIO_NR_ROVERP5P_PXA_BT_RTS		(45)
#define GPIO_NR_ROVERP5P_PXA_RXD_2		(46)
#define GPIO_NR_ROVERP5P_PXA_TXD_2		(47)
#define GPIO_NR_ROVERP5P_PXA_nPOE		(48)
#define GPIO_NR_ROVERP5P_PXA_nPWE		(49)
#define GPIO_NR_ROVERP5P_PXA_nPIOW		(50)
#define GPIO_NR_ROVERP5P_PXA_nPIOR		(51)
#define GPIO_NR_ROVERP5P_PXA_nPCE1		(52)
#define GPIO_NR_ROVERP5P_PXA_nPCE2		(53)
#define GPIO_NR_ROVERP5P_PXA_nPSKTSEL		(54)
#define GPIO_NR_ROVERP5P_PXA_nPREG		(55)
#define GPIO_NR_ROVERP5P_PXA_nWAIT		(56)
#define GPIO_NR_ROVERP5P_PXA_nPIOS16		(57)

#define GPIO_NR_ROVERP5P_USB_EN			(59)

#define GPIO_NR_ROVERP5P_PHONE_IN		(63)

#define GPIO_NR_ROVERP5P_CF_BVD1		(66)
#define GPIO_NR_ROVERP5P_CF_BVD2		(67)



#define GPIO_NR_ROVERP5P_PXA_BT_RESET		(70)

#define GPIO_NR_ROVERP5P_BLUE_ON_OFF		(72)


#define GPIO_NR_ROVERP5P_RS232_VALID		(75)
#define GPIO_NR_ROVERP5P_CF_PWR_ON		(76)
#define GPIO_NR_ROVERP5P_CF_RESET		(77)

/*
 * Some macros to use MediaQ 1132 GPIO pins
 */
#if 0
#define PLATFORM_SIR_OFF \
  { MQ11xx_SP08R = (MQ11xx_SP08R & ~(MQ11xx_SP08R_GPIO63 | (MQ11xx_SP08R_GPIO_CTL_MASK << MQ11xx_SP08R_GPIO63_CTL_SHIFT))) \
    | (MQ11xx_SP08R_GPIO_CTL_OUT << MQ11xx_SP08R_GPIO63_CTL_SHIFT); }
#define PLATFORM_SIR_ON \
  { MQ11xx_SP08R = (MQ11xx_SP08R & ~(MQ11xx_SP08R_GPIO_CTL_MASK << MQ11xx_SP08R_GPIO63_CTL_SHIFT)) \
    | (MQ11xx_SP08R_GPIO63 | (MQ11xx_SP08R_GPIO_CTL_OUT << MQ11xx_SP08R_GPIO63_CTL_SHIFT)); }
#endif

#endif /* _ROVERP5P_GPIO_H_ */
