/* SCCSID("@(#)debug.h   %E%   SAP   %I%") */

/************************************************************************/
/* $Id: debug.h,v 1.1.1.1 1998/11/06 14:33:16 d019080 Exp $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */


#ifndef _XX_DEBUG_H_
#  define  _XX_DEBUG_H_

#include <stdarg.h>

#ifdef     XDEBUG

extern int debug_global_flag;

typedef enum dbg_class_e {
      DBG_CLASS_ERR	= (1<<0),
      DBG_CLASS_ARG	= (1<<1),
      DBG_CLASS_ARGV	= (1<<2),
      DBG_CLASS_RET	= (1<<3),
      DBG_CLASS_INFO	= (1<<4),
      DBG_CLASS_STRING	= (1<<5)
} dbg_class_et;


extern void debug_init( int enable, FILE * fp, char * filename );
extern void debug_print( dbg_class_et p_class, ... );

#define DEBUG_INIT()	   debug_init( FALSE, stderr, NULL );

#define DEBUG_BEGIN(x)	   char  * this_Call GNU_UNUSED = # x ;
#define DEBUG_EXEC(x)	   x


#undef XDBG
#define XDBG(x)  debug_print x ;
#define D_ERR    DBG_CLASS_ERR,  this_Call
#define D_ARG    DBG_CLASS_ARG,  this_Call
#define D_RET    DBG_CLASS_RET,  this_Call
#define D_ARGV   DBG_CLASS_ARGV
#define D_INFO   DBG_CLASS_INFO
#define D_STRING DBG_CLASS_STRING


#if 1
#define DEBUG_ERR(x)
#define DEBUG_INFO(x)
#define DEBUG_STRANGE(x)

#define DEBUG_ARG(x)
#define DEBUG_ARG_STRING(x)

#define DEBUG_RET(x)

#else

#define DEBUG_ARG(x)					 \
      if ( (debug_global_flag) )			 \
      {							 \
	 fprintf(tf, "->> %s(\n", this_Call);		 \
	 fprintf x ;					 \
	 fflush(tf);					 \
      }

#define DEBUG_ARG_STRING(x)				 \
      if ( (debug_global_flag) )			 \
      {							 \
	 fprintf(tf, "\t%s = \"%s\"\n", #x, x);		 \
	 fflush(tf);					 \
      }

#define DEBUG_ERR(x)					 \
      if ( (debug_global_flag) )			 \
      {							 \
	 fprintf(tf, "  ERROR in %s\n  ", this_Call);	 \
	 fprintf x;					 \
	 fflush(tf);					 \
      }


#define DEBUG_INFO(x)
#define DEBUG_STRANGE(x)

#define DEBUG_RET(x)					 \
      if ( (debug_global_flag) )			 \
      {							 \
	 fprintf(tf, "<<- %s() ", this_Call);		 \
	 fprintf x;					 \
	 fprintf(tf, "----------\n");			 \
	 fflush(tf);					 \
      }
#endif


#else  /* !XDEBUG */

#define XDBG(x)
#define DEBUG_INIT()

#define DEBUG_BEGIN(x)
#define DEBUG_ERR(x)
#define DEBUG_INFO(x)
#define DEBUG_STRANGE(x)

#define DEBUG_ARG(x)
#define DEBUG_ARG_STRING(x)

#define DEBUG_RET(x)

#define DEBUG_EXEC(x)


#endif /* !XDEBUG */



#endif /* _XX_DEBUG_H_ */
