/* SCCSID("@(#)load_dll.h   %E%   SAP   %I%") */

/************************************************************************/
/* $Id: load_dll.h,v 1.2 1998/11/27 15:25:01 d019080 Exp $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#define MAX_QOP_VALUES   5


typedef OM_uint32 (FUNCPTR_DECO GSS_VOID_FUNC_T)( void );


struct xtime {
   Ulong    min;
   Ulong    max;
   Ulong    count;
   Ulong    sum;
};

struct dll_gssfp_s {
   int				  dll_handle;
   char			        * dll_name;

   GSS_ACQUIRE_CRED_T		* gss_acquire_cred;
   GSS_RELEASE_CRED_T		* gss_release_cred;
   GSS_INIT_SEC_CONTEXT_T	* gss_init_sec_context;
   GSS_ACCEPT_SEC_CONTEXT_T	* gss_accept_sec_context;
   GSS_PROCESS_CONTEXT_TOKEN_T	* gss_process_context_token;
   GSS_DELETE_SEC_CONTEXT_T	* gss_delete_sec_context;
   GSS_CONTEXT_TIME_T		* gss_context_time;
   GSS_GET_MIC_T		* gss_get_mic;
   GSS_VERIFY_MIC_T		* gss_verify_mic;
   GSS_WRAP_T			* gss_wrap;
   GSS_UNWRAP_T			* gss_unwrap;
   GSS_DISPLAY_STATUS_T		* gss_display_status;
   GSS_INDICATE_MECHS_T		* gss_indicate_mechs;
   GSS_COMPARE_NAME_T		* gss_compare_name;
   GSS_DISPLAY_NAME_T	        * gss_display_name;
   GSS_IMPORT_NAME_T		* gss_import_name;
   GSS_RELEASE_NAME_T		* gss_release_name;
   GSS_RELEASE_BUFFER_T		* gss_release_buffer;
   GSS_RELEASE_OID_SET_T	* gss_release_oid_set;
   GSS_INQUIRE_CRED_T		* gss_inquire_cred;
   GSS_ADD_CRED_T		* gss_add_cred;
   GSS_INQUIRE_CRED_BY_MECH_T	* gss_inquire_cred_by_mech;
   GSS_INQUIRE_CONTEXT_T	* gss_inquire_context;
   GSS_WRAP_SIZE_LIMIT_T	* gss_wrap_size_limit;
   GSS_EXPORT_SEC_CONTEXT_T	* gss_export_sec_context;
   GSS_IMPORT_SEC_CONTEXT_T	* gss_import_sec_context;
   GSS_CREATE_EMPTY_OID_SET_T	* gss_create_empty_oid_set;
   GSS_ADD_OID_SET_MEMBER_T	* gss_add_oid_set_member;
   GSS_TEST_OID_SET_MEMBER_T	* gss_test_oid_set_member;
   GSS_INQUIRE_NAMES_FOR_MECH_T	* gss_inquire_names_for_mech;
   GSS_INQUIRE_MECHS_FOR_NAME_T	* gss_inquire_mechs_for_name;
   GSS_CANONICALIZE_NAME_T	* gss_canonicalize_name;
   GSS_EXPORT_NAME_T		* gss_export_name;
   GSS_DUPLICATE_NAME_T		* gss_duplicate_name;
   GSS_VOID_FUNC_T		* gss_last_func;

   SAPSNC_INIT_ADAPTER_T        * sapsnc_init_adapter;
   SAPSNC_EXPORT_CNAME_BLOB_T	* sapsnc_export_cname_blob;
   SAPSNC_IMPORT_CNAME_BLOB_T	* sapsnc_import_cname_blob;

   struct xtime			  tm[GSS_CALL_ENUM_MAX];    /* reset-able timing statistics     */
   struct xtime			  gtm[GSS_CALL_ENUM_MAX];   /* overall/global timing statistics */

   gss_OID_set			  mech_set;
   gss_OID			  mech;
   gss_OID_set			  nt_list;
   gss_OID			  can_nametype;

   char			        * acceptor;	   /* (malloced) as supplied by user (or copied from initiator when not supplied) */
   size_t			  acceptor_len;	   /* valid length of acceptor name (the buffer is NOT 0-terminated, but filled with trailing garbage) */
   char			        * initiator;	   /* (malloced) as retrieved from default initiator credentials */
   size_t			  initiator_len;   /* valid length of initiator name (the buffer is NOT 0-terminated, but filled with trailing garbage) */
   gss_name_t			  acc_name;	   /* gssapi-imported acceptor  name convenience handle */
   gss_name_t			  ini_name;	   /* gssapi-imported initiator name convenience handle */

   char				* def_acc;	   /* default acceptor identity (from default acceptor credentials) */
   size_t			  def_acc_len;	   /* length of acceptor identity */
   char			        * can_acc;	   /* canonical acceptor identity (from accepting credentials) */
   size_t			  can_acc_len;	   /* length of canonical acceptor identity */

   Ulong			  dspstat_one_max_lines;
   Ulong			  dspstat_one_max_linelen;
   Ulong			  dspstat_one_min_linelen;
   Ulong			  dspstat_one_sum_linelen;
   Ulong			  dspstat_one_counter;
   Ulong			  dspstat_two_max_lines;
   Ulong			  dspstat_two_max_linelen;
   Ulong			  dspstat_two_min_linelen;
   Ulong			  dspstat_two_sum_linelen;
   Ulong			  dspstat_two_counter;

   Ulong			  dspstat_trailing_nul;
   Ulong			  dspstat_embedded_nul;
   Ulong			  dspstat_linebreak;

   Ulong			  dspname_trailing_nul;
   Ulong			  dspname_embedded_nul;
   Ulong			  dspname_linebreak;
   Ulong			  dspname_specials;
   Ulong			  dspname_trailing_wsp;
   Ulong			  dspname_leading_wsp;

   OM_uint32			  rci;

   OM_uint32			  ctx_flags_always;	  /* only context flags that were returned for EVERY successfully established context */
   OM_uint32			  ctx_flags_requested;	  /* all context flags that were requested at least once */
   OM_uint32			  ctx_flags_sometimes;	  /* all context flags that were returned at least for one successfully established context */
   OM_uint32			  ctx_flags_donated;	  /* all context flags that were returned but not requested */
   OM_uint32			  ctx_flags_denied;	  /* all context flags that were requested but not returned */
   OM_uint32			  ctx_flags_inconsistent; /* inconsistent flags for acceptor and initiator */

   Ulong			  ctx_lifetime_stat_begin;   /* current time() for the first successfully established security context */
   Ulong			  ctx_lifetime_stat_end;     /* current time() for the last  successfully established security context */
   Ulong			  ctx_lifetime_counter;	     /* counter of successfully established security context */
   Ulong			  ctx_lifetime_indefinite;   /* counter of successfully established security context with indefinite lifetime */
   Ulong			  ctx_lifetime_inconsistent; /* counter of successfully established security context with mismatch in lifetime ini<->acc */
   Ulong			  ctx_lifetime_skew;	     /* mismatch of credential and security context lifetime (>20sec) that will break security context refresh at app level */
   Ulong			  ctx_lifetime_ini_initial;  /* initiator context lifetime for the first successfully established security context   */
   Ulong			  ctx_lifetime_ini_final;    /* initiator context lifetime for the last  successfully established security context   */
   Ulong			  ctx_lifetime_ini_growth;   /* accumulated lifetime of observed growth for initial security context lifetimes (ini) */
   Ulong			  ctx_lifetime_ini_min;	     /* observed shorted initial context lifetime */
   Ulong			  ctx_lifetime_ini_max;	     /* observed longest initial context lifetime */
   Ulong			  ctx_lifetime_acc_initial;  /* acceptor context lifetime for the first successfully established security context    */
   Ulong			  ctx_lifetime_acc_final;    /* acceptor context lifetime for the last  successfully established security context    */
   Ulong			  ctx_lifetime_acc_growth;   /* accumulated lifetime of observed growth for initial security context lifetimes (acc) */
   Ulong			  ctx_lifetime_acc_min;	     /* observed shorted initial context lifetime */
   Ulong			  ctx_lifetime_acc_max;      /* observed longest initial context lifetime */

   Ulong			  cred_lifetime_counter;
   Ulong			  cred_lifetime_ini_growth;
   Ulong			  cred_lifetime_ini_initial;
   Ulong			  cred_lifetime_ini_final;
   Ulong			  cred_lifetime_acc_growth;
   Ulong			  cred_lifetime_acc_initial;
   Ulong			  cred_lifetime_acc_final;
   Ulong			  cred_ctx_lifetime_ini_mismatch;
   Ulong			  cred_ctx_lifetime_acc_mismatch;

   Ulong			  context_counter;	 /* count of successfully established security contexts */
   Ulong			  context_xferable;	 /* count of established security contexts with transferable attribute */
   Ulong		          context_xferred;	 /* count of successful context transfers within same process */
   Ulong			  context_xferred_child; /* count of successful context transfers to and from child process */
   Ulong		          context_conf;		 /* count of established security contexts with confidentiality protection */  
   Ulong			  context_integ;	 /* count of established security contexts with integrity       protection */

   Ulong			  ctx_ini_token_min;	 /* observed min size of context level tokens from ini->acc */
   Ulong			  ctx_ini_token_max;	 /* observed max size of context level tokens from ini->acc */
   Ulong			  ctx_acc_token_min;	 /* observed min size of context level tokens from acc->ini */
   Ulong			  ctx_acc_token_max;	 /* observed max size of context level tokens from acc->ini */
   Ulong			  ctx_exported_min[2];	 /* observed min size of interprocess context token */
   Ulong			  ctx_exported_max[2];	 /* observed max size of interprocess context token */
   Ulong			  ctx_exported_count[2]; /* counter for successful context exports (initiator/acceptor) */

   Ulong			  mic_size_min;		 /* observed min length of gss_getmic() tokens */
   Ulong			  mic_size_max;		 /* observed max length of gss_getmic() tokens */
   Ulong		          wconf_size_min;	 /* observed min growth of gss_wrap(conf=TRUE) messages */
   Ulong		          wconf_size_max;	 /* observed max growth of gss_wrap(conf=TRUE) messages */
   Ulong			  wmic_size_min;	 /* observed min growth of gss_wrap(conf=FALSE) messages */
   Ulong			  wmic_size_max;	 /* observed max growth of gss_wrap(conf=FALSE) messages */

   OM_uint32			  mic_qop[MAX_QOP_VALUES];
   OM_uint32			  wconf_qop[MAX_QOP_VALUES];
   OM_uint32			  wmic_qop[MAX_QOP_VALUES];

   Ulong			  prname_size_min;       /* observed min length of printable names */
   Ulong			  prname_size_max;	 /* observed max length of printable names */
   Ulong			  bcname_size_min;	 /* observed min length of binary canonical names */
   Ulong			  bcname_size_max;	 /* observed max length of binary canonical names */

   struct xtime			  getmic_speed;
   struct xtime			  verifymic_speed;
   struct xtime			  wconf_speed;
   struct xtime			  wmic_speed;
   struct xtime			  unwconf_speed;
   struct xtime			  unwmic_speed;

   int				  flags;		   /* (private) dll_load flags for availability of gssapi calls */

   int				  snc_qop;		   /* snc QOP-level (Quality of Protection) Authentication-only, Integrity, Privacy */

   Uchar		          conf_failure;		   /* flag for confidentiality protection failure during gss_wrap()	        */
   Uchar			  context_transfer_calls;  /* flag for availability of context transfer calls (DLL entry points)	*/
   Uchar			  canonical_names_calls;   /* flag for availability of export_name/canonicalize_name (DLL entry points) */
   Uchar			  export_name_in_namelist; /* NT_EXPORT_NAME found in namelist */
   Uchar			  snc_adapter_flag;
   Uchar		          snc_builtin_flag;

   struct sapgss_info_s		  info;
};

typedef struct dll_gssfp_s DLL_GSSFP_T;


#define GSS_FIRST_FUNC  gss_acquire_cred
#define GSS_LAST_FUNC   gss_last_func

#define GSS_FUNC_COUNT					 \
     ( ( offsetof(struct dll_gssfp_s, GSS_LAST_FUNC)	 \
	 - offsetof(struct dll_gssfp_s, GSS_FIRST_FUNC) ) \
       / sizeof(GSS_VOID_FUNC *) )


#define GSS_BASE_FUNC_PTR(x)    (GSS_VOID_FUNC_T **) (&((x)->GSS_FIRST_FUNC))



typedef enum gss_call_t {
   GSS_DL_UNUSED   =    (0),
   GSS_DL_REQ      =  (1<<0),
   GSS_DL_NEED	   =  (1<<1),
   GSS_DL_OPT	   =  (1<<2),
   GSS_DL_V2       =  (1<<3),
   GSS_DL_V1       =  (1<<4),
   GSS_DL_SAP	   =  (1<<5)
} GSS_CALL_T;


#define GSS_FUNC_NAME_MAXLEN  64

struct dll_call_entry_s {
	char      * name;
	int         offset;
	int	    flags; /* GSS_CALL_T bitfield */
	OM_uint32   attributes;
};


int    dll_load_gssapi( int		 p_trclevel,
			char	       * p_libname,
			DLL_GSSFP_T    * p_gssfp      );

int    dll_unload_gssapi( int	         p_trclevel,
			  DLL_GSSFP_T  * p_gssfp      );
