/* SCCSID("@(#)rtlink.h   %E%   SAP   %I%") */

/************************************************************************/
/* $Id: rtlink.h,v 1.1.1.1 1998/11/06 14:33:19 d019080 Exp $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */


#ifndef _XX_RTLINK_H_
#  define _XX_RTLINK_H_

#define RTL_HANDLE   int

/* it's cleaner if memset(&handle, 0, sizeof(handle))         */
/* also creates an initial/invalid handle, especially         */
/* when the handle is part of a dynamically allocated struct  */

#define RTL_INVALID_HANDLE 0

#define RTL_OK		       0
#define RTLERR_LOAD_FAILED     1
#define RTLERR_UNLOAD_FAILED   2
#define RTLERR_SYMBOL_FAILED   3
#define RTLERR_TABLE_FULL      4
#define RTLERR_INVALID_HANDLE  5
#define RTLERR_INVALID_VALUE   6
#define RTLERR_NAME_TOO_LONG   7
#define RTLERR_OUT_OF_MEMORY   8
#define RTLERR_EMPTY_SLOT      9


typedef  Uint32 (FUNCPTR_DECO _RTL_CALL)(void);
typedef  _RTL_CALL  * RTL_FUNC_ADR;


int    rtl_load_library(   char	         * p_libname,	 /* in     */
		           RTL_HANDLE    * pp_handle );	 /* out    */

int    rtl_library_name(   RTL_HANDLE      p_handle,	 /* in     */
			   char         ** pp_name );    /* out    */

int    rtl_load_function(  RTL_HANDLE      p_handle,	 /* in     */
			   char		 * p_prefix,     /* in     */
			   char          * p_funcname,	 /* in     */
			   Uint32          p_attributes, /* in     */
			   RTL_FUNC_ADR  * pp_fptr );	 /* out    */

int    rtl_unload_library( RTL_HANDLE    * pp_handle );	 /* in+out */

char * rtl_error_name(	   int p_rc );			 /* in	   */

/*---------------------------------------------------------------*/
/*  RTL_ATTR(retval, c, ARGLIST)                                 */
/*                                                               */
/*  Used to generate the attributes parameter for                */
/*  rt_load_function()  on the Apple MacIntosh 68K               */
/*							         */
/*  Note: ARGLIST should be a Macro of the argument list         */
/*  ***** so that it counts as a single argument to the          */
/*        RTL_ATTR() macro                                       */
/*---------------------------------------------------------------*/

# if !defined(_MACINTOSH)

 /**** default RTL_ATTR expands to 0 *****/
#  define RTL_ATTR(retval, c, ARGLIST)         0

#else /* defined(_MACINTOSH) */

#  include <MixedMode.h>

#  undef  RTL_ATTR
#  define RTL_ATTR(retval, argc, arglist)    SHLIB_ARG##argc(retval, arglist)


#  define RETURNS(r)	 kCStackBased | RESULT_SIZE(SIZE_CODE(sizeof(r)))
#  define USE_ARG(p,t)   STACK_ROUTINE_PARAMETER(p, SIZE_CODE(sizeof(t)))



#  define SHLIB_ARG1(retval, a1) \
   ( RETURNS(retval)  | USE_ARG(1,a1) )

#  define SHLIB_ARG2(retval, a1, a2) \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2) )

#  define SHLIB_ARG3(retval, a1, a2, a3) \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3) )

#  define SHLIB_ARG4(retval, a1, a2, a3, a4)                               \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4) )

#  define SHLIB_ARG5(retval, a1, a2, a3, a4, a5)                           \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4)   | USE_ARG(5,a5) )

#  define SHLIB_ARG6(retval, a1, a2, a3, a4, a5, a6)                       \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4)   | USE_ARG(5,a5)  | USE_ARG(6,a6) )

#  define SHLIB_ARG7(retval, a1, a2, a3, a4, a5, a6, a7)                   \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4)   | USE_ARG(5,a5)  | USE_ARG(6,a6)   | USE_ARG(7,a7) )

#  define SHLIB_ARG8(retval, a1, a2, a3, a4, a5, a6, a7, a8)               \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4)   | USE_ARG(5,a5)  | USE_ARG(6,a6)   | USE_ARG(7,a7)   \
    | USE_ARG(8,a8) )

#  define SHLIB_ARG9(retval, a1, a2, a3, a4, a5, a6, a7, a8, a9)           \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4)   | USE_ARG(5,a5)  | USE_ARG(6,a6)   | USE_ARG(7,a7)   \
    | USE_ARG(8,a8)   | USE_ARG(9,a9) )

#  define SHLIB_ARG10(retval, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)     \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4)   | USE_ARG(5,a5)  | USE_ARG(6,a6)   | USE_ARG(7,a7)   \
    | USE_ARG(8,a8)   | USE_ARG(9,a9)  | USE_ARG(10,a10) )

#  define SHLIB_ARG11(retval,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)           \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4)   | USE_ARG(5,a5)  | USE_ARG(6,a6)   | USE_ARG(7,a7)   \
    | USE_ARG(8,a8)   | USE_ARG(9,a9)  | USE_ARG(10,a10) | USE_ARG(11,a11) )

#  define SHLIB_ARG12(retval,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)	   \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4)   | USE_ARG(5,a5)  | USE_ARG(6,a6)   | USE_ARG(7,a7)   \
    | USE_ARG(8,a8)   | USE_ARG(9,a9)  | USE_ARG(10,a10) | USE_ARG(11,a11) \
    | USE_ARG(12,a12) )

#  define SHLIB_ARG13(retval,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13)   \
   ( RETURNS(retval)  | USE_ARG(1,a1)  | USE_ARG(2,a2)   | USE_ARG(3,a3)   \
    | USE_ARG(4,a4)   | USE_ARG(5,a5)  | USE_ARG(6,a6)   | USE_ARG(7,a7)   \
    | USE_ARG(8,a8)   | USE_ARG(9,a9)  | USE_ARG(10,a10) | USE_ARG(11,a11) \
    | USE_ARG(12,a12) | USE_ARG(13,a13) )


#endif /* defined(_MACINTOSH) */



#endif /* _XX_RTLINK_H_ */
