#include "mysccs.h"
SCCSID("@(#)verbose.c   %E%   SAP   %I%")

static char * this_File GNU_UNUSED = __FILE__;

/************************************************************************/
/* $Id: verbose.c,v 1.1.1.1 1998/11/06 14:33:19 d019080 Exp $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */


#include "common.h"
#include "verbose.h"

/* global variables */
int      verbose_level         = 0;
int	 there_was_output      = FALSE;
int      show_error_location   = FALSE;
int	 duplicate_to_stdout   = FALSE;
int      sap_constraints_count = 0;

char   * first_message         = NULL;
char   * last_message          = NULL;

/* local variables */

static int     verbose_initialized     = FALSE;
FILE         * outfp[3];


void
verbose_init( int p_level, FILE * p_fp, char * p_filename, int quiet )
{
   char     * where	     = "";
   char     * fmt            = "%s\n";

   verbose_initialized       = TRUE;
   verbose_level             = p_level;

   if ( quiet!=FALSE ) {
      fprintf(stderr, "Sending verbose output to ");
   }

   if ( p_fp==NULL || p_fp==stderr ) {

      vfp   = stderr;
      where = "STDERR";

   } else if ( p_fp==stdout ) {

      vfp   = stdout;
      where = "STDOUT";

   } else {

      vfp   = p_fp;
      where = p_filename;
      fmt   = "file \"%s\"\n";

   }

   outfp[0] = vfp;
   outfp[1] = stdout;
   outfp[2] = NULL;

   if ( quiet!=FALSE ) {
      fprintf( stderr, fmt, where );
      fflush( stderr );
   }

   return;
 
} /* verbose_init() */




void
set_verbose_level( int p_level )
{
   if ( p_level>=0 && p_level<=4 )
      verbose_level = p_level;

} /* set_verbose_level() */



#define DFPRINTF(x)  \
   for( fpc=0 ; (ffp=outfp[fpc])!=NULL ; fpc++ ) {	    \
      if ( duplicate_to_stdout==FALSE ) { fpc++; }	    \
      fprintf x;					    \
   }


#define DVFPRINTF(x)  \
   for( fpc=0 ; (ffp=outfp[fpc])!=NULL ; fpc++ ) {	    \
      if ( duplicate_to_stdout==FALSE ) { fpc++; }	    \
      vfprintf x;					    \
   }


#define DFFLUSH(x) \
   for( fpc=0 ; (ffp=outfp[fpc])!=NULL ; fpc++ ) {	    \
      if ( duplicate_to_stdout==FALSE ) { fpc++; }	    \
      fflush x;						    \
   }


void
verbose_print( veb_class_et p_class, int p_int_arg, ... )
{
   FILE     * ffp;
   int	      fpc;
   va_list    args;
   char     * label;
   char	    * prefix = NULL;
   char       prefix_buf[64];
   char     * fmt1 = NULL;
   char	    * fmt2 = NULL;
   char     * file = "";
   Uint       line = 0;
   int        routine_rc;
   int	      expected_rc;
   int	      section;
   char       rc_string[32];

   if ( vfp==NULL ) {
      checkin_message();
      fprintf(stderr, "WAAA! I don't have a valid FILE * for verbose output!\n");
      abort();
   }

   va_start(args, p_int_arg);

   switch( p_class ) {

      case VEB_CLASS_RESULT:
	 routine_rc  = p_int_arg;
	 expected_rc = (int)    va_arg(args, int);
	 label       = (char *) va_arg(args, char *);
	 sprintf(rc_string, " (rc=%u)", (Uint) routine_rc);
	 checkin_message();
	 DFPRINTF((ffp, "RESULT  %s%s%s%s\n%s",
	    label!=NULL ? label : "",
	    label!=NULL ? "(): " : "",
	    (routine_rc==expected_rc) ? "OK" : "NOT ok",
	    (routine_rc==expected_rc) ? "" : rc_string,
	    (verbose_level>0 || routine_rc>0) ? "-------\n" : ""
	 ));
	 break;

      case VEB_CLASS_SECTION:
	   section = p_int_arg;
	   label   = (char *) va_arg(args, char *);
	   DFPRINTF((ffp,"\n(( %d %s ))\n", section, label));
	   break;
	 
      case VEB_CLASS_ERR:  file   = va_arg(args, char *);
			   line   = va_arg(args, Uint  );
			   if ( show_error_location!=FALSE ) {
			      sprintf(prefix_buf, "%.32s(%u): ERROR: ", file, line);
			      prefix = prefix_buf;
			   } else {
			      prefix = "ERROR: ";
			   }
			   goto print_with_prefix;

      case VEB_CLASS_STATUS: prefix = "Status:  ";	 goto print_with_prefix;
      case VEB_CLASS_TEST: prefix = "TEST: ";		 goto print_with_prefix;
      case VEB_CLASS_BUG:  prefix = "INTERNAL BUG: ";	 goto print_with_prefix;
      case VEB_CLASS_TRIN: prefix = "  ==> ";		 goto print_with_prefix;
      case VEB_CLASS_TIMING: prefix = "  ... ";		 goto print_with_prefix;

      case VEB_CLASS_SAPERR:
			   prefix = "*FAILING* SAP constraint:\n==> ";
			   sap_constraints_count++;	 goto print_with_prefix;

      case VEB_CLASS_TROUT: prefix = "  <== ";

print_with_prefix:
	 checkin_message();
	 if ( prefix!=NULL ) { DFPRINTF((ffp, prefix)); }
	 fmt1  = (char *) va_arg(args, char *);
	 DVFPRINTF((ffp, fmt1, args));
	 break;


      default:
	 if ( p_int_arg>0  ) {

	    checkin_message();

	    switch( p_class ) {
	       case VEB_CLASS_OK:					break;
	       case VEB_CLASS_STRING: fmt2 = "\t%.50s =\"%.150s\"\n";	break;
	       case VEB_CLASS_INFO:   DFPRINTF((ffp, "  "));		break;
	       default:		      break;
	    }
   
	    if ( fmt1!=NULL ) {
	       DVFPRINTF((ffp, fmt1, args));
	    }

	    if ( fmt2==NULL ) {
	       fmt2 = va_arg( args, char * );
	    }

	    DVFPRINTF((ffp, fmt2, args));

	 }

   }

   va_end(args);

   DFFLUSH((ffp));

   return;

} /* verbose_print() */




/*
 * verbose_dupmem()
 *
 *
 */
void *
verbose_dupmem( char * module_name, Uint line_of_code,
	        void * orig_ptr, size_t orig_len,  size_t * new_len )
{
   void * ptr = NULL;
   
   if ( orig_ptr==NULL  ||  orig_len==0 ) {

      (*new_len) = 0;

   } else {

      ptr = malloc( orig_len + 256 );

      if (ptr==NULL) {
	 *new_len = 0;
	 XVEB((V_ERR, "File %s(line %u): malloc(%lu) FAILED: %s\n",
		      module_name, line_of_code,
		      (Ulong) orig_len + 256, strerror(errno) ));
	 return(NULL);
      }

      *new_len = orig_len;
      memset( ptr, 'X', orig_len + 256 );
      memcpy( ptr, orig_ptr, orig_len );

   }

   return(ptr);

} /* verbose_dupmem() */




/*
 * verbose_freemem()
 *
 *
 */
void
verbose_freemem( void ** ptr, size_t * len )
{
   if ( ptr!=NULL && *ptr!=NULL ) {
      if ( len!=NULL && *len!=0 ) {
	 memset( *ptr, 0, *len );
	 *len = 0;
      }
      free( *ptr );
      *ptr = NULL;
   }

   return;

} /* verbose_freemem() */



void
set_enter_leave_messages( char * enter_msg, char * leave_msg )
{
   first_message = enter_msg;
   last_message  = leave_msg;

   return;

} /* set_first_message() */



void
checkin_message( void )
{
   FILE     * ffp;
   int	      fpc;

   if ( there_was_output==FALSE && first_message!=NULL ) {
      DFPRINTF((ffp, "%s", first_message));
   }
   there_was_output = TRUE;

   return;

} /* checkin_message() */



void
checkout_message( void )
{
   FILE     * ffp;
   int	      fpc;

   if ( there_was_output!=FALSE && last_message!=NULL ) {
      DFPRINTF((ffp, "%s", last_message));
   }

   return;

} /* check_leave_message() */
