dnl
dnl Figure out the top of the source and build trees.  We depend on localdir
dnl being a relative pathname; we could make it general later, but for now 
dnl this is good enough.
dnl
AC_DEFUN(V5_SET_TOPDIR,[dnl
ac_reltopdir=AC_LOCALDIR
case "$ac_reltopdir" in 
/*)
	echo "Configure script built with absolute localdir pathname"
	exit 1
	;;
"")
	ac_reltopdir=.
	;;
esac
ac_topdir=$srcdir/$ac_reltopdir
ac_config_fragdir=$ac_reltopdir/config
ac_prepend=$ac_config_fragdir/pre.in
ac_postpend=$ac_config_fragdir/post.in
BUILDTOP=$ac_reltopdir
SRCTOP=$srcdir/$ac_reltopdir
if test -d "$srcdir/$ac_config_fragdir"; then
  AC_CONFIG_AUX_DIR($ac_config_fragdir)
else
  AC_MSG_ERROR([can not find config/ directory in $ac_reltopdir])
fi
])dnl
dnl
dnl Does configure need to be run in immediate subdirectories of this
dnl directory?
dnl
dnl XXX we should remove this and replace CONFIG_DIRS with AC_CONFIG_SUBDIRS
dnl in all of the configure.in files.
dnl
define(CONFIG_DIRS,[AC_CONFIG_SUBDIRS($1)])dnl
dnl
dnl AC_PUSH_MAKEFILE():
dnl allow stuff to get tacked on to the end of the makefile
dnl
define(AC_PUSH_MAKEFILE,[dnl
cat>>append.out<<\PUSHEOF
])dnl
define(AC_POP_MAKEFILE,[dnl
PUSHEOF
])dnl
dnl
dnl Work around bug in autoconf which causes a relative path for 
dnl AC_PROG_INSTALL to be cached.
dnl
define(INSTALL_VARIABLE_HACK,[dnl
#
# Work around a bug in autoconf; unset the cache variable for the install 
# program if it is a relative path.
#
case "$ac_cv_path_install" in
../*|./*|[[a-zA-Z]]*)
	unset ac_cv_path_install
	;;
esac
])dnl
dnl
dnl DO_SUBDIRS
dnl recurse into subdirs by specifying the recursion targets
dnl the rules are in post.in but the target needs substitution
AC_DEFUN([DO_SUBDIRS],
[RECURSE_TARGETS="all-unix clean-unix install-unix install-all install-kdc install-server install-client check-unix Makefiles"
AC_SUBST(RECURSE_TARGETS)])
dnl
dnl drop in standard rules for all configure files -- CONFIG_RULES
dnl
define(CONFIG_RULES,[dnl
V5_SET_TOPDIR dnl
INSTALL_VARIABLE_HACK dnl
WITH_CC dnl
WITH_CCOPTS dnl
WITH_LINKER dnl
WITH_LDOPTS dnl
WITH_CPPOPTS dnl
WITH_KRB4 dnl
AC_CONST dnl
WITH_NETLIB dnl
WITH_ORACLE dnl
KRB_INCLUDE dnl
AC_ARG_PROGRAM dnl
])dnl

dnl This is somewhat gross and should go away when the build system
dnl is revamped. -- tlyu
dnl DECLARE_SYS_ERRLIST - check for sys_errlist in libc
dnl
AC_DEFUN([DECLARE_SYS_ERRLIST],
[AC_CACHE_CHECK([for sys_errlist declaration], krb5_cv_decl_sys_errlist,
[AC_TRY_COMPILE([#include <stdio.h>
#include <errno.h>], [1+sys_nerr;],
krb5_cv_decl_sys_errlist=yes, krb5_cv_decl_sys_errlist=no)])
# assume sys_nerr won't be declared w/o being in libc
if test $krb5_cv_decl_sys_errlist = yes; then
  AC_DEFINE(SYS_ERRLIST_DECLARED)
  AC_DEFINE(HAVE_SYS_ERRLIST)
else
  # This means that sys_errlist is not declared in errno.h, but may still
  # be in libc.
  AC_CACHE_CHECK([for sys_errlist in libc], krb5_cv_var_sys_errlist,
  [AC_TRY_LINK([extern int sys_nerr;], [1+sys_nerr;],
  krb5_cv_var_sys_errlist=yes, krb5_cv_var_sys_errlist=no;)])
  if test $krb5_cv_var_sys_errlist = yes; then
    AC_DEFINE(HAVE_SYS_ERRLIST)
    # Do this cruft for backwards compatibility for now.
    AC_DEFINE(NEED_SYS_ERRLIST)
  else
    AC_MSG_WARN([sys_errlist is neither in errno.h nor in libc])
  fi
fi])

dnl
dnl check for sigmask/sigprocmask -- CHECK_SIGPROCMASK
dnl
define(CHECK_SIGPROCMASK,[
AC_MSG_CHECKING([for use of sigprocmask])
AC_CACHE_VAL(krb5_cv_func_sigprocmask_use,
[AC_TRY_LINK(
[#include <signal.h>], [sigmask(1);], 
 krb5_cv_func_sigprocmask_use=no,
AC_TRY_LINK([#include <signal.h>], [sigprocmask(SIG_SETMASK,0,0);],
 krb5_cv_func_sigprocmask_use=yes, krb5_cv_func_sigprocmask_use=no))])
AC_MSG_RESULT($krb5_cv_func_sigprocmask_use)
if test $krb5_cv_func_sigprocmask_use = yes; then
 AC_DEFINE(USE_SIGPROCMASK)
fi
])dnl
dnl
define(AC_PROG_ARCHIVE, [AC_PROGRAM_CHECK(ARCHIVE, ar, ar cqv, false)])dnl
define(AC_PROG_ARCHIVE_ADD, [AC_PROGRAM_CHECK(ARADD, ar, ar cruv, false)])dnl
dnl
dnl check for <dirent.h> -- CHECK_DIRENT
dnl (may need to be more complex later)
dnl
define(CHECK_DIRENT,[
AC_HEADER_CHECK(dirent.h,AC_DEFINE(USE_DIRENT_H))])dnl
dnl
dnl check if union wait is defined, or if WAIT_USES_INT -- CHECK_WAIT_TYPE
dnl
define(CHECK_WAIT_TYPE,[
AC_MSG_CHECKING([for union wait])
AC_CACHE_VAL(krb5_cv_struct_wait,
[AC_TRY_COMPILE(
[#include <sys/wait.h>], [union wait i;
#ifdef WEXITSTATUS
  WEXITSTATUS (i);
#endif
], 
	krb5_cv_struct_wait=yes, krb5_cv_struct_wait=no)])
AC_MSG_RESULT($krb5_cv_struct_wait)
if test $krb5_cv_struct_wait = no; then
	AC_DEFINE(WAIT_USES_INT)
fi
])dnl
dnl
dnl check for POSIX signal handling -- CHECK_SIGNALS
dnl
define(CHECK_SIGNALS,[
AC_FUNC_CHECK(sigprocmask,
AC_MSG_CHECKING(for sigset_t and POSIX_SIGNALS)
AC_CACHE_VAL(krb5_cv_type_sigset_t,
[AC_TRY_COMPILE(
[#include <signal.h>],
[sigset_t x],
krb5_cv_type_sigset_t=yes, krb5_cv_type_sigset_t=no)])
AC_MSG_RESULT($krb5_cv_type_sigset_t)
if test $krb5_cv_type_sigset_t = yes; then
  AC_DEFINE(POSIX_SIGNALS)
fi
)])dnl
dnl
dnl check for signal type
dnl
dnl AC_RETSIGTYPE isn't quite right, but almost.
define(KRB5_SIGTYPE,[
AC_MSG_CHECKING([POSIX signal handlers])
AC_CACHE_VAL(krb5_cv_has_posix_signals,
[AC_TRY_COMPILE(
[#include <sys/types.h>
#include <signal.h>
#ifdef signal
#undef signal
#endif
extern void (*signal ()) ();], [],
krb5_cv_has_posix_signals=yes, krb5_cv_has_posix_signals=no)])
AC_MSG_RESULT($krb5_cv_has_posix_signals)
if test $krb5_cv_has_posix_signals = yes; then
   AC_DEFINE(krb5_sigtype, void) AC_DEFINE(POSIX_SIGTYPE)
else
  if test $ac_cv_type_signal = void; then
     AC_DEFINE(krb5_sigtype, void)
  else
     AC_DEFINE(krb5_sigtype, int)
  fi
fi])dnl
dnl
dnl check for POSIX setjmp/longjmp -- CHECK_SETJMP
dnl
define(CHECK_SETJMP,[
AC_FUNC_CHECK(sigsetjmp,
AC_MSG_CHECKING(for sigjmp_buf)
AC_CACHE_VAL(krb5_cv_struct_sigjmp_buf,
[AC_TRY_COMPILE(
[#include <setjmp.h>],[sigjmp_buf x],
krb5_cv_struct_sigjmp_buf=yes,krb5_cv_struct_sigjmp_buf=no)])
AC_MSG_RESULT($krb5_cv_struct_sigjmp_buf)
if test $krb5_cv_struct_sigjmp_buf = yes; then
  AC_DEFINE(POSIX_SETJMP)
fi
)])dnl
dnl
dnl set $(KRB4) from --with-krb4=value -- WITH_KRB4
dnl
define(WITH_KRB4,[
AC_ARG_WITH([krb4],
[  --without-krb4          don't include Kerberos V4 backwards compatibility
  --with-krb4             use V4 libraries included with V5 (default)
  --with-krb4=KRB4DIR     use preinstalled V4 libraries],
,
withval=yes
)dnl
if test $withval = no; then
	AC_MSG_RESULT(no krb4 support)
	KRB4_LIB=
	DEPKRB4_LIB=
	KRB4_CRYPTO_LIB=
	DEPKRB4_CRYPTO_LIB=
	KDB4_LIB=
	DEPKDB4_LIB=
	KRB4_INCLUDES=
	LDARGS=
	krb5_cv_build_krb4_libs=no
	krb5_cv_krb4_libdir=
else 
 ADD_DEF(-DKRB5_KRB4_COMPAT)
 if test $withval = yes; then
	AC_MSG_RESULT(built in krb4 support)
	KRB4_INCLUDE="-I$SRCTOP/include/kerberosIV"
	KRB4_LIB='-lkrb4'
	DEPKRB4_LIB='$(TOPLIBD)/libkrb4.a'
	KRB4_CRYPTO_LIB='-ldes425'
	DEPKRB4_CRYPTO_LIB='$(TOPLIBD)/libdes425.a'
	KDB4_LIB='-lkdb4'
	DEPKDB4_LIB='$(TOPLIBD)/libkdb4.a'
	KRB4_INCLUDES='-I$(SRCTOP)/include/kerberosIV'
	LDARGS=
	krb5_cv_build_krb4_libs=yes
	krb5_cv_krb4_libdir=
 else
	AC_MSG_RESULT(preinstalled krb4 in $withval)
	KRB4_INCLUDE="-I$withval/include"
	KRB4_LIB="-lkrb"
	DEPKRB4_LIB="$withval/lib/libkrb.a"
	KRB4_CRYPTO_LIB='-ldes425'
	DEPKRB4_CRYPTO_LIB='$(TOPLIBD)/libdes425.a'
	KDB4_LIB="-lkdb"
	DEPKDB4_LIB="$withval/lib/libkdb.a"
	KRB4_INCLUDES="-I$withval/include"
	LDARGS="-L$withval/lib"
	krb5_cv_build_krb4_libs=no
	krb5_cv_krb4_libdir="$withval/lib"
 fi
fi
AC_SUBST(KRB4_INCLUDES)
AC_SUBST(KRB4_LIB)
AC_SUBST(KRB4_CRYPTO_LIB)
AC_SUBST(DEPKRB4_LIB)
AC_SUBST(DEPKRB4_CRYPTO_LIB)
])dnl
dnl
dnl set $(CC) from --with-cc=value
dnl
define(WITH_CC,[
AC_ARG_WITH([cc],
[  --with-cc=COMPILER      select compiler to use])
AC_MSG_CHECKING(for C compiler)
if test "$with_cc" != ""; then
  if test "$ac_cv_prog_cc" != "" && test "$ac_cv_prog_cc" != "$with_cc"; then
    AC_MSG_ERROR(Specified compiler doesn't match cached compiler name;
	remove cache and try again.)
  else
    CC="$with_cc"
  fi
fi
AC_CACHE_VAL(ac_cv_prog_cc,[dnl
  if test -z "$CC" ; then
    dnl CYGNUS LOCAL: HP base-system compilers are crap.
    dnl Also, we need ANSI compilers now, with the new admin code.
    case "`(uname -s) 2>/dev/null`:`(uname -r) 2>/dev/null`" in
      HP-UX:*9.*)  CC=gcc ;;
      HP-UX:*10.*) CC="gcc -O" ;;
      SunOS:4.*)   CC=gcc ;;
      SunOS:5.*)   CC=gcc ;;	# no -O, our Solaris box is too slow
      AIX:*)	   CC="xlc -D_ALL_SOURCE" ;;
      *) CC=cc ;;
    esac
  fi
  AC_TRY_LINK([#include <stdio.h>],[printf("hi\n");], ,
    AC_MSG_ERROR(Can't find a working compiler.))
  ac_cv_prog_cc="$CC"
])
CC="$ac_cv_prog_cc"
AC_MSG_RESULT($CC)
AC_PROG_CC
])dnl
dnl
dnl set $(LD) from --with-linker=value
dnl
define(WITH_LINKER,[
AC_ARG_WITH([linker],
[  --with-linker=LINKER    select linker to use],
AC_MSG_RESULT(LD=$withval)
LD=$withval,
if test -z "$LD" ; then LD=$CC; fi
[AC_MSG_RESULT(LD defaults to $LD)])dnl
AC_SUBST([LD])])dnl
dnl
dnl set $(CCOPTS) from --with-ccopts=value
dnl
define(WITH_CCOPTS,[
AC_ARG_WITH([ccopts],
[  --with-ccopts=CCOPTS    select compiler command line options],
AC_MSG_RESULT(CCOPTS is $withval)
CCOPTS=$withval
CFLAGS="$CFLAGS $withval",
CCOPTS=)dnl
AC_SUBST(CCOPTS)])dnl
dnl
dnl set $(LDFLAGS) from --with-ldopts=value
dnl
define(WITH_LDOPTS,[
AC_ARG_WITH([ldopts],
[  --with-ldopts=LDOPTS    select linker command line options],
AC_MSG_RESULT(LDFLAGS is $withval)
LDFLAGS=$withval,
LDFLAGS=)dnl
AC_SUBST(LDFLAGS)])dnl
dnl
dnl set $(CPPOPTS) from --with-cppopts=value
dnl
define(WITH_CPPOPTS,[
AC_ARG_WITH([cppopts],
[  --with-cppopts=CPPOPTS  select compiler preprocessor command line options],
AC_MSG_RESULT(CPPOPTS=$withval)
CPPOPTS=$withval
CPPFLAGS="$CPPFLAGS $withval",
[AC_MSG_RESULT(CPPOPTS defaults to $CPPOPTS)])dnl
AC_SUBST(CPPOPTS)])dnl
dnl
dnl Imake LinkFile rule, so they occur in the right place -- LinkFile(dst,src)
dnl
define(LinkFile,[
AC_REQUIRE([AC_LN_S])
AC_PUSH_MAKEFILE()dnl
changequote({,})dnl

$1:: $2{
	$(RM) $}{@
	$(LN) $}{? $}{@

}
changequote([,])dnl
AC_POP_MAKEFILE()dnl
])dnl
dnl
dnl Like above, but specifies how to get from link target to source, e.g.
dnl LinkFileDir(../foo, blotz, ./bar) issues a:
dnl	ln -s ../foo ./bar/blotz
dnl
define(LinkFileDir,[
AC_REQUIRE([AC_LN_S])
AC_PUSH_MAKEFILE()dnl
changequote({,})dnl

$1:: $2{
	$(RM) $}{@
	$(LN) }$3{$(S)$}{? $}{@

}
changequote([,])dnl
AC_POP_MAKEFILE()dnl
])dnl
dnl
dnl explicit append text (for non-general things) -- AppendRule(txt)
dnl
define(AppendRule,[
AC_PUSH_MAKEFILE()dnl

$1

AC_POP_MAKEFILE()dnl
])dnl
dnl
dnl create DONE file for lib/krb5 -- SubdirLibraryRule(list)
define(SubdirLibraryRule,[
AC_PUSH_MAKEFILE()dnl

all-unix:: DONE

DONE:: $1 $(srcdir)/Makefile.in
	@if test x'$1' = x && test -r [$]@; then :;\
	else \
		(set -x; echo $1 > [$]@) \
	fi

clean-unix::
	$(RM) DONE
AC_POP_MAKEFILE()dnl
])dnl
dnl
dnl copy header file into include dir -- CopyHeader(hfile,hdir)
dnl
define(CopyHeader,[
AC_PUSH_MAKEFILE()dnl

includes:: $1
	@if test -d $2; then :; else (set -x; mkdir $2) fi
	@if cmp $1 $2/$1 >/dev/null 2>&1; then :; \
	else \
		(set -x; [$](RM) $2/$1;	[$](CP) $1 $2/$1) \
	fi

clean-unix::
	$(RM) $2/$1

AC_POP_MAKEFILE()dnl
])dnl
dnl
dnl copy source header file into include dir -- CopySrcHeader(hfile,hdir)
dnl
define(CopySrcHeader,[
AC_PUSH_MAKEFILE()dnl

includes:: $1
	@if test -d $2; then :; else (set -x; mkdir $2) fi
	@if cmp $(srcdir)/$1 $2/$1 >/dev/null 2>&1; then :; \
	else \
		(set -x; [$](RM) $2/$1;	[$](CP) $(srcdir)/$1 $2/$1) \
	fi

clean-unix::
	$(RM) $2/$1

AC_POP_MAKEFILE()dnl
])dnl
dnl
dnl Krb5InstallHeaders(headers,destdir)
define(Krb5InstallHeaders,[
AC_PUSH_MAKEFILE()dnl
install-unix:: $1
	@set -x; for f in $1 ; \
	do [$](INSTALL_DATA) [$$]f $2/[$$]f ; \
	done
AC_POP_MAKEFILE()dnl
])dnl
dnl
dnl arbitrary DEFS -- ADD_DEF(value)
dnl
define(ADD_DEF,[
CPPFLAGS="[$]CPPFLAGS "'$1'
])dnl
dnl
dnl local includes are used -- KRB_INCLUDE
dnl
define(KRB_INCLUDE,[
ADD_DEF([-I$(BUILDTOP)/include -I$(SRCTOP)/include -I$(BUILDTOP)/include/krb5 -I$(SRCTOP)/include/krb5])dnl
])dnl
dnl
dnl check for yylineno -- HAVE_YYLINENO
dnl
define(HAVE_YYLINENO,[dnl
AC_REQUIRE_CPP()AC_REQUIRE([AC_PROG_LEX])dnl
AC_MSG_CHECKING([for yylineno declaration])
AC_CACHE_VAL(krb5_cv_type_yylineno,
# some systems have yylineno, others don't...
  echo '%%
%%' | ${LEX} -t > conftest.out
  if egrep yylineno conftest.out >/dev/null 2>&1; then
	krb5_cv_type_yylineno=yes
  else
	krb5_cv_type_yylineno=no
  fi
  rm -f conftest.out)
  AC_MSG_RESULT($krb5_cv_type_yylineno)
  if test $krb5_cv_type_yylineno = no; then
	AC_DEFINE([NO_YYLINENO])
  fi
])dnl
dnl
dnl fix AC_PROG_LEX
dnl
undefine([AC_PROG_LEX])dnl
define(AC_PROG_LEX,
[AC_PROVIDE([$0])dnl
AC_PROGRAM_CHECK(LEX, flex, flex, lex)dnl
if test -z "$LEXLIB"
then
   case "$LEX" in
   flex*) AC_CHECK_LIB(fl,main, LEXLIB="-lfl") ;;
   *) AC_CHECK_LIB(l,main, LEXLIB="-ll") ;;
   esac
fi
AC_MSG_RESULT(setting LEXLIB to $LEXLIB)
AC_SUBST(LEX)AC_SUBST(LEXLIB)])dnl
dnl
dnl V5_OUTPUT_MAKEFILE
dnl
define(V5_AC_OUTPUT_MAKEFILE,
[ifelse($1, , ac_v5_makefile_dirs=., ac_v5_makefile_dirs="$1")
ifelse($2, , filelist="", filelist="$2")
dnl OPTIMIZE THIS FOR COMMON CASE!!
for x in $ac_v5_makefile_dirs; do
  filelist="$filelist $x/Makefile.tmp:$ac_prepend+$x/Makefile.in+$ac_postpend"
done
AC_OUTPUT($filelist,
[EOF
ac_reltopdir=`echo $ac_reltopdir | sed   \
	-e ':LOOP'		\
	-e 's,/\./,/,'		\
	-e 'tLOOP'		\
	-e 's,^\./,,'		\
	-e 's,/\.$,,g'		\
	`
test "$ac_reltopdir" = "" && ac_reltopdir=.
cat >> $CONFIG_STATUS <<EOF
ac_v5_makefile_dirs="$ac_v5_makefile_dirs"
ac_reltopdir=$ac_reltopdir
EOF
dnl This should be fixed so that the here document produced gets broken up
dnl into chunks that are the "right" size, in case we run across shells that
dnl are broken WRT large here documents.
>> append.out
cat - append.out >> $CONFIG_STATUS <<\EOF
cat >> append.tmp <<\CEOF
#
# rules appended by configure

EOF
rm append.out
dnl now back to regular config.status generation
cat >> $CONFIG_STATUS <<\EOF
CEOF
for d in $ac_v5_makefile_dirs; do
  # If CONFIG_FILES was set from Makefile, skip unprocessed directories.
  if test -r $d/Makefile.tmp; then
changequote(,)dnl
    x=`echo $d/ | sed   \
	-e 's,//*$,/,'		\
	-e ':LOOP'		\
	-e 's,/\./,/,'		\
	-e 'tLOOP'		\
	-e 's,^\./,,'		\
	-e 's,[^/]*/,../,g'	\
	`
changequote([,])dnl
    test "$x" = "" && x=./
    case $srcdir in
    /*)  s=$ac_given_srcdir/$ac_reltopdir ;;
    *)   s=$x$ac_given_srcdir/$ac_reltopdir ;;
    esac
    s=`echo $s | sed   \
	-e 's,//*$,/,'		\
	-e ':LOOP'		\
	-e 's,/\./,/,'		\
	-e 'tLOOP'		\
	-e 's,^\./,,'		\
	-e 's,/\.$,,g'		\
	`
    test "$s" = "" && s=.
    echo creating $d/Makefile
    cat - $d/Makefile.tmp append.tmp > $d/Makefile <<EOX
thisconfigdir=$x
SRCTOP=$s
BUILDTOP=$x$ac_reltopdir
EOX
    rm  $d/Makefile.tmp
# sed -f $CONF_FRAGDIR/mac-mf.sed < Makefile > MakeFile
  fi
done
rm append.tmp
],
CONF_FRAGDIR=$srcdir/${ac_config_fragdir} )])dnl
dnl
dnl CHECK_STRUCT_MEMBER(headers, struct, field)
dnl look for field in struct, using headers...
dnl
define(CHECK_STRUCT_MEMBER,[
AC_MSG_CHECKING(whether struct $2 contains $3)
AC_CACHE_VAL(krb5_cv_struct_$2_$3,
[AC_TRY_COMPILE($1, [struct $2 actest; actest.$3;],
krb5_cv_struct_$2_$3=yes, krb5_cv_struct_$2_$3=no)])
AC_MSG_RESULT([$]krb5_cv_struct_$2_$3)
if test $krb5_cv_struct_$2_$3 = yes; then
  AC_DEFINE_UNQUOTED(HAVE_[]translit(struct_$2_$3, [a-z], [A-Z]))
fi
])dnl
dnl
dnl KRB5_SOCKADDR_SA_LEN: define HAVE_SA_LEN if sockaddr contains the sa_len
dnl component
dnl
AC_DEFUN([KRB5_SOCKADDR_SA_LEN],[ dnl
CHECK_STRUCT_MEMBER([#include <sys/types.h>
#include <sys/socket.h>
], sockaddr, sa_len)
if test $krb5_cv_struct_sockaddr_sa_len = yes; then
   AC_DEFINE_UNQUOTED(HAVE_SA_LEN)
   fi
])
dnl
dnl
dnl CHECK_UTMP: check utmp structure and functions
dnl
define(CHECK_UTMP,[
define(CHECK_UTMP_HEADERS,[#include <sys/types.h>
#include <utmp.h>
])
CHECK_STRUCT_MEMBER(CHECK_UTMP_HEADERS, utmp, ut_pid)
if test $krb5_cv_struct_utmp_ut_pid = no; then
  AC_DEFINE(NO_UT_PID)
fi
CHECK_STRUCT_MEMBER(CHECK_UTMP_HEADERS, utmp, ut_type)
if test $krb5_cv_struct_utmp_ut_type = no; then
  AC_DEFINE(NO_UT_TYPE)
fi
CHECK_STRUCT_MEMBER(CHECK_UTMP_HEADERS, utmp, ut_host)
if test $krb5_cv_struct_utmp_ut_host = no; then
  AC_DEFINE(NO_UT_HOST)
fi
CHECK_STRUCT_MEMBER(CHECK_UTMP_HEADERS, utmp, ut_exit)
if test $krb5_cv_struct_utmp_ut_exit = no; then
  AC_DEFINE(NO_UT_EXIT)
fi
AC_CHECK_FUNCS(setutent setutxent updwtmp updwtmpx)
])dnl
dnl
dnl
dnl Check for POSIX_FILE_LOCKS - used be include/krb5 and appl/popper
dnl
AC_DEFUN([KRB5_POSIX_LOCKS],[dnl
AC_HEADER_CHECK(flock.h,[echo found flock.h for non-posix locks],
  [AC_MSG_CHECKING([POSIX file locking -- structs and flags])
  AC_CACHE_VAL(krb5_cv_struct_flock,
[AC_TRY_LINK(dnl
[#include <sys/types.h>
#include <fcntl.h>],
[struct flock f; 1+F_SETLK;], 
  krb5_cv_struct_flock=yes, krb5_cv_struct_flock=no)])
  AC_MSG_RESULT($krb5_cv_struct_flock)
  if test $krb5_cv_struct_flock = yes; then
    AC_DEFINE(POSIX_FILE_LOCKS)
  fi
])])dnl
dnl
dnl WITH_NETLIB
dnl 
dnl
define(WITH_NETLIB,[
AC_ARG_WITH([netlib],
[  --with-netlib[=libs]    use user defined resolve library],
  if test "$withval" = yes -o "$withval" = no ; then
	AC_MSG_RESULT("netlib will link with C library resolver only")
  else
	LIBS="$LIBS $withval"
	AC_MSG_RESULT("netlib will use \'$withval\'")
  fi
,dnl
[if test "`(uname) 2>/dev/null`" != IRIX ; then
  AC_CHECK_LIB(socket,main)
  AC_CHECK_LIB(nsl,main)]
fi
)])dnl
dnl
dnl HAS_ANSI_VOLATILE
dnl
define(HAS_ANSI_VOLATILE,[
AC_MSG_CHECKING([volatile])
AC_CACHE_VAL(krb5_cv_has_ansi_volatile,
[AC_TRY_COMPILE(
[volatile int x();], [],
krb5_cv_has_ansi_volatile=yes, krb5_cv_has_ansi_volatile=no)])
AC_MSG_RESULT($krb5_cv_has_ansi_volatile)
if test $krb5_cv_has_ansi_volatile = no; then
ADD_DEF(-Dvolatile=)
fi
])dnl
dnl
dnl set oracle logging parameter
dnl
define(WITH_ORACLE_LOG,[
AC_ARG_WITH([oracle-logging],
[  --with-oracle-logging     Allow Oracle to be used for logging info.],
,
withval=no
)dnl
if test $withval = yes -o "$with_oracle" = yes; then
	ADD_DEF(-DHAVE_ORACLE_LOG -I$(ORACLE_HOME)/rdbms/demo)
	AC_MSG_RESULT(adding Oracle logging ability)
	OCI_LDFLAGS="-L$(ORACLE_HOME)/lib"
	OCI_LIBS="-lclntsh -lm"
fi
AC_SUBST(OCI_LDFLAGS)
AC_SUBST(OCI_LIBS)
])dnl
dnl
dnl set $(USE_OCI_KDB) from --with-oracle
dnl
define(WITH_ORACLE,[
AC_ARG_WITH([oracle],
[  --with-oracle             Use Oracle for backend database],
,
withval=no
)dnl
if test $withval = yes; then
	ADD_DEF(-DUSE_OCI_KDB -I$(ORACLE_HOME)/rdbms/demo)
	AC_MSG_RESULT(built in Oracle OCI support)
	AC_REQUIRE([WITH_ORACLE_LOG])
	OCI_LDFLAGS="-L$(ORACLE_HOME)/lib"
	OCI_LIBS="-lclntsh -lm"
# The next line is the old OCI_LIBS...
#	OCI_LIBS="-lclient -lsqlnet -lncr -lsqlnet -lclient -lcommon -lgeneric -lsqlnet -lncr -lsqlnet -lclient -lcommon -lgeneric -lepc -lnlsrtl3 -lc3v6 -lcore3 -lnlsrtl3 -lcore3 -lnlsrtl3 -lm"
fi
AC_SUBST(OCI_LDFLAGS)
AC_SUBST(OCI_LIBS)
])dnl
dnl
dnl This rule tells KRB5_LIBRARIES to use the kadm5srv library.
dnl
define([krb5m4_kadmsrv_deplib],[])dnl
define([krb5m4_kadmsrv_lib],[])dnl
AC_DEFUN(USE_KADMSRV_LIBRARY,[
AC_REQUIRE([USE_DYN_LIBRARY])dnl
AC_REQUIRE([USE_GSSRPC_LIBRARY])dnl
undefine([krb5m4_kadmsrv_deplib])dnl
define([krb5m4_kadmsrv_deplib],\[$](TOPLIBD)/libkadm5srv.a)dnl
undefine([krb5m4_kadmsrv_lib])dnl
define([krb5m4_kadmsrv_lib],-lkadm5srv)])
dnl
dnl This rule tells KRB5_LIBRARIES to use the kadm5clnt library.
dnl
define([krb5m4_kadmclnt_deplib],[])dnl
define([krb5m4_kadmclnt_lib],[])dnl
AC_DEFUN(USE_KADMCLNT_LIBRARY,[
undefine([krb5m4_kadmclnt_deplib])dnl
define([krb5m4_kadmclnt_deplib],\[$](TOPLIBD)/libkadm5clnt.a)dnl
undefine([krb5m4_kadmclnt_lib])dnl
define([krb5m4_kadmclnt_lib],-lkadm5clnt) ])
dnl
dnl This rule tells KRB5_LIBRARIES to use the gssrpc library.
dnl
define([krb5m4_gssrpc_deplib],[])dnl
define([krb5m4_gssrpc_lib],[])dnl
AC_DEFUN(USE_GSSRPC_LIBRARY,[
AC_REQUIRE([USE_GSSAPI_LIBRARY])dnl
undefine([krb5m4_gssrpc_deplib])dnl
define([krb5m4_gssrpc_deplib],\[$](TOPLIBD)/libgssrpc.a)dnl
undefine([krb5m4_gssrpc_lib])dnl
define([krb5m4_gssrpc_lib],-lgssrpc) ])
dnl
dnl This rule tells KRB5_LIBRARIES to use the gssapi library.
dnl
define([krb5m4_gssapi_deplib],[])dnl
define([krb5m4_gssapi_lib],[])dnl
AC_DEFUN(USE_GSSAPI_LIBRARY,[
undefine([krb5m4_gssapi_deplib])dnl
define([krb5m4_gssapi_deplib],\[$](TOPLIBD)/libgssapi_krb5.a)dnl
undefine([krb5m4_gssapi_lib])dnl
define([krb5m4_gssapi_lib],-lgssapi_krb5) ])
dnl
dnl This rule tells KRB5_LIBRARIES to use the krb5util library.
dnl
define([krb5m4_kutil_deplib],[])dnl
define([krb5m4_kutil_lib],[])dnl
AC_DEFUN(USE_KRB5UTIL_LIBRARY,[
undefine([krb5m4_kutil_deplib])dnl
define([krb5m4_kutil_deplib],\[$](TOPLIBD)/libkrb5util.a)dnl
undefine([krb5m4_kutil_lib])dnl
define([krb5m4_kutil_lib],-lkrb5util) ])
dnl
dnl This rule tells KRB5_LIBRARIES to include the aname db library.
dnl
AC_DEFUN(USE_ANAME,[AC_REQUIRE([USE_DB_LIBRARY]) ])dnl
dnl
dnl This rule tells KRB5_LIBRARIES to include the kdb5 and db libraries.
dnl (Updated to also require OCI libraries if necessary).
dnl
define([krb5m4_kdb5_deplib],[])dnl
define([krb5m4_kdb5_lib],[])dnl
AC_DEFUN(USE_KDB5_LIBRARY,[
undefine([krb5m4_kdb5_deplib])dnl
define([krb5m4_kdb5_deplib],\[$](TOPLIBD)/libkdb5.a)dnl
undefine([krb5m4_kdb5_lib])dnl
define([krb5m4_kdb5_lib],-lkdb5)dnl
AC_REQUIRE([USE_DB_LIBRARY])dnl
AC_REQUIRE([USE_OCI_LIBRARY])dnl
])
dnl
dnl This rule tells KRB5_LIBRARIES to include the krb4 libraries.
dnl
define([krb5m4_krb4_deplib],[])dnl
define([krb5m4_krb4_lib],[])dnl
AC_DEFUN(USE_KRB4_LIBRARY,[
undefine([krb5m4_krb4_deplib])dnl
define([krb5m4_krb4_deplib],$DEPKRB4_LIB $DEPKRB4_CRYPTO_LIB)dnl
undefine([krb5m4_krb4_lib])dnl
define([krb5m4_krb4_lib],$KRB4_LIB $KRB4_CRYPTO_LIB)])
dnl
dnl This rule tells KRB5_LIBRARIES to include the ss library.
dnl
define([krb5m4_ss_deplib],[])dnl
define([krb5m4_ss_lib],[])dnl
AC_DEFUN(USE_SS_LIBRARY,[
undefine([krb5m4_ss_deplib])dnl
define([krb5m4_ss_deplib],\[$](TOPLIBD)/libss.a)dnl
undefine([krb5m4_ss_lib])dnl
define([krb5m4_ss_lib],-lss)dnl
])
dnl
dnl This rule tells KRB5_LIBRARIES to include the dyn library.
dnl
define([krb5m4_dyn_deplib],[])dnl
define([krb5m4_dyn_lib],[])dnl
AC_DEFUN(USE_DYN_LIBRARY,[
undefine([krb5m4_dyn_deplib])dnl
define([krb5m4_dyn_deplib],\[$](TOPLIBD)/libdyn.a)dnl
undefine([krb5m4_dyn_lib])dnl
define([krb5m4_dyn_lib],-ldyn)dnl
])
dnl
dnl This rule tells KRB5_LIBRARIES to include the db library.
dnl
define([krb5m4_db_deplib],[])dnl
define([krb5m4_db_lib],[])dnl
AC_DEFUN(USE_DB_LIBRARY,[
undefine([krb5m4_db_deplib])dnl
define([krb5m4_db_deplib],\[$](TOPLIBD)/libdb.a)dnl
undefine([krb5m4_db_lib])dnl
define([krb5m4_db_lib],-ldb)dnl
])
dnl
dnl This rule tells KRB5_LIBRARIES to include the OCI libraries.
dnl
define([krb5m4_oci_deplib],[])dnl
define([krb5m4_oci_lib],[])dnl
AC_DEFUN(USE_OCI_LIBRARY,[
undefine([krb5m4_oci_lib])dnl
define([krb5m4_oci_lib],$OCI_LDFLAGS $OCI_LIBS)dnl
])
dnl
dnl This rule generates library lists for programs.
dnl
define(KRB5_LIBRARIES,[
dnl
dnl under solaris, if we use compile() and step(), we need -lgen
save_LIBS="$LIBS"
LIBS=-lgen
dnl this will fail if there's no compile/step in -lgen, or if there's
dnl no -lgen.  This is fine.
AC_CHECK_FUNCS(compile step)
[if test "$ac_cv_func_compile" = yes ; then
	LIBS="$save_LIBS -lgen"
else
	LIBS="$save_LIBS"
fi]
dnl this is ugly, but it wouldn't be necessary if krb5 didn't abuse
dnl configure so badly
SRVDEPLIBS="\[$](DEPLOCAL_LIBRARIES) krb5m4_kadmsrv_deplib krb5m4_gssrpc_deplib krb5m4_gssapi_deplib krb5m4_kdb5_deplib krb5m4_kutil_deplib \[$](TOPLIBD)/libkrb5.a $kdb4_deplib krb5m4_krb4_deplib \[$](TOPLIBD)/libcrypto.a krb5m4_ss_deplib krb5m4_dyn_deplib krb5m4_db_deplib krb5m4_oci_deplib \[$](TOPLIBD)/libcom_err.a \[$](SHLIB_EXTRA_DEPS)"
SRVLIBS="\[$](LOCAL_LIBRARIES) krb5m4_kadmsrv_lib krb5m4_gssrpc_lib krb5m4_gssapi_lib krb5m4_kdb5_lib $kdb4_lib krb5m4_kutil_lib krb5m4_krb4_lib -lkrb5 -lcrypto krb5m4_ss_lib krb5m4_dyn_lib krb5m4_db_lib krb5m4_oci_lib -lcom_err $LIBS"
CLNTDEPLIBS="\[$](DEPLOCAL_LIBRARIES) krb5m4_kadmclnt_deplib krb5m4_gssrpc_deplib krb5m4_gssapi_deplib krb5m4_kdb5_deplib krb5m4_kutil_deplib \[$](TOPLIBD)/libkrb5.a $kdb4_deplib krb5m4_krb4_deplib \[$](TOPLIBD)/libcrypto.a krb5m4_ss_deplib krb5m4_dyn_deplib krb5m4_db_deplib krb5m4_oci_deplib \[$](TOPLIBD)/libcom_err.a \[$](SHLIB_EXTRA_DEPS)"
CLNTLIBS="\[$](LOCAL_LIBRARIES) krb5m4_kadmclnt_lib krb5m4_gssrpc_lib krb5m4_gssapi_lib krb5m4_kdb5_lib $kdb4_lib krb5m4_kutil_lib krb5m4_krb4_lib -lkrb5 -lcrypto krb5m4_ss_lib krb5m4_dyn_lib krb5m4_db_lib krb5m4_oci_lib -lcom_err $LIBS"
DEPLIBS="\[$](DEPLOCAL_LIBRARIES) krb5m4_kadmclnt_deplib krb5m4_kadmsrv_deplib krb5m4_gssrpc_deplib krb5m4_gssapi_deplib krb5m4_kdb5_deplib krb5m4_kutil_deplib \[$](TOPLIBD)/libkrb5.a $kdb4_deplib krb5m4_krb4_deplib \[$](TOPLIBD)/libcrypto.a krb5m4_ss_deplib krb5m4_dyn_deplib krb5m4_db_deplib krb5m4_oci_deplib \[$](TOPLIBD)/libcom_err.a \[$](SHLIB_EXTRA_DEPS)"
LIBS="\[$](LOCAL_LIBRARIES) krb5m4_kadmclnt_lib krb5m4_kadmsrv_lib krb5m4_gssrpc_lib krb5m4_gssapi_lib krb5m4_kdb5_lib $kdb4_lib krb5m4_kutil_lib krb5m4_krb4_lib -lkrb5 -lcrypto krb5m4_ss_lib krb5m4_dyn_lib krb5m4_db_lib krb5m4_oci_lib -lcom_err $LIBS"
LDFLAGS="$LDFLAGS -L\$(TOPLIBD)"
AC_SUBST(LDFLAGS)
AC_SUBST(LDARGS)
AC_SUBST(DEPLIBS)
AC_SUBST(SRVDEPLIBS)
AC_SUBST(SRVLIBS)
AC_SUBST(CLNTDEPLIBS)
AC_SUBST(CLNTLIBS)])
dnl
dnl This rule supports the generation of the shared library object files
dnl
define(V5_SHARED_LIB_OBJS,[
if test ${krb5_cv_shlibs_dir}x != x; then
SHARED_RULE="	\$(CC) ${krb5_cv_shlibs_cflags} \$(CFLAGS) -o ${krb5_cv_shlibs_dir}/\$""*.o -c \$""<"
SHARED_RULE_LOCAL="	\$(CC) ${krb5_cv_shlibs_cflags} \$(CFLAGS) -o ${krb5_cv_shlibs_dir}/\$""*.o -c \$""<"
else
SHARED_RULE=
SHARED_RULE_LOCAL=
fi
AC_SUBST(SHARED_RULE)
AC_SUBST(SHARED_RULE_LOCAL)
])dnl
dnl
dnl
dnl This rule adds the additional Makefile fragment necessary to actually 
dnl create the shared library
dnl
dnl V5_MAKE_SHARED_LIB(libname, version, libdir, dirname_relative_to_libdir,
dnl		       lib_subdirs)
dnl
define(V5_MAKE_SHARED_LIB,[
if test "[$]krb5_cv_staticlibs_enabled" = yes
	then
	SHLIB_STATIC_TARGET="$1.[\$](STEXT)"
	else
	SHLIB_STATIC_TARGET=
	fi
AC_ARG_ENABLE([shared],
[  --enable-shared         build with shared libraries], ,enable_shared=no)
if test "$enable_shared" != no ; then
  SHLIB_TAIL_COMP=$krb5_cv_shlibs_tail_comp
  AC_SUBST(SHLIB_TAIL_COMP)
  LD_UNRESOLVED_PREFIX=$krb5_cv_shlibs_sym_ufo
  AC_SUBST(LD_UNRESOLVED_PREFIX)
  LD_SHLIBDIR_PREFIX=$krb5_cv_shlibs_dirhead
  AC_SUBST(LD_SHLIBDIR_PREFIX)
  SHLIB_RPATH_DIRS=
  if test $krb5_cv_shlibs_use_dirs = yes ; then
	if test $krb5_cv_shlibs_use_colon_dirs = yes ; then
		SHLIB_RPATH_DIRS="${krb5_cv_shlibs_dirhead}\$(KRB5_SHLIBDIR)"
	else
		SHLIB_RPATH_DIRS="${krb5_cv_shlibs_dirhead}\$(KRB5_SHLIBDIR)"
	fi
  fi
  AC_SUBST(SHLIB_RPATH_DIRS)
  SHLIB_LIBDIRS="-L\$(TOPLIBD)"
  if test X$krb5_cv_krb4_libdir != X ; then
	SHLIB_LIBDIRS="$SHLIB_LIBDIRS -L$krb5_cv_krb4_libdir"
  fi
  AC_SUBST(SHLIB_LIBDIRS)
  HOST_TYPE=$krb5_cv_host
  AC_SUBST(HOST_TYPE)
  if test "$krb5_cv_shlibs_ext" = ""; then
    AC_MSG_ERROR(Library building info can't be determined by this lame configure
	script; try reconfiguring again from the top of the tree.)
  fi
  SHEXT=$krb5_cv_shlibs_ext
  AC_SUBST(SHEXT)
  if test "$krb5_cv_shlibs_versioned_filenames" = "yes" ; then
	VEXT=".$2" # Version of library goes in archive name
	if test "$krb5_cv_shlibs_need_nover" = yes; then
		DO_MAKE_SHLIB="$1.\$""(SHEXT).$2 $1.\$""(SHEXT)"
	else
		DO_MAKE_SHLIB="$1.\$""(SHEXT).$2"
	fi
  else # $krb5_cv_shlibs_versioned_filenames
	VEXT=
	DO_MAKE_SHLIB="$1.\$""(SHEXT)"
  fi
  AC_SUBST(VEXT)
  dnl export the version of the library....
  krb5_cv_shlib_version_$1=$2
  AC_SUBST(SHLIB_NAME)
  AC_PUSH_MAKEFILE()dnl

all-unix:: [$](DO_MAKE_SHLIB) [$](SHLIB_STATIC_TARGET)

clean-unix:: 
	$(RM) $1.[$](SHEXT)$(VEXT) $1.[$](SHEXT) [$](SHLIB_STATIC_TARGET)

$1.[$](SHEXT)$(VEXT): [$](LIBDONE) [$](DEPLIBS)
	[$](BUILDTOP)/util/makeshlib [$]@	\
		"[$](SHLIB_LIBDIRS)" \
		"[$](SHLIB_LIBS)" "[$](SHLIB_LDFLAGS)" "$2" [$](LIB_SUBDIRS) $5
AC_POP_MAKEFILE()dnl
  if test "$krb5_cv_shlibs_versioned_filenames" = "yes" ; then
	LinkFile($1.[$](SHEXT),$1.[$](SHEXT).$2)
  fi

else # not shared

  DO_MAKE_SHLIB=
  AC_PUSH_MAKEFILE()
all-unix:: [$](DO_MAKE_SHLIB) [$](SHLIB_STATIC_TARGET)

clean-unix:: 
	$(RM) $1.[$](STEXT)
AC_POP_MAKEFILE()
fi # not shared
AC_SUBST(DO_MAKE_SHLIB)
AC_SUBST(SHLIB_STATIC_TARGET)
STEXT=$krb5_cv_noshlibs_ext
AC_SUBST(STEXT)
SHLIB_MODE=$krb5_cv_shlib_mode
AC_SUBST(SHLIB_MODE)

AC_ARG_ENABLE([shared],
[  --enable-shared         build shared libraries], ,enable_shared=no)dnl
if test "$enable_shared" != no; then
  # Note that even if we aren't installing versions of the library with
  # Version identifiers in the file name, we still need to make the links
  # in ${BUILDTOP}/lib for dependencies.
  # The following makes sure that the path of symlinks traces back to the real
  # library; it is not an error that $2 is used in some places and $VEXT in
  # others.
  LinkFileDir($3/$1.[$](SHEXT).$2, $1.[$](SHEXT)[$](VEXT), $4)
  AppendRule([$3/$1.[$](SHEXT): $3/$1.[$](SHEXT).$2
	[$](RM) $3/$1.[$](SHEXT)
	[$](LN) $1.[$](SHEXT).$2 $3/$1.[$](SHEXT)
])
  AppendRule(clean::[
	[$](RM) $3/$1.[$](SHEXT).$2 $3/$1.[$](SHEXT)
])
  if test "$krb5_cv_shlibs_need_nover" = "yes" ; then
	AppendRule([all-unix:: $3/$1.$(SHEXT).$2 $3/$1.$(SHEXT)])
  else
	AppendRule([all-unix:: $3/$1.$(SHEXT)[$](VEXT)])
  fi
  AppendRule([install-all install-kdc install-server install-client install::	$1.[$](SHEXT)[$](VEXT)
	[$](RM) [$](DESTDIR)[$](KRB5_SHLIBDIR)[$](S)$1.[$](SHEXT)[$](VEXT)
	[$](INSTALL_SHLIB) $1.[$](SHEXT)[$](VEXT)	\
		[$](DESTDIR)[$](KRB5_SHLIBDIR)[$](S)$1.[$](SHEXT)[$](VEXT)
])
  if test "$krb5_cv_shlibs_need_nover" = "yes" ; then
    AppendRule([install-all install-kdc install-server install-client install::	$1.[$](SHEXT).$2
	[$](RM) [$](DESTDIR)[$](KRB5_SHLIBDIR)[$](S)$1.[$](SHEXT)
	[$](LN) $1.[$](SHEXT).$2 \
		[$](DESTDIR)[$](KRB5_SHLIBDIR)[$](S)$1.[$](SHEXT)])
  fi
fi
if test -n "$krb5_cv_staticlibs_enabled" ; then
    AppendRule([install-all install-kdc install:: $1.[$](STEXT)
	[$](INSTALL_DATA) $1.[$](STEXT) [$](DESTDIR)[$](KRB5_LIBDIR)[$](S)$1.[$](STEXT)
	$(RANLIB) $(DESTDIR)$(KRB5_LIBDIR)[$](S)$1.[$](STEXT)])
    LinkFileDir($3/$1.[$](STEXT),$1.[$](STEXT),$4)
    AppendRule([all-unix:: $3/$1.[$](STEXT)])
fi
])dnl
dnl In case USE_SHARED_LIBS isn't used.
AC_SUBST(SHLIB_EXTRA_DEPS)dnl
dnl
dnl Defines LDARGS correctly so that we actually link with the shared library
dnl
define(V5_USE_SHARED_LIB,[
AC_ARG_WITH([shared],
[  --with-shared	use shared libraries (default)
  --without-shared	don't use shared libraries],
,
withval=yes
)dnl
if test "$krb5_cv_shlibs_enabled" = yes ; then
  if test "$withval" = yes; then
	AC_MSG_RESULT(Using shared libraries)
	LDARGS="$krb5_cv_shlibs_ldflag -L\$(TOPLIBD) $LDARGS"
	if test "$krb5_cv_exe_need_dirs" = yes; then
		LDARGS="$LDARGS ${krb5_cv_shlibs_dirhead}\$(KRB5_SHLIBDIR)"
	fi
	SHLIB_EXTRA_DEPS=$krb5_cv_shlib_extra_deps
	SHLIB_TAIL_COMP=$krb5_cv_shlibs_tail_comp
	AC_SUBST(SHLIB_TAIL_COMP)
  else
	AC_MSG_RESULT(Using archive libraries)
	LDARGS="$krb5_cv_noshlibs_ldflag -L\$(TOPLIBD) $LDARGS"
	SHLIB_EXTRA_DEPS=
  fi
else
  LDARGS="-L\$(TOPLIBD) $LDARGS"
fi
AC_SUBST(LDARGS)
AC_SUBST(SHLIB_EXTRA_DEPS)
])dnl
dnl
dnl
dnl Check for prototype support - used by application not including k5-int.h
dnl
define(KRB5_CHECK_PROTOS,[
AC_MSG_CHECKING([prototype support])
AC_CACHE_VAL(krb5_cv_has_prototypes,
[AC_TRY_COMPILE(
[int x(double y, int z);], [],
krb5_cv_has_prototypes=yes, krb5_cv_has_prototypes=no)])
AC_MSG_RESULT($krb5_cv_has_prototypes)
if test $krb5_cv_has_prototypes = no; then
AC_DEFINE(KRB5_NO_PROTOTYPES)
else
AC_DEFINE(KRB5_PROVIDE_PROTOTYPES)
fi
dnl *never* set NARROW_PROTOTYPES
])dnl
dnl
dnl Check if stdarg or varargs is available *and compiles*; prefer stdarg.
dnl (This was sent to djm for incorporation into autoconf 3/12/1996.  KR)
dnl
AC_DEFUN(AC_HEADER_STDARG, [

AC_MSG_CHECKING([for stdarg.h])
AC_CACHE_VAL(ac_cv_header_stdarg_h,
[AC_TRY_COMPILE([#include <stdarg.h>], [
  } /* ac_try_compile will have started a function body */
  int aoeu (char *format, ...) {
    va_list v;
    int i;
    va_start (v, format);
    i = va_arg (v, int);
    va_end (v);
],ac_cv_header_stdarg_h=yes,ac_cv_header_stdarg_h=no)])dnl
AC_MSG_RESULT($ac_cv_header_stdarg_h)
if test $ac_cv_header_stdarg_h = yes; then
  AC_DEFINE(HAVE_STDARG_H)
else

AC_MSG_CHECKING([for varargs.h])
AC_CACHE_VAL(ac_cv_header_varargs_h,
[AC_TRY_COMPILE([#include <varargs.h>],[
  } /* ac_try_compile will have started a function body */
  int aoeu (va_alist) va_dcl {
    va_list v;
    int i;
    va_start (v);
    i = va_arg (v, int);
    va_end (v);
],ac_cv_header_varargs_h=yes,ac_cv_header_varargs_h=no)])dnl
AC_MSG_RESULT($ac_cv_header_varargs_h)
if test $ac_cv_header_varargs_h = yes; then
  AC_DEFINE(HAVE_VARARGS_H)
else
  AC_MSG_ERROR(Neither stdarg nor varargs compile?)
fi

fi dnl stdarg test failure

])dnl
dnl
dnl Set environment variables so that shared library executables can run
dnl in the build tree.
dnl
define(KRB5_RUN_FLAGS,[
if test "$krb5_cv_shlibs_enabled" = yes ; then
	KRB5_RUN_ENV=
	if test "$krb5_cv_shlibs_run_ldpath" = default ; then
		KRB5_RUN_ENV="$KRB5_RUN_ENV LD_LIBRARY_PATH=\$(TOPLIBD) ;  export LD_LIBRARY_PATH;"
	elif test "$krb5_cv_shlibs_run_ldpath" != no ; then
		KRB5_RUN_ENV="$KRB5_RUN_ENV LD_LIBRARY_PATH=\$(TOPLIBD):$krb5_cv_shlibs_run_ldpath ; export LD_LIBRARY_PATH;"
	fi
	# For OSF/1 this commits us to ignore built in rpath libraries
	if test "$krb5_cv_shlibs_run_rldroot" = dummy ; then
		KRB5_RUN_ENV="$KRB5_RUN_ENV _RLD_ROOT=/dev/dummy/d; export _RLD_ROOT;"
	fi
	# For AIX
	if test "$krb5_cv_shlibs_run_libpath" != no ; then
		KRB5_RUN_ENV="$KRB5_RUN_ENV LIBPATH=\$(TOPLIBD):$krb5_cv_shlibs_run_libpath ; export LIBPATH;"
	fi
else
	KRB5_RUN_ENV=
fi
AC_SUBST(KRB5_RUN_ENV)
])dnl
dnl
dnl figure out how many arguments gettimeofday has. 
dnl
define(KRB5_GETTIMEOFDAY_ARGS,[
AC_TIME_WITH_SYS_TIME
AC_CHECK_HEADERS(sys/time.h)
AC_MSG_CHECKING([whether gettimeofday will accept two arguments])
AC_CACHE_VAL(krb5_cv_gettimeofday_twoargs,
[AC_TRY_COMPILE([#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif
],
[struct timezone z; struct timeval v; gettimeofday(&v,&z);],
krb5_cv_gettimeofday_twoargs=yes,krb5_cv_gettimeofday_twoargs=no)])
AC_MSG_RESULT($krb5_cv_gettimeofday_twoargs)
if test $krb5_cv_gettimeofday_twoargs = yes; then
AC_DEFINE(KRB5_GETTIMEOFDAY_TWOARGS)
fi
])dnl
dnl
dnl BEGIN CYGNUS LOCAL: Added Tcl and Tk analysis
dnl
dnl
dnl
dnl AC_KRB5_TCL - determine if the TCL library is present on system
dnl
AC_DEFUN(AC_KRB5_TCL,[
tcl_inc=
tcl_lib=
TCL_WITH=
AC_ARG_WITH(tcl,
[  --with-tcl=path         where TCL resides],
        TCL_WITH=$withval
        if test "$withval" != yes -a "$withval" != no ; then
                tcl_lib=$withval/lib
        fi)
tcl_found=no
tcl_search_dirs="$exec_prefix/lib /usr/local/lib /usr/lib"
AC_MSG_CHECKING(Tcl location)
if test -d ${SRCTOP}/support/tcl; then tclsupport=yes; else tclsupport=no; fi
if test "$with_tcl" = no ; then
    tcl_found=no
    AC_MSG_RESULT(disabled by command line option)
elif (test "$with_tcl" = "" || test "$with_tcl" = yes) && test $tclsupport = yes ; then
    # Pull from build tree.  Yuck!
    if test ! -r ${BUILDTOP}/support/tcl/unix/tclConfig.sh ; then
	AC_MSG_ERROR(Can't find tclConfig.sh in build tree.)
    fi
    tcl_lib=${BUILDTOP}/support/tcl/unix
    . ${BUILDTOP}/support/tcl/unix/tclConfig.sh
    AC_MSG_RESULT(in build tree)
    tcl_found=yes

    KRB5_TCL_LIBS="${TCL_BUILD_LIB_SPEC} ${TCL_LIBS}"
    KRB5_TCL_INC="-I${SRCTOP}/support/tcl/generic"
    TCL_LIB="$KRB5_TCL_LIBS"
    TCL_DEPLIB=${BUILDTOP}/support/tcl/unix/${TCL_LIB_FILE}
    KRB5_TCL_FOUND=tcl
elif (test "$with_tcl" = "" || test "$with_tcl" = yes) && test $tclsupport = no ; then
    for i in $tcl_search_dirs ; do
	if test -r $i/tclConfig.sh ; then
	    tcl_lib=$i
	    tcl_found=yes
	    break
	fi
    done
    if test $tcl_found = no ; then
	if test "$with_tcl" = yes ; then
	    AC_MSG_ERROR(not found)
	else
	    AC_MSG_WARN(not found)
	fi
    else
	. $tcl_lib/tclConfig.sh
	AC_MSG_RESULT(found $tcl_lib/tclConfig.sh)
    fi
else # with_tcl is neither yes nor no -- a pathname was given
    if test ! -r $with_tcl/lib/tclConfig.sh ; then
	AC_MSG_ERROR(Can't find $with_tcl/lib/tclConfig.sh)
    fi
    tcl_lib=$with_tcl/lib
    . $tcl_lib/tclConfig.sh
    AC_MSG_RESULT(found $tcl_lib/tclConfig.sh)
    tcl_found=yes
    tclsupport=no # ignore it
fi
if test "$tcl_found/$tclsupport" = "yes/no" ; then
	if test -f "$TCL_PREFIX/include/tcl.h" ; then
		# any normal Tcl installation
		tcl_inc="$TCL_PREFIX/include"
	elif test -f "$TCL_PREFIX/include/tcl/tcl.h" ; then
		# Linux Debian
		tcl_inc="$TCL_PREFIX/include/tcl"
	else
		AC_MSG_WARN(Found tclConfig.sh but not tcl.h.)
		tcl_found=no
	fi
	KRB5_TCL_LIBS="$TCL_LIB_SPEC $TCL_LIBS"
	KRB5_TCL_INC="-I$tcl_inc"
	TCL_LIB=$KRB5_TCL_LIBS
	TCL_DEPLIB=
fi
if test "$tcl_found" = yes; then
    AC_SUBST(KRB5_TCL_LIBS)
    AC_SUBST(KRB5_TCL_INC)
    KRB5_TCL_FOUND=tcl
    AC_SUBST(KRB5_TCL_FOUND)
    AC_MSG_CHECKING(Tcl configuration)
    AC_MSG_RESULT(version: TCL $TCL_VERSION.$TCL_PATCH_LEVEL)
fi
])dnl end of AC_KRB5_TCL
dnl
dnl
dnl AC_KRB5_TK - determine if the TK library is present on system
dnl
AC_DEFUN(AC_KRB5_TK,[
AC_REQUIRE([AC_KRB5_TCL])
tk_inc=
tk_lib=
AC_ARG_WITH(tk,
[  --with-tk=path         where TK resides],
        if test "$withval" != yes -a "$withval" != no ; then
                tk_lib=$withval/lib
        fi)
if test $tcl_found = no && test "$with_tk" != "" && test "$with_tk" != no ; then
    AC_MSG_ERROR(Tk cannot be required when Tcl is not available)
fi
tk_found=no
tk_search_dirs="$tcl_lib $exec_prefix/lib /usr/local/lib /usr/lib"
AC_MSG_CHECKING(Tk location)
if test -d ${SRCTOP}/support/tk ; then tksupport=yes ; else tksupport=no ; fi
if test "$with_tk" = no ; then
    tk_found=no
    AC_MSG_RESULT(disabled by command line option)
elif (test "$with_tk" = "" || test "$with_tk" = yes) && test $tksupport = yes ; then
    # Pull from build tree.  Yuck!
    if test ! -r ${BUILDTOP}/support/tk/unix/tkConfig.sh ; then
	AC_MSG_ERROR(Can't find tkConfig.sh in build tree.)
    fi
    tk_lib=${BUILDTOP}/support/tk/unix
    . ${BUILDTOP}/support/tk/unix/tkConfig.sh
    AC_MSG_RESULT(in build tree)
    tk_found=yes

    KRB5_TK_LIBS="${TK_BUILD_LIB_SPEC} ${TK_LIBS}"
    KRB5_TK_INC="-I${SRCTOP}/support/tk/generic"
    KRB5_TK_INC="$KRB5_TK_INC ${TK_XINCLUDES}"
    KRB5_TK_LIBS="$KRB5_TK_LIBS ${TK_XLIBSW}"
    TK_LIB="$KRB5_TK_LIBS"
    TK_DEPLIB=${BUILDTOP}/support/tk/unix/${TK_LIB_FILE}
    KRB5_TK_FOUND=tk
elif (test "$with_tk" = "" || test "$with_tk" = yes) && test $tksupport = no ; then
    for i in $tk_search_dirs ; do
	if test -r $i/tkConfig.sh ; then
	    tk_lib=$i
	    tk_found=yes
	    break
	fi
    done
    if test $tk_found = no ; then
	if test "$with_tk" = yes ; then
	    AC_MSG_ERROR(not found)
	else
	    AC_MSG_WARN(not found)
	fi
    else
	. $tk_lib/tkConfig.sh
	AC_MSG_RESULT(found $tk_lib/tkConfig.sh)
    fi
else # with_tk is neither yes nor no -- a pathname was given
    if test ! -r $with_tk/lib/tkConfig.sh ; then
	AC_MSG_ERROR(Can't find $with_tk/lib/tkConfig.sh)
    fi
    tk_lib=$with_tk/lib
    . $tk_lib/tkConfig.sh
    AC_MSG_RESULT(found $tk_lib/tkConfig.sh)
    tk_found=yes
    tksupport=no # ignore it
fi
if test "$tk_found/$tksupport" = "yes/no" ; then
	if test -f "$TK_PREFIX/include/tk.h" ; then
		# any normal Tk installation
		tk_inc="$TK_PREFIX/include"
	elif test -f "$TK_PREFIX/include/tcl/tk.h" ; then
		# Linux Debian
		tk_inc="$TK_PREFIX/include/tcl"
	else
		AC_MSG_WARN(Found tkConfig.sh but not tk.h.)
		tk_found=no
	fi
	KRB5_TK_LIBS="$TK_LIB_SPEC $TK_LIBS"
	KRB5_TK_INC="-I$tk_inc $TK_XINCLUDES"

	AC_SUBST(KRB5_TK_LIBS)
	AC_SUBST(KRB5_TK_INC)

	KRB5_TK_FOUND=tk
	AC_SUBST(KRB5_TK_FOUND)
fi

if test "$tcl_found$tk_found" = "yesyes" ; then
	AC_MSG_CHECKING(Tk configuration)

	dnl
	dnl It is assumed that tcl and tk are properly installed and fully
	dnl functional if we got to this point, so no further checks
	dnl are made.
	dnl

	AC_MSG_RESULT(version: TK $TK_VERSION.$TK_PATCH_LEVEL)
fi
])dnl end of AC_KRB5_TK
dnl
dnl END CYGNUS LOCAL
