#include "k5-int.h"
#include "kdb5_edit.h"
#include <ss/ss.h>

extern ss_request_table kdb5_maint_cmds;
extern int sci_idx;
extern int exit_status;

static int maint_enabled;

void maint_mode(argc, argv)
    int argc;
    char *argv[];
{
    krb5_error_code retval;

    if (argc != 1) {
	com_err(argv[0], 0, "Too many arguments");
	com_err(argv[0], 0, "Usage: %s", argv[0]);
    	exit_status++;
	return;
    }

    if (!maint_enabled) {
      ss_add_request_table(sci_idx, &kdb5_maint_cmds, 0, &retval);

      if (retval) {
	ss_perror(sci_idx, retval, "adding maintenance commands");
	exit(1);
      }

      maint_enabled++;
    }

    printf("Maintenance mode commands available.\n");
}
