.\" 
.\" $Id: aklog.M,v 1.3 1996/08/01 02:56:22 jcb Exp $
.\"
.\" Copyright 1990,1991 by the Massachusetts Institute of Technology
.\" For distribution and copying rights, see the file "mit-copyright.h"
.\" "
.ds h ""KerbNet -- Kerberos V5" "Cygnus Solutions""
.TH AKLOG 1 \*h
.UC 4
.SH NAME
aklog \- Obtain tokens for authentication to AFS

.SH SYNOPSIS
.B aklog 
[ 
.B \-d 
] [ 
.B \-hosts
] [ 
.B \-zsubs 
] [ 
.B \-noprdb 
] [ [
.B \-cell | \-c 
] cell [
.B \-k 
kerberos-realm
] ] [ [ 
.B \-path | \-p 
] pathname ]

.SH DESCRIPTION
The 
.I aklog
program is used to authenticate to a cell or directory in 
.I AFS,
the Andrew Filesystem, by obtaining AFS 
.I tokens.  
Ordinarily, aklog is not used directly but called by
.IR attach (1).

If
.I aklog
is invoked with no command line arguments, it will obtain tokens for the
workstation's local cell.  It is possible to invoke
.I aklog
with arbitrarily many cells and pathnames specified on the command line.
.I aklog 
knows how to expand cell name abbreviations, so short forms of cell
names can be use used.  In addition,
.I aklog
understands the following command line options:

.TP 4 
.B  \-cell | \-c \fRcell
This flag is not ordinarily necessary since
.I aklog
can usually figure out when an argument is a cell.  It can be used to
introduce a cell name that would ordinarily be mistaken for a path name
if this should be required.  If this flag is omitted, an argument will
be treated as a cell name if it contains no slashes (/) and is neither
"." nor ".." .

.TP
.B \-k \fRkerberos-realm
This flag is valid only when immediately following the name of a cell.
It is used to tell
.I aklog
what kerberos realm should be used while authenticating to the preceding
cell.  This argument is unnecessary except when the workstation is not
properly configured.  Ordinarily,
.I aklog
can determine this information on its own.

.TP
.B \-path | \-p \fRpathname
Like the \-cell flag, this flag is usually unnecessary.  When it
appears, the next command line argument is always treated as a path
name.  Ordinarily, an argument is treated as a path name if it is "." or
".." or if it contains a slash (/).

.TP
.B \-hosts
Prints all the server addresses which may act as a single point of
failure in accessing the specified directory path.  Each element of the
path is examined, and as new volumes are traversed, if they are not
replicated, the server's IP address containing the volume will be
displayed.
.IR Attach (1)
invokes 
.I aklog
with this option.  The output is of the form

host: 
.I IP address

.TP
.B \-zsubs
Causes the printing of the zephyr subscription information that a person
using a given path or cell would want.
.IR Attach (1)
invokes 
.I aklog
with this option.  The output is of the form

zsub: 
.I instance

where 
.I instance
is the instance of a class filsrv zephyr subscription.

.TP
.B \-noprdb
Ordinarily, aklog looks up the AFS ID corresponding to the name of the
person invoking the command.  Specifying this flag turns off this
functionality.  This may be desirable if the protection database is
unavailable for some reason and tokens are desired anyway.

.TP
.B \-d
Turns on printing of debugging information.  This option is not intended
for general users.

.SH EXIT CODES
The exit status of
.I aklog
will be one of the following:
.TP 5
0
Success -- No error occurred.
.TP 5
1
Usage -- Bad command syntax; accompanied by a usage message.
.TP 5
2
Something failed -- More than one cell or pathname was given on the
command line and at least one failure occurred.  A more specific error
status is returned when only one directive is given.
.TP 5
3
AFS -- Unable to get AFS configuration or unable to get information
about a specific cell.
.TP 5
4
Kerberos -- Unable to get tickets for authentication.
.TP 5
5
Token -- Unable to get tokens.
.TP 5
6
Bad pathname -- The path given was not a directory or 
.I lstat(2)
failed on some component of the pathname.
.TP 5
7
Miscellaneous -- An internal failure occurred.  For example, 
.I aklog
returns this if it runs out of memory.

.SH EXAMPLES
.br
To get tokens for the local cell:
.br
% aklog

To get tokens for the fubar cell:
.br
% aklog fubar

To get tokens adequate to read /afs/fubar/user/p/potato:
.br
% aklog /afs/fubar/user/p/potato

To get tokens for a cell that is in a different Kerberos realm:
.br
% aklog testcell -k BLEEP.COM

.SH SEE ALSO
attach(1), tokens(1), unlog(1)

.SH AUTHOR
Emanuel Jay Berkenbilt (MIT-Project Athena)
