/* $XConsortium: greet.c,v 1.40 94/04/17 20:03:54 gildea Exp $ */
/*

Copyright (c) 1988  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

/*
 * xdm - display manager daemon
 * Author:  Keith Packard, MIT X Consortium
 *
 * widget to get username/password
 *
 */

#include "defines.h"
#include "dm.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#ifdef USESHADOW
# include	<shadow.h>
#endif
# include	<pwd.h>
# ifdef NGROUPS_MAX
# include	<grp.h>
# endif


#include "greet.h"
#include "Login.h"

#if GREET_LIB
/*
 * Function pointers filled in by the initial call ito the library
 */

int     (*__xdm_PingServer)() = NULL;
int     (*__xdm_SessionPingFailed)() = NULL;
int     (*__xdm_Debug)() = NULL;
int     (*__xdm_RegisterCloseOnFork)() = NULL;
int     (*__xdm_SecureDisplay)() = NULL;
int     (*__xdm_UnsecureDisplay)() = NULL;
int     (*__xdm_ClearCloseOnFork)() = NULL;
int     (*__xdm_SetupDisplay)() = NULL;
int     (*__xdm_LogError)() = NULL;
int     (*__xdm_SessionExit)() = NULL;
int     (*__xdm_DeleteXloginResources)() = NULL;
int     (*__xdm_source)() = NULL;
char    **(*__xdm_defaultEnv)() = NULL;
char    **(*__xdm_setEnv)() = NULL;
char    **(*__xdm_parseArgs)() = NULL;
int     (*__xdm_printEnv)() = NULL;
char    **(*__xdm_systemEnv)() = NULL;
int     (*__xdm_LogOutOfMem)() = NULL;
void    (*__xdm_setgrent)() = NULL;
struct group    *(*__xdm_getgrent)() = NULL;
void    (*__xdm_endgrent)() = NULL;
#ifdef USESHADOW
struct spwd   *(*__xdm_getspnam)() = NULL;
void   (*__xdm_endspent)() = NULL;
#endif
struct passwd   *(*__xdm_getpwnam)() = NULL;
char     *(*__xdm_crypt)() = NULL;

#endif

#ifdef SECURE_RPC
#include <rpc/rpc.h>
#include <rpc/key_prot.h>
#endif

#ifdef K5AUTH
#include <krb5.h>
#endif

extern Display	*dpy;

static int	done, redone, code;
static char	name[128], password[128];
static Widget		toplevel;
static Widget		login;
static Widget		regreeter, relogin;
static XtAppContext	context;
static XtIntervalId	pingTimeout;

/*ARGSUSED*/
static void
GreetPingServer (closure, intervalId)
    XtPointer	    closure;
    XtIntervalId    *intervalId;
{
    struct display *d;

    d = (struct display *) closure;
    if (!PingServer (d, XtDisplay (toplevel)))
	SessionPingFailed (d);
    pingTimeout = XtAppAddTimeOut (context, d->pingInterval * 60 * 1000,
				   GreetPingServer, (closure));
}

/*ARGSUSED*/
static void
GreetDone (w, data, status)
    Widget	w;
    LoginData	*data;
    int		status;
{
    Debug ("GreetDone: %s, (password is %d long)\n",
	    data->name, strlen (data->passwd));
    switch (status) {
    case NOTIFY_OK:
	strcpy (name, data->name);
	strcpy (password, data->passwd);
	bzero (data->passwd, NAME_LEN);
	code = 0;
	done = 1;
	break;
    case NOTIFY_ABORT:
	Debug ("RESERVER_DISPLAY\n");
	code = RESERVER_DISPLAY;
	done = 1;
	break;
    case NOTIFY_RESTART:
	Debug ("REMANAGE_DISPLAY\n");
	code = REMANAGE_DISPLAY;
	done = 1;
	break;
    case NOTIFY_ABORT_DISPLAY:
	Debug ("UNMANAGE_DISPLAY\n");
	code = UNMANAGE_DISPLAY;
	done = 1;
	break;
    }
}

/*ARGSUSED*/
static void
ReGreetDone (w, data, status)
    Widget	w;
    LoginData	*data;
    int		status;
{
    Debug ("ReGreetDone: %s, (password is %d long)\n",
	    data->name, strlen (data->passwd));
    switch (status) {
    case NOTIFY_OK:
	strcpy (name, data->name);
	strcpy (password, data->passwd);
	bzero (data->passwd, NAME_LEN);
	code = 0;
	redone = 1;
	break;
    case NOTIFY_ABORT:
	Debug ("RESERVER_DISPLAY\n");
	code = RESERVER_DISPLAY;
	redone = 1;
	break;
    case NOTIFY_RESTART:
	Debug ("REMANAGE_DISPLAY\n");
	code = REMANAGE_DISPLAY;
	redone = 1;
	break;
    case NOTIFY_ABORT_DISPLAY:
	Debug ("UNMANAGE_DISPLAY\n");
	code = UNMANAGE_DISPLAY;
	redone = 1;
	break;
    }
}

static Display *
InitGreet (d)
    struct display	*d;
{
    Arg		arglist[10];
    int		i;
    static int	argc;
    Screen		*scrn;
    static char	*argv[] = { "xlogin", 0 };
    Display		*dpy;

    Debug ("greet %s\n", d->name);
    argc = 1;
    XtToolkitInitialize ();
    context = XtCreateApplicationContext();
    dpy = XtOpenDisplay (context, d->name, "xlogin", "Xlogin", 0,0,
			 &argc, argv);

    if (!dpy)
	return 0;

    RegisterCloseOnFork (ConnectionNumber (dpy));

    if (debugLevel != 42) SecureDisplay (d, dpy);

    i = 0;
    scrn = XDefaultScreenOfDisplay(dpy);
    XtSetArg(arglist[i], XtNscreen, scrn);	i++;
    XtSetArg(arglist[i], XtNargc, argc);	i++;
    XtSetArg(arglist[i], XtNargv, argv);	i++;

    toplevel = XtAppCreateShell ((String) NULL, "Xlogin",
		    applicationShellWidgetClass, dpy, arglist, i);

    i = 0;
    XtSetArg (arglist[i], XtNnotifyDone, (XtPointer)GreetDone); i++;
    if (!d->authorize || d->authorizations || !d->authComplain)
    {
	XtSetArg (arglist[i], XtNsecureSession, True); i++;
    }

    Debug("Init Greet: Creating managed widget\n");

    login = XtCreateManagedWidget ("login", loginWidgetClass, toplevel,
				    arglist, i);
    XtRealizeWidget (toplevel);

    Debug("Init Greet: Realizing managed widget\n");
 
    XWarpPointer(dpy, None, XRootWindowOfScreen (scrn),
		    0, 0, 0, 0,
		    XWidthOfScreen(scrn) / 2,
		    XHeightOfScreen(scrn) / 2);

    if (d->pingInterval)
    {
    	pingTimeout = XtAppAddTimeOut (context, d->pingInterval * 60 * 1000,
				       GreetPingServer, (XtPointer) d);
    }

    Debug("Init Greet: Exiting managed widget\n");

    return dpy;
}

static
CloseGreet (d)
    struct display	*d;
{
    Boolean	    allow;
    Arg	    arglist[1];
    Display* dpy = XtDisplay(toplevel);

    if (pingTimeout)
    {
	XtRemoveTimeOut (pingTimeout);
	pingTimeout = 0;
    }
    UnsecureDisplay (d, dpy);
    XtSetArg (arglist[0], XtNallowAccess, (char *) &allow);
    XtGetValues (login, arglist, 1);
    if (allow)
    {
	Debug ("Disabling access control\n");
	XSetAccessControl (dpy, DisableAccess);
    }

    XtDestroyWidget (toplevel);
    ClearCloseOnFork (XConnectionNumber (dpy));
    XCloseDisplay (dpy);
    Debug ("Greet connection closed\n");
}

static
ReGreet (d, dpy, prompt, hidden, banner)
     struct display	*d;
     Display		*dpy;
     char * prompt;
     int hidden;
     char * banner;
{
    Arg		arglist[10];
    int		i;
    static int	argc;
    Screen		*scrn;
    static char	*argv[] = { "xlogin", 0 };
    static char bn[1024], pr[1024];
    strcpy(bn, banner);
    strcpy(pr, prompt);

    /* from CloseGreet */
    if (pingTimeout)
    {
	XtRemoveTimeOut (pingTimeout);
	pingTimeout = 0;
    }
    /* UnsecureDisplay (d, XtDisplay (toplevel)); */
    /* from InitGreet */

    /* if (debugLevel != 42) SecureDisplay (d, dpy); */

    i = 0;
    scrn = XDefaultScreenOfDisplay(dpy);
    XtSetArg(arglist[i], XtNscreen, scrn);	i++;
    XtSetArg(arglist[i], XtNargc, argc);	i++;
    XtSetArg(arglist[i], XtNargv, argv);	i++;
    regreeter = XtAppCreateShell ((String) NULL, "Xlogin",
		    applicationShellWidgetClass, dpy, arglist, i);

    i = 0;
    XtSetArg (arglist[i], XtNnotifyDone, (XtPointer)ReGreetDone); i++;
    if (!d->authorize || d->authorizations || !d->authComplain)
    {
	XtSetArg (arglist[i], XtNsecureSession, True); i++;
    }
    if (hidden) {
      XtSetArg(arglist[i], XtNnamePrompt, "");		i++;
      XtSetArg(arglist[i], XtNpasswdPrompt, pr);	i++;
    } else {
      XtSetArg(arglist[i], XtNnamePrompt, pr);		i++;
      XtSetArg(arglist[i], XtNpasswdPrompt, "");	i++;
    }
    XtSetArg(arglist[i], XtNgreeting, bn); i++;
    Debug("Re Greet: Creating managed widget, pr <%s> bn <%s>\n",pr,bn);


    Debug("Re Greet: Creating managed widget\n");

    relogin = XtCreateManagedWidget ("login", loginWidgetClass, regreeter,
				     arglist, i);
    XtRealizeWidget (regreeter);

    Debug("Re Greet: Realizing managed widget\n");
 
    i = 0;
    XtSetArg(arglist[i], XtNstate, hidden?GET_PASSWD:GET_NAME_ONLY);	i++;
    XtSetValues (relogin, arglist, i);

    XWarpPointer(dpy, None, XRootWindowOfScreen (scrn),
		    0, 0, 0, 0,
		    XWidthOfScreen(scrn) / 2,
		    XHeightOfScreen(scrn) / 2);

    Debug("Re Greet: Exiting managed widget\n");

    return 0;
}

static int
Greet (d, greet)
    struct display *d;
    struct greet_info *greet;
{
    XEvent		event;
    Arg		arglist[1];

    XtSetArg (arglist[0], XtNallowAccess, False);
    XtSetValues (login, arglist, 1);

    Debug ("dispatching %s\n", d->name);
    done = 0;
    while (!done) {
	    XtAppNextEvent (context, &event);
	    XtDispatchEvent (&event);
    }
    XFlush (XtDisplay (toplevel));
    Debug ("Done dispatch %s\n", d->name);
    if (code == 0)
    {
	greet->name = name;
	greet->password = password;
	XtSetArg (arglist[0], XtNsessionArgument, (char *) &(greet->string));
	XtGetValues (login, arglist, 1);
	Debug ("sessionArgument: %s\n", greet->string ? greet->string : "<NULL>");
    }
    return code;
}

typedef struct greeter_xstuff {
  Display* dpy;  
  struct display *d;
  char *inituser;
  char *initpw;
} greeter_xstuff;

static krb5_error_code
greeter_prompter(krb5_context kcontext,
		 void *data,
		 const char *banner,
		 int num_prompts,
		 krb5_prompt prompts[])
{
  greeter_xstuff *gx = (greeter_xstuff*)data;
  int i;
  XEvent		event;
  Arg		arglist[2];
  Debug ("\tgreeter_prompter called\n");

  for (i = 0; i < num_prompts; i++ ) {
    ReGreet(gx->d, gx->dpy, prompts[i].prompt, prompts[i].hidden, banner);
    XtSetArg (arglist[0], XtNallowAccess, False);
    XtSetValues (relogin, arglist, 1);

    Debug ("\tgreeter_prompter %s\n", banner?banner:"<null>");

    redone = 0;
    while (!redone) {
      Debug ("\tgreeter_prompter looping on redone\n");
      XtAppNextEvent (context, &event);
      XtDispatchEvent (&event);
    }
    XFlush (XtDisplay (regreeter));
    Debug ("\tgreeter_prompter: done loop\n");
    /* Debug ("Done dispatch %s\n", d->name); */
    if (code == 0)
      {
	/* greet->name = name; */
	/* greet->password = password;*/
	strcpy(prompts[i].reply->data, prompts[i].hidden?password:name);
	prompts[i].reply->length = strlen(prompts[i].reply->data);
      }
    XtUnrealizeWidget (regreeter);
    XtDestroyWidget (regreeter);
    Debug ("old ReGreet nuked\n");
  }

  Debug ("\tgreeter_prompter: returning %d\n", code);
  return code;
}

static void
FailedLogin (d, greet)
    struct display	*d;
    struct greet_info	*greet;
{
    DrawFail (login);
    bzero (greet->name, strlen(greet->name));
    bzero (greet->password, strlen(greet->password));
}

#ifdef K5AUTH
/* snarfed from verify.c */
#ifdef X_NOT_STDC_ENV
char *getenv();
#endif

static char *envvars[] = {
#if defined(sony) && !defined(SYSTYPE_SYSV) && !defined(_SYSTYPE_SYSV)
    "bootdev",
    "boothowto",
    "cputype",
    "ioptype",
    "machine",
    "model",
    "CONSDEVTYPE",
    "SYS_LANGUAGE",
    "SYS_CODE",
    "TZ",
#endif
    NULL
};

static char **
userEnv (d, useSystemPath, user, home, shell)
struct display	*d;
int	useSystemPath;
char	*user, *home, *shell;
{
    char	**env;
    char	**envvar;
    char	*str;
    extern char **defaultEnv (), **setEnv ();
    
    env = defaultEnv ();
    env = setEnv (env, "DISPLAY", d->name);
    env = setEnv (env, "HOME", home);
    env = setEnv (env, "USER", user);
    env = setEnv (env, "PATH", useSystemPath ? d->systemPath : d->userPath);
    env = setEnv (env, "SHELL", shell);
    for (envvar = envvars; *envvar; envvar++)
    {
	if (str = getenv(*envvar))
	    env = setEnv (env, *envvar, str);
    }
    return env;
}

#ifdef NGROUPS_MAX
static int
groupMember (name, members)
    char *name;
    char **members;
{
	while (*members) {
		if (!strcmp (name, *members))
			return 1;
		++members;
	}
	return 0;
}

static void
getGroups (name, verify, gid)
    char		*name;
    struct verify_info	*verify;
    int			gid;
{
	int		ngroups;
	struct group	*g;
	int		i;

	ngroups = 0;
	verify->groups[ngroups++] = gid;
	setgrent ();
	/* SUPPRESS 560 */
	while (g = getgrent()) {
		/*
		 * make the list unique
		 */
		for (i = 0; i < ngroups; i++)
			if (verify->groups[i] == g->gr_gid)
				break;
		if (i != ngroups)
			continue;
		if (groupMember (name, g->gr_mem)) {
			if (ngroups >= NGROUPS_MAX)
				LogError ("%s belongs to more than %d groups, %s ignored\n",
					name, NGROUPS_MAX, g->gr_name);
			else
				verify->groups[ngroups++] = g->gr_gid;
		}
	}
	verify->ngroups = ngroups;
	endgrent ();
}
#endif /* NGROUPS_MAX */

krb5_creds my_creds;
krb5_ccache xtra_creds;
krb5_principal me;

int
VerifyK5 (d, greet, verify, dpy)
     struct display		*d;
     struct greet_info	*greet;
     struct verify_info	*verify;
     Display *dpy;
{
	struct passwd	*p;
#ifdef USESHADOW
	struct spwd	*sp;
#endif
#if !defined(SVR4) || !defined(GREET_LIB) /* shared lib decls handle this */
	char		*crypt ();
	char		**systemEnv (), **parseArgs ();
#endif
	char		*shell, *home;
	char		**argv;

	Debug ("Verify %s ...\n", greet->name);
	p = getpwnam (greet->name);
	if (!p || strlen (greet->name) == 0) {
		Debug ("getpwnam() failed.\n");
		bzero(greet->password, strlen(greet->password));
		return 0;
	}

#ifdef K5AUTH
	{
	  extern int Krb5InitDone;
	  krb5_context kcontext;
	  extern krb5_principal me;
	  extern krb5_creds my_creds;
	  extern krb5_ccache xtra_creds;
	  krb5_error_code code;
	  greeter_xstuff gx;
	  int success;

	  me = NULL;
	  gx.inituser = strdup(greet->name);
	  gx.initpw = strdup(greet->password);
	  gx.d = d;
	  gx.dpy = dpy;

	  krb5_init_context(&kcontext);
	  krb5_init_ets(kcontext);

	  Debug ("K5AUTH: getting name\n");
	  if (code = krb5_parse_name (kcontext, gx.inituser, &me)) {
	    com_err("xdm", code,
		    "when parsing user name");
	    goto krb_greet_fail;
	  }
	  Debug ("K5AUTH: getting creds with greeter prompter\n");

	  code = krb5_get_init_creds_password(kcontext, &my_creds, me, gx.initpw,
					      greeter_prompter, &gx,
					      0, NULL,
					      NULL /* &opts */);
	  Debug ("K5AUTH: got creds code %d\n", code);
	  if (code) {
	    if (code == KRB5KRB_AP_ERR_BAD_INTEGRITY)
	      fprintf (stderr, "%s: Password incorrect\n", "xdm");
	    else
	      com_err ("xdm", code, "while getting initial credentials");
	    goto krb_greet_fail;
	  }
	  /* Now verify the creds against the local keytab */
	  xtra_creds = NULL;
	  code = krb5_verify_init_creds(kcontext, &my_creds, NULL,
					NULL, &xtra_creds, NULL);
	  if (code) {
	      com_err ("xdm", code, "while verifying initial credentials");
	      goto krb_greet_fail;
	  }

	  /* just leave the creds around and stash them later */
	  krb5_free_context(kcontext);
	  success = 1;
	  Krb5InitDone = 0;
	  free(gx.inituser); free(gx.initpw);
	  goto verify_ok;

	krb_greet_fail:
	  Krb5InitDone = code;
	  krb5_free_context(kcontext);
	  Debug ("K5AUTH: krb_greet_fail\n");
	  Debug ("K5AUTH: fail: name <%s> pw <%s>\n",
		 greet->name, greet->password);
	  /* return code; */ /* fall through to local pw checks */
	  greet->name = gx.inituser;
	  greet->password = gx.initpw;
	  Debug ("K5AUTH: fail: real name <%s> pw <%s>\n",
		 greet->name, greet->password);
	}
#endif /* K5AUTH */

#ifdef USESHADOW
	sp = getspnam(greet->name);
	if (sp == NULL) {
		Debug ("getspnam() failed.  Are you root?\n");
		bzero(greet->password, strlen(greet->password));
		return 0;
	}
	endspent();

	if (strcmp (crypt (greet->password, sp->sp_pwdp), sp->sp_pwdp))
#else
	if (strcmp (crypt (greet->password, p->pw_passwd), p->pw_passwd))
#endif
	{
		Debug ("password verify failed\n");
		bzero(greet->password, strlen(greet->password));
		return 0;
	}
	/* If we got here by this path, Kerberos authentication failed.  */
	LogError ("Warning: No Kerberos tickets obtained.\n");
verify_ok:
	Debug ("verify succeeded\n");
/*	bzero(greet->password, strlen(greet->password)); */
	verify->uid = p->pw_uid;
#ifdef NGROUPS_MAX
	getGroups (greet->name, verify, p->pw_gid);
#else
	verify->gid = p->pw_gid;
#endif
	home = p->pw_dir;
	shell = p->pw_shell;
	argv = 0;
	if (d->session)
		argv = parseArgs (argv, d->session);
	if (greet->string)
		argv = parseArgs (argv, greet->string);
	if (!argv)
		argv = parseArgs (argv, "xsession");
	verify->argv = argv;
	verify->userEnviron = userEnv (d, p->pw_uid == 0,
				       greet->name, home, shell);
	Debug ("user environment:\n");
	printEnv (verify->userEnviron);
	verify->systemEnviron = systemEnv (d, greet->name, home);
	Debug ("system environment:\n");
	printEnv (verify->systemEnviron);
	Debug ("end of environments\n");
	return 1;
}


#endif /* K5AUTH */

greet_user_rtn GreetUser(d, dpy, verify, greet, dlfuncs)
    struct display          *d;
    Display                 ** dpy;
    struct verify_info      *verify;
    struct greet_info       *greet;
    struct dlfuncs       *dlfuncs;
{
    int i;

#ifdef GREET_LIB
/*
 * These must be set before they are used.
 */
    __xdm_PingServer = dlfuncs->_PingServer;
    __xdm_SessionPingFailed = dlfuncs->_SessionPingFailed;
    __xdm_Debug = dlfuncs->_Debug;
    __xdm_RegisterCloseOnFork = dlfuncs->_RegisterCloseOnFork;
    __xdm_SecureDisplay = dlfuncs->_SecureDisplay;
    __xdm_UnsecureDisplay = dlfuncs->_UnsecureDisplay;
    __xdm_ClearCloseOnFork = dlfuncs->_ClearCloseOnFork;
    __xdm_SetupDisplay = dlfuncs->_SetupDisplay;
    __xdm_LogError = dlfuncs->_LogError;
    __xdm_SessionExit = dlfuncs->_SessionExit;
    __xdm_DeleteXloginResources = dlfuncs->_DeleteXloginResources;
    __xdm_source = dlfuncs->_source;
    __xdm_defaultEnv = dlfuncs->_defaultEnv;
    __xdm_setEnv = dlfuncs->_setEnv;
    __xdm_parseArgs = dlfuncs->_parseArgs;
    __xdm_printEnv = dlfuncs->_printEnv;
    __xdm_systemEnv = dlfuncs->_systemEnv;
    __xdm_LogOutOfMem = dlfuncs->_LogOutOfMem;
    __xdm_setgrent = dlfuncs->_setgrent;
    __xdm_getgrent = dlfuncs->_getgrent;
    __xdm_endgrent = dlfuncs->_endgrent;
#ifdef USESHADOW
    __xdm_getspnam = dlfuncs->_getspnam;
    __xdm_endspent = dlfuncs->_endspent;
#endif
    __xdm_getpwnam = dlfuncs->_getpwnam;
    __xdm_crypt = dlfuncs->_crypt;
#endif

    *dpy = InitGreet (d);
    /*
     * Run the setup script - note this usually will not work when
     * the server is grabbed, so we don't even bother trying.
     */
    if (!d->grabServer)
	SetupDisplay (d);
    if (!*dpy) {
	LogError ("Cannot reopen display %s for greet window\n", d->name);
	EXIT (RESERVER_DISPLAY);
    }
    for (;;) {
	/*
	 * Greet user, requesting name/password
	 */
	code = Greet (d, greet);
	if (code != 0)
	{
	    CloseGreet (d);
	    SessionExit (d, code, FALSE);
	}
	/*
	 * Verify user
	 */
#ifdef K5AUTH
	XtUnmapWidget (toplevel);
	Debug ("toplevel Greet unmapped\n");
	{ int st;
	  st = VerifyK5 (d, greet, verify, *dpy);
	  XtMapWidget (toplevel);
	  if (st)
	    break;
	  else
	    FailedLogin (d, greet);
	}
#else
	if (Verify (d, greet, verify))
	    break;
	else
	    FailedLogin (d, greet);
#endif
    }
    DeleteXloginResources (d, *dpy);
    CloseGreet (d);
    Debug ("Greet loop finished\n");
    /*
     * Run system-wide initialization file
     */
    if (source (verify->systemEnviron, d->startup) != 0)
    {
	Debug ("Startup program %s EXITed with non-zero status\n",
		d->startup);
	SessionExit (d, OBEYSESS_DISPLAY, FALSE);
    }
    /*
     * for user-based authorization schemes,
     * add the user to the server's allowed "hosts" list.
     */
    for (i = 0; i < d->authNum; i++)
    {
#ifdef SECURE_RPC
	if (d->authorizations[i]->name_length == 9 &&
	    memcmp(d->authorizations[i]->name, "SUN-DES-1", 9) == 0)
	{
	    XHostAddress	addr;
	    char		netname[MAXNETNAMELEN+1];
	    char		domainname[MAXNETNAMELEN+1];
    
	    getdomainname(domainname, sizeof domainname);
	    user2netname (netname, verify->uid, domainname);
	    addr.family = FamilyNetname;
	    addr.length = strlen (netname);
	    addr.address = netname;
	    XAddHost (*dpy, &addr);
	}
#endif
#ifdef K5AUTH
	if (d->authorizations[i]->name_length == 14 &&
	    memcmp(d->authorizations[i]->name, "MIT-KERBEROS-5", 14) == 0)
	{
	    /* Update server's auth file with user-specific info.
	     * Don't need to AddHost because X server will do that
	     * automatically when it reads the cache we are about
	     * to point it at.
	     */
	    extern Xauth *Krb5GetAuthFor();

	    XauDisposeAuth (d->authorizations[i]);
	    d->authorizations[i] =
		Krb5GetAuthFor(14, "MIT-KERBEROS-5", d->name);
	    SaveServerAuthorizations (d, d->authorizations, d->authNum);
	} 
#endif
    }

    return Greet_Success;
}
