#include <stdio.h>
#include <string.h>
#include <signal.h>
#include "config.h"

#define PIDFILE_LINE	"DisplayManager.pidFile:"

char buf[BUFSIZ + 1], pidfile[BUFSIZ];
char *config_file = DEF_XDM_CONFIG;
int pid;
char *p;
FILE *f;

int main (argc, argv) int argc; char *argv[]; {

  f = fopen (config_file, "r");
  if (f == 0)
    {
      perror (config_file);
      return 1;
    }
  while (fgets (buf, BUFSIZ, f) != NULL)
    {
      if (buf[0] == 0)
	continue;
      if (buf[strlen(buf)-1] != '\n')
	{
	  fprintf (stderr, "%s: line too long\n", config_file);
	  return 1;
	}
      if (strncmp (buf, PIDFILE_LINE, strlen (PIDFILE_LINE)))
	continue;
      /* got the right line! */
      break;
    }

  if (ferror (f))
    {
      perror (config_file);
      return 1;
    }
  else if (feof (f))
    {
      fprintf (stderr, "no \"%s\" line found\n", PIDFILE_LINE);
      return 1;
    }

  fclose (f);

  p = buf + strlen (PIDFILE_LINE);
  while (*p == ' ' || *p == '\t')
    p++;

  strcpy (pidfile, p);
  p = strchr (pidfile, '!');
  if (p)
    *p = 0;
  if (pidfile[0] == 0)
    {
      fprintf (stderr, "empty pid file pathname?\n");
      return 1;
    }
  p = pidfile + strlen (pidfile) - 1;
  while (*p == ' ' || *p == '\t' || *p == '\n')
    *p-- = 0;

  /* got just the filename */
  if (pidfile[0] != '/')
    {
      fprintf (stderr, "pid file pathname not absolute\n");
      return 1;
    }

  f = fopen (pidfile, "r");
  if (f == 0)
    {
      perror (pidfile);
      return 1;
    }
  if (fscanf (f, "%d", &pid) != 1)
    {
      if (ferror (f))
	perror (pidfile);
      else if (feof (f))
	fprintf (stderr, "no pid stored in %s?\n", pidfile);
      else
	fprintf (stderr, "couldn't read pid from %s\n", pidfile);
      return 1;
    }
  if (kill (pid, SIGHUP))
    {
      perror ("sending SIGHUP to xdm");
      return 1;
    }
  return 0;
}
