/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include "krb5.h"
#include "com_err.h"

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <signal.h>
#include <netinet/in.h>

#include <krb.h>
#include <krb4-proto.h>
#include "krb524.h"
#include "getopt.h"

/* Variables for getopt() */
struct option long_options[] = {
    { "version", 0, NULL, 0x01 },
    { NULL, 0, NULL, 0 }
};

int main(argc, argv)
     int argc;
     char **argv;
{
     krb5_principal client, server;
     krb5_ccache cc;
     krb5_creds increds, *v5creds;
     CREDENTIALS v4creds;
     int code;
     int option;
     char *princ = NULL;
     int nodelete = 0;
     int lose = 0;
     krb5_context context;

     krb5_init_context(&context);

    while(((option =  getopt_long(argc, argv, "p:n",
      long_options, NULL)) != EOF)) {
	switch(option) {
	case 'p':
	    princ = optarg;
	    break;
	case 'n':
	    nodelete++;
	    break;
	case 1: /* Print the version */
            printf("%s\n", krb5_version);
            exit(0);
	default:
	    lose++;
	    break;
	}
    }

     if (lose || (argc - optind > 1)) {
	 fprintf(stderr, "Usage: k524init [-p principal]\n");
	 exit(1);
     }

     krb524_init_ets(context);

     if ((code = krb5_cc_default(context, &cc))) {
	  com_err("k524init", code, "opening default credentials cache");
	  exit(1);
     }

     if ((code = krb5_cc_get_principal(context, cc, &client))) {
	 com_err("k524init", code, "while retrieving user principal name");
	 exit(1);
     }

     if (princ) {
	 if ((code = krb5_parse_name(context, princ, &server))) {
	     com_err("k524init", code, "while parsing service principal name");
	     exit(1);
	 }
     } else {
	 if ((code = krb5_build_principal(context, &server, 
					  krb5_princ_realm(context, client)->length,
					  krb5_princ_realm(context, client)->data,
					  "krbtgt",
					  krb5_princ_realm(context, client)->data,
					  NULL))) {
	     com_err("k524init", code, "while creating service principal name");
	     exit(1);
	 }
     }

     memset((char *) &increds, 0, sizeof(increds));
     increds.client = client;
     increds.server = server;
     increds.times.endtime = 0;
     increds.keyblock.enctype = ENCTYPE_DES_CBC_CRC;
     if ((code = krb5_get_credentials(context, 0, cc, &increds, &v5creds))) {
	  com_err("k524init", code, "getting V5 credentials");
	  exit(1);
     }

     if ((code = krb524_convert_creds_kdc(context, v5creds, &v4creds))) {
	  com_err("k524init", code, "converting to V4 credentials");
	  exit(1);
     }
     
     /* this is stolen from the v4 kinit */

     if (!nodelete) {
	/* initialize ticket cache */
	if ((code = in_tkt(v4creds.pname,v4creds.pinst) != KSUCCESS)) {
	   com_err("k524init", code, "trying to create the V4 ticket file");
	   exit(1);
	}
     }

#ifdef	notdef
     /* stash ticket, session key, etc. for future use */
     if ((code = krb_save_credentials(v4creds.service, v4creds.instance,
				      v4creds.realm, v4creds.session,
				      v4creds.lifetime, v4creds.kvno,
				      &(v4creds.ticket_st), 
				      v4creds.issue_date))) {
	 com_err("k524init", code, "trying to save the V4 ticket");
	 exit(1);
     }
#else	/* notdef */
     /*
      * krb_save_credentials() as supplied by CNS doesn't exist in the MIT
      * Kerberos version 4.  So, we're inlining the logic here.
      */
     if (((code = tf_init(TKT_FILE, W_TKT_FIL)) != KSUCCESS) ||
	 ((code = tf_save_cred(v4creds.service, v4creds.instance,
			       v4creds.realm, v4creds.session,
			       v4creds.lifetime, v4creds.kvno,
			       &(v4creds.ticket_st),
			       v4creds.issue_date)))) {
	 com_err("k524init", code, "trying to save the V4 ticket");
	 exit(1);
     }
     else
	 (void) tf_close();
#endif	/* notdef */

     exit(0);
}
