/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/*
 * $Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/lib/kadm5/misc_free.c,v 1.16 1996/07/25 22:06:40 tytso Exp $
 */

#if !defined(lint) && !defined(__CODECENTER__)
static char *rcsid = "$Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/lib/kadm5/misc_free.c,v 1.16 1996/07/25 22:06:40 tytso Exp $";
#endif
#include	<kadm5/admin.h>
#include 	<stdlib.h>
#ifdef HAVE_MALLOC_H
#include 	<malloc.h>
#endif /* HAVE_MALLOC_H */
#include	"server_internal.h"

kadm5_ret_t
kadm5_free_policy_ent(void *server_handle, kadm5_policy_ent_t val)
{
    kadm5_server_handle_t	handle = server_handle;

    _KADM5_CHECK_HANDLE(server_handle);

    if(val) {
	if (val->policy)
	    free(val->policy);
	if (handle->api_version == KADM5_API_VERSION_1)
	     free(val);
    }
    return KADM5_OK;
}

kadm5_ret_t
     kadm5_free_name_list(void *server_handle, char **names, int count)
{
    _KADM5_CHECK_HANDLE(server_handle);
	  
    while (count--)
	  free(names[count]);
     free(names);
    return KADM5_OK;
}


/* XXX this ought to be in libkrb5.a, but isn't */
kadm5_ret_t krb5_free_key_data_contents(context, key)
   krb5_context context;
   krb5_key_data *key;
{
     int i, idx;
     
     idx = (key->key_data_ver == 1 ? 1 : 2);
     for (i = 0; i < idx; i++) {
	  if (key->key_data_contents[i]) {
	       memset(key->key_data_contents[i], 0, key->key_data_length[i]);
	       free(key->key_data_contents[i]);
	  }
     }
     return KADM5_OK;
}

kadm5_ret_t
kadm5_free_principal_ent(void *server_handle,
			      kadm5_principal_ent_t val)
{
    kadm5_server_handle_t	handle = server_handle;
    int i;

    _KADM5_CHECK_HANDLE(server_handle);

    if(val) {
	if(val->principal) 
	    krb5_free_principal(handle->context, val->principal);
	if(val->mod_name)
	    krb5_free_principal(handle->context, val->mod_name);
	if(val->policy)
	    free(val->policy);
	if (handle->api_version > KADM5_API_VERSION_1) {
	     if (val->n_key_data) {
		  for (i = 0; i < val->n_key_data; i++)
		       krb5_free_key_data_contents(handle->context,
						   &val->key_data[i]);
		  free(val->key_data);
	     }
	     if (val->tl_data) {
		  krb5_tl_data *tl;
		  
		  while (val->tl_data) {
		       tl = val->tl_data->tl_data_next;
		       free(val->tl_data->tl_data_contents);
		       free(val->tl_data);
		       val->tl_data = tl;
		  }
	     }
	}
	
	if (handle->api_version == KADM5_API_VERSION_1)
	     free(val);
    }
    return KADM5_OK;
}
