#ifndef _WIN32SERVICE_H_
#define _WIN32SERVICE_H_

struct argc_argv {
  int argc;
  char **argv;
};

/*
 * Headers prototyping the
 * following calls.
 */
 
extern int do_service_install(int *argc, char *argv[], int *);
extern int do_service_delete(int *argc, char *argv[], int *);
extern int do_service_main(struct argc_argv *);
extern int request_service_stop(SERVICE_STATUS *);
extern int request_service_pause(SERVICE_STATUS *);
extern int request_service_continue(SERVICE_STATUS *);
extern int do_service_usage(int argc, char *argv[]);
extern void log_message(int, const char *fmt, ...);
extern void log_message_va(int, const char *, va_list);
extern BOOL create_sd_from_list( SECURITY_DESCRIPTOR *, int, ...);
extern int create_registry_tree( HKEY, const char *, SECURITY_DESCRIPTOR *);
extern int setup_service_args( HKEY, const char *, const char *, int, char **);
extern int check_kerbnet_base_args();

extern char *str_oserr(DWORD);

extern BOOL global_log_to_stderr_flag;
extern BOOL global_debug_flag;
extern HANDLE global_service_thread;

extern char global_service_name[];

#define CYGWIN_SERVICE_NAME "KerbnetKPropd"
#define CYGWIN_SERVICE_SZDEPENDENCIES ""

#define CYGWIN_SERVICE_ACCEPT_ALL SERVICE_ACCEPT_STOP|SERVICE_ACCEPT_SHUTDOWN|\
                                  SERVICE_ACCEPT_PAUSE_CONTINUE

#endif

