/*
 * Copyright (c) 1997 Cygnus Solutions
 *
 * Author:  Michael Graff
 */

#include <krb5.h>

typedef struct telnet_host {
  char       name[MAXHOSTNAMELEN];   /* the hostname */
  int        port;                   /* port to connect to this host on */
  DWORD      backspace;              /* backspace setting */
} telnet_host_t;

typedef struct telnet_font {
  char       face[256];
  DWORD      height;
  DWORD      width;
  BYTE       pitch_and_family;
  BYTE       char_set;
  DWORD      escapement;
} telnet_font_t;

typedef struct telnet_reg {
  DWORD         height;     /* default screen height */
  DWORD         width;      /* default screen width */
  DWORD         backspace;  /* default backspace value */
  telnet_host_t hosts[10];  /* the hosts themselves */
  int           num_hosts;  /* number of hosts remembered */
  telnet_font_t font;
} telnet_reg_t;

extern telnet_reg_t tel_res;

void telnet_load_registry(void);
void telnet_save_registry(void);
