/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

public class LightweightRedirector {
    static final int LAST_BUTTON_NUMBER = 3;
    Component[] releaseTargets;

    private /* synthetic */ void finit$() {
        this.releaseTargets = new Component[4];
    }

    public AWTEvent redirect(AWTEvent event) {
        if (event instanceof MouseEvent) {
            return this.redirectMouse((MouseEvent)event);
        }
        return event;
    }

    MouseEvent redirectMouse(MouseEvent event) {
        Component heavySource;
        int button = this.getButtonNumber(event);
        int id = event.getID();
        Component source = heavySource = (Component)event.getSource();
        int x = event.getX();
        int y = event.getY();
        if (id == 502) {
            Component target = this.releaseTargets[button];
            if (target != null) {
                this.releaseTargets[button] = null;
                Component child = source = target;
                while (child != heavySource) {
                    x -= child.getX();
                    y -= child.getY();
                    if ((child = child.getParent()) != null) continue;
                    System.err.println("warning, orphaned release target");
                }
            }
        } else {
            Component child;
            Component parent;
            while ((parent = source) != (child = parent.getComponentAt(x, y))) {
                if (child == null) {
                    String msg = "delivered event not within component. Heavyweight source was " + heavySource + ". " + "Component was " + parent;
                    throw new AWTError(msg);
                }
                if (child.isLightweight()) {
                    source = child;
                    x -= child.getX();
                    y -= child.getY();
                    continue;
                }
                System.err.println("warning: event delivered to wrong heavyweight component. Was delivered to " + source + ". " + "Should have been delivered to " + child + ". Maybe the native window " + "system is bubbling events up the " + "containment hierarchy.");
                break;
            }
            if (id == 501) {
                this.releaseTargets[button] = source;
            }
        }
        if (source == heavySource) {
            return event;
        }
        if (!source.isLightweight()) {
            System.err.println("warning: redirecting to heavyweight");
        }
        MouseEvent redirected = new MouseEvent(source, event.getID(), event.getWhen(), event.getModifiersEx(), x, y, event.getClickCount(), event.isPopupTrigger());
        return redirected;
    }

    int getButtonNumber(InputEvent event) {
        int modifiers = event.getModifiersEx();
        switch (modifiers &= 0x1C00) {
            case 1024: {
                return 1;
            }
            case 2048: {
                return 2;
            }
            case 4096: {
                return 3;
            }
            case 0: {
                return 0;
            }
        }
        System.err.println("FIXME: multibutton event");
        return 0;
    }

    public LightweightRedirector() {
        this.finit$();
    }
}

